#ifndef __MAC_REG_BE_H__
#define __MAC_REG_BE_H__

#include "hci_reg_be.h"
#include "plat_reg_be.h"

//
// WL_BE_REG_DMAC.xls
//

//
// TOP_OFF
//

#define R_BE_GT0_CTRL 0x7000
#define B_BE_GT_COUNT_EN BIT(31)
#define B_BE_GT_MODE BIT(30)
#define B_BE_GT_EN BIT(29)
#define B_BE_GT_SORT_EN BIT(28)
#define B_BE_GT_DATA_SH 0
#define B_BE_GT_DATA_MSK 0xfffffff

#define R_BE_GT0_CNT 0x7004
#define B_BE_GT_CNT_SH 0
#define B_BE_GT_CNT_MSK 0xfffffff

#define R_BE_GT1_CTRL 0x7008

#define R_BE_GT1_CNT 0x700C

#define R_BE_GT2_CTRL 0x7010

#define R_BE_GT2_CNT 0x7014

#define R_BE_GT3_CTRL 0x7018

#define R_BE_GT3_CNT 0x701C

#define R_BE_TOPOFF_DBG_SEL 0x7020
#define B_BE_TOPOFF_DBG_SEL_SH 0
#define B_BE_TOPOFF_DBG_SEL_MSK 0xf

#define R_BE_SORT_CTRL 0x7024
#define B_BE_CMAC1_SORT_EN BIT(1)
#define B_BE_CMAC0_SORT_EN BIT(0)

#define R_BE_GT4_CTRL 0x7040

#define R_BE_GT4_CNT 0x7044

#define R_BE_GT5_CTRL 0x7048

#define R_BE_GT5_CNT 0x704C

#define R_BE_GT6_CTRL 0x7050

#define R_BE_GT6_CNT 0x7054

#define R_BE_GT7_CTRL 0x7058

#define R_BE_GT7_CNT 0x705C

#define R_BE_FWD0IMR 0x7100
#define B_BE_FS_GT7_INT_EN BIT(15)
#define B_BE_FS_GT6_INT_EN BIT(14)
#define B_BE_FS_GT5_INT_EN BIT(13)
#define B_BE_FS_GT4_INT_EN BIT(12)
#define B_BE_FS_H2C_INT_EN BIT(8)
#define B_BE_FS_HIOE_ERR_INT_EN BIT(7)
#define B_BE_FS_SW_PLL_LEAVE_32K_INT_EN BIT(6)
#define B_BE_FS_MAILBOX_OUT_EMPTY_INT_EN BIT(5)
#define B_BE_FS_GT3_INT_EN BIT(3)
#define B_BE_FS_GT2_INT_EN BIT(2)
#define B_BE_FS_GT1_INT_EN BIT(1)
#define B_BE_FS_GT0_INT_EN BIT(0)

#define R_BE_FWD0ISR 0x7104
#define B_BE_FS_GT7_INT BIT(15)
#define B_BE_FS_GT6_INT BIT(14)
#define B_BE_FS_GT5_INT BIT(13)
#define B_BE_FS_GT4_INT BIT(12)
#define B_BE_FS_H2C_INT BIT(8)
#define B_BE_FS_HIOE_ERR_INT BIT(7)
#define B_BE_FS_SW_PLL_LEAVE_32K_INT BIT(6)
#define B_BE_FS_MAILBOX_OUT_EMPTY_INT BIT(5)
#define B_BE_FS_GT3_INT BIT(3)
#define B_BE_FS_GT2_INT BIT(2)
#define B_BE_FS_GT1_INT BIT(1)
#define B_BE_FS_GT0_INT BIT(0)

#define R_BE_HD0IMR 0x7110
#define B_BE_CPWM_INT_EN BIT(2)
#define B_BE_GT3_INT_EN BIT(1)
#define B_BE_C2H_INT_EN BIT(0)

#define R_BE_HD0ISR 0x7114
#define B_BE_CPWM_INT BIT(2)
#define B_BE_GT3_INT BIT(1)
#define B_BE_C2H_INT BIT(0)

#define R_BE_H2CREG_DATA0 0x7140
#define B_BE_H2CREG_D0_SH 0
#define B_BE_H2CREG_D0_MSK 0xffffffffL

#define R_BE_H2CREG_DATA1 0x7144
#define B_BE_H2CREG_D1_SH 0
#define B_BE_H2CREG_D1_MSK 0xffffffffL

#define R_BE_H2CREG_DATA2 0x7148
#define B_BE_H2CREG_D2_SH 0
#define B_BE_H2CREG_D2_MSK 0xffffffffL

#define R_BE_H2CREG_DATA3 0x714C
#define B_BE_H2CREG_D3_SH 0
#define B_BE_H2CREG_D3_MSK 0xffffffffL

#define R_BE_C2HREG_DATA0 0x7150
#define B_BE_C2HREG_D0_SH 0
#define B_BE_C2HREG_D0_MSK 0xffffffffL

#define R_BE_C2HREG_DATA1 0x7154
#define B_BE_C2HREG_D1_SH 0
#define B_BE_C2HREG_D1_MSK 0xffffffffL

#define R_BE_C2HREG_DATA2 0x7158
#define B_BE_C2HREG_D2_SH 0
#define B_BE_C2HREG_D2_MSK 0xffffffffL

#define R_BE_C2HREG_DATA3 0x715C
#define B_BE_C2HREG_D3_SH 0
#define B_BE_C2HREG_D3_MSK 0xffffffffL

#define R_BE_H2CREG_CTRL 0x7160
#define B_BE_H2CREG_TRIGGER BIT(0)

#define R_BE_C2HREG_CTRL 0x7164
#define B_BE_C2HREG_TRIGGER BIT(0)

#define R_BE_CPWM 0x7170
#define B_BE_CPWM_TOGGLE BIT(15)
#define B_BE_CPWM_VAL_SH 0
#define B_BE_CPWM_VAL_MSK 0x7fff

#define R_BE_ANACLK_CAL_CTRL 0x7180
#define B_BE_ANACLK_CAL_EN BIT(31)
#define B_BE_ANACLK_SEL_SH 24
#define B_BE_ANACLK_SEL_MSK 0x3
#define B_BE_ANACLK_CAL_RPT_SH 0
#define B_BE_ANACLK_CAL_RPT_MSK 0xffff

#define R_BE_OTP_PARA 0x7190
#define B_BE_OTP_PWE_H_PARA_SH 4
#define B_BE_OTP_PWE_H_PARA_MSK 0x3
#define B_BE_OTP_PWE_L_PARA_SH 0
#define B_BE_OTP_PWE_L_PARA_MSK 0x3

#define R_BE_PARAM_BIST_CTRL 0x7200
#define B_BE_BIST_TMCK BIT(15)
#define B_BE_BIST_DYN_READ_EN BIT(14)
#define B_BE_BIST_LOOP_MODE BIT(13)
#define B_BE_BIST_LVDRF_CLKDIS BIT(12)
#define B_BE_BIST_BT_RPT_SEL_SH 4
#define B_BE_BIST_BT_RPT_SEL_MSK 0xf
#define B_BE_BIST_DRF_RESUME BIT(3)
#define B_BE_BIST_DRF_MODE BIT(2)
#define B_BE_BIST_MODE BIT(1)
#define B_BE_BIST_RSTN_ALL BIT(0)

#define R_BE_PARAM_MEM_RM_CTRL 0x7204
#define B_BE_SYM_MEM_RMV_FABDBG_SH 30
#define B_BE_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_BE_SYM_MEM_RMV_SIGN BIT(29)
#define B_BE_SYM_MEM_RMV_2PRF BIT(27)
#define B_BE_SYM_MEM_RMV_1PRF BIT(26)
#define B_BE_SYM_MEM_RMV_1PSR BIT(25)
#define B_BE_SYM_MEM_RMV_ROM BIT(24)
#define B_BE_SYM_MEM_RME_BT_SH 8
#define B_BE_SYM_MEM_RME_BT_MSK 0xf
#define B_BE_SYM_MEM_RME_HCI_SH 0
#define B_BE_SYM_MEM_RME_HCI_MSK 0xf

#define R_BE_PARAM_USB_BIST_RSTN 0x7210
#define B_BE_BIST_RST_N_USB_SH 0
#define B_BE_BIST_RST_N_USB_MSK 0x3fffff

#define R_BE_PARAM_USB_BIST_DONE 0x7214
#define B_BE_BIST_DONE_USB_SH 0
#define B_BE_BIST_DONE_USB_MSK 0x3fffff

#define R_BE_PARAM_USB_BIST_FAIL 0x7218
#define B_BE_BIST_FAIL_USB_SH 0
#define B_BE_BIST_FAIL_USB_MSK 0x3fffff

#define R_BE_PARAM_USB_DRF_PAUSE 0x721C
#define B_BE_BIST_DRF_PAUSE_USB_SH 0
#define B_BE_BIST_DRF_PAUSE_USB_MSK 0x3fffff

#define R_BE_PARAM_PCIE_BIST_RSTN 0x7220
#define B_BE_BIST_RST_N_PCIE_SH 0
#define B_BE_BIST_RST_N_PCIE_MSK 0x7fff

#define R_BE_PARAM_PCIE_BIST_DONE 0x7224
#define B_BE_BIST_DONE_PCIE_SH 0
#define B_BE_BIST_DONE_PCIE_MSK 0x7fff

#define R_BE_PARAM_PCIE_BIST_FAIL 0x7228
#define B_BE_BIST_FAIL_PCIE_SH 0
#define B_BE_BIST_FAIL_PCIE_MSK 0x7fff

#define R_BE_PARAM_PCIE_DRF_PAUSE 0x722C
#define B_BE_BIST_DRF_PAUSE_PCIE_SH 0
#define B_BE_BIST_DRF_PAUSE_PCIE_MSK 0x7fff

#define R_BE_PARAM_SDIO_BIST_RSTN 0x7240
#define B_BE_BIST_RST_N_SDIO_SH 0
#define B_BE_BIST_RST_N_SDIO_MSK 0x3

#define R_BE_PARAM_SDIO_BIST_DONE 0x7244
#define B_BE_BIST_DONE_SDIO_SH 0
#define B_BE_BIST_DONE_SDIO_MSK 0x3

#define R_BE_PARAM_SDIO_BIST_FAIL 0x7248
#define B_BE_BIST_FAIL_SDIO_SH 0
#define B_BE_BIST_FAIL_SDIO_MSK 0x3

#define R_BE_PARAM_SDIO_DRF_PAUSE 0x724C
#define B_BE_DRF_PAUSE_SDIO_SH 0
#define B_BE_DRF_PAUSE_SDIO_MSK 0x3

#define R_BE_PARAM_BT0_BIST_RSTN 0x7250
#define B_BE_BIST_RST_N_BT0_SH 0
#define B_BE_BIST_RST_N_BT0_MSK 0xffffffffL

#define R_BE_PARAM_BT0_BIST_DONE 0x7254
#define B_BE_BIST_DONE_BIT0_SH 0
#define B_BE_BIST_DONE_BIT0_MSK 0xffffffffL

#define R_BE_PARAM_BT0_BIST_FAIL 0x7258
#define B_BE_BIST_FAIL_BT0_SH 0
#define B_BE_BIST_FAIL_BT0_MSK 0xffffffffL

#define R_BE_PARAM_BT0_DRF_PAUSE 0x725C
#define B_BE_BIST_DRF_PAUSE_BT0_SH 0
#define B_BE_BIST_DRF_PAUSE_BT0_MSK 0xffffffffL

#define R_BE_PARAM_BT1_BIST_RSTN 0x7260
#define B_BE_BIST_RST_N_BT1_SH 0
#define B_BE_BIST_RST_N_BT1_MSK 0x1fff

#define R_BE_PARAM_BT1_BIST_DONE 0x7264
#define B_BE_BIST_DONE_BT1_SH 0
#define B_BE_BIST_DONE_BT1_MSK 0x1fff

#define R_BE_PARAM_BT1_BIST_FAIL 0x7268
#define B_BE_BIST_FAIL_BT1_SH 0
#define B_BE_BIST_FAIL_BT1_MSK 0x1fff

#define R_BE_PARAM_BT1_DRF_PAUSE 0x726C
#define B_BE_BIST_DRF_PAUSE_BT1_SH 0
#define B_BE_BIST_DRF_PAUSE_BT1_MSK 0x1fff

#define R_BE_PARAM_BT_BIST_RPT 0x7274
#define B_BE_BT_BIST_RPT_SH 0
#define B_BE_BT_BIST_RPT_MSK 0xffffffffL

//
// WL_PON
//

#define R_BE_FWD1IMR 0x7800
#define B_BE_FS_TM_WAKE_INT_EN BIT(16)
#define B_BE_FS_BT_MAILBOX_INT_EN BIT(1)
#define B_BE_FS_RPWM_INT_EN BIT(0)

#define R_BE_FWD1ISR 0x7804
#define B_BE_FS_TM_WAKE_INT BIT(16)
#define B_BE_FS_BT_MAILBOX_INT BIT(1)
#define B_BE_FS_RPWM_INT BIT(0)

#define R_BE_FSMIMR 0x7808
#define B_BE_FSM_RP_END_EVENT_IMR BIT(6)
#define B_BE_FSM_RX_BCN_TO_CNT_EVENT_IMR BIT(5)
#define B_BE_FSM_RX_MATCH_EVENT_IMR BIT(4)
#define B_BE_FSM_HIOE_ERR_EVENT_IMR BIT(3)
#define B_BE_FSM_OTHERS_WAKE_EVENT_IMR BIT(2)
#define B_BE_FSM_TIMER_TO_EVENT_IMR BIT(1)

#define R_BE_FSMISR 0x780C
#define B_BE_FSM_RP_END_EVENT_ISR BIT(6)
#define B_BE_FSM_RX_BCN_TO_CNT_EVENT_ISR BIT(5)
#define B_BE_FSM_RX_MATCH_EVENT_ISR BIT(4)
#define B_BE_FSM_HIOE_ERR_EVENT_ISR BIT(3)
#define B_BE_FSM_OTHERS_WAKE_EVENT_ISR BIT(2)
#define B_BE_FSM_TIMER_TO_EVENT_ISR BIT(1)

#define R_BE_TM_BKP_RES_CTRL 0x7810
#define B_BE_SORTING_ROLE_SEL_SH 12
#define B_BE_SORTING_ROLE_SEL_MSK 0x3
#define B_BE_SORTING_ROLE_ST_SH 8
#define B_BE_SORTING_ROLE_ST_MSK 0xf
#define B_BE_TM_WAKE_IND BIT(7)
#define B_BE_TM_BKP_EN_STS BIT(6)
#define B_BE_SCH_RES_EN BIT(4)
#define B_BE_PRE_CHK_DONE BIT(3)
#define B_BE_PRE_CHK_VALID BIT(2)
#define B_BE_TM_RES_EN BIT(1)
#define B_BE_TM_BKP_EN_TRIGGER BIT(0)

#define R_BE_PRE_CHK_CTRL 0x7814
#define B_BE_PRE_CHK_THD_SH 16
#define B_BE_PRE_CHK_THD_MSK 0xffff
#define B_BE_PRE_WAKE_TIME_SH 0
#define B_BE_PRE_WAKE_TIME_MSK 0xffff

#define R_BE_LPS_WTM_SC 0x7818
#define B_BE_LPS_WTM_SC_SH 0
#define B_BE_LPS_WTM_SC_MSK 0xffffffffL

#define R_BE_LPS_WTM_CNT 0x781C
#define B_BE_LPS_WTM_CNT_SH 0
#define B_BE_LPS_WTM_CNT_MSK 0xffffffffL

#define R_BE_TSF_32K_SEL 0x7820
#define B_BE_TSF_CLK_STABLE BIT(17)
#define B_BE_CKSL_WLTSF BIT(16)
#define B_BE_32K_SRC_SEL BIT(8)
#define B_BE_US_TIME_VALUE_SH 0
#define B_BE_US_TIME_VALUE_MSK 0xff

#define R_BE_HIOE_END_ADDR 0x7840
#define B_BE_HIOE_END_ADDR_SH 0
#define B_BE_HIOE_END_ADDR_MSK 0xffffffffL

#define R_BE_HIOE_STR_ADDR 0x7844
#define B_BE_HIOE_STR_ADDR_SH 0
#define B_BE_HIOE_STR_ADDR_MSK 0xffffffffL

#define R_BE_BKP_HIOE_CTRL 0x7848
#define B_BE_BKP_HIOE_CTRL_SH 16
#define B_BE_BKP_HIOE_CTRL_MSK 0xffff

#define R_BE_RES_HIOE_CTRL 0x784C
#define B_BE_RES_HIOE_CTRL_SH 16
#define B_BE_RES_HIOE_CTRL_MSK 0xffff

#define R_BE_HCI_FUNC_EN 0x7880
#define B_BE_HCI_CR_PROTECT BIT(31)
#define B_BE_HCI_TRXBUF_EN BIT(2)
#define B_BE_HCI_RXDMA_EN BIT(1)
#define B_BE_HCI_TXDMA_EN BIT(0)

#define R_BE_OSC_32K_CTRL 0x7894
#define B_BE_LPOSC32K_OK BIT(31)
#define B_BE_CAL_32K_DBG_SEL BIT(3)
#define B_BE_CAL32K_XTAL_EN BIT(2)
#define B_BE_CAL32K_OSC_EN BIT(1)
#define B_BE_WL_POW_32KOSC BIT(0)

#define R_BE_32K_CAL_REG0 0x7898
#define B_BE_CAL_32K_REG_WR BIT(31)
#define B_BE_CAL_OSC_XTAL_SEL BIT(22)
#define B_BE_CAL_32K_REG_ADDR_SH 16
#define B_BE_CAL_32K_REG_ADDR_MSK 0x3f
#define B_BE_CAL_32K_REG_DATA_SH 0
#define B_BE_CAL_32K_REG_DATA_MSK 0xffff

#define R_BE_OSC32K_RCAL 0x789C
#define B_BE_OSC32K_RCAL_SH 0
#define B_BE_OSC32K_RCAL_MSK 0x7fff

#define R_BE_BOOT_DBG 0x78F0
#define B_BE_BOOT_STATUS_SH 16
#define B_BE_BOOT_STATUS_MSK 0xffff
#define B_BE_SECUREBOOT_STATUS_SH 0
#define B_BE_SECUREBOOT_STATUS_MSK 0xffff

//
// HCI_LA
//

#define R_BE_HCI_LA_FLOW_CONTROL 0x7C00
#define B_BE_HCI_LA_GO BIT(0)

#define R_BE_HCI_LA_RECORD_SET 0x7C04
#define B_BE_HCI_LA_REC_MODE_SH 6
#define B_BE_HCI_LA_REC_MODE_MSK 0x3
#define B_BE_HCI_LA_DEC_MODE_SH 4
#define B_BE_HCI_LA_DEC_MODE_MSK 0x3
#define B_BE_HCI_LA_ADP_MODE BIT(2)
#define B_BE_HCI_LA_PAT_MODE_1 BIT(1)
#define B_BE_HCI_LA_PAT_MODE_0 BIT(0)

#define R_BE_HCI_LA_MEM_SET 0x7C08
#define B_BE_HCI_LA_IND_MEM_OFFSET_SH 0
#define B_BE_HCI_LA_IND_MEM_OFFSET_MSK 0xff

#define R_BE_HCI_LA_TRIG_SET 0x7C10
#define B_BE_HCI_TRIGGER_MASK_SH 0
#define B_BE_HCI_TRIGGER_MASK_MSK 0xffffffffL

#define R_BE_HCI_LA_TRIG_CON_SET_0 0x7C14
#define B_BE_HCI_TRIGGER_CON_0_SH 0
#define B_BE_HCI_TRIGGER_CON_0_MSK 0xffffffffL

#define R_BE_HCI_LA_TRIG_CON_SET_1 0x7C18
#define B_BE_HCI_TRIGGER_CON_1_SH 0
#define B_BE_HCI_TRIGGER_CON_1_MSK 0xffffffffL

#define R_BE_HCI_LA_MEM_PTR 0x7C20
#define B_BE_HCI_RECORD_END_PTR_SH 16
#define B_BE_HCI_RECORD_END_PTR_MSK 0xffff
#define B_BE_HCI_RECORD_START_PTR_SH 0
#define B_BE_HCI_RECORD_START_PTR_MSK 0xffff

#define R_BE_HCI_LA_RECORD_STATUS 0x7C24
#define B_BE_HCI_STATUS_MEM_WRAP BIT(3)
#define B_BE_HCI_STATUS_FINISH BIT(2)
#define B_BE_HCI_STATUS_FLAG BIT(1)
#define B_BE_HCI_STATUS_TRI_VLD BIT(0)

//
// COMMON
//

#define R_BE_DMAC_FUNC_EN 0x8400
#define B_BE_DMAC_CRPRT BIT(31)
#define B_BE_MAC_EN BIT(30)
#define B_BE_DMAC_EN BIT(29)
#define B_BE_MPDU_EN BIT(28)
#define B_BE_WDRLS_EN BIT(27)
#define B_BE_WDE_DLE_EN BIT(26)
#define B_BE_TXPKTCTL_EN BIT(25)
#define B_BE_STA_SCH_EN BIT(24)
#define B_BE_PLE_DEL_EN BIT(23)
#define B_BE_PKTBUF_EN BIT(22)
#define B_BE_DMAC_TABLE_EN BIT(21)
#define B_BE_PKTIN_EN BIT(20)
#define B_BE_DLE_CPUIO_EN BIT(19)
#define B_BE_DISPATCHER_EN BIT(18)
#define B_BE_BBRPT_EN BIT(17)
#define B_BE_WSEC_EN BIT(16)
#define B_BE_FORCE_DMAREG_GCKEN BIT(15)
#define B_BE_H_AXIDMA_EN BIT(14)
#define B_BE_DMAC_SER_PS BIT(13)
#define B_BE_CMAC_SER_PS BIT(12)
#define B_BE_DMAC_MLO_EN BIT(11)
#define B_BE_PLRLS_EN BIT(10)

#define R_BE_DMAC_CLK_EN 0x8404
#define B_BE_MAC_CKEN BIT(30)
#define B_BE_DMAC_CKEN BIT(29)
#define B_BE_MPDU_CKEN BIT(28)
#define B_BE_WDRLS_CKEN BIT(27)
#define B_BE_WDE_DLE_CKEN BIT(26)
#define B_BE_TXPKTCTL_CKEN BIT(25)
#define B_BE_STA_SCH_CKEN BIT(24)
#define B_BE_PLE_DEL_CKEN BIT(23)
#define B_BE_PKTBUF_CKEN BIT(22)
#define B_BE_DMAC_TABLE_CKEN BIT(21)
#define B_BE_PKTIN_CKEN BIT(20)
#define B_BE_DLE_CPUIO_CKEN BIT(19)
#define B_BE_DISPATCHEB_BE_CKEN BIT(18)
#define B_BE_BBRPT_CKEN BIT(17)
#define B_BE_WSEC_CKEN BIT(16)
#define B_BE_DMAC_MLO_CKEN BIT(11)
#define B_BE_PLRLS_CKEN BIT(10)

#define R_BE_LTR_CTRL_0 0x8410
#define B_BE_LTR_REQ_FW BIT(18)
#define B_BE_LTR_IDX_FW_SH 16
#define B_BE_LTR_IDX_FW_MSK 0x3
#define B_BE_LTR_IDLE_TIMER_IDX_SH 8
#define B_BE_LTR_IDLE_TIMER_IDX_MSK 0x7
#define B_BE_LTR_WD_NOEMP_CHK BIT(1)
#define B_BE_LTR_HW_EN BIT(0)

#define R_BE_LTR_CTRL_1 0x8414
#define B_BE_LTR_RX1_TH_SH 16
#define B_BE_LTR_RX1_TH_MSK 0xfff
#define B_BE_LTR_RX0_TH_SH 0
#define B_BE_LTR_RX0_TH_MSK 0xfff

#define R_BE_LTR_IDLE_LATENCY 0x8418
#define B_BE_LTR_IDX_HW_IDLE_SH 0
#define B_BE_LTR_IDX_HW_IDLE_MSK 0x3

#define R_BE_LTR_ACTIVE_LATENCY 0x841C
#define B_BE_LRT_IDX_HW_ACTIVE_SH 0
#define B_BE_LRT_IDX_HW_ACTIVE_MSK 0x3

#define R_BE_DMAC_TALBE_CTRL 0x8420
#define B_BE__HWAMSDU_PADDING_MODE BIT(31)
#define B_BE_MACID_MPDU_PROCESSOR_OFFSET_SH 16
#define B_BE_MACID_MPDU_PROCESSOR_OFFSET_MSK 0x7ff
#define B_BE_DMAC_CTRL_INFO_SER_IO BIT(11)
#define B_BE_DMAC_CTRL_INFO_OFFSET_SH 0
#define B_BE_DMAC_CTRL_INFO_OFFSET_MSK 0x7ff

#define R_BE_SER_DBG_INFO 0x8424
#define B_BE_SER_DBG_INFO_SH 0
#define B_BE_SER_DBG_INFO_MSK 0xffffffffL

#define R_BE_DMAC_ASSERTION_EN 0x8428
#define B_BE_DMAC_ASSERTION BIT(31)

#define R_BE_DLE_EMPTY0 0x8430
#define B_BE_PLE_EMPTY_QTA_DMAC_CPUIO BIT(26)
#define B_BE_PLE_EMPTY_QTA_DMAC_MPDU_TX BIT(25)
#define B_BE_PLE_EMPTY_QTA_DMAC_WLAN_CPU BIT(24)
#define B_BE_PLE_EMPTY_QTA_DMAC_H2C BIT(23)
#define B_BE_PLE_EMPTY_QTA_DMAC_B1_TXPL BIT(22)
#define B_BE_PLE_EMPTY_QTA_DMAC_B0_TXPL BIT(21)
#define B_BE_WDE_EMPTY_QTA_DMAC_CPUIO BIT(20)
#define B_BE_WDE_EMPTY_QTA_DMAC_PKTIN BIT(19)
#define B_BE_WDE_EMPTY_QTA_DMAC_DATA_CPU BIT(18)
#define B_BE_WDE_EMPTY_QTA_DMAC_WLAN_CPU BIT(17)
#define B_BE_WDE_EMPTY_QTA_DMAC_HIF BIT(16)
#define B_BE_WDE_EMPTY_QUE_DMAC_PKTIN BIT(10)
#define B_BE_PLE_EMPTY_QUE_DMAC_SEC_TX BIT(9)
#define B_BE_PLE_EMPTY_QUE_DMAC_MPDU_TX BIT(8)
#define B_BE_WDE_EMPTY_QUE_OTHERS BIT(7)
#define B_BE_WDE_EMPTY_QUE_CMAC0_WMM1 BIT(4)
#define B_BE_WDE_EMPTY_QUE_CMAC0_WMM0 BIT(3)
#define B_BE_WDE_EMPTY_QUE_CMAC1_MBH BIT(2)
#define B_BE_WDE_EMPTY_QUE_CMAC0_MBH BIT(1)
#define B_BE_WDE_EMPTY_QUE_CMAC0_ALL_AC BIT(0)

#define R_BE_DLE_EMPTY1 0x8434
#define B_BE_PLE_EMPTY_QTA_CMAC_DMA_TXRPT BIT(21)
#define B_BE_PLE_EMPTY_QTA_DMAC_WDRLS BIT(20)
#define B_BE_PLE_EMPTY_QTA_CMAC1_DMA_BBRPT BIT(19)
#define B_BE_PLE_EMPTY_QTA_CMAC1_DMA_RX BIT(18)
#define B_BE_PLE_EMPTY_QTA_CMAC0_DMA_RX BIT(17)
#define B_BE_PLE_EMPTY_QTA_DMAC_C2H BIT(16)
#define B_BE_PLE_EMPTY_QUE_DMAC_PLRLS BIT(5)
#define B_BE_PLE_EMPTY_QUE_DMAC_CPUIO BIT(4)
#define B_BE_PLE_EMPTY_QUE_DMAC_SEC_RX BIT(3)
#define B_BE_PLE_EMPTY_QUE_DMAC_MPDU_RX BIT(2)
#define B_BE_PLE_EMPTY_QUE_DMAC_HDP BIT(1)
#define B_BE_WDE_EMPTY_QUE_DMAC_WDRLS BIT(0)

#define R_BE_FWD2IMR 0x8500
#define B_BE_TXPKTIN_INT_EN BIT(5)
#define B_BE_WWLAN_INT_EN BIT(4)
#define B_BE_PLD_CPU_IO_PORT_Q1_INT_EN BIT(3)
#define B_BE_PLD_CPU_IO_PORT_Q0_INT_EN BIT(2)
#define B_BE_WD_CPU_IO_PORT_Q1_INT_EN BIT(1)
#define B_BE_WD_CPU_IO_PORT_Q0_INT_EN BIT(0)

#define R_BE_FWD2ISR 0x8504
#define B_BE_TXPKTIN_INT BIT(5)
#define B_BE_WWLAN_INT BIT(4)
#define B_BE_PLD_CPU_IO_PORT_Q1_INT BIT(3)
#define B_BE_PLD_CPU_IO_PORT_Q0_INT BIT(2)
#define B_BE_WD_CPU_IO_PORT_Q1_INT BIT(1)
#define B_BE_WD_CPU_IO_PORT_Q0_INT BIT(0)

#define R_BE_FW_TRIGGER_IDCT_ISR 0x8508
#define B_BE_DMAC_FW_ERR_IDCT_IMR BIT(31)
#define B_BE_DMAC_FW_TRIG_IDCT BIT(0)

#define R_BE_FW_TRIGGER_IDCT_SRC 0x850C
#define B_BE_DMAC_FW_ERR_IDCT_SRC BIT(31)

#define R_BE_DMAC_ERR_IMR 0x8520
#define B_BE_H_AXIDMA_ERR_INT_EN BIT(14)
#define B_BE_P_AXIDMA_ERR_INT_EN BIT(13)
#define B_BE_HCI_BUF_ERR_INT_EN BIT(12)
#define B_BE_BBRPT_ERR_INT_EN BIT(11)
#define B_BE_DLE_CPUIO_ERR_INT_EN BIT(10)
#define B_BE_APB_BRIDGE_ERR_INT_EN BIT(9)
#define B_BE_DISPATCH_ERR_INT_EN BIT(8)
#define B_BE_PKTIN_ERR_INT_EN BIT(7)
#define B_BE_PLE_DLE_ERR_INT_EN BIT(6)
#define B_BE_TXPKTCTRL_ERR_INT_EN BIT(5)
#define B_BE_WDE_DLE_ERR_INT_EN BIT(4)
#define B_BE_STA_SCHEDULER_ERR_INT_EN BIT(3)
#define B_BE_MPDU_ERR_INT_EN BIT(2)
#define B_BE_WSEC_ERR_INT_EN BIT(1)
#define B_BE_WDRLS_ERR_INT_EN BIT(0)

#define R_BE_DMAC_ERR_ISR 0x8524
#define B_BE_DMAC_FW_ERR_IDCT BIT(16)
#define B_BE_H_AXIDMA_ERR_INT BIT(14)
#define B_BE_P_AXIDMA_ERR_INT BIT(13)
#define B_BE_HCI_BUF_ERR_INT BIT(12)
#define B_BE_BBRPT_ERR_INT BIT(11)
#define B_BE_DLE_CPUIO_ERR_INT BIT(10)
#define B_BE_APB_BRIDGE_ERR_INT BIT(9)
#define B_BE_DISP_ERR_INT BIT(8)
#define B_BE_PKTIN_ERR_INT BIT(7)
#define B_BE_PLE_DLE_ERR_INT BIT(6)
#define B_BE_TXPKTCTRL_ERR_INT BIT(5)
#define B_BE_WDE_DLE_ERR_INT BIT(4)
#define B_BE_STA_SCHEDULER_ERR_INT BIT(3)
#define B_BE_MPDU_ERR_INT BIT(2)
#define B_BE_WSEC_ERR_INT BIT(1)
#define B_BE_WDRLS_ERR_INT BIT(0)

#define R_BE_BIST_CTRL 0x8600
#define B_BE_BIST_TMCK_W BIT(15)

#define R_BE_BIST_CTRL_MEM 0x8604
#define B_BE_SYS_MEM_RMV_FABDBG_SH 30
#define B_BE_SYS_MEM_RMV_FABDBG_MSK 0x3
#define B_BE_SYS_MEM_RMV_SIGN BIT(29)
#define B_BE_SYS_MEM_RMV_2PRF BIT(27)
#define B_BE_SYS_MEM_RMV_1PRF BIT(26)
#define B_BE_SYS_MEM_RMV_1PSR BIT(25)
#define B_BE_SYS_MEM_RMV_ROM BIT(24)
#define B_BE_SYS_MEM_RME_WL_SH 4
#define B_BE_SYS_MEM_RME_WL_MSK 0xf

#define R_BE_BIST_RSTN 0x8610
#define B_BE_BIST_RSTN_N_DMAC_SH 0
#define B_BE_BIST_RSTN_N_DMAC_MSK 0x3fffffff

#define R_BE_BIST_DONE 0x8614
#define B_BE_BIST_DONE_DMAC_SH 0
#define B_BE_BIST_DONE_DMAC_MSK 0x3fffffff

#define R_BE_BIST_FAIL 0x8618
#define B_BE_BIST_FAIL_DMAC_SH 0
#define B_BE_BIST_FAIL_DMAC_MSK 0x3fffffff

#define R_BE_BIST_DRF_PAUSE 0x861C
#define B_BE_BIST_DRF_PAUSE_DMAC_SH 0
#define B_BE_BIST_DRF_PAUSE_DMAC_MSK 0x3fffffff

#define R_BE_BIST_RSTN1 0x8620
#define B_BE_R_BIST_RSTN_N_DMAC1_SH 0
#define B_BE_R_BIST_RSTN_N_DMAC1_MSK 0xffffffffL

#define R_BE_BIST_DONE1 0x8624
#define B_BE_BIST_DONE_DMAC1_SH 0
#define B_BE_BIST_DONE_DMAC1_MSK 0xffffffffL

#define R_BE_BIST_FAIL1 0x8628
#define B_BE_BIST_FAIL_DMAC1_SH 0
#define B_BE_BIST_FAIL_DMAC1_MSK 0xffffffffL

#define R_BE_BIST_DRF_PAUSE1 0x862C
#define B_BE_BIST_DRF_PAUSE_DMAC1_SH 0
#define B_BE_BIST_DRF_PAUSE_DMAC1_MSK 0xffffffffL

//
// Dispatcher
//

#define R_BE_DISPATCHER_GLOBAL_SETTING_0 0x8800
#define B_BE_SER_RX_TO_TH_SH 24
#define B_BE_SER_RX_TO_TH_MSK 0xff
#define B_BE_SER_TX_TO_TH_SH 16
#define B_BE_SER_TX_TO_TH_MSK 0xff
#define B_BE_SER_RX_TO_UNIT_SH 10
#define B_BE_SER_RX_TO_UNIT_MSK 0x3
#define B_BE_SER_TX_TO_UNIT_SH 8
#define B_BE_SER_TX_TO_UNIT_MSK 0x3
#define B_BE_PLE_LAST_OPT_V1 BIT(7)
#define B_BE_WDE_LAST_OPT_V1 BIT(6)
#define B_BE_DDR_GATTING_DISABLE BIT(5)
#define B_BE_DDT_GATTING_DISABLE BIT(4)
#define B_BE_CDR_GATTING_DISABLE BIT(3)
#define B_BE_CDT_GATTING_DISABLE BIT(2)
#define B_BE_HDR_GATTING_DISABLE BIT(1)
#define B_BE_HDT_GATTING_DISABLE BIT(0)

#define R_BE_OTHER_DISPATCHER_ERR_ISR 0x8804
#define B_BE_REUSE_SIZE_ERR BIT(31)
#define B_BE_REUSE_EN_ERR BIT(30)
#define B_BE_STF_OQT_UNDERFLOW_ERR BIT(29)
#define B_BE_STF_OQT_OVERFLOW_ERR BIT(28)
#define B_BE_STF_WRFF_UNDERFLOW_ERR BIT(27)
#define B_BE_STF_WRFF_OVERFLOW_ERR BIT(26)
#define B_BE_STF_CMD_UNDERFLOW_ERR BIT(25)
#define B_BE_STF_CMD_OVERFLOW_ERR BIT(24)
#define B_BE_REUSE_SIZE_ZERO_ERR BIT(23)
#define B_BE_REUSE_PKT_CNT_ERR BIT(22)
#define B_BE_CDT_PTR_TIMEOUT_ERR BIT(21)
#define B_BE_CDT_HCI_TIMEOUT_ERR BIT(20)
#define B_BE_HDT_PTR_TIMEOUT_ERR BIT(19)
#define B_BE_HDT_HCI_TIMEOUT_ERR BIT(18)
#define B_BE_CDT_ADDR_INFO_LEN_ERR BIT(17)
#define B_BE_HDT_ADDR_INFO_LEN_ERR BIT(16)
#define B_BE_CDR_DMA_TIMEOUT_ERR BIT(15)
#define B_BE_CDR_RX_TIMEOUT_ERR BIT(14)
#define B_BE_PLE_OUTPUT_ERR BIT(12)
#define B_BE_PLE_RESPOSE_ERR BIT(11)
#define B_BE_PLE_BURST_NUM_ERR BIT(10)
#define B_BE_PLE_NULL_PKT_ERR BIT(9)
#define B_BE_PLE_FLOW_CTRL_ERR BIT(8)
#define B_BE_HDR_DMA_TIMEOUT_ERR BIT(7)
#define B_BE_HDR_RX_TIMEOUT_ERR BIT(6)
#define B_BE_WDE_OUTPUT_ERR BIT(4)
#define B_BE_WDE_RESPONSE_ERR BIT(3)
#define B_BE_WDE_BURST_NUM_ERR BIT(2)
#define B_BE_WDE_NULL_PKT_ERR BIT(1)
#define B_BE_WDE_FLOW_CTRL_ERR BIT(0)

#define R_BE_HOST_DISPATCHER_ERR_ISR 0x8808
#define B_BE_HR_WRFF_UNDERFLOW_ERR BIT(31)
#define B_BE_HR_WRFF_OVERFLOW_ERR BIT(30)
#define B_BE_HR_CHKSUM_FSM_ERR BIT(29)
#define B_BE_HR_SHIFT_DMA_CFG_ERR BIT(28)
#define B_BE_HR_DMA_PROCESS_ERR BIT(27)
#define B_BE_HR_TOTAL_LEN_UNDER_ERR BIT(26)
#define B_BE_HR_SHIFT_EN_ERR BIT(25)
#define B_BE_HR_AGG_CFG_ERR BIT(24)
#define B_BE_HR_DMA_RD_CNT_DEQ_ERR BIT(23)
#define B_BE_HR_PLD_LEN_ZERO_ERR BIT(22)
#define B_BE_HT_ILL_CH_ERR BIT(20)
#define B_BE_HT_ADDR_INFO_LEN_ERR BIT(18)
#define B_BE_HT_WD_LEN_OVER_ERR BIT(17)
#define B_BE_HT_PLD_CMD_UNDERFLOW_ERR BIT(16)
#define B_BE_HT_PLD_CMD_OVERFLOW_ERR BIT(15)
#define B_BE_HT_WRFF_UNDERFLOW_ERR BIT(14)
#define B_BE_HT_WRFF_OVERFLOW_ERR BIT(13)
#define B_BE_HT_CHKSUM_FSM_ERR BIT(12)
#define B_BE_HT_TXPKTSIZE_ERR BIT(11)
#define B_BE_HT_PRE_SUB_ERR BIT(10)
#define B_BE_HT_WD_CHKSUM_ERR BIT(9)
#define B_BE_HT_CHANNEL_DMA_ERR BIT(8)
#define B_BE_HT_OFFSET_UNMATCH_ERR BIT(7)
#define B_BE_HT_PAYLOAD_UNDER_ERR BIT(6)
#define B_BE_HT_PAYLOAD_OVER_ERR BIT(5)
#define B_BE_HT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_BE_HT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_BE_HT_PKT_FAIL_ERR BIT(2)
#define B_BE_HT_CH_ID_ERR BIT(1)
#define B_BE_HT_EP_CH_DIFF_ERR BIT(0)

#define R_BE_CPU_DISPATCHER_ERR_ISR 0x880C
#define B_BE_CR_PLD_LEN_ERR BIT(30)
#define B_BE_CR_WRFF_UNDERFLOW_ERR BIT(29)
#define B_BE_CR_WRFF_OVERFLOW_ERR BIT(28)
#define B_BE_CR_SHIFT_DMA_CFG_ERR BIT(27)
#define B_BE_CR_DMA_PROCESS_ERR BIT(26)
#define B_BE_CR_TOTAL_LEN_UNDER_ERR BIT(25)
#define B_BE_CR_SHIFT_EN_ERR BIT(24)
#define B_BE_REUSE_FIFO_B_UNDER_ERR BIT(22)
#define B_BE_REUSE_FIFO_B_OVER_ERR BIT(21)
#define B_BE_REUSE_FIFO_A_UNDER_ERR BIT(20)
#define B_BE_REUSE_FIFO_A_OVER_ERR BIT(19)
#define B_BE_CT_ADDR_INFO_LEN_MISS_ERR BIT(17)
#define B_BE_CT_WD_LEN_OVER_ERR BIT(16)
#define B_BE_CT_F2P_SEQ_ERR BIT(15)
#define B_BE_CT_F2P_QSEL_ERR BIT(14)
#define B_BE_CT_PLD_CMD_UNDERFLOW_ERR BIT(13)
#define B_BE_CT_PLD_CMD_OVERFLOW_ERR BIT(12)
#define B_BE_CT_PRE_SUB_ERR BIT(11)
#define B_BE_CT_WD_CHKSUM_ERR BIT(10)
#define B_BE_CT_CHANNEL_DMA_ERR BIT(9)
#define B_BE_CT_OFFSET_UNMATCH_ERR BIT(8)
#define B_BE_CT_PAYLOAD_CHKSUM_ERR BIT(7)
#define B_BE_CT_PAYLOAD_UNDER_ERR BIT(6)
#define B_BE_CT_PAYLOAD_OVER_ERR BIT(5)
#define B_BE_CT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_BE_CT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_BE_CT_CH_ID_ERR BIT(2)
#define B_BE_CT_EP_CH_DIFF_ERR BIT(0)

#define R_BE_TX_ADDRESS_INFO_MODE_SETTING 0x8810
#define B_BE_CPU_ADDR_INFO_8B_SEL BIT(8)
#define B_BE_HOST_ADDR_INFO_8B_SEL BIT(0)

#define R_BE_TX_TCPIP_CHECKSUM_FUNCTION 0x8814
#define B_BE_HDT_TCPIP_CHKSUM_EN BIT(0)

#define R_BE_TXAGG_ALIGN_CFG 0x8818
#define B_BE_TXAGG_ALIGN_SIZE_EN BIT(31)
#define B_BE_TXAGG_ALIGN_SIZE_SH 0
#define B_BE_TXAGG_ALIGN_SIZE_MSK 0xfff

#define R_BE_TX_PASTE_TIMESTAMP_SETTING 0x881C
#define B_BE_CDT_TIMESTAMP_EN BIT(1)
#define B_BE_HDT_TIMESTAMP_EN BIT(0)

#define R_BE_CPU_PORT_DEBUG_SETTING 0x8820
#define B_BE_CDT_F2P_CPU_PORT_EN BIT(9)
#define B_BE_CDT_AC_CPU_PORT_EN BIT(8)
#define B_BE_HDT_H2C_RX_Q_SEL_SH 1
#define B_BE_HDT_H2C_RX_Q_SEL_MSK 0x3
#define B_BE_HDT_AC_CPU_PORT_EN BIT(0)

#define R_BE_TX_CHECK_OFFSET_SETTING 0x8824
#define B_BE_CDT_CHK_OFFSET_EN BIT(24)
#define B_BE_CDT_CHK_OFFSET_SH 16
#define B_BE_CDT_CHK_OFFSET_MSK 0xff
#define B_BE_HDT_CHK_OFFSET_EN BIT(8)
#define B_BE_HDT_CHK_OFFSET_SH 0
#define B_BE_HDT_CHK_OFFSET_MSK 0xff

#define R_BE_TX_QUEUE_CLEAR_SETTING 0x8828
#define B_BE_HDT_TXQUE_CLR_EN BIT(0)

#define R_BE_TX_ERROR_STOP_DEBUG_SETTING 0x882C
#define B_BE_CDT_ERROR_STOP BIT(8)
#define B_BE_HDT_ERROR_STOP BIT(0)

#define R_BE_WD_CHECKSUM_FUNCTION_ENABLE 0x8830
#define B_BE_CDT_WD_CHKSUM_EN BIT(8)
#define B_BE_HDT_WD_CHKSUM_EN BIT(0)

#define R_BE_TX_DTAT_DROP_DEBUG_SETTING 0x8834
#define B_BE_HDT_REUSE_EN BIT(23)
#define B_BE_HDT_REUSE_OFFSET_SH 16
#define B_BE_HDT_REUSE_OFFSET_MSK 0xf
#define B_BE_CDT_DATA_DROP_EN BIT(8)
#define B_BE_HDT_DATA_DROP_EN BIT(0)

#define R_BE_REQUEST_PLE_BUFFER_SETTING 0x8838
#define B_BE_AMSDU_HDR_CNV_SPACE_SH 16
#define B_BE_AMSDU_HDR_CNV_SPACE_MSK 0xf
#define B_BE_AMSDU_PADDING_SPACE_SH 8
#define B_BE_AMSDU_PADDING_SPACE_MSK 0xff
#define B_BE_RSV_PLD_SPACE_SH 0
#define B_BE_RSV_PLD_SPACE_MSK 0xff

#define R_BE_DMAC_MACID_DROP_0 0x8840
#define B_BE_DMAC_MACID31_0_DROP_SH 0
#define B_BE_DMAC_MACID31_0_DROP_MSK 0xffffffffL

#define R_BE_DMAC_MACID_DROP_1 0x8844
#define B_BE_DMAC_MACID63_32_DROP_SH 0
#define B_BE_DMAC_MACID63_32_DROP_MSK 0xffffffffL

#define R_BE_DMAC_MACID_DROP_2 0x8848
#define B_BE_DMAC_MACID95_64_DROP_SH 0
#define B_BE_DMAC_MACID95_64_DROP_MSK 0xffffffffL

#define R_BE_DMAC_MACID_DROP_3 0x884C
#define B_BE_DMAC_MACID127_96_DROP_SH 0
#define B_BE_DMAC_MACID127_96_DROP_MSK 0xffffffffL

#define R_BE_HOST_DISPATCHER_ERR_IMR 0x8850
#define B_BE_HR_WRFF_UNDERFLOW_ERR_INT_EN BIT(31)
#define B_BE_HR_WRFF_OVERFLOW_ERR_INT_EN BIT(30)
#define B_BE_HR_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_BE_HR_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_BE_HR_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_BE_HR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(26)
#define B_BE_HR_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_BE_HR_AGG_CFG_ERR_INT_EN BIT(24)
#define B_BE_HR_DMA_RD_CNT_DEQ_ERR_INT_EN BIT(23)
#define B_BE_HR_PLD_LEN_ZERO_ERR_INT_EN BIT(22)
#define B_BE_HT_ILL_CH_ERR_INT_EN BIT(20)
#define B_BE_HT_ADDR_INFO_LEN_ERR_INT_EN BIT(18)
#define B_BE_HT_WD_LEN_OVER_ERR_INT_EN BIT(17)
#define B_BE_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(16)
#define B_BE_HT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(15)
#define B_BE_HT_WRFF_UNDERFLOW_ERR_INT_EN BIT(14)
#define B_BE_HT_WRFF_OVERFLOW_ERR_INT_EN BIT(13)
#define B_BE_HT_CHKSUM_FSM_ERR_INT_EN BIT(12)
#define B_BE_HT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_BE_HT_PRE_SUB_ERR_INT_EN BIT(10)
#define B_BE_HT_WD_CHKSUM_ERR_INT_EN BIT(9)
#define B_BE_HT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_BE_HT_OFFSET_UNMATCH_ERR_INT_EN BIT(7)
#define B_BE_HT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_BE_HT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_BE_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_BE_HT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_BE_HT_PKT_FAIL_ERR_INT_EN BIT(2)
#define B_BE_HT_CH_ID_ERR_INT_EN BIT(1)
#define B_BE_HT_EP_CH_DIFF_ERR_INT_EN BIT(0)

#define R_BE_CPU_DISPATCHER_ERR_IMR 0x8854
#define B_BE_CR_PLD_LEN_ERR_INT_EN BIT(30)
#define B_BE_CR_WRFF_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_BE_CR_WRFF_OVERFLOW_ERR_INT_EN BIT(28)
#define B_BE_CR_SHIFT_DMA_CFG_ERR_INT_EN BIT(27)
#define B_BE_CR_DMA_PROCESS_ERR_INT_EN BIT(26)
#define B_BE_CR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(25)
#define B_BE_CR_SHIFT_EN_ERR_INT_EN BIT(24)
#define B_BE_REUSE_FIFO_B_UNDER_ERR_INT_EN BIT(22)
#define B_BE_REUSE_FIFO_B_OVER_ERR_INT_EN BIT(21)
#define B_BE_REUSE_FIFO_A_UNDER_ERR_INT_EN BIT(20)
#define B_BE_REUSE_FIFO_A_OVER_ERR_INT_EN BIT(19)
#define B_BE_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN BIT(17)
#define B_BE_CT_WD_LEN_OVER_ERR_INT_EN BIT(16)
#define B_BE_CT_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_BE_CT_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_BE_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(13)
#define B_BE_CT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(12)
#define B_BE_CT_PRE_SUB_ERR_INT_EN BIT(11)
#define B_BE_CT_WD_CHKSUM_ERR_INT_EN BIT(10)
#define B_BE_CT_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_BE_CT_OFFSET_UNMATCH_ERR_INT_EN BIT(8)
#define B_BE_CT_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_BE_CT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_BE_CT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_BE_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_BE_CT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_BE_CT_CH_ID_ERR_INT_EN BIT(2)
#define B_BE_CT_EP_CH_DIFF_ERR_INT_EN BIT(0)

#define R_BE_OTHER_DISPATCHER_ERR_IMR 0x8858
#define B_BE_REUSE_SIZE_ERR_INT_EN BIT(31)
#define B_BE_REUSE_EN_ERR_INT_EN BIT(30)
#define B_BE_STF_OQT_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_BE_STF_OQT_OVERFLOW_ERR_INT_EN BIT(28)
#define B_BE_STF_WRFF_UNDERFLOW_ERR_INT_EN BIT(27)
#define B_BE_STF_WRFF_OVERFLOW_ERR_INT_EN BIT(26)
#define B_BE_STF_CMD_UNDERFLOW_ERR_INT_EN BIT(25)
#define B_BE_STF_CMD_OVERFLOW_ERR_INT_EN BIT(24)
#define B_BE_REUSE_SIZE_ZERO_ERR_INT_EN BIT(23)
#define B_BE_REUSE_PKT_CNT_ERR_INT_EN BIT(22)
#define B_BE_CDT_PTR_TIMEOUT_ERR_INT_EN BIT(21)
#define B_BE_CDT_HCI_TIMEOUT_ERR_INT_EN BIT(20)
#define B_BE_HDT_PTR_TIMEOUT_ERR_INT_EN BIT(19)
#define B_BE_HDT_HCI_TIMEOUT_ERR_INT_EN BIT(18)
#define B_BE_CDT_ADDR_INFO_LEN_ERR_INT_EN BIT(17)
#define B_BE_HDT_ADDR_INFO_LEN_ERR_INT_EN BIT(16)
#define B_BE_CDR_DMA_TIMEOUT_ERR_INT_EN BIT(15)
#define B_BE_CDR_RX_TIMEOUT_ERR_INT_EN BIT(14)
#define B_BE_PLE_OUTPUT_ERR_INT_EN BIT(12)
#define B_BE_PLE_RESPOSE_ERR_INT_EN BIT(11)
#define B_BE_PLE_BURST_NUM_ERR_INT_EN BIT(10)
#define B_BE_PLE_NULL_PKT_ERR_INT_EN BIT(9)
#define B_BE_PLE_FLOW_CTRL_ERR_INT_EN BIT(8)
#define B_BE_HDR_DMA_TIMEOUT_ERR_INT_EN BIT(7)
#define B_BE_HDR_RX_TIMEOUT_ERR_INT_EN BIT(6)
#define B_BE_WDE_OUTPUT_ERR_INT_EN BIT(4)
#define B_BE_WDE_RESPONSE_ERR_INT_EN BIT(3)
#define B_BE_WDE_BURST_NUM_ERR_INT_EN BIT(2)
#define B_BE_WDE_NULL_PKT_ERR_INT_EN BIT(1)
#define B_BE_WDE_FLOW_CTRL_ERR_INT_EN BIT(0)

#define R_BE_DISPATCHER_DBG_PORT 0x8860
#define B_BE_DISPATCHER_DBG_PTR_SEL1_SH 24
#define B_BE_DISPATCHER_DBG_PTR_SEL1_MSK 0xf
#define B_BE_DISPATCHER_DBG_SEL1_SH 16
#define B_BE_DISPATCHER_DBG_SEL1_MSK 0xff
#define B_BE_DISPATCHER_DBG_PTR_SEL0_SH 8
#define B_BE_DISPATCHER_DBG_PTR_SEL0_MSK 0xf
#define B_BE_DISPATCHER_DBG_SEL0_SH 0
#define B_BE_DISPATCHER_DBG_SEL0_MSK 0xff

#define R_BE_DISPATCHER_DISP_DBG 0x8864
#define B_BE_DISPATCHER_DISP_DBG_SH 0
#define B_BE_DISPATCHER_DISP_DBG_MSK 0xffffffffL

#define R_BE_DELAY_MULTI_WP_SRC 0x8868
#define B_BE_DELAY_MULTI_WP_SRC BIT(0)

#define R_BE_HDP_DBG_INFO_0_V1 0x8880
#define B_BE_PTR_CS_WP_SH 28
#define B_BE_PTR_CS_WP_MSK 0xf
#define B_BE_PTR_CS_10_SH 24
#define B_BE_PTR_CS_10_MSK 0xf
#define B_BE_PTR_CS_8_SH 20
#define B_BE_PTR_CS_8_MSK 0xf
#define B_BE_PTR_CS_6_SH 16
#define B_BE_PTR_CS_6_MSK 0xf
#define B_BE_PTR_CS_4_SH 12
#define B_BE_PTR_CS_4_MSK 0xf
#define B_BE_PTR_CS_2_SH 8
#define B_BE_PTR_CS_2_MSK 0xf
#define B_BE_PTR_CS_0_SH 4
#define B_BE_PTR_CS_0_MSK 0xf
#define B_BE_HCIFF_NON_EMPTY_V1 BIT(3)
#define B_BE_DATA_CS_SH 0
#define B_BE_DATA_CS_MSK 0x7

#define R_BE_HDP_DBG_INFO_1_V1 0x8884
#define B_BE_PTR_CS_12_HDT_SH 28
#define B_BE_PTR_CS_12_HDT_MSK 0xf
#define B_BE_F2P_PTR_CS_SH 24
#define B_BE_F2P_PTR_CS_MSK 0xf
#define B_BE_PTR_CS_WP_CDT_SH 20
#define B_BE_PTR_CS_WP_CDT_MSK 0xf
#define B_BE_PTR_CS_CDT_SH 16
#define B_BE_PTR_CS_CDT_MSK 0xf
#define B_BE_PTR_CS_C2H_CDT_SH 12
#define B_BE_PTR_CS_C2H_CDT_MSK 0xf
#define B_BE_AXIFF_NON_EMPTY_V1 BIT(11)
#define B_BE_DATA_CS_CDT_SH 8
#define B_BE_DATA_CS_CDT_MSK 0x7
#define B_BE_ADDR_INFO_CS_V1_SH 4
#define B_BE_ADDR_INFO_CS_V1_MSK 0xf
#define B_BE_STF_CS_SH 0
#define B_BE_STF_CS_MSK 0xf

#define R_BE_HDP_DBG_INFO_2_V1 0x8888
#define B_BE_WRFF_EMPTY_HDT BIT(31)
#define B_BE_WRFF_FULL_HDT BIT(30)
#define B_BE_WRFF_PRE_FULL_HDT BIT(29)
#define B_BE_HCIWPFF_FULL BIT(28)
#define B_BE_AXIWPFF_FULL BIT(27)
#define B_BE_HCI_REQ_CH_PG_SH 13
#define B_BE_HCI_REQ_CH_PG_MSK 0x1fff
#define B_BE_TX_FULL_STS_SH 0
#define B_BE_TX_FULL_STS_MSK 0x1fff

#define R_BE_HDP_DBG_INFO_3_V1 0x888C

#define R_BE_HDP_DBG_INFO_4_V1 0x8890

#define R_BE_HDP_DBG_INFO_5_V1 0x8894

#define R_BE_HDP_DBG_INFO_6_V1 0x8898

#define R_BE_HDP_DBG_INFO_7_V1 0x889C
#define B_BE_WRFF_EMPTY_HDR BIT(23)
#define B_BE_WRFF_PRE_FULL_HDR BIT(22)
#define B_BE_WRFF_FULL_HDR BIT(21)
#define B_BE_DMA_ST_HDR_SH 16
#define B_BE_DMA_ST_HDR_MSK 0xf
#define B_BE_RX_ST_HDR_SH 12
#define B_BE_RX_ST_HDR_MSK 0x7
#define B_BE_LENFF_EMPTY_HDR BIT(11)
#define B_BE_LENFF_PRE_FULL_HDR BIT(10)
#define B_BE_LENFF_FULL_HDR BIT(9)
#define B_BE_HR_RXPKT_PROCESS BIT(7)
#define B_BE_HR_HCI_LAST_DMA BIT(6)
#define B_BE_HR_HCI_REQ_SH 4
#define B_BE_HR_HCI_REQ_MSK 0x3
#define B_BE_HR_HCI_EMPTY BIT(3)
#define B_BE_PCIE_BD_VLD_SH 0
#define B_BE_PCIE_BD_VLD_MSK 0x3

#define R_BE_HDP_DBG_INFO_8_V1 0x88A0
#define B_BE_HR_HCI_LENGTH_SH 16
#define B_BE_HR_HCI_LENGTH_MSK 0xffff
#define B_BE_PLE_Q_EMPTY_SH 0
#define B_BE_PLE_Q_EMPTY_MSK 0xffff

#define R_BE_HDP_DBG_INFO_9_V1 0x88A4
#define B_BE_WRFF_PRE_FULL_CDR BIT(31)
#define B_BE_WRFF_FULL_CDR BIT(30)
#define B_BE_WRFF_EMPTY_CDR BIT(29)
#define B_BE_DMA_ST_CDR_SH 24
#define B_BE_DMA_ST_CDR_MSK 0x7
#define B_BE_RX_ST_CDR_SH 20
#define B_BE_RX_ST_CDR_MSK 0x7
#define B_BE_CR_HCI_NEED_RXBD_TAG BIT(19)
#define B_BE_CR_RXPKT_PROCESS BIT(18)
#define B_BE_CR_HCI_LAST_DMA BIT(17)
#define B_BE_CR_HCI_EMPTY BIT(16)
#define B_BE_CR_HCI_REQ_SH 12
#define B_BE_CR_HCI_REQ_MSK 0x7
#define B_BE_AXIDMA_BD_VLD_SH 8
#define B_BE_AXIDMA_BD_VLD_MSK 0x7

#define R_BE_RXDMA_SETTING 0x8908
#define B_BE_PLE_BURST_READ BIT(24)
#define B_BE_REQ_DEPTH_SH 16
#define B_BE_REQ_DEPTH_MSK 0x3
#define B_BE_BULK_TH_OPT BIT(10)
#define B_BE_BURST_CNT_SH 8
#define B_BE_BURST_CNT_MSK 0x3
#define B_BE_BULK_SIZE_SH 0
#define B_BE_BULK_SIZE_MSK 0x3

#define R_BE_FWDL_CHECKSUM 0x890C
#define B_BE_FWDL_CHKSUM_SH 16
#define B_BE_FWDL_CHKSUM_MSK 0xffff
#define B_BE_FWDL_CHKSUM_VALID BIT(2)
#define B_BE_FWDL_CHKSUM_RESULT BIT(1)
#define B_BE_FWDL_CHKSUM_EN BIT(0)

#define R_BE_H2C_SETTING 0x8910
#define B_BE_RX_CPU_PORT_SEL BIT(8)
#define B_BE_REMOVE_H2C_RXD BIT(0)

#define R_BE_RX_PPDU_STATUS_FW_MODE 0x8914
#define B_BE_HDR_PPDU_ENQ_WLCPU_EN BIT(31)
#define B_BE_CDR_PPDU_2_WLCPU_LEN_SH 0
#define B_BE_CDR_PPDU_2_WLCPU_LEN_MSK 0x3fff

#define R_BE_RX_TCPIP_CHECKSUM_FUNCTION 0x8918
#define B_BE_HDR_TCPIP_CHKSUM_EN BIT(0)

#define R_BE_RX_FC_BD_VALID_MASK 0x891C
#define B_BE_CDR_BD_MASK_V1_SH 8
#define B_BE_CDR_BD_MASK_V1_MSK 0x7
#define B_BE_HDR_BD_MASK_SH 0
#define B_BE_HDR_BD_MASK_MSK 0x3

#define R_BE_RX_FUNCTION_STOP 0x8920
#define B_BE_CDR_DISABLE_CH2 BIT(18)
#define B_BE_CDR_DISABLE_CH1 BIT(17)
#define B_BE_CDR_DISABLE_CH0 BIT(16)
#define B_BE_HDR_DISABLE_RPQ BIT(11)
#define B_BE_HDR_DISABLE_C2H BIT(10)
#define B_BE_HDR_DISABLE_REPORT BIT(9)
#define B_BE_HDR_DISABLE_NORMAL BIT(8)
#define B_BE_CDR_RX_STOP BIT(1)
#define B_BE_HDR_RX_STOP BIT(0)

#define R_BE_TYPE_NEED_RXBD_TAG 0x8924
#define B_BE_TUPE_ENQ_TO_CPU_SH 16
#define B_BE_TUPE_ENQ_TO_CPU_MSK 0xffff
#define B_BE_TYPE_NEED_RXBD_TAG_SH 0
#define B_BE_TYPE_NEED_RXBD_TAG_MSK 0xffff

//
// WDE_DLE
//

#define R_BE_WDE_GLB_CFG 0x8C00
#define B_BE_WDE_DIS_ACGC_FUNC BIT(0)

#define R_BE_WDE_WORD004 0x8C04

#define R_BE_WDE_PKTBUF_CFG 0x8C08
#define B_BE_WDE_FREE_PAGE_NUM_SH 16
#define B_BE_WDE_FREE_PAGE_NUM_MSK 0x1fff
#define B_BE_WDE_START_BOUND_SH 8
#define B_BE_WDE_START_BOUND_MSK 0x3f
#define B_BE_WDE_PAGE_SEL_SH 0
#define B_BE_WDE_PAGE_SEL_MSK 0x3

#define R_BE_WDE_WORD00C 0x8C0C

#define R_BE_WDE_WORD010 0x8C10

#define R_BE_WDE_WORD014 0x8C14

#define R_BE_WDE_DATCHN_CTL 0x8C18
#define B_BE_WDE_NULLPG_WRPORT BIT(8)

#define R_BE_WDE_FUNC_RSTCTL 0x8C1C
#define B_BE_WDE_GEN_PIF07 BIT(7)
#define B_BE_WDE_GEN_PIF06 BIT(6)
#define B_BE_WDE_GEN_PIF05 BIT(5)
#define B_BE_WDE_GEN_PIF04 BIT(4)
#define B_BE_WDE_GEN_PIF03 BIT(3)
#define B_BE_WDE_GEN_PIF02 BIT(2)
#define B_BE_WDE_GEN_PIF01 BIT(1)
#define B_BE_WDE_GEN_PIF00 BIT(0)

#define R_BE_WDE_DBGERR_LOCKEN 0x8C20
#define B_BE_WDE_LOCKEN_DLEPIF07 BIT(7)
#define B_BE_WDE_LOCKEN_DLEPIF06 BIT(6)
#define B_BE_WDE_LOCKEN_DLEPIF05 BIT(5)
#define B_BE_WDE_LOCKEN_DLEPIF04 BIT(4)
#define B_BE_WDE_LOCKEN_DLEPIF03 BIT(3)
#define B_BE_WDE_LOCKEN_DLEPIF02 BIT(2)
#define B_BE_WDE_LOCKEN_DLEPIF01 BIT(1)
#define B_BE_WDE_LOCKEN_DLEPIF00 BIT(0)

#define R_BE_WDE_DBGERR_STS 0x8C24
#define B_BE_WDE_LOCKON_DLEPIF07 BIT(7)
#define B_BE_WDE_LOCKON_DLEPIF06 BIT(6)
#define B_BE_WDE_LOCKON_DLEPIF05 BIT(5)
#define B_BE_WDE_LOCKON_DLEPIF04 BIT(4)
#define B_BE_WDE_LOCKON_DLEPIF03 BIT(3)
#define B_BE_WDE_LOCKON_DLEPIF02 BIT(2)
#define B_BE_WDE_LOCKON_DLEPIF01 BIT(1)
#define B_BE_WDE_LOCKON_DLEPIF00 BIT(0)

#define R_BE_WDE_WORD028 0x8C28

#define R_BE_WDE_WORD02C 0x8C2C

#define R_BE_WDE_ERRFLAG_MSG 0x8C30
#define B_BE_WDE_ERR_FLAG_MSG_SH 0
#define B_BE_WDE_ERR_FLAG_MSG_MSK 0xffffffffL

#define R_BE_WDE_ERR_FLAG_CFG_NUM1 0x8C34
#define B_BE_WDE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_BE_WDE_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_BE_WDE_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_BE_WDE_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_BE_WDE_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_BE_WDE_DATCHN_FRZTMR_MODE BIT(2)
#define B_BE_WDE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_BE_WDE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_BE_WDE_ERR_IMR 0x8C38
#define B_BE_WDE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_BE_WDE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_BE_WDE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_BE_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_BE_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_BE_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_BE_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_BE_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_BE_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_BE_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_BE_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_BE_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_BE_WDE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_BE_WDE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_BE_WDE_BUFMGN_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_WDE_GETNPG_PGOFST_ERR_INT_EN BIT(8)
#define B_BE_WDE_GETNPG_STRPG_ERR_INT_EN BIT(7)
#define B_BE_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(6)
#define B_BE_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_BE_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(4)
#define B_BE_WDE_BUFREQ_UNAVAL_ERR_INT_EN BIT(3)
#define B_BE_WDE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_BE_WDE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_BE_WDE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_BE_WDE_ERR_ISR 0x8C3C
#define B_BE_WDE_DATCHN_EVT7_ERR BIT(31)
#define B_BE_WDE_DATCHN_EVT6_ERR BIT(30)
#define B_BE_WDE_DATCHN_CAMREQ_ERR BIT(29)
#define B_BE_WDE_DATCHN_ADRERR_ERR BIT(28)
#define B_BE_WDE_DATCHN_RRDY_ERR BIT(27)
#define B_BE_WDE_DATCHN_FRZTO_ERR BIT(26)
#define B_BE_WDE_DATCHN_NULLPG_ERR BIT(25)
#define B_BE_WDE_DATCHN_ARBT_ERR BIT(24)
#define B_BE_WDE_QUEMGN_FRZTO_ERR BIT(19)
#define B_BE_WDE_NXTPKTLL_AD_ERR BIT(18)
#define B_BE_WDE_PREPKTLLT_AD_ERR BIT(17)
#define B_BE_WDE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_BE_WDE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_BE_WDE_QUE_SRCQUEID_ERR BIT(14)
#define B_BE_WDE_QUE_DSTQUEID_ERR BIT(13)
#define B_BE_WDE_QUE_CMDTYPE_ERR BIT(12)
#define B_BE_WDE_DATCHN_EVT11_ERR BIT(11)
#define B_BE_WDE_DATCHN_EVT10_ERR BIT(10)
#define B_BE_WDE_BUFMGN_FRZTO_ERR BIT(9)
#define B_BE_WDE_GETNPG_PGOFST_ERR BIT(8)
#define B_BE_WDE_GETNPG_STRPG_ERR BIT(7)
#define B_BE_WDE_BUFREQ_SRCHTAILPG_ERR BIT(6)
#define B_BE_WDE_BUFRTN_SIZE_ERR BIT(5)
#define B_BE_WDE_BUFRTN_INVLD_PKTID_ERR BIT(4)
#define B_BE_WDE_BUFREQ_UNAVAL_ERR BIT(3)
#define B_BE_WDE_BUFREQ_SIZELMT_ERR BIT(2)
#define B_BE_WDE_BUFREQ_SIZE0_ERR BIT(1)
#define B_BE_WDE_BUFREQ_QTAID_ERR BIT(0)

#define R_BE_WDE_QTA0_CFG 0x8C40
#define B_BE_WDE_Q0_MAX_SIZE_SH 16
#define B_BE_WDE_Q0_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q0_MIN_SIZE_SH 0
#define B_BE_WDE_Q0_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA1_CFG 0x8C44
#define B_BE_WDE_Q1_MAX_SIZE_SH 16
#define B_BE_WDE_Q1_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q1_MIN_SIZE_SH 0
#define B_BE_WDE_Q1_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA2_CFG 0x8C48
#define B_BE_WDE_Q2_MAX_SIZE_SH 16
#define B_BE_WDE_Q2_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q2_MIN_SIZE_SH 0
#define B_BE_WDE_Q2_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA3_CFG 0x8C4C
#define B_BE_WDE_Q3_MAX_SIZE_SH 16
#define B_BE_WDE_Q3_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q3_MIN_SIZE_SH 0
#define B_BE_WDE_Q3_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA4_CFG 0x8C50
#define B_BE_WDE_Q4_MAX_SIZE_SH 16
#define B_BE_WDE_Q4_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q4_MIN_SIZE_SH 0
#define B_BE_WDE_Q4_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA5_CFG 0x8C54
#define B_BE_WDE_Q5_MAX_SIZE_SH 16
#define B_BE_WDE_Q5_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q5_MIN_SIZE_SH 0
#define B_BE_WDE_Q5_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA6_CFG 0x8C58
#define B_BE_WDE_Q6_MAX_SIZE_SH 16
#define B_BE_WDE_Q6_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q6_MIN_SIZE_SH 0
#define B_BE_WDE_Q6_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA7_CFG 0x8C5C
#define B_BE_WDE_Q7_MAX_SIZE_SH 16
#define B_BE_WDE_Q7_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q7_MIN_SIZE_SH 0
#define B_BE_WDE_Q7_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA8_CFG 0x8C60
#define B_BE_WDE_Q8_MAX_SIZE_SH 16
#define B_BE_WDE_Q8_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q8_MIN_SIZE_SH 0
#define B_BE_WDE_Q8_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA9_CFG 0x8C64
#define B_BE_WDE_Q9_MAX_SIZE_SH 16
#define B_BE_WDE_Q9_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q9_MIN_SIZE_SH 0
#define B_BE_WDE_Q9_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA10_CFG 0x8C68
#define B_BE_WDE_Q10_MAX_SIZE_SH 16
#define B_BE_WDE_Q10_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q10_MIN_SIZE_SH 0
#define B_BE_WDE_Q10_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA11_CFG 0x8C6C
#define B_BE_WDE_Q11_MAX_SIZE_SH 16
#define B_BE_WDE_Q11_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q11_MIN_SIZE_SH 0
#define B_BE_WDE_Q11_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA12_CFG 0x8C70
#define B_BE_WDE_Q12_MAX_SIZE_SH 16
#define B_BE_WDE_Q12_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q12_MIN_SIZE_SH 0
#define B_BE_WDE_Q12_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA13_CFG 0x8C74
#define B_BE_WDE_Q13_MAX_SIZE_SH 16
#define B_BE_WDE_Q13_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q13_MIN_SIZE_SH 0
#define B_BE_WDE_Q13_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA14_CFG 0x8C78
#define B_BE_WDE_Q14_MAX_SIZE_SH 16
#define B_BE_WDE_Q14_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q14_MIN_SIZE_SH 0
#define B_BE_WDE_Q14_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_QTA15_CFG 0x8C7C
#define B_BE_WDE_Q15_MAX_SIZE_SH 16
#define B_BE_WDE_Q15_MAX_SIZE_MSK 0xfff
#define B_BE_WDE_Q15_MIN_SIZE_SH 0
#define B_BE_WDE_Q15_MIN_SIZE_MSK 0xfff

#define R_BE_WDE_WORD0F0 0x8CF0

#define R_BE_WDE_WORD0F4 0x8CF4

#define R_BE_WDE_WORD0F8 0x8CF8

#define R_BE_WDE_WORD0FC 0x8CFC

#define R_BE_WDE_INI_STATUS 0x8D00
#define B_BE_WDE_Q_MGN_INI_RDY BIT(1)
#define B_BE_WDE_BUF_MGN_INI_RDY BIT(0)

#define R_BE_WDE_WORD104 0x8D04

#define R_BE_WDE_WORD108 0x8D08

#define R_BE_WDE_WORD10C 0x8D0C

#define R_BE_WDE_DBG_FUN_INTF_CTL 0x8D10
#define B_BE_WDE_DFI_ACTIVE BIT(31)
#define B_BE_WDE_DFI_TRGSEL_SH 16
#define B_BE_WDE_DFI_TRGSEL_MSK 0xf
#define B_BE_WDE_DFI_ADDR_SH 0
#define B_BE_WDE_DFI_ADDR_MSK 0xffff

#define R_BE_WDE_DBG_FUN_INTF_DATA 0x8D14
#define B_BE_WDE_DFI_DATA_SH 0
#define B_BE_WDE_DFI_DATA_MSK 0xffffffffL

#define R_BE_WDE_DBG_CTL 0x8D18
#define B_BE_WDE_DBG1_SEL_SH 8
#define B_BE_WDE_DBG1_SEL_MSK 0xff
#define B_BE_WDE_DBG0_SEL_SH 0
#define B_BE_WDE_DBG0_SEL_MSK 0xff

#define R_BE_DBG_OUT 0x8D1C
#define B_BE_WDE_DBG1_OUT_SH 16
#define B_BE_WDE_DBG1_OUT_MSK 0xffff
#define B_BE_WDE_DBG0_OUT_SH 0
#define B_BE_WDE_DBG0_OUT_MSK 0xffff

#define R_BE_WDE_Q_STATUS_CFG 0x8D80
#define B_BE_WDE_Q_STATUS_SEL_SH 0
#define B_BE_WDE_Q_STATUS_SEL_MSK 0x7

#define R_BE_WDE_Q_STATUS_VAL 0x8D84
#define B_BE_WDE_Q_STATUS_VAL_SH 0
#define B_BE_WDE_Q_STATUS_VAL_MSK 0xffffffffL

//
// PLE_DLE
//

#define R_BE_PLE_GLB_CFG 0x9000
#define B_BE_PLE_DIS_ACGC_FUNC BIT(0)

#define R_BE_PLE_WORD004 0x9004

#define R_BE_PLE_PKTBUF_CFG 0x9008
#define B_BE_PLE_FREE_PAGE_NUM_SH 16
#define B_BE_PLE_FREE_PAGE_NUM_MSK 0x1fff
#define B_BE_PLE_START_BOUND_SH 8
#define B_BE_PLE_START_BOUND_MSK 0x3f
#define B_BE_PLE_PAGE_SEL_SH 0
#define B_BE_PLE_PAGE_SEL_MSK 0x3

#define R_BE_PLE_WORD00C 0x900C

#define R_BE_PLE_WORD010 0x9010

#define R_BE_PLE_WORD014 0x9014

#define R_BE_PLE_DATCHN_CTL 0x9018
#define B_BE_PLE_NULLPG_WRPORT BIT(8)

#define R_BE_PLE_FUNC_RSTCTL 0x901C
#define B_BE_PLE_GEN_PIF07 BIT(7)
#define B_BE_PLE_GEN_PIF06 BIT(6)
#define B_BE_PLE_GEN_PIF05 BIT(5)
#define B_BE_PLE_GEN_PIF04 BIT(4)
#define B_BE_PLE_GEN_PIF03 BIT(3)
#define B_BE_PLE_GEN_PIF02 BIT(2)
#define B_BE_PLE_GEN_PIF01 BIT(1)
#define B_BE_PLE_GEN_PIF00 BIT(0)

#define R_BE_PLE_DBGERR_LOCKEN 0x9020
#define B_BE_PLE_LOCKEN_DLEPIF07 BIT(7)
#define B_BE_PLE_LOCKEN_DLEPIF06 BIT(6)
#define B_BE_PLE_LOCKEN_DLEPIF05 BIT(5)
#define B_BE_PLE_LOCKEN_DLEPIF04 BIT(4)
#define B_BE_PLE_LOCKEN_DLEPIF03 BIT(3)
#define B_BE_PLE_LOCKEN_DLEPIF02 BIT(2)
#define B_BE_PLE_LOCKEN_DLEPIF01 BIT(1)
#define B_BE_PLE_LOCKEN_DLEPIF00 BIT(0)

#define R_BE_PLE_DBGERR_STS 0x9024
#define B_BE_PLE_LOCKON_DLEPIF07 BIT(7)
#define B_BE_PLE_LOCKON_DLEPIF06 BIT(6)
#define B_BE_PLE_LOCKON_DLEPIF05 BIT(5)
#define B_BE_PLE_LOCKON_DLEPIF04 BIT(4)
#define B_BE_PLE_LOCKON_DLEPIF03 BIT(3)
#define B_BE_PLE_LOCKON_DLEPIF02 BIT(2)
#define B_BE_PLE_LOCKON_DLEPIF01 BIT(1)
#define B_BE_PLE_LOCKON_DLEPIF00 BIT(0)

#define R_BE_PLE_WORD028 0x9028

#define R_BE_PLE_WORD02C 0x902C

#define R_BE_PLE_ERRFLAG_MSG 0x9030
#define B_BE_PLE_ERR_FLAG_MSG_SH 0
#define B_BE_PLE_ERR_FLAG_MSG_MSK 0xffffffffL

#define R_BE_PLE_ERR_FLAG_CFG_NUM1 0x9034
#define B_BE_PLE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_BE_PLE_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_BE_PLE_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_BE_PLE_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_BE_PLE_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_BE_PLE_DATCHN_FRZTMR_MODE BIT(2)
#define B_BE_PLE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_BE_PLE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_BE_PLE_ERR_IMR 0x9038
#define B_BE_PLE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_BE_PLE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_BE_PLE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_BE_PLE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_BE_PLE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_BE_PLE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_BE_PLE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_BE_PLE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_BE_PLE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_BE_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_BE_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_BE_PLE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_BE_PLE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_BE_PLE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_BE_PLE_BUFMGN_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_PLE_GETNPG_PGOFST_ERR_INT_EN BIT(8)
#define B_BE_PLE_GETNPG_STRPG_ERR_INT_EN BIT(7)
#define B_BE_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(6)
#define B_BE_PLE_BUFRTN_SIZE_ERR_INT_EN BIT(5)
#define B_BE_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(4)
#define B_BE_PLE_BUFREQ_UNAVAL_ERR_INT_EN BIT(3)
#define B_BE_PLE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_BE_PLE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_BE_PLE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_BE_PLE_ERR_FLAG_ISR 0x903C
#define B_BE_PLE_DATCHN_EVT7_ERR BIT(31)
#define B_BE_PLE_DATCHN_EVT6_ERR BIT(30)
#define B_BE_PLE_DATCHN_CAMREQ_ERR BIT(29)
#define B_BE_PLE_DATCHN_ADRERR_ERR BIT(28)
#define B_BE_PLE_DATCHN_RRDY_ERR BIT(27)
#define B_BE_PLE_DATCHN_FRZTO_ERR BIT(26)
#define B_BE_PLE_DATCHN_NULLPG_ERR BIT(25)
#define B_BE_PLE_DATCHN_ARBT_ERR BIT(24)
#define B_BE_PLE_QUEMGN_FRZTO_ERR BIT(19)
#define B_BE_PLE_NXTPKTLL_AD_ERR BIT(18)
#define B_BE_PLE_PREPKTLLT_AD_ERR BIT(17)
#define B_BE_PLE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_BE_PLE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_BE_PLE_QUE_SRCQUEID_ERR BIT(14)
#define B_BE_PLE_QUE_DSTQUEID_ERR BIT(13)
#define B_BE_PLE_QUE_CMDTYPE_ERR BIT(12)
#define B_BE_PLE_DATCHN_EVT11_ERR BIT(11)
#define B_BE_PLE_DATCHN_EVT10_ERR BIT(10)
#define B_BE_PLE_BUFMGN_FRZTO_ERR BIT(9)
#define B_BE_PLE_GETNPG_PGOFST_ERR BIT(8)
#define B_BE_PLE_GETNPG_STRPG_ERR BIT(7)
#define B_BE_PLE_BUFREQ_SRCHTAILPG_ERR BIT(6)
#define B_BE_PLE_BUFRTN_SIZE_ERR BIT(5)
#define B_BE_PLE_BUFRTN_INVLD_PKTID_ERR BIT(4)
#define B_BE_PLE_BUFREQ_UNAVAL_ERR BIT(3)
#define B_BE_PLE_BUFREQ_SIZELMT_ERR BIT(2)
#define B_BE_PLE_BUFREQ_SIZE0_ERR BIT(1)
#define B_BE_PLE_BUFREQ_QTAID_ERR BIT(0)

#define R_BE_PLE_QTA0_CFG 0x9040
#define B_BE_PLE_Q0_MAX_SIZE_SH 16
#define B_BE_PLE_Q0_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q0_MIN_SIZE_SH 0
#define B_BE_PLE_Q0_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA1_CFG 0x9044
#define B_BE_PLE_Q1_MAX_SIZE_SH 16
#define B_BE_PLE_Q1_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q1_MIN_SIZE_SH 0
#define B_BE_PLE_Q1_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA2_CFG 0x9048
#define B_BE_PLE_Q2_MAX_SIZE_SH 16
#define B_BE_PLE_Q2_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q2_MIN_SIZE_SH 0
#define B_BE_PLE_Q2_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA3_CFG 0x904C
#define B_BE_PLE_Q3_MAX_SIZE_SH 16
#define B_BE_PLE_Q3_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q3_MIN_SIZE_SH 0
#define B_BE_PLE_Q3_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA4_CFG 0x9050
#define B_BE_PLE_Q4_MAX_SIZE_SH 16
#define B_BE_PLE_Q4_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q4_MIN_SIZE_SH 0
#define B_BE_PLE_Q4_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA5_CFG 0x9054
#define B_BE_PLE_Q5_MAX_SIZE_SH 16
#define B_BE_PLE_Q5_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q5_MIN_SIZE_SH 0
#define B_BE_PLE_Q5_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA6_CFG 0x9058
#define B_BE_PLE_Q6_MAX_SIZE_SH 16
#define B_BE_PLE_Q6_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q6_MIN_SIZE_SH 0
#define B_BE_PLE_Q6_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA7_CFG 0x905C
#define B_BE_PLE_Q7_MAX_SIZE_SH 16
#define B_BE_PLE_Q7_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q7_MIN_SIZE_SH 0
#define B_BE_PLE_Q7_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA8_CFG 0x9060
#define B_BE_PLE_Q8_MAX_SIZE_SH 16
#define B_BE_PLE_Q8_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q8_MIN_SIZE_SH 0
#define B_BE_PLE_Q8_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA9_CFG 0x9064
#define B_BE_PLE_Q9_MAX_SIZE_SH 16
#define B_BE_PLE_Q9_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q9_MIN_SIZE_SH 0
#define B_BE_PLE_Q9_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA10_CFG 0x9068
#define B_BE_PLE_Q10_MAX_SIZE_SH 16
#define B_BE_PLE_Q10_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q10_MIN_SIZE_SH 0
#define B_BE_PLE_Q10_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA11_CFG 0x906C
#define B_BE_PLE_Q11_MAX_SIZE_SH 16
#define B_BE_PLE_Q11_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q11_MIN_SIZE_SH 0
#define B_BE_PLE_Q11_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA12_CFG 0x9070
#define B_BE_PLE_Q12_MAX_SIZE_SH 16
#define B_BE_PLE_Q12_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q12_MIN_SIZE_SH 0
#define B_BE_PLE_Q12_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA13_CFG 0x9074
#define B_BE_PLE_Q13_MAX_SIZE_SH 16
#define B_BE_PLE_Q13_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q13_MIN_SIZE_SH 0
#define B_BE_PLE_Q13_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA14_CFG 0x9078
#define B_BE_PLE_Q14_MAX_SIZE_SH 16
#define B_BE_PLE_Q14_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q14_MIN_SIZE_SH 0
#define B_BE_PLE_Q14_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_QTA15_CFG 0x907C
#define B_BE_PLE_Q15_MAX_SIZE_SH 16
#define B_BE_PLE_Q15_MAX_SIZE_MSK 0xfff
#define B_BE_PLE_Q15_MIN_SIZE_SH 0
#define B_BE_PLE_Q15_MIN_SIZE_MSK 0xfff

#define R_BE_PLE_WORD084 0x9084

#define R_BE_PLE_WORD088 0x9088

#define R_BE_PLE_WORD08C 0x908C

#define R_BE_PLE_WORD090 0x9090

#define R_BE_PLE_WORD094 0x9094

#define R_BE_PLE_WORD098 0x9098

#define R_BE_PLE_WORD09C 0x909C

#define R_BE_PLE_WORD0A0 0x90A0

#define R_BE_PLE_WORD0A4 0x90A4

#define R_BE_PLE_WORD0A8 0x90A8

#define R_BE_PLE_WORD0AC 0x90AC

#define R_BE_PLE_WORD0B0 0x90B0

#define R_BE_PLE_WORD0B4 0x90B4

#define R_BE_PLE_WORD0B8 0x90B8

#define R_BE_PLE_WORD0BC 0x90BC

#define R_BE_PLE_WORD0C0 0x90C0

#define R_BE_PLE_WORD0C4 0x90C4

#define R_BE_PLE_WORD0C8 0x90C8

#define R_BE_PLE_WORD0CC 0x90CC

#define R_BE_PLE_WORD0D0 0x90D0

#define R_BE_PLE_WORD0D4 0x90D4

#define R_BE_PLE_WORD0D8 0x90D8

#define R_BE_PLE_WORD0DC 0x90DC

#define R_BE_PLE_WORD0E0 0x90E0

#define R_BE_PLE_WORD0E4 0x90E4

#define R_BE_PLE_WORD0E8 0x90E8

#define R_BE_PLE_WORD0EC 0x90EC

#define R_BE_PLE_WORD0F0 0x90F0

#define R_BE_PLE_WORD0F4 0x90F4

#define R_BE_PLE_WORD0F8 0x90F8

#define R_BE_PLE_WORD0FC 0x90FC

#define R_BE_PLE_INI_STATUS 0x9100
#define B_BE_PLE_Q_MGN_INI_RDY BIT(1)
#define B_BE_PLE_BUF_MGN_INI_RDY BIT(0)

#define R_BE_PLE_WORD104 0x9104

#define R_BE_PLE_WORD108 0x9108

#define R_BE_PLE_WORD10C 0x910C

#define R_BE_PLE_DBG_FUN_INTF_CTL 0x9110
#define B_BE_PLE_DFI_ACTIVE BIT(31)
#define B_BE_PLE_DFI_TRGSEL_SH 16
#define B_BE_PLE_DFI_TRGSEL_MSK 0xf
#define B_BE_PLE_DFI_ADDR_SH 0
#define B_BE_PLE_DFI_ADDR_MSK 0xffff

#define R_BE_PLE_DBG_FUN_INTF_DATA 0x9114
#define B_BE_PLE_DFI_DATA_SH 0
#define B_BE_PLE_DFI_DATA_MSK 0xffffffffL

#define R_BE_PLE_DBG_CTL 0x9118
#define B_BE_PLE_DBG1_SEL_SH 8
#define B_BE_PLE_DBG1_SEL_MSK 0xff
#define B_BE_PLE_DBG0_SEL_SH 0
#define B_BE_PLE_DBG0_SEL_MSK 0xff

#define R_BE_PLE_DBG_OUT 0x911C
#define B_BE_PLE_DBG1_OUT_SH 16
#define B_BE_PLE_DBG1_OUT_MSK 0xffff
#define B_BE_PLE_DBG0_OUT_SH 0
#define B_BE_PLE_DBG0_OUT_MSK 0xffff

#define R_BE_PLE_WORD120 0x9120

#define R_BE_PLE_WORD124 0x9124

#define R_BE_PLE_WORD128 0x9128

#define R_BE_PLE_WORD12C 0x912C

#define R_BE_PLE_WORD130 0x9130

#define R_BE_PLE_WORD134 0x9134

#define R_BE_PLE_WORD138 0x9138

#define R_BE_PLE_WORD13C 0x913C

#define R_BE_PLE_WORD140 0x9140

#define R_BE_PLE_WORD144 0x9144

#define R_BE_PLE_WORD148 0x9148

#define R_BE_PLE_WORD14C 0x914C

#define R_BE_PLE_WORD150 0x9150

#define R_BE_PLE_WORD154 0x9154

#define R_BE_PLE_WORD158 0x9158

#define R_BE_PLE_WORD15C 0x915C

#define R_BE_PLE_WORD160 0x9160

#define R_BE_PLE_WORD164 0x9164

#define R_BE_PLE_WORD168 0x9168

#define R_BE_PLE_WORD16C 0x916C

#define R_BE_PLE_WORD170 0x9170

#define R_BE_PLE_WORD174 0x9174

#define R_BE_PLE_WORD178 0x9178

#define R_BE_PLE_WORD17C 0x917C

#define R_BE_PLE_WORD180 0x9180

#define R_BE_PLE_WORD184 0x9184

#define R_BE_PLE_WORD188 0x9188

#define R_BE_PLE_WORD18C 0x918C

#define R_BE_PLE_WORD190 0x9190

#define R_BE_PLE_WORD194 0x9194

#define R_BE_PLE_WORD198 0x9198

#define R_BE_PLE_WORD19C 0x919C

#define R_BE_PLE_WORD1A0 0x91A0

#define R_BE_PLE_WORD1A4 0x91A4

#define R_BE_PLE_WORD1A8 0x91A8

#define R_BE_PLE_WORD1AC 0x91AC

#define R_BE_PLE_WORD1B0 0x91B0

#define R_BE_PLE_WORD1B4 0x91B4

#define R_BE_PLE_WORD1B8 0x91B8

#define R_BE_PLE_WORD1BC 0x91BC

#define R_BE_PLE_WORD1C0 0x91C0

#define R_BE_PLE_WORD1C4 0x91C4

#define R_BE_PLE_WORD1C8 0x91C8

#define R_BE_PLE_WORD1CC 0x91CC

#define R_BE_PLE_WORD1D0 0x91D0

#define R_BE_PLE_WORD1D4 0x91D4

#define R_BE_PLE_WORD1D8 0x91D8

#define R_BE_PLE_WORD1DC 0x91DC

#define R_BE_PLE_WORD1E0 0x91E0

#define R_BE_PLE_WORD1E4 0x91E4

#define R_BE_PLE_WORD1E8 0x91E8

#define R_BE_PLE_WORD1EC 0x91EC

#define R_BE_PLE_WORD1F0 0x91F0

#define R_BE_PLE_WORD1F4 0x91F4

#define R_BE_PLE_WORD1F8 0x91F8

#define R_BE_PLE_WORD1FC 0x91FC

//
// WDRLS
//

#define R_BE_WDRLS_WORD000 0x9400

#define R_BE_WDRLS_WORD004 0x9404

#define R_BE_WDRLS_CFG 0x9408
#define B_BE_RLSRPT_BUFREQ_TO_SH 8
#define B_BE_RLSRPT_BUFREQ_TO_MSK 0xff
#define B_BE_RLSRPT_BUFREQ_TO_SEL_SH 6
#define B_BE_RLSRPT_BUFREQ_TO_SEL_MSK 0x3
#define B_BE_WDRLS_MODE_SH 0
#define B_BE_WDRLS_MODE_MSK 0x3

#define R_BE_WDRLS_WORD00C 0x940C

#define R_BE_RLSRPT0_CFG0 0x9410
#define B_BE_RLSRPT0_FLTR_MAP_SH 24
#define B_BE_RLSRPT0_FLTR_MAP_MSK 0xf
#define B_BE_RLSRPT0_PKTTYPE_SH 16
#define B_BE_RLSRPT0_PKTTYPE_MSK 0xf
#define B_BE_RLSRPT0_PID_SH 8
#define B_BE_RLSRPT0_PID_MSK 0x7
#define B_BE_RLSRPT0_QID_SH 0
#define B_BE_RLSRPT0_QID_MSK 0x3f

#define R_BE_RLSRPT0_CFG1 0x9414
#define B_BE_RLSRPT0_TO_SH 16
#define B_BE_RLSRPT0_TO_MSK 0xff
#define B_BE_RLSRPT0_AGGNUM_SH 0
#define B_BE_RLSRPT0_AGGNUM_MSK 0xff

#define R_BE_WDRLS_WORD018 0x9418

#define R_BE_WDRLS_WORD01C 0x941C

#define R_BE_RLSRPT1_CFG0 0x9420
#define B_BE_RLSRPT1_FLTR_MAP_SH 24
#define B_BE_RLSRPT1_FLTR_MAP_MSK 0xf
#define B_BE_RLSRPT1_PKTTYPE_SH 16
#define B_BE_RLSRPT1_PKTTYPE_MSK 0xf
#define B_BE_RLSRPT1_PID_SH 8
#define B_BE_RLSRPT1_PID_MSK 0x7
#define B_BE_RLSRPT1_QID_SH 0
#define B_BE_RLSRPT1_QID_MSK 0x3f

#define R_BE_RLSRPT1_CFG1 0x9424
#define B_BE_RLSRPT1_TO_SH 16
#define B_BE_RLSRPT1_TO_MSK 0xff
#define B_BE_RLSRPT1_AGGNUM_SH 0
#define B_BE_RLSRPT1_AGGNUM_MSK 0xff

#define R_BE_WDRLS_WORD028 0x9428

#define R_BE_WDRLS_WORD02C 0x942C

#define R_BE_WDRLS_ERR_IMR 0x9430
#define B_BE_WDRLS_RPT1_FRZTO_ERR_INT_EN BIT(13)
#define B_BE_WDRLS_RPT1_AGGNUM0_ERR_INT_EN BIT(12)
#define B_BE_WDRLS_RPT0_FRZTO_ERR_INT_EN BIT(9)
#define B_BE_WDRLS_RPT0_AGGNUM0_ERR_INT_EN BIT(8)
#define B_BE_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN BIT(5)
#define B_BE_WDRLS_PLEBREQ_TO_ERR_INT_EN BIT(4)
#define B_BE_WDRLS_CTL_FRZTO_ERR_INT_EN BIT(2)
#define B_BE_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN BIT(1)
#define B_BE_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN BIT(0)

#define R_BE_WDRLS_ERR_ISR 0x9434
#define B_BE_WDRLS_RPT1_FRZTO_ERR BIT(13)
#define B_BE_WDRLS_RPT1_AGGNUM_ERR BIT(12)
#define B_BE_WDRLS_RPT0_FRZTO_ERR BIT(9)
#define B_BE_WDRLS_RPT0_AGGNUM0_ERR BIT(8)
#define B_BE_WDRLS_PLEBREQ_PKTID_ISNULL_ERR BIT(5)
#define B_BE_WDRLS_PLEBREQ_TO_ERR BIT(4)
#define B_BE_WDRLS_CTL_FRZTO_ERR BIT(2)
#define B_BE_WDRLS_CTL_PLPKTID_ISNULL_ERR BIT(1)
#define B_BE_WDRLS_CTL_WDPKTID_ISNULL_ERR BIT(0)

#define R_BE_DBG_CTL_WDRLS 0x9438
#define B_BE_DBG1_SEL_SH 8
#define B_BE_DBG1_SEL_MSK 0xff
#define B_BE_DBG0_SEL_SH 0
#define B_BE_DBG0_SEL_MSK 0xff

#define R_BE_DBG_OUT_WDRLS 0x943C
#define B_BE_DBG1_OUT_SH 16
#define B_BE_DBG1_OUT_MSK 0xffff
#define B_BE_DBG0_OUT_SH 0
#define B_BE_DBG0_OUT_MSK 0xffff

#define R_BE_WDRLS_WORD040 0x9440

#define R_BE_WDRLS_WORD044 0x9444

#define R_BE_WDRLS_WORD048 0x9448

#define R_BE_WDRLS_WORD04C 0x944C

#define R_BE_WDRLS_WORD050 0x9450

#define R_BE_WDRLS_WORD054 0x9454

#define R_BE_WDRLS_WORD058 0x9458

#define R_BE_WDRLS_WORD05C 0x945C

#define R_BE_WDRLS_WORD060 0x9460

#define R_BE_WDRLS_WORD064 0x9464

#define R_BE_WDRLS_WORD068 0x9468

#define R_BE_WDRLS_WORD06C 0x946C

#define R_BE_WDRLS_WORD070 0x9470

#define R_BE_WDRLS_WORD074 0x9474

#define R_BE_WDRLS_WORD078 0x9478

#define R_BE_WDRLS_WORD07C 0x947C

//
// BBRPT
//

#define R_BE_COM_CFG 0x9600
#define B_BE_1US_CYCNUM_SEL_SH 16
#define B_BE_1US_CYCNUM_SEL_MSK 0x3
#define B_BE_DIS_ACGC_DMA_PHYIF_V1 BIT(1)
#define B_BE_DIS_ACGC_DMA_RPTGEN_V1 BIT(0)

#define R_BE_BBRPT_COEX_CFG 0x9604
#define B_BE_DFS_THR_SH 8
#define B_BE_DFS_THR_MSK 0xf
#define B_BE_BBRPT_COEX_EN BIT(0)

#define R_BE_BBRPT_COM_ERR_IMR 0x9608
#define B_BE_BBRPT_COM_HANG_EN BIT(1)
#define B_BE_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN BIT(0)

#define R_BE_BBRPT_COM_ERR_ISR 0x960C
#define B_BE_BBRPT_COM_NULL_PLPKTID_ERR_INT_V1 BIT(0)

#define R_BE_BBRPT_WORD010 0x9610

#define R_BE_BBRPT_WORD014 0x9614

#define R_BE_BBRPT_WORD018 0x9618

#define R_BE_BBRPT_WORD01C 0x961C

#define R_BE_CH_INFO 0x9620
#define B_BE_CH_INFO_QID_SH 24
#define B_BE_CH_INFO_QID_MSK 0x3f
#define B_BE_CH_INFO_PRTID_SH 20
#define B_BE_CH_INFO_PRTID_MSK 0x7
#define B_BE_CH_INFO_REQ_SH 18
#define B_BE_CH_INFO_REQ_MSK 0x3
#define B_BE_CH_INFO_SEG_SH 16
#define B_BE_CH_INFO_SEG_MSK 0x3
#define B_BE_CH_INFO_INTVL_SH 12
#define B_BE_CH_INFO_INTVL_MSK 0xf
#define B_BE_GET_CH_INFO_TO_SH 9
#define B_BE_GET_CH_INFO_TO_MSK 0x7
#define B_BE_CH_INFO_PHY BIT(8)
#define B_BE_CH_INFO_BUF_SH 6
#define B_BE_CH_INFO_BUF_MSK 0x3
#define B_BE_CH_INFO_STOP BIT(5)
#define B_BE_CH_INFO_STOP_REQ BIT(4)
#define B_BE_CH_INFO_ON BIT(3)
#define B_BE_CH_INFO_EN BIT(0)

#define R_BE_BBRPT_WORD024 0x9624

#define R_BE_BBRPT_CHINFO_ERR_IMR 0x9628
#define B_BE_BBPRT_CHIF_TO_ERR_INT_EN BIT(7)
#define B_BE_BBPRT_CHIF_NULL_ERR_INT_EN BIT(6)
#define B_BE_BBPRT_CHIF_LEFT2_ERR_INT_EN BIT(5)
#define B_BE_BBPRT_CHIF_LEFT1_ERR_INT_EN BIT(4)
#define B_BE_BBPRT_CHIF_HDRL_ERR_INT_EN BIT(3)
#define B_BE_BBPRT_CHIF_BOVF_ERR_INT_EN BIT(2)
#define B_BE_BBPRT_CHIF_OVF_ERR_INT_EN BIT(1)
#define B_BE_BBPRT_CHIF_BB_TO_ERR_INT_EN BIT(0)

#define R_BE_BBRPT_CHINFO_ERR_ISR 0x962C
#define B_BE_BBPRT_CHIF_TO_ERR_V1 BIT(7)
#define B_BE_BBPRT_CHIF_NULL_ERR_V1 BIT(6)
#define B_BE_BBPRT_CHIF_LEFT2_ERR_V1 BIT(5)
#define B_BE_BBPRT_CHIF_LEFT1_ERR_V1 BIT(4)
#define B_BE_BBPRT_CHIF_HDRL_ERR_V1 BIT(3)
#define B_BE_BBPRT_CHIF_BOVF_ERR_V1 BIT(2)
#define B_BE_BBPRT_CHIF_OVF_ERR_V1 BIT(1)
#define B_BE_BBPRT_CHIF_BB_TO_ERR_V1 BIT(0)

#define R_BE_DFS_CFG0 0x9630
#define B_BE_DFS_QID_SH 24
#define B_BE_DFS_QID_MSK 0x3f
#define B_BE_DFS_PRTID_SH 20
#define B_BE_DFS_PRTID_MSK 0x7
#define B_BE_DFS_TIME_TH_SH 10
#define B_BE_DFS_TIME_TH_MSK 0x3
#define B_BE_DFS_NUM_TH_SH 8
#define B_BE_DFS_NUM_TH_MSK 0x3
#define B_BE_DFS_BUF_SH 6
#define B_BE_DFS_BUF_MSK 0x3
#define B_BE_DFS_IN_STOP BIT(5)
#define B_BE_STOP_DFS BIT(4)
#define B_BE_DFS_RPT_EN BIT(0)

#define R_BE_BBRPT_WORD034 0x9634

#define R_BE_BBRPT_DFS_ERR_IMR 0x9638
#define B_BE_BBRPT_DFS_TO_ERR_INT_EN BIT(0)

#define R_BE_BBRPT_DFS_ERR_ISR 0x963C
#define B_BE_BBRPT_DFS_TO_ERR_V1 BIT(0)

#define R_BE_BBRPT_WORD040 0x9640

#define R_BE_BBRPT_WORD044 0x9644

#define R_BE_BBRPT_WORD048 0x9648

#define R_BE_BBRPT_WORD04C 0x964C

#define R_BE_BBRPT_WORD050 0x9650

#define R_BE_BBRPT_WORD054 0x9654

#define R_BE_BBRPT_WORD058 0x9658

#define R_BE_BBRPT_WORD05C 0x965C

#define R_BE_LA_CFG 0x9660
#define B_BE_LA_TRIG_TIME_VAL_SH 24
#define B_BE_LA_TRIG_TIME_VAL_MSK 0x7f
#define B_BE_LA_TRIG_TU_SEL_SH 20
#define B_BE_LA_TRIG_TU_SEL_MSK 0xf
#define B_BE_LA_BUF_SEL_SH 16
#define B_BE_LA_BUF_SEL_MSK 0xf
#define B_BE_LA_BUF_BNDY_SH 8
#define B_BE_LA_BUF_BNDY_MSK 0x3f
#define B_BE_LA_TO_VAL_SH 6
#define B_BE_LA_TO_VAL_MSK 0x3
#define B_BE_LA_TO_EN BIT(5)
#define B_BE_LA_RESTART_EN BIT(4)
#define B_BE_LA_TRIG_START BIT(3)
#define B_BE_LA_FEN BIT(0)

#define R_BE_LA_STATUS 0x9664
#define B_BE__LA_SW_FSMST_SH 17
#define B_BE__LA_SW_FSMST_MSK 0x7
#define B_BE__LA_BUF_RNDUP BIT(16)
#define B_BE__LA_BUF_WPTR_SH 0
#define B_BE__LA_BUF_WPTR_MSK 0xffff

#define R_BE_LA_ERRFLAG_IMR 0x9668
#define B_BE_LA_IMR_DATA_LOSS BIT(0)

#define R_BE_LA_ERRFLAG_ISR 0x966C
#define B_BE_LA_ISR_DATA_LOSS_V1 BIT(0)

#define R_BE_BBRPT_WORD070 0x9670

#define R_BE_BBRPT_WORD074 0x9674

#define R_BE_BBRPT_WORD078 0x9678

#define R_BE_BBRPT_WORD07C 0x967C

#define R_BE_DBG_CTL_BBRPT 0x9680

#define R_BE_DBG_OUT_BBRPT 0x9684

#define R_BE_BBRPT_WORD088 0x9688

#define R_BE_BBRPT_WORD08C 0x968C

#define R_BE_BBRPT_WORD090 0x9690

#define R_BE_BBRPT_WORD094 0x9694

#define R_BE_BBRPT_WORD098 0x9698

#define R_BE_BBRPT_WORD09C 0x969C

#define R_BE_BBRPT_WORD0A0 0x96A0

#define R_BE_BBRPT_WORD0A4 0x96A4

#define R_BE_BBRPT_WORD0A8 0x96A8

#define R_BE_BBRPT_WORD0AC 0x96AC

#define R_BE_BBRPT_WORD0B0 0x96B0

#define R_BE_BBRPT_WORD0B4 0x96B4

#define R_BE_BBRPT_WORD0B8 0x96B8

#define R_BE_BBRPT_WORD0BC 0x96BC

#define R_BE_BBRPT_WORD0C0 0x96C0

#define R_BE_BBRPT_WORD0C4 0x96C4

#define R_BE_BBRPT_WORD0C8 0x96C8

#define R_BE_BBRPT_WORD0CC 0x96CC

#define R_BE_BBRPT_WORD0D0 0x96D0

#define R_BE_BBRPT_WORD0D4 0x96D4

#define R_BE_BBRPT_WORD0D8 0x96D8

#define R_BE_BBRPT_WORD0DC 0x96DC

#define R_BE_BBRPT_WORD0E0 0x96E0

#define R_BE_BBRPT_WORD0E4 0x96E4

#define R_BE_BBRPT_WORD0E8 0x96E8

#define R_BE_BBRPT_WORD0EC 0x96EC

#define R_BE_BBRPT_WORD0F0 0x96F0

#define R_BE_BBRPT_WORD0F4 0x96F4

#define R_BE_BBRPT_WORD0F8 0x96F8

#define R_BE_BBRPT_WORD0FC 0x96FC

//
// CPUIO
//

#define R_BE_WD_BUF_REQ 0x9800
#define B_BE_WD_BUF_REQ_EXEC BIT(31)
#define B_BE_WD_BUF_REQ_QUOTA_ID_SH 16
#define B_BE_WD_BUF_REQ_QUOTA_ID_MSK 0xff
#define B_BE_WD_BUF_REQ_LEN_SH 0
#define B_BE_WD_BUF_REQ_LEN_MSK 0xffff

#define R_BE_WD_BUF_STATUS 0x9804
#define B_BE_WD_BUF_STAT_DONE BIT(31)
#define B_BE_WD_BUF_STAT_PKTID_SH 0
#define B_BE_WD_BUF_STAT_PKTID_MSK 0xfff

#define R_BE_WD_QUOTA_STATUS 0x9808

#define R_BE_CPUIO_WORD00C 0x980C

#define R_BE_WD_CPUQ_OP_0 0x9810
#define B_BE_WD_CPUQ_OP_EXEC BIT(31)
#define B_BE_WD_CPUQ_OP_CMD_TYPE_SH 24
#define B_BE_WD_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_BE_WD_CPUQ_OP_MACID_SH 16
#define B_BE_WD_CPUQ_OP_MACID_MSK 0xff
#define B_BE_WD_CPUQ_OP_PKTNUM_SH 0
#define B_BE_WD_CPUQ_OP_PKTNUM_MSK 0xff

#define R_BE_WD_CPUQ_OP_1 0x9814
#define B_BE_WD_CPUQ_OP_SRC_PID_SH 22
#define B_BE_WD_CPUQ_OP_SRC_PID_MSK 0x7
#define B_BE_WD_CPUQ_OP_SRC_QID_SH 16
#define B_BE_WD_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_BE_WD_CPUQ_OP_DST_PID_SH 6
#define B_BE_WD_CPUQ_OP_DST_PID_MSK 0x7
#define B_BE_WD_CPUQ_OP_DST_QID_SH 0
#define B_BE_WD_CPUQ_OP_DST_QID_MSK 0x3f

#define R_BE_WD_CPUQ_OP_2 0x9818
#define B_BE_WD_CPUQ_OP_STRT_PKTID_SH 16
#define B_BE_WD_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_BE_WD_CPUQ_OP_END_PKTID_SH 0
#define B_BE_WD_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_BE_WD_CPUQ_OP_STATUS 0x981C
#define B_BE_WD_CPUQ_OP_STAT_DONE BIT(31)
#define B_BE_WD_CPUQ_OP_PKTID_SH 0
#define B_BE_WD_CPUQ_OP_PKTID_MSK 0xfff

#define R_BE_PL_BUF_REQ 0x9820
#define B_BE_PL_BUF_REQ_EXEC BIT(31)
#define B_BE_PL_BUF_REQ_QUOTA_ID_SH 16
#define B_BE_PL_BUF_REQ_QUOTA_ID_MSK 0xf
#define B_BE_PL_BUF_REQ_LEN_SH 0
#define B_BE_PL_BUF_REQ_LEN_MSK 0xffff

#define R_BE_PL_BUF_STATUS 0x9824
#define B_BE_PL_BUF_STAT_DONE BIT(31)
#define B_BE_PL_BUF_STAT_PKTID_SH 0
#define B_BE_PL_BUF_STAT_PKTID_MSK 0xfff

#define R_BE_PL_QUOTA_STATUS 0x9828

#define R_BE_CPUIO_WORD02C 0x982C

#define R_BE_PL_CPUQ_OP_0 0x9830
#define B_BE_PL_CPUQ_OP_EXEC BIT(31)
#define B_BE_PL_CPUQ_OP_CMD_TYPE_SH 24
#define B_BE_PL_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_BE_PL_CPUQ_OP_MACID_SH 16
#define B_BE_PL_CPUQ_OP_MACID_MSK 0xff
#define B_BE_PL_CPUQ_OP_PKTNUM_SH 0
#define B_BE_PL_CPUQ_OP_PKTNUM_MSK 0xff

#define R_BE_PL_CPUQ_OP_1 0x9834
#define B_BE_PL_CPUQ_OP_SRC_PID_SH 22
#define B_BE_PL_CPUQ_OP_SRC_PID_MSK 0x7
#define B_BE_PL_CPUQ_OP_SRC_QID_SH 16
#define B_BE_PL_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_BE_PL_CPUQ_OP_DST_PID_SH 6
#define B_BE_PL_CPUQ_OP_DST_PID_MSK 0x7
#define B_BE_PL_CPUQ_OP_DST_QID_SH 0
#define B_BE_PL_CPUQ_OP_DST_QID_MSK 0x3f

#define R_BE_PL_CPUQ_OP_2 0x9838
#define B_BE_PL_CPUQ_OP_STRT_PKTID_SH 16
#define B_BE_PL_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_BE_PL_CPUQ_OP_END_PKTID_SH 0
#define B_BE_PL_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_BE_PL_CPUQ_OP_STATUS 0x983C
#define B_BE_PL_CPUQ_OP_STAT_DONE BIT(31)
#define B_BE_PL_CPUQ_OP_PKTID_SH 0
#define B_BE_PL_CPUQ_OP_PKTID_MSK 0xfff

#define R_BE_CPUIO_ERR_IMR 0x9840
#define B_BE_PLEQUE_OP_ERR_INT_EN BIT(12)
#define B_BE_PLEBUF_OP_ERR_INT_EN BIT(8)
#define B_BE_WDEQUE_OP_ERR_INT_EN BIT(4)
#define B_BE_WDEBUF_OP_ERR_INT_EN BIT(0)

#define R_BE_CPUIO_ERR_ISR 0x9844
#define B_BE_PLEQUE_OP_ERR BIT(12)
#define B_BE_PLEBUF_OP_ERR BIT(8)
#define B_BE_ERR_WDEQUE_OP_ERR BIT(4)
#define B_BE_ERR_WDEBUF_OP_ERR BIT(0)

#define R_BE_CPUIO_WORD048 0x9848

#define R_BE_CPUIO_WORD04C 0x984C

#define R_BE_CPUIO_WORD050 0x9850

#define R_BE_CPUIO_WORD054 0x9854

#define R_BE_CPUIO_WORD058 0x9858

#define R_BE_CPUIO_WORD05C 0x985C

#define R_BE_CPUIO_WORD060 0x9860

#define R_BE_CPUIO_WORD064 0x9864

#define R_BE_CPUIO_WORD068 0x9868

#define R_BE_CPUIO_WORD06C 0x986C

#define R_BE_CPUIO_WORD070 0x9870

#define R_BE_CPUIO_WORD074 0x9874

#define R_BE_CPUIO_WORD078 0x9878

#define R_BE_CPUIO_WORD07C 0x987C

//
// PKTIN
//

#define R_BE_PKTIN_SETTING 0x9A00
#define B_BE_AMSDU_MAX_FS_NUM_SH 2
#define B_BE_AMSDU_MAX_FS_NUM_MSK 0x7
#define B_BE_WD_ADDR_INFO_LENGTH BIT(1)
#define B_BE_PKTIN_CLK_GATING_DIS BIT(0)

#define R_BE_HWAMSDU_CTRL 0x9A04
#define B_BE_MAX_AMSDU_NUM_SH 3
#define B_BE_MAX_AMSDU_NUM_MSK 0x7
#define B_BE_SINGLE_AMSDU BIT(2)
#define B_BE_AMSDU_FS_ENABLE BIT(1)
#define B_BE_HWAMSDU_EN BIT(0)

#define R_BE_HWAMSDU_STATUS 0x9A08
#define B_BE_AMSDU_PKT_SIZE_ERR BIT(31)
#define B_BE_AMSDU_EN_ERR BIT(30)
#define B_BE_AMSDU_ADDR_INFO_ERR BIT(29)
#define B_BE_AMSDU_RD_SEL_Q_ERR BIT(28)

#define R_BE_TXPKTIN_CTRL 0x9A14
#define B_BE_TXPKTIN_CTRL_25 BIT(25)
#define B_BE_TXPKTIN_CTRL_24 BIT(24)
#define B_BE_TXPKTIN_CTRL_23 BIT(23)
#define B_BE_TXPKTIN_CTRL_22 BIT(22)
#define B_BE_TXPKTIN_CTRL_21 BIT(21)
#define B_BE_TXPKTIN_CTRL_20 BIT(20)
#define B_BE_TXPKTIN_CTRL_19 BIT(19)
#define B_BE_TXPKTIN_CTRL_18 BIT(18)
#define B_BE_TXPKTIN_CTRL_17 BIT(17)
#define B_BE_TXPKTIN_CTRL_16 BIT(16)
#define B_BE_TXPKTIN_CTRL_EN BIT(15)
#define B_BE_TXPKTIN_CTRL_SH 0
#define B_BE_TXPKTIN_CTRL_MSK 0x3ff

#define R_BE_TXPKTIN_DBG_SEL 0x9A18
#define B_BE_TXPKTIN_DBG_SEL_SH 0
#define B_BE_TXPKTIN_DBG_SEL_MSK 0xf

#define R_BE_DBG_DATA 0x9A1C
#define B_BE_PRE_DBG_DMAC_PKTIN_SH 0
#define B_BE_PRE_DBG_DMAC_PKTIN_MSK 0xffffffffL

#define R_BE_PKTIN_ERR_IMR 0x9A20
#define B_BE_PKTIN_GETPKTID_ERR_INT_EN_SH 0
#define B_BE_PKTIN_GETPKTID_ERR_INT_EN_MSK 0xff

#define R_BE_PKTIN_ERR_ISR 0x9A24
#define B_BE_PKTIN_GETPKTID_ERR_INT BIT(0)

#define R_BE_AMSDU_COUNTER_EN_MACID 0x9A28
#define B_BE_AMSDU_COUNTER2_EN BIT(29)
#define B_BE_AMSDU_COUNTER2_MACID_SH 20
#define B_BE_AMSDU_COUNTER2_MACID_MSK 0x1ff
#define B_BE_AMSDU_COUNTER1_EN BIT(19)
#define B_BE_AMSDU_COUNTER1_MACID_SH 10
#define B_BE_AMSDU_COUNTER1_MACID_MSK 0x1ff
#define B_BE_AMSDU_COUNTER0_EN BIT(9)
#define B_BE_AMSDU_COUNTER0_MACID_SH 0
#define B_BE_AMSDU_COUNTER0_MACID_MSK 0x1ff

#define R_BE_AMSDU_COUNTER_4 0x9A2C
#define B_BE_AMSDU6_COUNTER2_SH 0
#define B_BE_AMSDU6_COUNTER2_MSK 0xffff

#define R_BE_AMSDU_COUNTER_3 0x9A30
#define B_BE_AMSDU45_COUNTER2_SH 16
#define B_BE_AMSDU45_COUNTER2_MSK 0xffff
#define B_BE_AMSDU23_COUNTER2_SH 0
#define B_BE_AMSDU23_COUNTER2_MSK 0xffff

#define R_BE_AMSDU_COUNTER_2 0x9A34
#define B_BE_AMSDU6_COUNTER1_SH 16
#define B_BE_AMSDU6_COUNTER1_MSK 0xffff
#define B_BE_AMSDU45_COUNTER1_SH 0
#define B_BE_AMSDU45_COUNTER1_MSK 0xffff

#define R_BE_AMSDU_COUNTER_1 0x9A38
#define B_BE_AMSDU23_COUNTER1_SH 16
#define B_BE_AMSDU23_COUNTER1_MSK 0xffff
#define B_BE_AMSDU6_COUNTER0_SH 0
#define B_BE_AMSDU6_COUNTER0_MSK 0xffff

#define R_BE_AMSDU_COUNTER_0 0x9A3C
#define B_BE_AMSDU45_COUNTER0_SH 16
#define B_BE_AMSDU45_COUNTER0_MSK 0xffff
#define B_BE_AMSDU23_COUNTER0_SH 0
#define B_BE_AMSDU23_COUNTER0_MSK 0xffff

//
// MPDU_Processor_1
//

#define R_BE_HDR_SHCUT_SETTING 0x9B00
#define B_BE_TX_ADDR_MLD_TO_LIK BIT(4)
#define B_BE_TX_HW_SEC_HDR_EN BIT(3)
#define B_BE_TX_MAC_MPDU_PROC_EN BIT(2)
#define B_BE_TX_HW_ACK_POLICY_EN BIT(1)
#define B_BE_TX_HW_SEQ_EN BIT(0)

#define R_BE_SHCUT_LLC_ETH_TYPE0 0x9B04
#define B_BE_SHUT_ETH_TYPE1_SH 16
#define B_BE_SHUT_ETH_TYPE1_MSK 0xffff
#define B_BE_SHUT_ETH_TYPE0_SH 0
#define B_BE_SHUT_ETH_TYPE0_MSK 0xffff

#define R_BE_SHCUT_LLC_ETH_TYPE1 0x9B08
#define B_BE_SHUT_ETH_TYPE2_SH 0
#define B_BE_SHUT_ETH_TYPE2_MSK 0xffff

#define R_BE_SHCUT_LLC_OUI0 0x9B0C
#define B_BE_SHUT_ENABLE_OUI0 BIT(24)
#define B_BE_SHUT_ETH_OUI0_SH 0
#define B_BE_SHUT_ETH_OUI0_MSK 0xffffff

#define R_BE_SHCUT_LLC_OUI1 0x9B10
#define B_BE_SHUT_ENABLE_OUI1 BIT(24)
#define B_BE_SHUT_ETH_OUI1_SH 0
#define B_BE_SHUT_ETH_OUI1_MSK 0xffffff

#define R_BE_SHCUT_LLC_OUI2 0x9B14
#define B_BE_SHUT_ENABLE_OUI2 BIT(24)
#define B_BE_SHUT_ETH_OUI2_SH 0
#define B_BE_SHUT_ETH_OUI2_MSK 0xffffff

#define R_BE_SHCUT_LLC_OUI3 0x9B18
#define B_BE_SHUT_ENABLE_OUI3 BIT(24)
#define B_BE_SHUT_ETH_OUI3_SH 0
#define B_BE_SHUT_ETH_OUI3_MSK 0xffffff

#define R_BE_TX_PTK_CNT 0x9BEC
#define B_BE_TX_PTKOUT_CNT_SH 16
#define B_BE_TX_PTKOUT_CNT_MSK 0xffff
#define B_BE_TX_PKTIN_CNT_SH 0
#define B_BE_TX_PKTIN_CNT_MSK 0xffff

#define R_BE_MPDU_TX_ERR_ISR 0x9BF0
#define B_BE_TX_KSRCH_ERR BIT(9)
#define B_BE_TX_NW_TYPE_ERR BIT(8)
#define B_BE_TX_LLC_PRE_ERR BIT(7)
#define B_BE_TX_ETH_TYPE_ERR BIT(6)
#define B_BE_TX_HDR3_SIZE_ERR BIT(5)
#define B_BE_TX_OFFSET_ERR BIT(4)
#define B_BE_TX_MPDU_SIZE_ZERO_ERR BIT(3)
#define B_BE_TX_NXT_ERRPKTID_ERR BIT(2)
#define B_BE_TX_GET_ERRPKTID_ERR BIT(1)
#define B_BE_TX_TIMEOUT_ERR BIT(0)

#define R_BE_MPDU_TX_ERR_IMR 0x9BF4
#define B_BE_TX_KSRCH_ERR_EN BIT(9)
#define B_BE_TX_NW_TYPE_ERR_EN BIT(8)
#define B_BE_TX_LLC_PRE_ERR_EN BIT(7)
#define B_BE_TX_ETH_TYPE_ERR_EN BIT(6)
#define B_BE_TX_HDR3_SIZE_ERR_INT_EN BIT(5)
#define B_BE_TX_OFFSET_ERR_INT_EN BIT(4)
#define B_BE_TX_MPDU_SIZE_ZERO_INT_EN BIT(3)
#define B_BE_TX_NXT_ERRPKTID_INT_EN BIT(2)
#define B_BE_TX_GET_ERRPKTID_INT_EN BIT(1)
#define B_BE_TX_TIMEOUT_ERR_EN BIT(0)

#define R_BE_MPDU_TX_DBG_V1 0x9BF8
#define B_BE_MPDU_TX_DBGEN_V1 BIT(8)
#define B_BE_MPDU_TX_CKEN_DIS BIT(1)
#define B_BE_MPDU_TX_DLAST_V1 BIT(0)

//
// MPDU_Processor_2
//

#define R_BE_MPDU_PROC 0x9C00
#define B_BE_WPKT_PORT_SEL BIT(29)
#define B_BE_WPKT_WLANCPU_QSEL_SH 27
#define B_BE_WPKT_WLANCPU_QSEL_MSK 0x3
#define B_BE_WPKT_DATACPU_QSEL_SH 25
#define B_BE_WPKT_DATACPU_QSEL_MSK 0x3
#define B_BE_WPKT_FW_ELS BIT(24)
#define B_BE_FWD_RPKT_SH 16
#define B_BE_FWD_RPKT_MSK 0xff
#define B_BE_FWD_WPKT_SH 8
#define B_BE_FWD_WPKT_MSK 0xff
#define B_BE_RXFWD_PRIO_SH 4
#define B_BE_RXFWD_PRIO_MSK 0x3
#define B_BE_RXFWD_EN BIT(3)
#define B_BE_DROP_NONDMA_PPDU BIT(2)
#define B_BE_APPEND_FCS BIT(0)

#define R_BE_FWD_TRIG0 0x9C04
#define B_BE_FWD_DELTS_SH 24
#define B_BE_FWD_DELTS_MSK 0xff
#define B_BE_FWD_ADDTS_RES_SH 16
#define B_BE_FWD_ADDTS_RES_MSK 0xff
#define B_BE_FWD_ADDTS_REQ_SH 8
#define B_BE_FWD_ADDTS_REQ_MSK 0xff
#define B_BE_FWD_CSA_SH 0
#define B_BE_FWD_CSA_MSK 0xff

#define R_BE_FWD_TRIG1 0x9C08
#define B_BE_FWD_NCW_SH 24
#define B_BE_FWD_NCW_MSK 0xff
#define B_BE_FWD_DELBA_SH 16
#define B_BE_FWD_DELBA_MSK 0xff
#define B_BE_FWD_ADDBA_RES_SH 8
#define B_BE_FWD_ADDBA_RES_MSK 0xff
#define B_BE_FWD_ADDBA_REQ_SH 0
#define B_BE_FWD_ADDBA_REQ_MSK 0xff

#define R_BE_FWD_TRIG2 0x9C0C
#define B_BE_FWD_HT_CBFM_SH 24
#define B_BE_FWD_HT_CBFM_MSK 0xff
#define B_BE_FWD_CSI_SH 16
#define B_BE_FWD_CSI_MSK 0xff
#define B_BE_FWD_OP_MODE_SH 8
#define B_BE_FWD_OP_MODE_MSK 0xff
#define B_BE_FWD_GID_MGNT_SH 0
#define B_BE_FWD_GID_MGNT_MSK 0xff

#define R_BE_ACTION_FWD_CTRL2 0x9C10
#define B_BE_FWD_CRC32_SH 24
#define B_BE_FWD_CRC32_MSK 0xff
#define B_BE_FWD_ICVERR_SH 16
#define B_BE_FWD_ICVERR_MSK 0xff
#define B_BE_FWD_SW_DEC_SH 8
#define B_BE_FWD_SW_DEC_MSK 0xff
#define B_BE_FWD_VHT_CBFM_SH 0
#define B_BE_FWD_VHT_CBFM_MSK 0xff

#define R_BE_FWD_ACTN0 0x9C14
#define B_BE_FWD_ACTN_CTRL3_SH 24
#define B_BE_FWD_ACTN_CTRL3_MSK 0xff
#define B_BE_FWD_ACTN_CTRL2_SH 16
#define B_BE_FWD_ACTN_CTRL2_MSK 0xff
#define B_BE_FWD_ACTN_CTRL1_SH 8
#define B_BE_FWD_ACTN_CTRL1_MSK 0xff
#define B_BE_FWD_ACTN_CTRL0_SH 0
#define B_BE_FWD_ACTN_CTRL0_MSK 0xff

#define R_BE_FWD_ACTN1 0x9C18
#define B_BE_FWD_ACTN_ACTN1_SH 24
#define B_BE_FWD_ACTN_ACTN1_MSK 0xff
#define B_BE_FWD_ACTN_CAT1_SH 16
#define B_BE_FWD_ACTN_CAT1_MSK 0xff
#define B_BE_FWD_ACTN_ACTN0_SH 8
#define B_BE_FWD_ACTN_ACTN0_MSK 0xff
#define B_BE_FWD_ACTN_CAT0_SH 0
#define B_BE_FWD_ACTN_CAT0_MSK 0xff

#define R_BE_FWD_ACTN2 0x9C1C
#define B_BE_FWD_ACTN_ACTN3_SH 24
#define B_BE_FWD_ACTN_ACTN3_MSK 0xff
#define B_BE_FWD_ACTN_CAT3_SH 16
#define B_BE_FWD_ACTN_CAT3_MSK 0xff
#define B_BE_FWD_ACTN_ACTN2_SH 8
#define B_BE_FWD_ACTN_ACTN2_MSK 0xff
#define B_BE_FWD_ACTN_CAT2_SH 0
#define B_BE_FWD_ACTN_CAT2_MSK 0xff

#define R_BE_FWD_TF0 0x9C20
#define B_BE_FWD_TF3_SH 24
#define B_BE_FWD_TF3_MSK 0xff
#define B_BE_FWD_TF2_SH 16
#define B_BE_FWD_TF2_MSK 0xff
#define B_BE_FWD_TF1_SH 8
#define B_BE_FWD_TF1_MSK 0xff
#define B_BE_FWD_TF0_SH 0
#define B_BE_FWD_TF0_MSK 0xff

#define R_BE_FWD_TF1 0x9C24
#define B_BE_FWD_TF7_SH 24
#define B_BE_FWD_TF7_MSK 0xff
#define B_BE_FWD_TF6_SH 16
#define B_BE_FWD_TF6_MSK 0xff
#define B_BE_FWD_TF5_SH 8
#define B_BE_FWD_TF5_MSK 0xff
#define B_BE_FWD_TF4_SH 0
#define B_BE_FWD_TF4_MSK 0xff

#define R_BE_FWD_TF2 0x9C28
#define B_BE_FWD_TF11_SH 24
#define B_BE_FWD_TF11_MSK 0xff
#define B_BE_FWD_TF10_SH 16
#define B_BE_FWD_TF10_MSK 0xff
#define B_BE_FWD_TF9_SH 8
#define B_BE_FWD_TF9_MSK 0xff
#define B_BE_FWD_TF8_SH 0
#define B_BE_FWD_TF8_MSK 0xff

#define R_BE_FWD_TF3 0x9C2C
#define B_BE_FWD_TF15_SH 24
#define B_BE_FWD_TF15_MSK 0xff
#define B_BE_FWD_TF14_SH 16
#define B_BE_FWD_TF14_MSK 0xff
#define B_BE_FWD_TF13_SH 8
#define B_BE_FWD_TF13_MSK 0xff
#define B_BE_FWD_TF12_SH 0
#define B_BE_FWD_TF12_MSK 0xff

#define R_BE_FWD_RPKT 0x9C30
#define B_BE_FWD_RPKTTYPE_SH 26
#define B_BE_FWD_RPKTTYPE_MSK 0x3f
#define B_BE_FWD_PPDU_PRTID_SH 23
#define B_BE_FWD_PPDU_PRTID_MSK 0x7
#define B_BE_FWD_PPDU_FW_RLS BIT(22)
#define B_BE_FWD_PPDU_QUEID_SH 16
#define B_BE_FWD_PPDU_QUEID_MSK 0x3f
#define B_BE_FWD_OTHER_RPKT_SH 8
#define B_BE_FWD_OTHER_RPKT_MSK 0xff
#define B_BE_FWD_PPDU_STAT_SH 0
#define B_BE_FWD_PPDU_STAT_MSK 0xff

#define R_BE_FWD_IE 0x9C34
#define B_BE_FWD_IE_HIT_SH 8
#define B_BE_FWD_IE_HIT_MSK 0xff
#define B_BE_FWD_IO_NO_HIT_SH 0
#define B_BE_FWD_IO_NO_HIT_MSK 0xff

#define R_BE_FWD_MGNT0 0x9C38
#define B_BE_FWD_MGNT3_SH 24
#define B_BE_FWD_MGNT3_MSK 0xff
#define B_BE_FWD_MGNT2_SH 16
#define B_BE_FWD_MGNT2_MSK 0xff
#define B_BE_FWD_MGNT1_SH 8
#define B_BE_FWD_MGNT1_MSK 0xff
#define B_BE_FWD_MGNT0_SH 0
#define B_BE_FWD_MGNT0_MSK 0xff

#define R_BE_FWD_MGNT1 0x9C3C
#define B_BE_FWD_MGNT7_SH 24
#define B_BE_FWD_MGNT7_MSK 0xff
#define B_BE_FWD_MGNT6_SH 16
#define B_BE_FWD_MGNT6_MSK 0xff
#define B_BE_FWD_MGNT5_SH 8
#define B_BE_FWD_MGNT5_MSK 0xff
#define B_BE_FWD_MGNT4_SH 0
#define B_BE_FWD_MGNT4_MSK 0xff

#define R_BE_FWD_MGNT2 0x9C40
#define B_BE_FWD_MGNT11_SH 24
#define B_BE_FWD_MGNT11_MSK 0xff
#define B_BE_FWD_MGNT10_SH 16
#define B_BE_FWD_MGNT10_MSK 0xff
#define B_BE_FWD_MGNT9_SH 8
#define B_BE_FWD_MGNT9_MSK 0xff
#define B_BE_FWD_MGNT8_SH 0
#define B_BE_FWD_MGNT8_MSK 0xff

#define R_BE_FWD_MGNT3 0x9C44
#define B_BE_FWD_MGNT15_SH 24
#define B_BE_FWD_MGNT15_MSK 0xff
#define B_BE_FWD_MGNT14_SH 16
#define B_BE_FWD_MGNT14_MSK 0xff
#define B_BE_FWD_MGNT13_SH 8
#define B_BE_FWD_MGNT13_MSK 0xff
#define B_BE_FWD_MGNT12_SH 0
#define B_BE_FWD_MGNT12_MSK 0xff

#define R_BE_FWD_CTRL0 0x9C48
#define B_BE_FWD_CTRL3_SH 24
#define B_BE_FWD_CTRL3_MSK 0xff
#define B_BE_FWD_CTRL2_SH 16
#define B_BE_FWD_CTRL2_MSK 0xff
#define B_BE_FWD_CTRL1_SH 8
#define B_BE_FWD_CTRL1_MSK 0xff
#define B_BE_FWD_CTRL0_SH 0
#define B_BE_FWD_CTRL0_MSK 0xff

#define R_BE_FWD_CTRL1 0x9C4C
#define B_BE_FWD_CTRL7_SH 24
#define B_BE_FWD_CTRL7_MSK 0xff
#define B_BE_FWD_CTRL6_SH 16
#define B_BE_FWD_CTRL6_MSK 0xff
#define B_BE_FWD_CTRL5_SH 8
#define B_BE_FWD_CTRL5_MSK 0xff
#define B_BE_FWD_CTRL4_SH 0
#define B_BE_FWD_CTRL4_MSK 0xff

#define R_BE_FWD_CTRL2 0x9C50
#define B_BE_FWD_CTRL11_SH 24
#define B_BE_FWD_CTRL11_MSK 0xff
#define B_BE_FWD_CTRL10_SH 16
#define B_BE_FWD_CTRL10_MSK 0xff
#define B_BE_FWD_CTRL9_SH 8
#define B_BE_FWD_CTRL9_MSK 0xff
#define B_BE_FWD_CTRL8_SH 0
#define B_BE_FWD_CTRL8_MSK 0xff

#define R_BE_FWD_CTRL3 0x9C54
#define B_BE_FWD_CTRL15_SH 24
#define B_BE_FWD_CTRL15_MSK 0xff
#define B_BE_FWD_CTRL14_SH 16
#define B_BE_FWD_CTRL14_MSK 0xff
#define B_BE_FWD_CTRL13_SH 8
#define B_BE_FWD_CTRL13_MSK 0xff
#define B_BE_FWD_CTRL12_SH 0
#define B_BE_FWD_CTRL12_MSK 0xff

#define R_BE_FWD_DATA0 0x9C58
#define B_BE_FWD_DATA3_SH 24
#define B_BE_FWD_DATA3_MSK 0xff
#define B_BE_FWD_DATA2_SH 16
#define B_BE_FWD_DATA2_MSK 0xff
#define B_BE_FWD_DATA1_SH 8
#define B_BE_FWD_DATA1_MSK 0xff
#define B_BE_FWD_DATA0_SH 0
#define B_BE_FWD_DATA0_MSK 0xff

#define R_BE_FWD_DATA1 0x9C5C
#define B_BE_FWD_DATA7_SH 24
#define B_BE_FWD_DATA7_MSK 0xff
#define B_BE_FWD_DATA6_SH 16
#define B_BE_FWD_DATA6_MSK 0xff
#define B_BE_FWD_DATA5_SH 8
#define B_BE_FWD_DATA5_MSK 0xff
#define B_BE_FWD_DATA4_SH 0
#define B_BE_FWD_DATA4_MSK 0xff

#define R_BE_FWD_DATA2 0x9C60
#define B_BE_FWD_DATA11_SH 24
#define B_BE_FWD_DATA11_MSK 0xff
#define B_BE_FWD_DATA10_SH 16
#define B_BE_FWD_DATA10_MSK 0xff
#define B_BE_FWD_DATA9_SH 8
#define B_BE_FWD_DATA9_MSK 0xff
#define B_BE_FWD_DATA8_SH 0
#define B_BE_FWD_DATA8_MSK 0xff

#define R_BE_FWD_DATA3 0x9C64
#define B_BE_FWD_DATA15_SH 24
#define B_BE_FWD_DATA15_MSK 0xff
#define B_BE_FWD_DATA14_SH 16
#define B_BE_FWD_DATA14_MSK 0xff
#define B_BE_FWD_DATA13_SH 8
#define B_BE_FWD_DATA13_MSK 0xff
#define B_BE_FWD_DATA12_SH 0
#define B_BE_FWD_DATA12_MSK 0xff

#define R_BE_CUT_AMSDU_CTRL 0x9C80
#define B_BE_EN_CUT_AMSDU BIT(31)
#define B_BE_CUT_AMSDU_CHKLEN_EN BIT(30)
#define B_BE_CA_CHK_ADDRCAM_EN BIT(29)
#define B_BE_CUT_AMSDU_CHKLEN_L_TH_SH 16
#define B_BE_CUT_AMSDU_CHKLEN_L_TH_MSK 0xff
#define B_BE_CUT_AMSDU_CHKLEN_H_TH_SH 0
#define B_BE_CUT_AMSDU_CHKLEN_H_TH_MSK 0xffff

#define R_BE_ALIGN_N_CA_LOG 0x9C84
#define B_BE_MSDU_DROP_SEQ_NMBR_SH 20
#define B_BE_MSDU_DROP_SEQ_NMBR_MSK 0xfff
#define B_BE_MSDU_DROP BIT(19)
#define B_BE_ALIGN_MODE_SH 17
#define B_BE_ALIGN_MODE_MSK 0x3

#define R_BE_CA_LOG 0x9C88
#define B_BE_AMSDU_LEN_ERR BIT(2)
#define B_BE_LEN_CHK_SMALL BIT(1)
#define B_BE_LEN_CHK_LARGE BIT(0)

#define R_BE_RX_NAT2P5_CTRL0 0x9C90
#define B_BE_NAT2P5_RX_CP_LEN_3_SH 27
#define B_BE_NAT2P5_RX_CP_LEN_3_MSK 0x1f
#define B_BE_NAT2P5_RX_CP_OFFSET_3_SH 17
#define B_BE_NAT2P5_RX_CP_OFFSET_3_MSK 0x3ff
#define B_BE_NAT2P5_RX_CP_VALID_3 BIT(16)
#define B_BE_NAT2P5_RX_CP_LEN_2_SH 11
#define B_BE_NAT2P5_RX_CP_LEN_2_MSK 0x1f
#define B_BE_NAT2P5_RX_CP_OFFSET_2_SH 1
#define B_BE_NAT2P5_RX_CP_OFFSET_2_MSK 0x3ff
#define B_BE_NAT2P5_RX_CP_VALID_2 BIT(0)

#define R_BE_RX_NAT2P5_CTRL1 0x9C94
#define B_BE_NAT2P5_RX_CP_LEN_1_SH 27
#define B_BE_NAT2P5_RX_CP_LEN_1_MSK 0x1f
#define B_BE_NAT2P5_RX_CP_OFFSET_1_SH 17
#define B_BE_NAT2P5_RX_CP_OFFSET_1_MSK 0x3ff
#define B_BE_NAT2P5_RX_CP_VALID_1 BIT(16)
#define B_BE_NAT2P5_RX_CP_LEN_0_SH 11
#define B_BE_NAT2P5_RX_CP_LEN_0_MSK 0x1f
#define B_BE_NAT2P5_RX_CP_OFFSET_0_SH 1
#define B_BE_NAT2P5_RX_CP_OFFSET_0_MSK 0x3ff
#define B_BE_NAT2P5_RX_CP_VALID_0 BIT(0)

#define R_BE_WOW_CTRL 0x9CB0
#define B_BE_WOW_HCI BIT(5)
#define B_BE_WOW_DROP BIT(2)
#define B_BE_WOW_WOWEN BIT(1)
#define B_BE_WOW_FORCE_WAKEUP BIT(0)

#define R_BE_HDR_CNV_CTRL 0x9CC0
#define B_BE_HDR_INFO_SH 4
#define B_BE_HDR_INFO_MSK 0x3
#define B_BE_HC_ADDR_HIT_EN BIT(3)
#define B_BE_RX_ADDR_LINK_TO_MLO BIT(2)
#define B_BE_HDR_CNV BIT(1)
#define B_BE_RX_HDR_CNV_EN BIT(0)

#define R_BE_HDR_CNV_VLAN_0_1 0x9CC4
#define B_BE_VLAN_TAG_1_SH 16
#define B_BE_VLAN_TAG_1_MSK 0xffff
#define B_BE_VLAN_TAG_0_SH 0
#define B_BE_VLAN_TAG_0_MSK 0xffff

#define R_BE_HDR_CNV_VLAN_2_3 0x9CC8
#define B_BE_VLAN_TAG_3_SH 16
#define B_BE_VLAN_TAG_3_MSK 0xffff
#define B_BE_VLAN_TAG_2_SH 0
#define B_BE_VLAN_TAG_2_MSK 0xffff

#define R_BE_HDR_CNV_VLAN_5_4 0x9CCC
#define B_BE_VLAN_TAG_5_SH 16
#define B_BE_VLAN_TAG_5_MSK 0xffff
#define B_BE_VLAN_TAG_4_SH 0
#define B_BE_VLAN_TAG_4_MSK 0xffff

#define R_BE_HDR_CNV_VLAN_7_6 0x9CD0
#define B_BE_VLAN_TAG_7_SH 16
#define B_BE_VLAN_TAG_7_MSK 0xffff
#define B_BE_VLAN_TAG_6_SH 0
#define B_BE_VLAN_TAG_6_MSK 0xffff

#define R_BE_MGCPKT 0x9CE0
#define B_BE_MGCPKT_IOT_EN BIT(7)
#define B_BE_MGCPKT_RPET_NBR_SH 0
#define B_BE_MGCPKT_RPET_NBR_MSK 0x1f

#define R_BE_DESIGN_VERSION 0x9CE0
#define B_BE_MPDU_DESIGN_VERSION_SH 0
#define B_BE_MPDU_DESIGN_VERSION_MSK 0xffffffffL

#define R_BE_STATISTIC0 0x9CE8
#define B_BERX_PKTOUT_CNT_SH 16
#define B_BERX_PKTOUT_CNT_MSK 0xffff
#define B_BE_RX_PKTIN_CNT_SH 0
#define B_BE_RX_PKTIN_CNT_MSK 0xffff

#define R_BE_STATISTIC1 0x9CE8
#define B_BE_RX_PKTDROP_CNT_SH 0
#define B_BE_RX_PKTDROP_CNT_MSK 0xffff

#define R_BE_MPDU_RX_ERR_ISR 0x9CF0
#define B_BE_TIMEOUT_ERR_ISR BIT(1)
#define B_BE_GETPKTID_ERR_ISR BIT(0)

#define R_BE_MPDU_RX_ERR_IMR 0x9CF4
#define B_BE_RPT_ERR_INT_EN BIT(3)
#define B_BE_TIMEOUT_ERR_INT_EN BIT(1)
#define B_BE_GETPKTID_ERR_INT_EN BIT(0)

#define R_BE_MPDU_RX_DBG 0x9CF8
#define B_BE_CAM_RST_CTRL BIT(24)
#define B_BE_MPDU_RX_2_CKEN_DIS BIT(18)
#define B_BE_MPDU_RX_1_CKEN_DIS BIT(17)
#define B_BE_MPDU_RX_0_CKEN_DIS BIT(16)
#define B_BE_MPDU_RX_DBG_EN BIT(8)
#define B_BE_MPDU_RX_2_D_LAST_EN BIT(2)
#define B_BE_MPDU_RX_1_D_LAST_EN BIT(1)
#define B_BE_MPDU_RX_0_D_LAST_EN BIT(0)

//
// SEC_ENG
//

#define R_BE_SEC_ENG_CTRL 0x0000
#define B_BE_SEC_ENG_EN BIT(31)
#define B_BE_CCMP_SPP_MIC BIT(30)
#define B_BE_CCMP_SPP_CTR BIT(29)
#define B_BE_SEC_CAM_ACC BIT(28)
#define B_BE_WMAC_SEC_PN_SEL_SH 26
#define B_BE_WMAC_SEC_PN_SEL_MSK 0x3
#define B_BE_WMAC_SEC_MASKIV BIT(25)
#define B_BE_WAPI_SPEC BIT(24)
#define B_BE_SEC_DBG_SEL_SH 16
#define B_BE_SEC_DBG_SEL_MSK 0xf
#define B_BE_CAM_FORCE_CLK BIT(15)
#define B_BE_SEC_FORCE_CLK BIT(14)
#define B_BE_SEC_RX_SHORT_ADD_ICVERR BIT(13)
#define B_BE_SRAM_IO_PROT BIT(12)
#define B_BE_SEC_PRE_ENQUE_TX BIT(11)
#define B_BE_CLK_EN_CGCMP BIT(10)
#define B_BE_CLK_EN_WAPI BIT(9)
#define B_BE_CLK_EN_WEP_TKIP BIT(8)
#define B_BE_BMC_MGNT_DEC BIT(5)
#define B_BE_UC_MGNT_DEC BIT(4)
#define B_BE_MC_DEC BIT(3)
#define B_BE_BC_DEC BIT(2)
#define B_BE_SEC_RX_DEC BIT(1)
#define B_BE_SEC_TX_ENC BIT(0)

#define R_BE_SEC_MPDU_PROC 0x0004
#define B_BE_QUEUE_FOWARD_SEL BIT(5)
#define B_BE_RESP1_PROTECT BIT(4)
#define B_BE_RESP0_PROTECT BIT(3)
#define B_BE_TX_ACTIVE_PROTECT BIT(2)
#define B_BE_APPEND_ICV BIT(1)
#define B_BE_APPEND_MIC BIT(0)

#define R_BE_SEC_CAM_ACCESS 0x0010
#define B_BE_SEC_TIME_OUT_SH 16
#define B_BE_SEC_TIME_OUT_MSK 0xffff
#define B_BE_SEC_CAM_POLL BIT(15)
#define B_BE_SEC_CAM_RW BIT(14)
#define B_BE_SEC_CAM_ACC_FAIL BIT(13)
#define B_BE_SEC_CAM_OFFSET_SH 0
#define B_BE_SEC_CAM_OFFSET_MSK 0x3ff

#define R_BE_SEC_CAM_RDATA 0x0014
#define B_BE_SEC_CAM_RDATA_SH 0
#define B_BE_SEC_CAM_RDATA_MSK 0xffffffffL

#define R_BE_SEC_CAM_WDATA 0x0018
#define B_BE_SEC_CAM_WDATA_SH 0
#define B_BE_SEC_CAM_WDATA_MSK 0xffffffffL

#define R_BE_SEC0_DEBUG1 0x001C
#define B_BE_TX_TIMEOUT_SEL_SH 30
#define B_BE_TX_TIMEOUT_SEL_MSK 0x3
#define B_BE_RX_TIMEOUT_SEL_SH 28
#define B_BE_RX_TIMEOUT_SEL_MSK 0x3
#define B_BE_TX_LAST_PKTID_SH 16
#define B_BE_TX_LAST_PKTID_MSK 0xfff
#define B_BE_RX_LAST_PKTID_SH 4
#define B_BE_RX_LAST_PKTID_MSK 0xfff
#define B_BE_SEC_ERROB_BE_BYPASS BIT(0)

#define R_BE_SEC0_TX_DEBUG 0x0020
#define B_BE_TX_READ_PARSEB_BE_FSM_SH 20
#define B_BE_TX_READ_PARSEB_BE_FSM_MSK 0xfff
#define B_BE_TX_WRITE_PARSEB_BE_FSM_SH 12
#define B_BE_TX_WRITE_PARSEB_BE_FSM_MSK 0xff
#define B_BE_TX_SEC_TYPE_SH 2
#define B_BE_TX_SEC_TYPE_MSK 0xf
#define B_BE_TX_EXKEY_ERROR BIT(1)
#define B_BE_TX_ENCRYPT BIT(0)

#define R_BE_SEC0_RX_DEBUG 0x0024
#define B_BE_RX_READ_PARSEB_BE_FSM_SH 21
#define B_BE_RX_READ_PARSEB_BE_FSM_MSK 0x7ff
#define B_BE_RX_WRITE_PARSEB_BE_FSM_SH 13
#define B_BE_RX_WRITE_PARSEB_BE_FSM_MSK 0xff
#define B_BE_RX_SEC_TYPE_SH 9
#define B_BE_RX_SEC_TYPE_MSK 0xf
#define B_BE_RX_MIC_ERROR BIT(8)
#define B_BE_RX_EXKEY_INDEX_SH 1
#define B_BE_RX_EXKEY_INDEX_MSK 0x7f
#define B_BE_RX_ENCRYPT BIT(0)

#define R_BE_SEC_DEBUG2 0x0028
#define B_BE_DBG_READ_SH 0
#define B_BE_DBG_READ_MSK 0xffffffffL

#define R_BE_SEC_ERROR_IMR 0x002C
#define B_BE_SEC1_RX_HANG_IMR BIT(3)
#define B_BE_SEC1_TX_HANG_IMR BIT(2)
#define B_BE_RX_HANG_IMR BIT(1)
#define B_BE_TX_HANG_IMR BIT(0)

#define R_BE_SEC_ERROR_FLAG 0x0030
#define B_BE_SEC1_RX_HANG_ERROR BIT(3)
#define B_BE_SEC1_TX_HANG_ERROR BIT(2)
#define B_BE_RX_HANG_ERROR BIT(1)
#define B_BE_TX_HANG_ERROR BIT(0)

#define R_BE_SEC1_DEBUG1 0x0034
#define B_BE_SEC1_TX_TIMEOUT_SEL_SH 30
#define B_BE_SEC1_TX_TIMEOUT_SEL_MSK 0x3
#define B_BE_SEC1_RX_TIMEOUT_SEL_SH 28
#define B_BE_SEC1_RX_TIMEOUT_SEL_MSK 0x3
#define B_BE_SEC1_TX_LAST_PKTID_SH 16
#define B_BE_SEC1_TX_LAST_PKTID_MSK 0xfff
#define B_BE_SEC1_RX_LAST_PKTID_SH 4
#define B_BE_SEC1_RX_LAST_PKTID_MSK 0xfff
#define B_BE_SEC1_SEC_ERROB_BE_BYPASS BIT(0)

#define R_BE_SEC1_TX_DEBUG 0x0038
#define B_BE_SEC1_TX_READ_PARSEB_BE_FSM_SH 20
#define B_BE_SEC1_TX_READ_PARSEB_BE_FSM_MSK 0xfff
#define B_BE_SEC1_TX_WRITE_PARSEB_BE_FSM_SH 12
#define B_BE_SEC1_TX_WRITE_PARSEB_BE_FSM_MSK 0xff
#define B_BE_SEC1_TX_SEC_TYPE_SH 2
#define B_BE_SEC1_TX_SEC_TYPE_MSK 0xf
#define B_BE_SEC1_TX_EXKEY_ERROR BIT(1)
#define B_BE_SEC1_TX_ENCRYPT BIT(0)

#define R_BE_SEC1_RX_DEBUG 0x003C
#define B_BE_SEC1_RX_READ_PARSEB_BE_FSM_SH 21
#define B_BE_SEC1_RX_READ_PARSEB_BE_FSM_MSK 0x7ff
#define B_BE_SEC1_RX_WRITE_PARSEB_BE_FSM_SH 13
#define B_BE_SEC1_RX_WRITE_PARSEB_BE_FSM_MSK 0xff
#define B_BE_SEC1_RX_SEC_TYPE_SH 9
#define B_BE_SEC1_RX_SEC_TYPE_MSK 0xf
#define B_BE_SEC1_RX_MIC_ERROR BIT(8)
#define B_BE_SEC1_RX_EXKEY_INDEX_SH 1
#define B_BE_SEC1_RX_EXKEY_INDEX_MSK 0x7f
#define B_BE_SEC1_RX_ENCRYPT BIT(0)

#define R_BE_SEC1_DEBUG2 0x0040
#define B_BE_SEC1_DBG_READ_SH 0
#define B_BE_SEC1_DBG_READ_MSK 0xffffffffL

//
// STA scheduler
//

//
// Tx Packet Controller
//

#define R_BE_TXPKTCTL_COM_CFG 0x9F00
#define B_BE_WDRLS_REASON4_DSTSEL_SH 16
#define B_BE_WDRLS_REASON4_DSTSEL_MSK 0x3
#define B_BE_WDRLS_REASON3_DSTSEL_SH 14
#define B_BE_WDRLS_REASON3_DSTSEL_MSK 0x3
#define B_BE_WDRLS_REASON2_DSTSEL_SH 12
#define B_BE_WDRLS_REASON2_DSTSEL_MSK 0x3
#define B_BE_WDRLS_REASON1_DSTSEL_SH 10
#define B_BE_WDRLS_REASON1_DSTSEL_MSK 0x3
#define B_BE_WDRLS_REASON0_DSTSEL_SH 8
#define B_BE_WDRLS_REASON0_DSTSEL_MSK 0x3
#define B_BE_COM_FSM_FRZTMR_TUSEL_SH 2
#define B_BE_COM_FSM_FRZTMR_TUSEL_MSK 0x3
#define B_BE_COM_CLKFREQ_SEL_SH 0
#define B_BE_COM_CLKFREQ_SEL_MSK 0x3

#define R_BE_TXPKTCTL_COM_ERRCHK_CFG 0x9F04
#define B_BE_COM_EM_1STCMD_IS_END BIT(0)

#define R_BE_TXPKTCTL_WORD008 0x9F08

#define R_BE_TXPKTCTL_WORD00C 0x9F0C

#define R_BE_DBG_FUN_INTF_CTL 0x9F30
#define B_BE_DFI_ACTIVE BIT(31)
#define B_BE_DFI_TRGSEL_SH 16
#define B_BE_DFI_TRGSEL_MSK 0xf
#define B_BE_DFI_ADDR_SH 0
#define B_BE_DFI_ADDR_MSK 0xffff

#define R_BE_DBG_FUN_INTF_DATA 0x9F34
#define B_BE_DFI_DATA_SH 0
#define B_BE_DFI_DATA_MSK 0xffffffffL

#define R_BE_DBG_CTL_TXPKT 0x9F38
#define B_BE_TPC_DBG1_SEL_SH 16
#define B_BE_TPC_DBG1_SEL_MSK 0xffff
#define B_BE_TPC_DBG0_SEL_SH 0
#define B_BE_TPC_DBG0_SEL_MSK 0xffff

#define R_BE_TPC_DBG_OUT 0x9F3C
#define B_BE_TPC_DBG1_OUT_SH 16
#define B_BE_TPC_DBG1_OUT_MSK 0xffff
#define B_BE_TPC_DBG0_OUT_SH 0
#define B_BE_TPC_DBG0_OUT_MSK 0xffff

#define R_BE_TXPKTCTL_B0_CFG 0x9F40
#define B_BE_B0_PATC_OPT_BRKOFF BIT(24)
#define B_BE_B0_ATCPAR_REFTU_VAL_SH 8
#define B_BE_B0_ATCPAR_REFTU_VAL_MSK 0xff
#define B_BE_B0_DIS_ACGC BIT(0)

#define R_BE_TXPKTCTL_B0_CTL 0x9F44
#define B_BE_B0_CTLST_IDLE BIT(1)
#define B_BE_B0_STOP_REQ BIT(0)

#define R_BE_TXPKTCTL_B0_PRELD_CFG0 0x9F48
#define B_BE_B0_PRELD_FEN BIT(31)
#define B_BE_B0_PRELD_USEMAXSZ_SH 16
#define B_BE_B0_PRELD_USEMAXSZ_MSK 0x3ff
#define B_BE_B0_PRELD_CAM_G1ENTNUM_SH 8
#define B_BE_B0_PRELD_CAM_G1ENTNUM_MSK 0x1f
#define B_BE_B0_PRELD_CAM_G0ENTNUM_SH 0
#define B_BE_B0_PRELD_CAM_G0ENTNUM_MSK 0x1f

#define R_BE_TXPKTCTL_B0_PRELD_CFG1 0x9F4C
#define B_BE_B0_PRELD_NXT_TXENDWIN_SH 8
#define B_BE_B0_PRELD_NXT_TXENDWIN_MSK 0xf
#define B_BE_B0_PRELD_NXT_RSVMINSZ_SH 0
#define B_BE_B0_PRELD_NXT_RSVMINSZ_MSK 0xff

#define R_BE_TXPKTCTL_B0_ERRINFO_DBGCTL 0x9F74
#define B_BE_B0_ERR_FLAG_NUM1_VLD BIT(31)
#define B_BE_B0_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_BE_B0_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_BE_B0_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_BE_B0_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_BE_B0_DBGERR_POP_PKTCMD BIT(3)
#define B_BE_B0_DBGERR_LOCKSTS BIT(1)
#define B_BE_B0_DBGERR_LOCKEN BIT(0)

#define R_BE_TXPKTCTL_B0_ERRFLAG_IMR 0x9F78
#define B_BE_B0_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_BE_B0_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_BE_B0_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_BE_B0_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_BE_B0_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B0_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B0_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B0_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B0_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_BE_B0_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_BE_B0_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B0_IMR_ERR_USRCTL_REINIT BIT(0)

#define R_BE_TXPKTCTL_B0_ERRFLAG_ISR 0x9F7C
#define B_BE_B0_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_BE_B0_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_BE_B0_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_BE_B0_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_BE_B0_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_BE_B0_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_BE_B0_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_BE_B0_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_BE_B0_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B0_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B0_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B0_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B0_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_BE_B0_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_BE_B0_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_BE_B0_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_BE_B0_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_BE_B0_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_BE_B0_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B0_ISR_ERR_USRCTL_REINIT BIT(0)

#define R_BE_TXPKTCTL_B1_CFG 0x9F80
#define B_BE_B1_PATC_OPT_BRKOFF BIT(24)
#define B_BE_B1_ATCPAR_REFTU_VAL_SH 8
#define B_BE_B1_ATCPAR_REFTU_VAL_MSK 0xff
#define B_BE_B1_DIS_ACGC BIT(0)

#define R_BE_TXPKTCTL_B1_CTL 0x9F84
#define B_BE_B1_CTLST_IDLE BIT(1)
#define B_BE_B1_STOP_REQ BIT(0)

#define R_BE_TXPKTCTL_B1_PRELD_CFG0 0x9F88
#define B_BE_B1_PRELD_FEN BIT(31)
#define B_BE_B1_PRELD_USEMAXSZ_SH 16
#define B_BE_B1_PRELD_USEMAXSZ_MSK 0x3ff
#define B_BE_B1_PRELD_CAM_G1ENTNUM_SH 8
#define B_BE_B1_PRELD_CAM_G1ENTNUM_MSK 0x1f
#define B_BE_B1_PRELD_CAM_G0ENTNUM_SH 0
#define B_BE_B1_PRELD_CAM_G0ENTNUM_MSK 0x1f

#define R_BE_TXPKTCTL_B1_PRELD_CFG1 0x9F8C
#define B_BE_B1_PRELD_NXT_TXENDWIN_SH 8
#define B_BE_B1_PRELD_NXT_TXENDWIN_MSK 0xf
#define B_BE_B1_PRELD_NXT_RSVMINSZ_SH 0
#define B_BE_B1_PRELD_NXT_RSVMINSZ_MSK 0xff

#define R_BE_TXPKTCTL_B1_ERRINFO_DBGCTL 0x9FB4
#define B_BE_B1_ERR_FLAG_NUM1_VLD BIT(31)
#define B_BE_B1_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_BE_B1_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_BE_B1_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_BE_B1_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_BE_B1_DBGERR_POP_PKTCMD BIT(3)
#define B_BE_B1_DBGERR_LOCKSTS BIT(1)
#define B_BE_B1_DBGERR_LOCKEN BIT(0)

#define R_BE_TXPKTCTL_B1_ERRFLAG_IMR 0x9FB8
#define B_BE_B1_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_BE_B1_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_BE_B1_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_BE_B1_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_BE_B1_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B1_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B1_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B1_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B1_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_BE_B1_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_BE_B1_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B1_IMR_ERR_USRCTL_REINIT BIT(0)

#define R_BE_TXPKTCTL_B1_ERRFLAG_ISR 0x9FBC
#define B_BE_B1_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_BE_B1_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_BE_B1_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_BE_B1_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_BE_B1_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_BE_B1_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_BE_B1_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_BE_B1_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_BE_B1_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_BE_B1_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_BE_B1_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_BE_B1_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_BE_B1_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_BE_B1_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_BE_B1_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_BE_B1_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_BE_B1_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_BE_B1_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_BE_B1_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_BE_B1_ISR_ERR_USRCTL_REINIT BIT(0)

//
// MLO
//

#define R_BE_MLO_STATUS_0 0xA100
#define B_BE_MLO_STATUS_0_SH 0
#define B_BE_MLO_STATUS_0_MSK 0xffffffffL

#define R_BE_MLO_STATUS_1 0xA104
#define B_BE_MLO_STATUS_1_SH 0
#define B_BE_MLO_STATUS_1_MSK 0xffffffffL

#define R_BE_MLO_STATUS_2 0xA108
#define B_BE_MLO_STATUS_2_SH 0
#define B_BE_MLO_STATUS_2_MSK 0xffffffffL

#define R_BE_MLO_STATUS_3 0xA10C
#define B_BE_MLO_STATUS_3_SH 0
#define B_BE_MLO_STATUS_3_MSK 0xffffffffL

#define R_BE_MLO_RSTCK_CTL 0xA110
#define B_BE_MLO_FUNC_RSTN BIT(31)
#define B_BE_MLO_REG_RSTN BIT(30)
#define B_BE_MLO_CLK_FREE BIT(29)
#define B_BE_MLO_FUNC_CLK_EN BIT(28)
#define B_BE_MLO_REG_CLK_EN BIT(27)
#define B_BE_MLO_TABLE_RSTN BIT(23)

#define R_BE_MLO_INIT_CTL 0xA114
#define B_BE_MLO_TABLE_INIT_DONE BIT(31)
#define B_BE_MLO_TABLE_CLR_DONE BIT(30)
#define B_BE_MLO_TABLE_REINIT BIT(23)
#define B_BE_MLO_TABLE_HW_FLAG_CLR BIT(22)

#define R_BE_MLO_OVERALL_CTL 0xA118
#define B_BE_MLO_BYPASS_MODE BIT(31)
#define B_BE_MLO_NO_BALIMIT BIT(30)
#define B_BE_MLO_NO_MAX_NUM_LIMIT BIT(29)
#define B_BE_MLO_BAND_ASSIGN_PRI BIT(24)

#define R_BE_MLO_IMR 0xA120
#define B_BE_MLO_IMR_SH 0
#define B_BE_MLO_IMR_MSK 0xffffffffL

#define R_BE_MLO_ISR 0xA124
#define B_BE_MLO_ISR_0 BIT(31)
#define B_BE_MLO_ISR_1 BIT(30)
#define B_BE_MLO_ISR_2 BIT(29)
#define B_BE_MLO_ISR_3 BIT(28)

#define R_BE_MLO_ERR_IDCT_IMR 0xA128
#define B_BE_MLO_ERR_IDCT_IMR_SH 0
#define B_BE_MLO_ERR_IDCT_IMR_MSK 0xffffffffL

#define R_BE_MLO_ERR_IDCT_ISR 0xA12C
#define B_BE_MLO_ISR_IDCT_0 BIT(31)
#define B_BE_MLO_ISR_IDCT_1 BIT(30)
#define B_BE_MLO_ISR_IDCT_2 BIT(29)
#define B_BE_MLO_ISR_IDCT_3 BIT(28)

#define R_BE_MLO_TABLE_CTL 0xA140
#define B_BE_MLO_TABLE_CMD_OWN BIT(31)
#define B_BE_MLO_TABLE_CMD_WR BIT(30)
#define B_BE_MLO_TABLE_DATA_OFFSET_SH 16
#define B_BE_MLO_TABLE_DATA_OFFSET_MSK 0xff
#define B_BE_MLO_TABLE_ADR_SH 0
#define B_BE_MLO_TABLE_ADR_MSK 0xff

#define R_BE_MLO_TABLE_DATA_MASK 0xA144
#define B_BE_MLO_TABLE_DATA_MASK_SH 0
#define B_BE_MLO_TABLE_DATA_MASK_MSK 0xffffffffL

#define R_BE_TABLE_DATA_WRITE 0xA148
#define B_BE_MLO_TABLE_WRITE_DATA_SH 0
#define B_BE_MLO_TABLE_WRITE_DATA_MSK 0xffffffffL

#define R_BE_MLO_TABLE_DATA_READ 0xA14C
#define B_BE_MLO_TABLE_READ_DATA_SH 0
#define B_BE_MLO_TABLE_READ_DATA_MSK 0xffffffffL

#define R_BE_IS_MLD_0 0xA160
#define B_BE_IS_MLD_0_SH 0
#define B_BE_IS_MLD_0_MSK 0xffffffffL

#define R_BE_IS_MLD_1 0xA164
#define B_BE_IS_MLD_1_SH 0
#define B_BE_IS_MLD_1_MSK 0xffffffffL

#define R_BE_IS_MLD_2 0xA168
#define B_BE_IS_MLD_2_SH 0
#define B_BE_IS_MLD_2_MSK 0xffffffffL

#define R_BE_IS_MLD_3 0xA16C
#define B_BE_IS_MLD_3_SH 0
#define B_BE_IS_MLD_3_MSK 0xffffffffL

#define R_BE_MLO_STOP_MACID_CTL 0xA180
#define B_BE_MLO_STOP_REQ BIT(15)
#define B_BE_MLO_STOP_ACK BIT(14)
#define B_BE_MLO_STOP_EN BIT(13)
#define B_BE_MLO_STOP_MACID_SH 0
#define B_BE_MLO_STOP_MACID_MSK 0xff

#define R_BE_MLO_FW_PORT_CTL 0xA190
#define B_BE_MLO_FW_ENQ_MODE BIT(31)
#define B_BE_MLO_FW_QSEL_MODE BIT(30)
#define B_BE_MLO_FW_DIS_WDINFO_MODE BIT(29)
#define B_BE_MLO_FW_Q_DST_PRTID_SH 8
#define B_BE_MLO_FW_Q_DST_PRTID_MSK 0x7
#define B_BE_MLO_FW_Q_DST_QUEID_SH 0
#define B_BE_MLO_FW_Q_DST_QUEID_MSK 0x3f

#define R_BE_MLO_HW_PORT_CTL 0xA194
#define B_BE_MLO_HW_ENQ_MODE BIT(31)
#define B_BE_MLO_HW_QSEL_MODE BIT(30)
#define B_BE_MLO_HW_DIS_WDINFO_MODE BIT(29)
#define B_BE_MLO_HW_Q_DST_PRTID_SH 8
#define B_BE_MLO_HW_Q_DST_PRTID_MSK 0x7
#define B_BE_MLO_HW_Q_DST_QUEID_SH 0
#define B_BE_MLO_HW_Q_DST_QUEID_MSK 0x3f

#define R_BE_MLO_WD_FUNC 0xA1A0
#define B_BE_MLO_INIT_WD_EN BIT(31)

#define R_BE_MLO_GRP_FUNC 0xA1B0
#define B_BE_MLO_GRP_CHANGE_MODE_SH 30
#define B_BE_MLO_GRP_CHANGE_MODE_MSK 0x3

#define R_BE_MLO_DBG_CTL 0xA1C0
#define B_BE_MLO_DBG_EN BIT(31)
#define B_BEL_MLO_DBG_SEL_SH 24
#define B_BEL_MLO_DBG_SEL_MSK 0xf

#define R_BE_MLO_DBG_DATA 0xA1C4
#define B_BE_MLO_DBG_DATA_SH 0
#define B_BE_MLO_DBG_DATA_MSK 0xffffffffL

#define R_BE_MLO_DBG_INIT_GRP 0xA1C8
#define B_BE_MLO_DBG_GRP_IDX_SEL_SH 24
#define B_BE_MLO_DBG_GRP_IDX_SEL_MSK 0xff

#define R_BE_MLO_DBG_INIT_DATA 0xA1CC
#define B_BE_MLO_DBG_QSTATUS_INT_SH 0
#define B_BE_MLO_DBG_QSTATUS_INT_MSK 0xffffffffL

#define R_BE_MLO_DBG_MACID_NUM_0 0xA1D0
#define B_BE_MLO_BA_LMT_CNT_CLR BIT(31)
#define B_BE_MLO_BA_LMT_CNT_NUM_0_SH 16
#define B_BE_MLO_BA_LMT_CNT_NUM_0_MSK 0xfff
#define B_BE_MLO_MONITOR_MACID_NUM_0_SH 0
#define B_BE_MLO_MONITOR_MACID_NUM_0_MSK 0xffff

#define R_BE_MLO_DBG_MACID_NUM_1 0xA1D4
#define B_BE_MLO_BA_LMT_CNT_NUM_1_SH 16
#define B_BE_MLO_BA_LMT_CNT_NUM_1_MSK 0xfff
#define B_BE_MLO_MONITOR_MACID_NUM_1_SH 0
#define B_BE_MLO_MONITOR_MACID_NUM_1_MSK 0xffff

#define R_BE_MLO_DBG_MACID_NUM_2 0xA1D8
#define B_BE_MLO_BA_LMT_CNT_NUM_2_SH 16
#define B_BE_MLO_BA_LMT_CNT_NUM_2_MSK 0xfff
#define B_BE_MLO_MONITOR_MACID_NUM_2_SH 0
#define B_BE_MLO_MONITOR_MACID_NUM_2_MSK 0xffff

#define R_BE_MLO_DBG_MACID_NUM_3 0xA1DC
#define B_BE_MLO_BA_LMT_CNT_NUM_3_SH 16
#define B_BE_MLO_BA_LMT_CNT_NUM_3_MSK 0xfff
#define B_BE_MLO_MONITOR_MACID_NUM_3_SH 0
#define B_BE_MLO_MONITOR_MACID_NUM_3_MSK 0xffff

//
// HCI common
//

#define R_BE_RXAGG_0_V1 0x0000
#define B_BE_RXAGG_EN BIT(31)
#define B_BE_RXAGG_DMA_STORE BIT(30)
#define B_BE_RXAGG_SW_EN BIT(29)
#define B_BE_RXAGG_SW_TRIG BIT(28)
#define B_BE_RXAGG_PKTNUM_TH_SH 16
#define B_BE_RXAGG_PKTNUM_TH_MSK 0xff
#define B_BE_RXAGG_TIMEOUT_TH_SH 8
#define B_BE_RXAGG_TIMEOUT_TH_MSK 0xff
#define B_BE_RXAGG_LEN_TH_SH 0
#define B_BE_RXAGG_LEN_TH_MSK 0xff

#define R_BE_RXAGG_1_V1 0x0004
#define B_BE_RXAGG_LEN_TH_HIGH_V1_SH 16
#define B_BE_RXAGG_LEN_TH_HIGH_V1_MSK 0x3
#define B_BE_RXAGG_SML_PKT_SIZE_V1_SH 5
#define B_BE_RXAGG_SML_PKT_SIZE_V1_MSK 0x7
#define B_BE_RXAGG_SML_PKTNUM_TH_SH 0
#define B_BE_RXAGG_SML_PKTNUM_TH_MSK 0x1f

#define R_BE_APB_BB 0x0010
#define B_BE_APB_CLR BIT(31)
#define B_BE_AXI_CLR BIT(30)
#define B_BE_RX_LEN_RCLR BIT(6)
#define B_BE_RX_LEN_WCLR BIT(5)
#define B_BE_RX_DATA_FIFO_RST BIT(4)
#define B_BE_PG_256_MODE BIT(2)
#define B_BE_AXI_B2B_MODE BIT(1)
#define B_BE_APB_BB_MODE BIT(0)

#define R_BE_TXBD_APB 0x0014
#define B_BE_AVLPG_FIFO_OVERFLOW BIT(31)
#define B_BE_AVLPG_FIFO_UNDERFLOW BIT(30)
#define B_BE_AXI_RCMD_ERR BIT(9)
#define B_BE_AXI_R_TIMEOUT BIT(8)
#define B_BE_USB_BULK_PG_ERR BIT(1)
#define B_BE_TXBD_APB_TIMEOUT BIT(0)

#define R_BE_HCI_BUF_IMR 0x0018
#define B_BE_HCI_BUF_IMR_SH 0
#define B_BE_HCI_BUF_IMR_MSK 0xffffffffL

#define R_BE_TX_APB 0x001C
#define B_BE_AVLPG_INIT_SW_RST BIT(20)
#define B_BE_AVLPG_FIFO_PTR_CLR BIT(19)
#define B_BE_AXI_RCMD_CLR BIT(16)
#define B_BE_TX_ARB_CLR BIT(12)
#define B_BE_TX_FIFO_PTR_CLR BIT(8)
#define B_BE_TX_APB_TIMEOUT_TH_SH 0
#define B_BE_TX_APB_TIMEOUT_TH_MSK 0xff

#define R_BE_AXI_ARID 0x0024
#define B_BE_AXI_ARID_ERR_EN BIT(31)
#define B_BE_AXI_ARADDR_ERR_EN BIT(30)
#define B_BE_AXI_ARLEN_ERR_RN BIT(29)

#define R_BE_AXI_R_TIMEOUT 0x002C
#define B_BE_AXI_R_TIMEOUT_TH_SH 24
#define B_BE_AXI_R_TIMEOUT_TH_MSK 0xff

#define R_BE_AXI_RTRANS 0x0030
#define B_BE_AXI_RCMD_CNT_SH 16
#define B_BE_AXI_RCMD_CNT_MSK 0xffff
#define B_BE_AXI_RTRANS_CNT_SH 0
#define B_BE_AXI_RTRANS_CNT_MSK 0xffff

#define R_BE_APB 0x0034
#define B_BE_APB_BULK_PG_CNT_SEL_SH 29
#define B_BE_APB_BULK_PG_CNT_SEL_MSK 0x7
#define B_BE_APB_PKT_PG_CNT_SEL_SH 13
#define B_BE_APB_PKT_PG_CNT_SEL_MSK 0x7

#define R_BE_USB_ERR_IND 0x0038
#define B_BE_ERR_USB_BULK_PG_CNT_SEL_SH 20
#define B_BE_ERR_USB_BULK_PG_CNT_SEL_MSK 0x7
#define B_BE_USB_CH6_BULK_PG_ERR BIT(6)
#define B_BE_USB_CH5_BULK_PG_ERR BIT(5)
#define B_BE_USB_CH4_BULK_PG_ERR BIT(4)
#define B_BE_USB_CH3_BULK_PG_ERR BIT(3)
#define B_BE_USB_CH2_BULK_PG_ERR BIT(2)
#define B_BE_USB_CH1_BULK_PG_ERR BIT(1)
#define B_BE_USB_CH0_BULK_PG_ERR BIT(0)

#define R_BE_HCI_BUF 0x0040
#define B_BE_HCI_BUF_DBESEL1_SH 8
#define B_BE_HCI_BUF_DBESEL1_MSK 0x1f
#define B_BE_HCI_BUF_DBESEL0_SH 0
#define B_BE_HCI_BUF_DBESEL0_MSK 0x1f

#define R_BE_AVLPG 0x0050
#define B_BE_AVLPG_TOTAL_DEC1_SH 0
#define B_BE_AVLPG_TOTAL_DEC1_MSK 0xf

//
// WL_BE_Reg_AON.xls
//

//
// AON
//

#define R_BE_SYS_ISO_CTRL 0x0000
#define B_BE_PWC_EV2EF_B BIT(15)
#define B_BE_PWC_EV2EF_S BIT(14)
#define B_BE_PA33V_EN BIT(13)
#define B_BE_PA12V_EN BIT(12)
#define B_BE_UA33V_EN BIT(11)
#define B_BE_UA12V_EN BIT(10)
#define B_BE_ISO_RFDIO BIT(9)
#define B_BE_ISO_EB2CORE BIT(8)
#define B_BE_ISO_DIOE BIT(7)
#define B_BE_ISO_WLPON2PP BIT(6)
#define B_BE_ISO_IP2MAC_WA2PP BIT(5)
#define B_BE_ISO_PD2CORE BIT(4)
#define B_BE_ISO_PA2PCIE BIT(3)
#define B_BE_ISO_UD2CORE BIT(2)
#define B_BE_ISO_UA2USB BIT(1)
#define B_BE_ISO_WD2PP BIT(0)

#define R_BE_SYS_FUNC_EN 0x0002
#define B_BE_FEN_MREGEN BIT(15)
#define B_BE_FEN_HWPDN BIT(14)
#define B_BE_FEN_ELDR BIT(12)
#define B_BE_FEN_DCORE BIT(11)
#define B_BE_FEN_DIOE BIT(9)
#define B_BE_FEN_PCIED BIT(8)
#define B_BE_FEN_PPLL BIT(7)
#define B_BE_FEN_PCIEA BIT(6)
#define B_BE_FEN_USBD BIT(4)
#define B_BE_FEN_UPLL BIT(3)
#define B_BE_FEN_USBA BIT(2)
#define B_BE_FEN_BB_GLB_RSTN BIT(1)
#define B_BE_FEN_BBRSTB BIT(0)

#define R_BE_SYS_PW_CTRL 0x0004
#define B_BE_SOP_ASWRM BIT(31)
#define B_BE_SOP_EASWR BIT(30)
#define B_BE_SOP_PWMM_DSWR BIT(29)
#define B_BE_SOP_EDSWR BIT(28)
#define B_BE_SOP_ACKF BIT(27)
#define B_BE_SOP_ERCK BIT(26)
#define B_BE_SOP_ANA_CLK_DIVISION_2 BIT(25)
#define B_BE_SOP_EXTL BIT(24)
#define B_BE_SOP_OFF_CAPC_EN BIT(23)
#define B_BE_XTAL_OFF_A_DIE BIT(22)
#define B_BE_ROP_SWPR BIT(21)
#define B_BE_DIS_HW_LPLDM BIT(20)
#define B_BE_DIS_HW_LPURLDO BIT(19)
#define B_BE_DIS_WLBT_PDNSUSEN_SOPC BIT(18)
#define B_BE_RDY_SYSPWR BIT(17)
#define B_BE_EN_WLON BIT(16)
#define B_BE_APDM_HPDN BIT(15)
#define B_BE_PSUS_OFF_CAPC_EN BIT(14)
#define B_BE_AFSM_PCIE_SUS_EN BIT(12)
#define B_BE_AFSM_WLSUS_EN BIT(11)
#define B_BE_APFM_SWLPS BIT(10)
#define B_BE_APFM_OFFMAC BIT(9)
#define B_BE_APFN_ONMAC BIT(8)
#define B_BE_CHIP_PDN_EN BIT(7)
#define B_BE_RDY_MACDIS BIT(6)
#define B_BE_SW_AFE_MODE BIT(4)
#define B_BE_PFM_WOWL BIT(3)
#define B_BE_WL_HCI_ALD BIT(1)
#define B_BE_EFUSE_LDALL BIT(0)

#define R_BE_SYS_CLK_CTRL 0x0008
#define B_BE_CPU_IDMEM_CLK_EN BIT(15)
#define B_BE_CPU_CLK_EN BIT(14)
#define B_BE_SYMR_BE_CLK_EN BIT(13)
#define B_BE_MAC_CLK_EN BIT(11)
#define B_BE_EXT_32K_EN BIT(8)
#define B_BE_WL_CLK_TEST BIT(7)
#define B_BE_LOADER_CLK_EN BIT(5)
#define B_BE_ANA_CLK_DIVISION_2 BIT(1)
#define B_BE_CNTD16V_EN BIT(0)

#define R_BE_SYS_WL_EFUSE_CTRL 0x000A
#define B_BE_OTP_B_PWC_RPT BIT(15)
#define B_BE_OTP_S_PWC_RPT BIT(14)
#define B_BE_OTP_ISO_RPT BIT(13)
#define B_BE_OTP_BURST_RPT BIT(12)
#define B_BE_OTP_AUTOLOAD_RPT BIT(11)
#define B_BE_AUTOLOAD_DIS_A_DIE BIT(6)
#define B_BE_AUTOLOAD_SUS BIT(5)
#define B_BE_AUTOLOAD_DIS BIT(4)

#define R_BE_SYS_PAGE_CLK_GATED 0x000C
#define B_BE_DIS_CLK_REGF_GATE BIT(15)
#define B_BE_DIS_CLK_REGE_GATE BIT(14)
#define B_BE_DIS_CLK_REGD_GATE BIT(13)
#define B_BE_DIS_CLK_REGC_GATE BIT(12)
#define B_BE_DIS_CLK_REGB_GATE BIT(11)
#define B_BE_DIS_CLK_REGA_GATE BIT(10)
#define B_BE_DIS_CLK_REG9_GATE BIT(9)
#define B_BE_DIS_CLK_REG8_GATE BIT(8)
#define B_BE_DIS_CLK_REG7_GATE BIT(7)
#define B_BE_DIS_CLK_REG6_GATE BIT(6)
#define B_BE_DIS_CLK_REG5_GATE BIT(5)
#define B_BE_DIS_CLK_REG4_GATE BIT(4)
#define B_BE_DIS_CLK_REG3_GATE BIT(3)
#define B_BE_DIS_CLK_REG2_GATE BIT(2)
#define B_BE_DIS_CLK_REG1_GATE BIT(1)
#define B_BE_DIS_CLK_REG0_GATE BIT(0)

#define R_BE_SYS_SWR_CTRL1 0x0010
#define B_BE_SYM_CTRL_SPSANA_PWMFREQ BIT(11)
#define B_BE_SYM_CTRL_SPS_PWMFREQ BIT(10)
#define B_BE_HW_AUTO_CTRL_EXT_SWR BIT(9)
#define B_BE_USE_INTERNAL_SWR_AND_LDO BIT(8)
#define B_BE_MAC_ID_EN BIT(7)
#define B_BE_OPTION_DIS_XTAL_BG BIT(2)

#define R_BE_ANAPARSW_POW_MAC 0x0014
#define B_BE_POW_LDO15 BIT(2)
#define B_BE_POW_SW_SPSANA BIT(1)
#define B_BE_POW_LDO14_SPSANA BIT(0)

#define R_BE_ANAPARLDO_POW_MAC 0x0015
#define B_BE_PWC_EV2EF_B_V1 BIT(7)
#define B_BE_PWC_EV2EF_S_V1 BIT(6)
#define B_BE_R_PD12_N_LDO BIT(5)
#define B_BE_POW_SW_SPSDIG BIT(1)
#define B_BE_POW_LDO14_SPSDIG BIT(0)

#define R_BE_ANAPAR_POW_MAC 0x0016
#define B_BE_POW_PC_LDO_PORT1 BIT(3)
#define B_BE_POW_PC_LDO_PORT0 BIT(2)
#define B_BE_POW_PLL_V1 BIT(1)
#define B_BE_POW_POWER_CUT_POW_LDO BIT(0)

#define R_BE_ANAPAR_POW_XTAL 0x0017
#define B_BE_POW_XTAL BIT(1)
#define B_BE_POW_BG BIT(0)

#define R_BE_SYS_ADIE_PAD_PWR_CTRL 0x0018
#define B_BE_SYM_PADPDN_WL_PTA_1P3 BIT(6)
#define B_BE_SYM_PADPDN_WL_RFC_1P3 BIT(5)

#define R_BE_AFE_LDO_VPULSE_CTRL 0x001A
#define B_BE_SYM_VPULSE_LDO_XBUF BIT(9)
#define B_BE_SYM_VPULSE_LDO_S1_ADDA BIT(3)
#define B_BE_SYM_VPULSE_LDO_S0_ADDA BIT(2)
#define B_BE_SYM_VPULSE_LDO_PLL BIT(0)

#define R_BE_RSV_CTRL 0x001C
#define B_BE_HR_BE_DBG_SH 12
#define B_BE_HR_BE_DBG_MSK 0xfff
#define B_BE_R_SYM_DIS_PCIE_FLR BIT(9)
#define B_BE_R_EN_HRST_PWRON BIT(8)
#define B_BE_LOCK_ALL_EN BIT(7)
#define B_BE_R_DIS_PRST BIT(6)
#define B_BE_WLOCK_1C_BIT6 BIT(5)
#define B_BE_WLOCK_40 BIT(4)
#define B_BE_WLOCK_08 BIT(3)
#define B_BE_WLOCK_04 BIT(2)
#define B_BE_WLOCK_00 BIT(1)
#define B_BE_WLOCK_ALL BIT(0)

#define R_BE_RF_CTRL 0x001F

#define R_BE_AFE_LDO_CTRL 0x0020
#define B_BE_R_SYM_WLPOFF_P4_PC_EN BIT(28)
#define B_BE_R_SYM_WLPOFF_P3_PC_EN BIT(27)
#define B_BE_R_SYM_WLPOFF_P2_PC_EN BIT(26)
#define B_BE_R_SYM_WLPOFF_P1_PC_EN BIT(25)
#define B_BE_R_SYM_WLPOFF_PC_EN BIT(24)
#define B_BE_AON_OFF_PC_EN BIT(23)
#define B_BE_R_SYM_WLPON_P3_PC_EN BIT(21)
#define B_BE_R_SYM_WLPON_P2_PC_EN BIT(20)
#define B_BE_R_SYM_WLPON_P1_PC_EN BIT(19)
#define B_BE_R_SYM_WLPON_PC_EN BIT(18)
#define B_BE_R_SYM_DIS_WPHYBBOFF_PC BIT(10)
#define B_BE_R_SYM_WLBBOFF1_P4_PC_EN BIT(9)
#define B_BE_R_SYM_WLBBOFF1_P3_PC_EN BIT(8)
#define B_BE_R_SYM_WLBBOFF1_P2_PC_EN BIT(7)
#define B_BE_R_SYM_WLBBOFF1_P1_PC_EN BIT(6)
#define B_BE_R_SYM_WLBBOFF_P4_PC_EN BIT(4)
#define B_BE_R_SYM_WLBBOFF_P3_PC_EN BIT(3)
#define B_BE_R_SYM_WLBBOFF_P2_PC_EN BIT(2)
#define B_BE_R_SYM_WLBBOFF_P1_PC_EN BIT(1)
#define B_BE_R_SYM_WLBBOFF_PC_EN BIT(0)

#define R_BE_AFE_CTRL1 0x0024
#define B_BE_WLCPU_CLK_SEL_SH 25
#define B_BE_WLCPU_CLK_SEL_MSK 0x3
#define B_BE_CMAC_CLK_SEL BIT(24)
#define B_BE_DMAC_CLK_SEL_SH 22
#define B_BE_DMAC_CLK_SEL_MSK 0x3
#define B_BE_DCPU_CLK_SEL_SH 20
#define B_BE_DCPU_CLK_SEL_MSK 0x3
#define B_BE_DMEM6_PC_EN BIT(18)
#define B_BE_DMEM5_PC_EN BIT(17)
#define B_BE_DMEM4_PC_EN BIT(16)
#define B_BE_DMEM3_PC_EN BIT(15)
#define B_BE_DMEM2_PC_EN BIT(14)
#define B_BE_DMEM1_PC_EN BIT(13)
#define B_BE_IMEM4_PC_EN BIT(12)
#define B_BE_IMEM3_PC_EN BIT(11)
#define B_BE_IMEM2_PC_EN BIT(10)
#define B_BE_IMEM1_PC_EN BIT(9)
#define B_BE_IMEM0_PC_EN BIT(8)
#define B_BE_R_SYM_WLCMAC1_P4_PC_EN BIT(4)
#define B_BE_R_SYM_WLCMAC1_P3_PC_EN BIT(3)
#define B_BE_R_SYM_WLCMAC1_P2_PC_EN BIT(2)
#define B_BE_R_SYM_WLCMAC1_P1_PC_EN BIT(1)
#define B_BE_R_SYM_WLCMAC1_PC_EN BIT(0)

#define R_BE_SYS_OCP_CTRL 0x0028
#define B_BE_SPS_OCP_DIS BIT(31)
#define B_BE_SPS_OCP_TH_SH 16
#define B_BE_SPS_OCP_TH_MSK 0x7fff
#define B_BE_OCP_WINDOW_SH 0
#define B_BE_OCP_WINDOW_MSK 0xffff

#define R_BE_SYSANA_OCP_CTRL 0x002C
#define B_BE_SPSANA_OCP_DIS BIT(31)
#define B_BE_SPSANA_OCP_TH_SH 16
#define B_BE_SPSANA_OCP_TH_MSK 0x7fff
#define B_BE_OCPANA_WINDOW_SH 0
#define B_BE_OCPANA_WINDOW_MSK 0xffff

#define R_BE_EFUSE_CTRL 0x0030
#define B_BE_EF_MODE_SEL_SH 30
#define B_BE_EF_MODE_SEL_MSK 0x3
#define B_BE_EF_RDY BIT(29)
#define B_BE_EF_COMP_RESULT BIT(28)
#define B_BE_EF_ADDR_SH 0
#define B_BE_EF_ADDR_MSK 0xffff

#define R_BE_EFUSE_CTRL_1_V1 0x0034
#define B_BE_EF_DATA_SH 0
#define B_BE_EF_DATA_MSK 0xffffffffL

#define R_BE_EFUSE_TEST_V1 0x0038
#define B_BE_EF_SCAN_SADR_SH 16
#define B_BE_EF_SCAN_SADR_MSK 0xffff
#define B_BE_EF_SCAN_EADR_SH 0
#define B_BE_EF_SCAN_EADR_MSK 0xffff

#define R_BE_EFUSE_TEST_1_V1 0x003C
#define B_BE_EF_CRES_SEL BIT(31)
#define B_BE_EF_SCAN_TRPT BIT(7)
#define B_BE_EF_SCAN_FTHR_SH 0
#define B_BE_EF_SCAN_FTHR_MSK 0x7f

#define R_BE_GPIO_MUXCFG 0x0040
#define B_BE_WCPU_JTAG_EN BIT(24)
#define B_BE_WCPU_DBG_EN BIT(23)
#define B_BE_DCPU_JTAG_EN BIT(22)
#define B_BE_DCPU_DBG_EN BIT(21)
#define B_BE_JTAG_CHAIN_EN BIT(20)
#define B_BE_BOOT_MODE BIT(19)
#define B_BE_WL_EECS_EXT_32K_SEL BIT(18)
#define B_BE_WL_SEC_BONDING_OPT_STS BIT(17)
#define B_BE_SECSIC_SEL BIT(16)
#define B_BE_ENHTP BIT(14)
#define B_BE_ENSIC BIT(12)
#define B_BE_SIC_SWRST BIT(11)
#define B_BE_PINMUX_PTA_EN BIT(10)
#define B_BE_WL_BT_PTA_SEC BIT(9)
#define B_BE_ENUARTTX BIT(8)
#define B_BE_BTMODE_SH 6
#define B_BE_BTMODE_MSK 0x3
#define B_BE_ENBT BIT(5)
#define B_BE_ENUARTRX BIT(2)

#define R_BE_GPIO_PIN_CTRL 0x0044
#define B_BE_GPIO_MOD_7_TO_0_SH 24
#define B_BE_GPIO_MOD_7_TO_0_MSK 0xff
#define B_BE_GPIO_IO_SEL_7_TO_0_SH 16
#define B_BE_GPIO_IO_SEL_7_TO_0_MSK 0xff
#define B_BE_GPIO_OUT_7_TO_0_SH 8
#define B_BE_GPIO_OUT_7_TO_0_MSK 0xff
#define B_BE_GPIO_IN_7_TO_0_SH 0
#define B_BE_GPIO_IN_7_TO_0_MSK 0xff

#define R_BE_GPIO_INTM 0x0048
#define B_BE_EXTWOL_EN BIT(16)
#define B_BE_GPIOF_INT_MD BIT(15)
#define B_BE_GPIOE_INT_MD BIT(14)
#define B_BE_GPIOD_INT_MD BIT(13)
#define B_BE_GPIOC_INT_MD BIT(12)
#define B_BE_GPIOB_INT_MD BIT(11)
#define B_BE_GPIOA_INT_MD BIT(10)
#define B_BE_GPIO9_INT_MD BIT(9)
#define B_BE_GPIO8_INT_MD BIT(8)
#define B_BE_GPIO7_INT_MD BIT(7)
#define B_BE_GPIO6_INT_MD BIT(6)
#define B_BE_GPIO5_INT_MD BIT(5)
#define B_BE_GPIO4_INT_MD BIT(4)
#define B_BE_GPIO3_INT_MD BIT(3)
#define B_BE_GPIO2_INT_MD BIT(2)
#define B_BE_GPIO1_INT_MD BIT(1)
#define B_BE_GPIO0_INT_MD BIT(0)

#define R_BE_LED_CFG 0x004C
#define B_BE_MAILBOX_3WIRE_GPIO_CFG BIT(28)
#define B_BE_LED2_EN BIT(22)
#define B_BE_LED2DIS BIT(21)
#define B_BE_LED2PL BIT(20)
#define B_BE_LED2SV BIT(19)
#define B_BE_LED2CM_SH 16
#define B_BE_LED2CM_MSK 0x7
#define B_BE_LED0LED1_RD_ONLY_SH 13
#define B_BE_LED0LED1_RD_ONLY_MSK 0x3

#define R_BE_PWR_OPTION_CTRL 0x0050
#define B_BE_DIS_LPS_WT_PDNSUS BIT(24)
#define B_BE_SYSON_DBG_PAD_E2 BIT(11)
#define B_BE_SYSON_PCI_PAD_E2 BIT(8)
#define B_BE_SYSON_WLPC_IDX_SH 6
#define B_BE_SYSON_WLPC_IDX_MSK 0x3
#define B_BE_SYSON_SPS0WWV_WT_SH 4
#define B_BE_SYSON_SPS0WWV_WT_MSK 0x3
#define B_BE_SYSON_SPS0LDO_WT_SH 2
#define B_BE_SYSON_SPS0LDO_WT_MSK 0x3
#define B_BE_SYSON_RCLK_SCALE_SH 0
#define B_BE_SYSON_RCLK_SCALE_MSK 0x3

#define R_BE_CAL_TIMER 0x0054
#define B_BE_CAL_SCAL_SH 0
#define B_BE_CAL_SCAL_MSK 0xffff

#define R_BE_DBG_CTRL 0x0058
#define B_BE_DBG_SEL1_4BIT_SH 30
#define B_BE_DBG_SEL1_4BIT_MSK 0x3
#define B_BE_DBG_SEL1_16BIT BIT(27)
#define B_BE_DBG_SEL1_SH 16
#define B_BE_DBG_SEL1_MSK 0xff
#define B_BE_DBG_SEL0_4BIT_SH 14
#define B_BE_DBG_SEL0_4BIT_MSK 0x3
#define B_BE_DBG_SEL0_16BIT BIT(11)
#define B_BE_DBG_SEL0_SH 0
#define B_BE_DBG_SEL0_MSK 0xff

#define R_BE_PWR_CUT_CTRL 0x005C
#define B_BE_WLBBPC1_WT_SH 24
#define B_BE_WLBBPC1_WT_MSK 0xff
#define B_BE_WLBBPC0_WT_SH 16
#define B_BE_WLBBPC0_WT_MSK 0xff
#define B_BE_WLMACPC1_WT_SH 12
#define B_BE_WLMACPC1_WT_MSK 0xf
#define B_BE_WLMACPC0_WT_SH 8
#define B_BE_WLMACPC0_WT_MSK 0xf
#define B_BE_WLPONPC1_WT_SH 4
#define B_BE_WLPONPC1_WT_MSK 0xf
#define B_BE_WLPONPC0_WT_SH 0
#define B_BE_WLPONPC0_WT_MSK 0xf

#define R_BE_GPIO_EXT_CTRL 0x0060
#define B_BE_GPIO_MOD_15_TO_8_SH 24
#define B_BE_GPIO_MOD_15_TO_8_MSK 0xff
#define B_BE_GPIO_IO_SEL_15_TO_8_SH 16
#define B_BE_GPIO_IO_SEL_15_TO_8_MSK 0xff
#define B_BE_GPIO_OUT_15_TO_8_SH 8
#define B_BE_GPIO_OUT_15_TO_8_MSK 0xff
#define B_BE_GPIO_IN_15_TO_8_SH 0
#define B_BE_GPIO_IN_15_TO_8_MSK 0xff

#define R_BE_PAD_CTRL1 0x0064
#define B_BE_BT_OTP_PWC_DIS BIT(28)
#define B_BE_BTGP_UART0_SEL BIT(27)
#define B_BE_BTGP_JTAG_EN BIT(24)
#define B_BE_XTAL_CLK_EXTARNAL_EN BIT(23)
#define B_BE_BTGP_UART0_EN BIT(22)
#define B_BE_BTGP_SPI_EN BIT(20)
#define B_BE_BTGP_GPIO_E2 BIT(19)
#define B_BE_BTGPDBG_EN BIT(17)
#define B_BE_BTGP_I2C_EN BIT(16)
#define B_BE_WL_JTAG_EN BIT(15)
#define B_BE_PAD_SDIO_SR BIT(14)

#define R_BE_WL_BT_PWR_CTRL 0x0068
#define B_BE_ISO_BD2PP BIT(31)
#define B_BE_LDOV12B_EN BIT(30)
#define B_BE_CKEN_BT BIT(29)
#define B_BE_FEN_BT BIT(28)
#define B_BE_BTCPU_BOOTSEL BIT(27)
#define B_BE_SPI_SPEEDUP BIT(26)
#define B_BE_BT_LDO_MODE BIT(25)
#define B_BE_CLKREQ_PAD_TYPE_SEL BIT(23)
#define B_BE_ISO_BTPON2PP BIT(22)
#define B_BE_BT_HWROF_EN BIT(19)
#define B_BE_BT_FUNC_EN BIT(18)
#define B_BE_BT_HWPDN_SL BIT(17)
#define B_BE_BT_DISN_EN BIT(16)
#define B_BE_EXTERNAL_REQUEST_PL BIT(13)
#define B_BE_SDM_SRC_SEL BIT(12)
#define B_BE_ISO_BA2PP BIT(11)
#define B_BE_BT_AFE_LDO_EN BIT(10)
#define B_BE_BT_AFE_PLL_EN BIT(9)
#define B_BE_WLAN_32K_SEL BIT(6)
#define B_BE_WL_DRV_EXIST_IDX BIT(5)
#define B_BE_DOP_EHPAD BIT(4)
#define B_BE_WL_HWROF_EN BIT(3)
#define B_BE_WL_FUNC_EN BIT(2)
#define B_BE_WL_HWPDN_SL BIT(1)
#define B_BE_WL_HWPDN_EN BIT(0)

#define R_BE_SDM_DEBUG 0x006C
#define B_BE_GPIO_IE_V18 BIT(10)
#define B_BE_PCIE_IE_V18 BIT(9)
#define B_BE_UART_IE_V18 BIT(8)

#define R_BE_SYS_SDIO_CTRL 0x0070
#define B_BE_MCM_FLASH_EN BIT(28)
#define B_BE_LTE_MUX_CTRL_PATH BIT(26)
#define B_BE_SDIO_CMD_SW_RST BIT(20)
#define B_BE_SDIO_INT_POLARITY BIT(19)
#define B_BE_SDIO_OFF_EN BIT(17)
#define B_BE_SDIO_ON_EN BIT(16)
#define B_BE_PCIE_DIS_L2__CTRL_LDO_HCI BIT(15)
#define B_BE_PCIE_DIS_WLSUS_AFT_PDN BIT(14)
#define B_BE_PCIE_FORCE_PWR_NGAT BIT(13)
#define B_BE_PCIE_FORCE_IBX_EN_V1 BIT(12)
#define B_BE_PCIE_AUXCLK_GATE BIT(11)
#define B_BE_PCIE_WAIT_TIMEOUT_EVENT BIT(10)
#define B_BE_PCIE_WAIT_TIME BIT(9)
#define B_BE_L1OFF_TO_L0_RESUME_EVT BIT(8)
#define B_BE_USBA_FORCE_PWR_NGAT BIT(7)
#define B_BE_USBD_FORCE_PWR_NGAT BIT(6)
#define B_BE_BT_CTRL_USB_PWR BIT(5)
#define B_BE_USB_D_STATE_HOLD BIT(4)
#define B_BE_R_BE_FORCE_DP BIT(3)
#define B_BE_R_BE_DP_MODE BIT(2)
#define B_BE_RES_USB_MASS_STORAGE_DESC BIT(1)
#define B_BE_USB_WAIT_TIME BIT(0)

#define R_BE_HCI_OPT_CTRL 0x0074
#define B_BE_USBMAC_ANACLK_SW BIT(21)
#define B_BE_PCIE_CPHY_CCK_XTAL_SEL BIT(20)
#define B_BE_SDIO_DATA_PAD_SMT BIT(19)
#define B_BE_SDIO_PAD_E5 BIT(18)
#define B_BE_HCI_LA_ADDR_MAP BIT(16)
#define B_BE_HCI_LA_GLO_RST BIT(15)
#define B_BE_USB3_SUS_DIS BIT(14)
#define B_BE_NOPWR_CTRL_SEL BIT(13)
#define B_BE_USB_HOST_PWR_OFF_EN BIT(12)
#define B_BE_SYM_LPS_BLOCK_EN BIT(11)
#define B_BE_USB_LPM_ACT_EN BIT(10)
#define B_BE_USB_LPM_NY BIT(9)
#define B_BE_USB2_SUS_DIS BIT(8)
#define B_BE_SDIO_PAD_E_SH 5
#define B_BE_SDIO_PAD_E_MSK 0x7
#define B_BE_USB_LPPLL_EN BIT(4)
#define B_BE_USB1_1_USB2_0_DECISION BIT(3)
#define B_BE_ROP_SW15 BIT(2)
#define B_BE_PCI_CKRDY_OPT BIT(1)
#define B_BE_PCI_VAUX_EN BIT(0)

#define R_BE_HCI_BG_CTRL 0x0078
#define B_BE_IBX_EN_VALUE BIT(15)
#define B_BE_IB_EN_VALUE BIT(14)
#define B_BE_FORCED_IB_EN BIT(4)
#define B_BE_EN_REGBG BIT(3)
#define B_BE_R_BE_BG_LPF BIT(2)
#define B_BE_R_BE_BG_SH 0
#define B_BE_R_BE_BG_MSK 0x3

#define R_BE_HCI_LDO_CTRL 0x007A
#define B_BE_EN_LW_PWR BIT(6)
#define B_BE_EN_REGU BIT(5)
#define B_BE_EN_PC BIT(4)
#define B_BE_R_BE_VADJ_SH 0
#define B_BE_R_BE_VADJ_MSK 0xf

#define R_BE_LDO_SWR_CTRL 0x007C
#define B_BE_DIG_ZCD_HW_AUTO_EN BIT(27)
#define B_BE_DIG_ZCD_REGSEL BIT(26)
#define B_BE_DIG_AUTO_ZCD_IN_CODE_SH 21
#define B_BE_DIG_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_BE_DIG_ZCD_CODE_IN_L_SH 16
#define B_BE_DIG_ZCD_CODE_IN_L_MSK 0x1f
#define B_BE_ANA_ZCD_HW_AUTO_EN BIT(11)
#define B_BE_ANA_ZCD_REGSEL BIT(10)
#define B_BE_ANA_AUTO_ZCD_IN_CODE_SH 5
#define B_BE_ANA_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_BE_ANA_ZCD_CODE_IN_L_SH 0
#define B_BE_ANA_ZCD_CODE_IN_L_MSK 0x1f

#define R_BE_SYS_ISO_CTRL_EXTEND 0x0080
#define B_BE_R_SYM_FEN_WLMACOFF BIT(31)
#define B_BE_CMAC1_FEN BIT(30)
#define B_BE_R_SYM_ISO_DMEM62PP BIT(29)
#define B_BE_R_SYM_ISO_DMEM52PP BIT(28)
#define B_BE_R_SYM_ISO_DMEM42PP BIT(27)
#define B_BE_R_SYM_ISO_DMEM32PP BIT(26)
#define B_BE_R_SYM_ISO_DMEM22PP BIT(25)
#define B_BE_R_SYM_ISO_DMEM12PP BIT(24)
#define B_BE_R_SYM_ISO_IMEM42PP BIT(22)
#define B_BE_R_SYM_ISO_IMEM32PP BIT(21)
#define B_BE_R_SYM_ISO_IMEM22PP BIT(20)
#define B_BE_R_SYM_ISO_IMEM12PP BIT(19)
#define B_BE_R_SYM_ISO_IMEM02PP BIT(18)
#define B_BE_R_SYM_FEN_WLBBGLB_1 BIT(17)
#define B_BE_R_SYM_FEN_WLBBFUN_1 BIT(16)
#define B_BE_R_SYM_ISO_AON_OFF2PP BIT(15)
#define B_BE_R_SYM_PWC_HCILA BIT(13)
#define B_BE_R_SYM_PWC_PD12V BIT(12)
#define B_BE_R_SYM_PWC_UD12V BIT(11)
#define B_BE_R_SYM_PWC_BTBRG BIT(10)
#define B_BE_R_SYM_LDOBTSDIO_EN BIT(9)
#define B_BE_R_SYM_LDOSPDIO_EN BIT(8)
#define B_BE_R_SYM_ISO_BB2PP BIT(7)
#define B_BE_R_SYM_ISO_CMAC12PP BIT(5)
#define B_BE_R_SYM_ISO_HCILA BIT(4)
#define B_BE_R_SYM_ISO_BTBRG2PP BIT(2)
#define B_BE_R_SYM_ISO_BTSDIO2PP BIT(1)
#define B_BE_R_SYM_ISO_SPDIO2PP BIT(0)

#define R_BE_PLATFORM_ENABLE 0x0088
#define B_BE_SYM_WLPLT_MEM_MUX_EN BIT(10)
#define B_BE_WCPU_WARM_EN BIT(9)
#define B_BE_SPIC_EN BIT(8)
#define B_BE_UART_EN BIT(7)
#define B_BE_IDDMA_EN BIT(6)
#define B_BE_IPSEC_EN BIT(5)
#define B_BE_HIOE_EN BIT(4)
#define B_BE_APB_WRAP_EN BIT(2)
#define B_BE_WCPU_EN BIT(1)
#define B_BE_PLATFORM_EN BIT(0)

#define R_BE_WLLPS_CTRL 0x0090
#define B_BE_LPSOP_BBOFF BIT(29)
#define B_BE_LPSOP_MACOFF BIT(28)
#define B_BE_LPSOP_OFF_CAPC_EN BIT(27)
#define B_BE_LPSOP_MEM_DS BIT(26)
#define B_BE_LPSOP_XTALM_LPS BIT(23)
#define B_BE_LPSOP_XTAL BIT(22)
#define B_BE_LPSOP_ACLK_DIV_2 BIT(21)
#define B_BE_LPSOP_ACLK_SEL BIT(20)
#define B_BE_LPSOP_ASWRM BIT(17)
#define B_BE_LPSOP_ASWR BIT(16)
#define B_BE_LPSOP_DSWR_ADJ_SH 12
#define B_BE_LPSOP_DSWR_ADJ_MSK 0xf
#define B_BE_LPSOP_DSWRSD BIT(10)
#define B_BE_LPSOP_DSWRM BIT(9)
#define B_BE_LPSOP_DSWR BIT(8)
#define B_BE_LPSOP_OLD_ADJ_SH 4
#define B_BE_LPSOP_OLD_ADJ_MSK 0xf
#define B_BE_FORCE_LEAVE_LPS BIT(3)
#define B_BE_LPSOP_OLDSD BIT(2)
#define B_BE_DIS_WLBT_LPSEN_LOPC BIT(1)
#define B_BE_WL_LPS_EN BIT(0)

#define R_BE_WLRESUME_CTRL 0x0094
#define B_BE_LPSROP_CMAC1 BIT(20)
#define B_BE_LPSROP_XTALM BIT(19)
#define B_BE_LPSROP_AFEM BIT(18)
#define B_BE_LPSROP_HIOE BIT(17)
#define B_BE_LPSROP_CPU BIT(16)
#define B_BE_LPSROP_DSWRSD_SEL_SH 4
#define B_BE_LPSROP_DSWRSD_SEL_MSK 0x3

#define R_BE_GPIO_DEBOUNCE_CTRL 0x0098
#define B_BE_WLGP_DBC1EN BIT(15)
#define B_BE_WLGP_DBC1_SH 8
#define B_BE_WLGP_DBC1_MSK 0xf
#define B_BE_WLGP_DBC0EN BIT(7)
#define B_BE_WLGP_DBC0_SH 0
#define B_BE_WLGP_DBC0_MSK 0xf

#define R_BE_SYSON_FSM_MON 0x00A0
#define B_BE_FSM_MON_SEL_SH 24
#define B_BE_FSM_MON_SEL_MSK 0x7
#define B_BE_DOP_ELDO BIT(23)
#define B_BE_FSM_MON_UPD BIT(15)
#define B_BE_FSM_PAR_SH 0
#define B_BE_FSM_PAR_MSK 0x7fff

#define R_BE_EFUSE_CTRL_2_V1 0x00A4
#define B_BE_EF_ENT BIT(31)
#define B_BE_EF_RDT BIT(27)
#define B_BE_EF_PGTS_SH 20
#define B_BE_EF_PGTS_MSK 0xf
#define B_BE_EF_BURST BIT(19)
#define B_BE_EF_TEST_SEL_SH 16
#define B_BE_EF_TEST_SEL_MSK 0x7
#define B_BE_EF_TROW_EN BIT(15)
#define B_BE_EF_ERR_FLAG BIT(14)
#define B_BE_EF_FBURST_DIS BIT(13)
#define B_BE_EF_DSB_EN BIT(11)
#define B_BE_EF_DLY_SEL_SH 0
#define B_BE_EF_DLY_SEL_MSK 0xf

#define R_BE_PMC_DBG_CTRL1 0x00A8
#define B_BE_PMC_WR_OVF BIT(8)
#define B_BE_WLPMC_ERRINT_SH 0
#define B_BE_WLPMC_ERRINT_MSK 0xff

#define R_BE_SCOREBOARD  0x00AC
#define B_BE_TOGGLE BIT(31)
#define B_BE_DATA_LINE_SH 0
#define B_BE_DATA_LINE_MSK 0x7fffffffL

#define R_BE_DBG_PORT_SEL 0x00C0
#define B_BE_DEBUG_ST_SH 0
#define B_BE_DEBUG_ST_MSK 0xffffffffL

#define R_BE_PAD_CTRL2 0x00C4
#define B_BE_FORCE_CLK_U2 BIT(25)
#define B_BE_FORCE_U2_CK BIT(24)
#define B_BE_FORCE_U3_CK BIT(23)
#define B_BE_USB2_FORCE BIT(22)
#define B_BE_USB3_FORCE BIT(21)
#define B_BE_USB3_USB2_TRANSITION BIT(20)
#define B_BE_USB23_SW_MODE_V1_SH 18
#define B_BE_USB23_SW_MODE_V1_MSK 0x3
#define B_BE_NO_PDN_CHIPOFF_V1 BIT(17)
#define B_BE_RSM_EN_V1 BIT(16)
#define B_BE_MATCH_CNT_SH 8
#define B_BE_MATCH_CNT_MSK 0xff
#define B_BE_LD_B12V_EN BIT(7)
#define B_BE_EECS_IOSEL_V1 BIT(6)
#define B_BE_EECS_DATA_O_V1 BIT(5)
#define B_BE_EECS_DATA_I_V1 BIT(4)
#define B_BE_EESK_IOSEL_V1 BIT(2)
#define B_BE_EESK_DATA_O_V1 BIT(1)
#define B_BE_EESK_DATA_I_V1 BIT(0)

#define R_BE_PMC_DBG_CTRL2 0x00CC
#define B_BE_EFUSE_BURN_GNT_SH 24
#define B_BE_EFUSE_BURN_GNT_MSK 0xff
#define B_BE_DIS_IOWRAP_TIMEOUT BIT(16)
#define B_BE_STOP_WL_PMC BIT(9)
#define B_BE_STOP_SYM_PMC BIT(8)
#define B_BE_BT_ACCESS_WL_PAGE0 BIT(6)
#define B_BE_R_BE_RST_WLPMC BIT(5)
#define B_BE_R_BE_RST_PD12N BIT(4)
#define B_BE_SYSON_DIS_WLR_BE_WRMSK BIT(3)
#define B_BE_SYSON_DIS_PMCR_BE_WRMSK BIT(2)
#define B_BE_SYSON_R_BE_ARB_SH 0
#define B_BE_SYSON_R_BE_ARB_MSK 0x3

#define R_BE_MEM_PWR_CTRL 0x00D0
#define B_BE_MEM_BB_SD BIT(17)
#define B_BE_MEM_BB_DS BIT(16)
#define B_BE_MEM_BT_DS BIT(10)
#define B_BE_MEM_SDIO_LS BIT(9)
#define B_BE_MEM_SDIO_DS BIT(8)
#define B_BE_MEM_USB_LS BIT(7)
#define B_BE_MEM_USB_DS BIT(6)
#define B_BE_MEM_PCI_LS BIT(5)
#define B_BE_MEM_PCI_DS BIT(4)
#define B_BE_MEM_WLMAC_LS BIT(3)
#define B_BE_MEM_WLMAC_DS BIT(2)
#define B_BE_MEM_WLMCU_LS BIT(1)
#define B_BE_MEM_WLMCU_DS BIT(0)

#define R_BE_INDIR_ADR_SDIO 0x00D4
#define B_BE_INDIR_READY_SDIO BIT(17)
#define B_BE_INDIR_R_SDIO BIT(16)
#define B_BE_INDIR_ADR_SDIO_SH 0
#define B_BE_INDIR_ADR_SDIO_MSK 0xffff

#define R_BE_INDIR_DATA_SDIO 0x00D8
#define B_BE_INDIR_DATA_SDIO_SH 0
#define B_BE_INDIR_DATA_SDIO_MSK 0xffffffffL

#define R_BE_USB_SIE_INTF 0x00E0
#define B_BE_USB_REG_SEL BIT(31)
#define B_BE_USB_WRITE_EN BIT(30)
#define B_BE_USB_REG_EN BIT(29)
#define B_BE_USB_SIE_SEL BIT(28)
#define B_BE_USB_REG_STATUS BIT(27)
#define B_BE_USB_PHY_BYTE_SEL BIT(26)
#define B_BE_USB_SIE_INTF_ADDR_SH 16
#define B_BE_USB_SIE_INTF_ADDR_MSK 0x3ff
#define B_BE_USB_SIE_INTF_RD_SH 8
#define B_BE_USB_SIE_INTF_RD_MSK 0xff
#define B_BE_USB_SIE_INTF_WD_SH 0
#define B_BE_USB_SIE_INTF_WD_MSK 0xff

#define R_BE_PCIE_MIO_INTF 0x00E4
#define B_BE_PCIE_MIO_ADDR_PAGE_V1_SH 16
#define B_BE_PCIE_MIO_ADDR_PAGE_V1_MSK 0x1f
#define B_BE_PCIE_MIO_BYIOREG BIT(13)
#define B_BE_PCIE_MIO_RE BIT(12)
#define B_BE_PCIE_MIO_WE_SH 8
#define B_BE_PCIE_MIO_WE_MSK 0xf
#define B_BE_PCIE_MIO_ADDR_SH 0
#define B_BE_PCIE_MIO_ADDR_MSK 0xff

#define R_BE_PCIE_MIO_INTD 0x00E8
#define B_BE_PCIE_MIO_DATA_SH 0
#define B_BE_PCIE_MIO_DATA_MSK 0xffffffffL

#define R_BE_SYS_CFG1 0x00F0
#define B_BE_TRP_ICFG_SH 28
#define B_BE_TRP_ICFG_MSK 0xf
#define B_BE_RF_TYPE_ID BIT(27)
#define B_BE_BD_PKG_SEL BIT(25)
#define B_BE_RTL_ID BIT(23)
#define B_BE_PAD_HWPD_IDN BIT(22)
#define B_BE_TESTMODE BIT(20)
#define B_BE_VENDOR_ID_SH 16
#define B_BE_VENDOR_ID_MSK 0xf
#define B_BE_CHIP_VER_SH 12
#define B_BE_CHIP_VER_MSK 0xf
#define B_BE_BD_MAC3 BIT(11)
#define B_BE_BD_MAC1 BIT(10)
#define B_BE_BD_MAC2 BIT(9)
#define B_BE_SIC_IDLE BIT(8)
#define B_BE_ANA_SPS_OCP_SHUTDN BIT(7)
#define B_BE_DIG_SPS_OCP_SHUTDN BIT(6)
#define B_BE_V15_VLD BIT(5)
#define B_BE_PCIRSTB BIT(4)
#define B_BE_PCLK_VLD BIT(3)
#define B_BE_UCLK_VLD BIT(2)
#define B_BE_ACLK_VLD BIT(1)
#define B_BE_XCLK_VLD BIT(0)

#define R_BE_SYS_STATUS1 0x00F4
#define B_BE_RF_RL_ID_SH 28
#define B_BE_RF_RL_ID_MSK 0xf
#define B_BE_BT_LPS_EN BIT(27)
#define B_BE_WLAN_LPS_EN BIT(26)
#define B_BE_HPHY_ICFG BIT(19)
#define B_BE_SEL_0XC0_SH 16
#define B_BE_SEL_0XC0_MSK 0x3
#define B_BE_HCI_SEL_V4_SH 13
#define B_BE_HCI_SEL_V4_MSK 0x7
#define B_BE_USB_OPERATION_MODE BIT(12)
#define B_BE_BT_PDN BIT(11)
#define B_BE_AUTO_WLPON BIT(10)
#define B_BE_WL_MODE_SH 8
#define B_BE_WL_MODE_MSK 0x3
#define B_BE_PKG_SEL_HCI BIT(6)
#define B_BE_PAD_HCI_SEL_V2_SH 3
#define B_BE_PAD_HCI_SEL_V2_MSK 0x7
#define B_BE_EFS_HCI_SEL_V1_SH 0
#define B_BE_EFS_HCI_SEL_V1_MSK 0x7

#define R_BE_SYS_STATUS2 0x00F8
#define B_BE_SIC_ON_TIMEOUT BIT(22)
#define B_BE_CPU_ON_TIMEOUT BIT(21)
#define B_BE_HCI_ON_TIMEOUT BIT(20)
#define B_BE_SIO_ALDN BIT(19)
#define B_BE_USB_ALDN BIT(18)
#define B_BE_PCI_ALDN BIT(17)
#define B_BE_SYS_ALDN BIT(16)
#define B_BE_EPVID1_SH 8
#define B_BE_EPVID1_MSK 0xff
#define B_BE_EPVID0_SH 0
#define B_BE_EPVID0_MSK 0xff

#define R_BE_SYS_CHIPINFO 0x00FC
#define B_BE_USB2_SEL BIT(31)
#define B_BE_U3PHY_RST_V1 BIT(30)
#define B_BE_U3_TERM_DETECT BIT(29)
#define B_BE_HW_ID_SH 0
#define B_BE_HW_ID_MSK 0xff

#define R_BE_USER_DEFINED_0 0x0100
#define B_BE_USER_DEFINED_0_SH 0
#define B_BE_USER_DEFINED_0_MSK 0xffffffffL

#define R_BE_USER_DEFINED_1 0x0104
#define B_BE_USER_DEFINED_1_SH 0
#define B_BE_USER_DEFINED_1_MSK 0xffffffffL

#define R_BE_USER_DEFINED_2 0x0108
#define B_BE_USER_DEFINED_2_SH 0
#define B_BE_USER_DEFINED_2_MSK 0xffffffffL

#define R_BE_USER_DEFINED_3 0x010C
#define B_BE_USER_DEFINED_3_SH 0
#define B_BE_USER_DEFINED_3_MSK 0xffffffffL

#define R_BE_GPIO16_27_EXT_INTM 0x0148
#define B_BE_GPIO27_INT_MD BIT(11)
#define B_BE_GPIO26_INT_MD BIT(10)
#define B_BE_GPIO25_INT_MD BIT(9)
#define B_BE_GPIO24_INT_MD BIT(8)
#define B_BE_GPIO23_INT_MD BIT(7)
#define B_BE_GPIO22_INT_MD BIT(6)
#define B_BE_GPIO21_INT_MD BIT(5)
#define B_BE_GPIO20_INT_MD BIT(4)
#define B_BE_GPIO19_INT_MD BIT(3)
#define B_BE_GPIO18_INT_MD BIT(2)
#define B_BE_GPIO17_INT_MD BIT(1)
#define B_BE_GPIO16_INT_MD BIT(0)

#define R_BE_GPIO_16_TO_23_EXT_CTRL 0x0150
#define B_BE_GPIO_MOD_23_TO_16_SH 24
#define B_BE_GPIO_MOD_23_TO_16_MSK 0xff
#define B_BE_GPIO_IO_SEL_23_TO_16_SH 16
#define B_BE_GPIO_IO_SEL_23_TO_16_MSK 0xff
#define B_BE_GPIO_OUT_23_TO_16_SH 8
#define B_BE_GPIO_OUT_23_TO_16_MSK 0xff
#define B_BE_GPIO_IN_23_TO_16_SH 0
#define B_BE_GPIO_IN_23_TO_16_MSK 0xff

#define R_BE_GPIO_24_TO_27_EXT_CTRL 0x0154
#define B_BE_GPIO_MOD_27_TO_24_SH 24
#define B_BE_GPIO_MOD_27_TO_24_MSK 0xf
#define B_BE_GPIO_IO_SEL_27_TO_24_SH 16
#define B_BE_GPIO_IO_SEL_27_TO_24_MSK 0xf
#define B_BE_GPIO_OUT_27_TO_24_SH 8
#define B_BE_GPIO_OUT_27_TO_24_MSK 0xf
#define B_BE_GPIO_IN_27_TO_24_SH 0
#define B_BE_GPIO_IN_27_TO_24_MSK 0xf

#define R_BE_HALT_H2C_CTRL 0x0160
#define B_BE_HALT_H2C_TRIGGER BIT(0)

#define R_BE_HALT_C2H_CTRL 0x0164
#define B_BE_HALT_C2H_TRIGGER BIT(0)

#define R_BE_HALT_H2C 0x0168
#define B_BE_HALT_H2C_SH 0
#define B_BE_HALT_H2C_MSK 0xffffffffL

#define R_BE_HALT_C2H 0x016C
#define B_BE_HALT_C2H_ERROR_SENARIO_SH 28
#define B_BE_HALT_C2H_ERROR_SENARIO_MSK 0xf
#define B_BE_ERROR_CODE_SH 0
#define B_BE_ERROR_CODE_MSK 0xffff

#define R_BE_SYS_CFG5 0x0170
#define B_BE_WDT_DATACPU_WAKE_PCIE_EN BIT(12)
#define B_BE_WDT_DATACPU_WAKE_USB_EN BIT(11)
#define B_BE_WDT_WAKE_PCIE_EN BIT(10)
#define B_BE_WDT_WAKE_USB_EN BIT(9)
#define B_BE_SYM_DIS_HC_ACCESS_MAC BIT(8)
#define B_BE_LPS_STATUS BIT(3)
#define B_BE_HCI_TXDMA_BUSY BIT(2)
#define B_BE_HCI_TXDMA_ALLOW BIT(1)
#define B_BE_FW_CTRL_HCI_TXDMA_EN BIT(0)

#define R_BE_FW_DEBUG_USE_ONLY_0 0x0180
#define B_BE_FW_DEBUG_USE_ONLY_0_SH 0
#define B_BE_FW_DEBUG_USE_ONLY_0_MSK 0xffffffffL

#define R_BE_FW_DEBUG_USE_ONLY_1 0x0184
#define B_BE_FW_DEBUG_USE_ONLY_1_SH 0
#define B_BE_FW_DEBUG_USE_ONLY_1_MSK 0xffffffffL

#define R_BE_FW_DEBUG_USE_ONLY_2 0x0188
#define B_BE_FW_DEBUG_USE_ONLY_2_SH 0
#define B_BE_FW_DEBUG_USE_ONLY_2_MSK 0xffffffffL

#define R_BE_FW_DEBUG_USE_ONLY_3 0x018C
#define B_BE_FW_DEBUG_USE_ONLY_3_SH 0
#define B_BE_FW_DEBUG_USE_ONLY_3_MSK 0xffffffffL

#define R_BE_FWS0IMR 0x0190
#define B_BE_FS_HALT_H2C_INT_EN BIT(31)
#define B_BE_FS_FSM_HIOE_TO_EVENT_INT_EN BIT(30)
#define B_BE_FS_HCI_SUS_INT_EN BIT(29)
#define B_BE_FS_HCI_RES_INT_EN BIT(28)
#define B_BE_FS_HCI_RESET_INT_EN BIT(27)
#define B_BE_FS_USB_SCSI_CMD_INT_EN BIT(26)
#define B_BE_FS_ACT2RECOVERY_INT_EN BIT(25)
#define B_BE_FS_GEN1GEN2_SWITCH_INT_EN BIT(24)
#define B_BE_FS_USB_LPMRSM_INT_EN BIT(22)
#define B_BE_FS_USB_LPMINT_INT_EN BIT(21)
#define B_BE_FS_PWMERR_INT_EN BIT(20)
#define B_BE_FS_PDNINT_EN BIT(19)
#define B_BE_FS_SPSA_OCP_INT_EN BIT(18)
#define B_BE_FS_SPSD_OCP_INT_EN BIT(17)
#define B_BE_FS_BT_SB_INT_EN BIT(16)
#define B_BE_FS_GPIOF_INT_EN BIT(15)
#define B_BE_FS_GPIOE_INT_EN BIT(14)
#define B_BE_FS_GPIOD_INT_EN BIT(13)
#define B_BE_FS_GPIOC_INT_EN BIT(12)
#define B_BE_FS_GPIOB_INT_EN BIT(11)
#define B_BE_FS_GPIOA_INT_EN BIT(10)
#define B_BE_FS_GPIO9_INT_EN BIT(9)
#define B_BE_FS_GPIO8_INT_EN BIT(8)
#define B_BE_FS_GPIO7_INT_EN BIT(7)
#define B_BE_FS_GPIO6_INT_EN BIT(6)
#define B_BE_FS_GPIO5_INT_EN BIT(5)
#define B_BE_FS_GPIO4_INT_EN BIT(4)
#define B_BE_FS_GPIO3_INT_EN BIT(3)
#define B_BE_FS_GPIO2_INT_EN BIT(2)
#define B_BE_FS_GPIO1_INT_EN BIT(1)
#define B_BE_FS_GPIO0_INT_EN BIT(0)

#define R_BE_FWS0ISR 0x0194
#define B_BE_FS_HALT_H2C_INT BIT(31)
#define B_BE_FS_FSM_HIOE_TO_EVENT_INT BIT(30)
#define B_BE_FS_HCI_SUS_INT BIT(29)
#define B_BE_FS_HCI_RES_INT BIT(28)
#define B_BE_FS_HCI_RESET_INT BIT(27)
#define B_BE_FS_USB_SCSI_CMD_INT BIT(26)
#define B_BE_FS_ACT2RECOVERY_INT BIT(25)
#define B_BE_FS_GEN1GEN2_SWITCH_INT BIT(24)
#define B_BE_FS_USB_LPMRSM_INT BIT(22)
#define B_BE_FS_USB_LPMINT_INT BIT(21)
#define B_BE_FS_PWMERR_INT BIT(20)
#define B_BE_FS_PDNINT BIT(19)
#define B_BE_FS_SPSA_OCP_INT BIT(18)
#define B_BE_FS_SPSD_OCP_INT BIT(17)
#define B_BE_FS_BT_SB_INT BIT(16)
#define B_BE_FS_GPIOF_INT BIT(15)
#define B_BE_FS_GPIOE_INT BIT(14)
#define B_BE_FS_GPIOD_INT BIT(13)
#define B_BE_FS_GPIOC_INT BIT(12)
#define B_BE_FS_GPIOB_INT BIT(11)
#define B_BE_FS_GPIOA_INT BIT(10)
#define B_BE_FS_GPIO9_INT BIT(9)
#define B_BE_FS_GPIO8_INT BIT(8)
#define B_BE_FS_GPIO7_INT BIT(7)
#define B_BE_FS_GPIO6_INT BIT(6)
#define B_BE_FS_GPIO5_INT BIT(5)
#define B_BE_FS_GPIO4_INT BIT(4)
#define B_BE_FS_GPIO3_INT BIT(3)
#define B_BE_FS_GPIO2_INT BIT(2)
#define B_BE_FS_GPIO1_INT BIT(1)
#define B_BE_FS_GPIO0_INT BIT(0)

#define R_BE_FWS1IMR 0x0198
#define B_BE_AON_PCIE_FLR_INT_EN BIT(19)
#define B_BE_PCIE_ERR_INDIC_INT_EN BIT(18)
#define B_BE_SDIO_ERR_INDIC_INT_EN BIT(17)
#define B_BE_USB_ERR_INDIC_INT_EN BIT(16)
#define B_BE_FS_GPIO27_INT_EN BIT(11)
#define B_BE_FS_GPIO26_INT_EN BIT(10)
#define B_BE_FS_GPIO25_INT_EN BIT(9)
#define B_BE_FS_GPIO24_INT_EN BIT(8)
#define B_BE_FS_GPIO23_INT_EN BIT(7)
#define B_BE_FS_GPIO22_INT_EN BIT(6)
#define B_BE_FS_GPIO21_INT_EN BIT(5)
#define B_BE_FS_GPIO20_INT_EN BIT(4)
#define B_BE_FS_GPIO19_INT_EN BIT(3)
#define B_BE_FS_GPIO18_INT_EN BIT(2)
#define B_BE_FS_GPIO17_INT_EN BIT(1)
#define B_BE_FS_GPIO16_INT_EN BIT(0)

#define R_BE_FWS1ISR 0x019C
#define B_BE_AON_PCIE_FLR_INT BIT(19)
#define B_BE_PCIE_ERR_INDIC BIT(18)
#define B_BE_SDIO_ERR_INDIC BIT(17)
#define B_BE_USB_ERR_INDIC BIT(16)
#define B_BE_FS_GPIO27_INT BIT(11)
#define B_BE_FS_GPIO26_INT BIT(10)
#define B_BE_FS_GPIO25_INT BIT(9)
#define B_BE_FS_GPIO24_INT BIT(8)
#define B_BE_FS_GPIO23_INT BIT(7)
#define B_BE_FS_GPIO22_INT BIT(6)
#define B_BE_FS_GPIO21_INT BIT(5)
#define B_BE_FS_GPIO20_INT BIT(4)
#define B_BE_FS_GPIO19_INT BIT(3)
#define B_BE_FS_GPIO18_INT BIT(2)
#define B_BE_FS_GPIO17_INT BIT(1)
#define B_BE_FS_GPIO16_INT BIT(0)

#define R_BE_HIMR0 0x01A0
#define B_BE_WDT_DATACPU_TIMEOUT_INT_EN BIT(25)
#define B_BE_HALT_D2H_INT_EN BIT(24)
#define B_BE_WDT_TIMEOUT_INT_EN BIT(22)
#define B_BE_HALT_C2H_INT_EN BIT(21)
#define B_BE_RON_INT_EN BIT(20)
#define B_BE_PDNINT_EN BIT(19)
#define B_BE_SPSANA_OCP_INT_EN BIT(18)
#define B_BE_SPS_OCP_INT_EN BIT(17)
#define B_BE_BTON_STS_UPDATE_INT_EN BIT(16)
#define B_BE_GPIOF_INT_EN BIT(15)
#define B_BE_GPIOE_INT_EN BIT(14)
#define B_BE_GPIOD_INT_EN BIT(13)
#define B_BE_GPIOC_INT_EN BIT(12)
#define B_BE_GPIOB_INT_EN BIT(11)
#define B_BE_GPIOA_INT_EN BIT(10)
#define B_BE_GPIO9_INT_EN BIT(9)
#define B_BE_GPIO8_INT_EN BIT(8)
#define B_BE_GPIO7_INT_EN BIT(7)
#define B_BE_GPIO6_INT_EN BIT(6)
#define B_BE_GPIO5_INT_EN BIT(5)
#define B_BE_GPIO4_INT_EN BIT(4)
#define B_BE_GPIO3_INT_EN BIT(3)
#define B_BE_GPIO2_INT_EN BIT(2)
#define B_BE_GPIO1_INT_EN BIT(1)
#define B_BE_GPIO0_INT_EN BIT(0)

#define R_BE_HISR0 0x01A4
#define B_BE_WDT_DATACPU_TIMEOUT_INT BIT(25)
#define B_BE_HALT_D2H_INT BIT(24)
#define B_BE_WDT_TIMEOUT_INT BIT(22)
#define B_BE_HALT_C2H_INT BIT(21)
#define B_BE_RON_INT BIT(20)
#define B_BE_PDNINT BIT(19)
#define B_BE_SPSANA_OCP_INT BIT(18)
#define B_BE_SPS_OCP_INT BIT(17)
#define B_BE_BTON_STS_UPDATE_INT BIT(16)
#define B_BE_GPIOF_INT BIT(15)
#define B_BE_GPIOE_INT BIT(14)
#define B_BE_GPIOD_INT BIT(13)
#define B_BE_GPIOC_INT BIT(12)
#define B_BE_GPIOB_INT BIT(11)
#define B_BE_GPIOA_INT BIT(10)
#define B_BE_GPIO9_INT BIT(9)
#define B_BE_GPIO8_INT BIT(8)
#define B_BE_GPIO7_INT BIT(7)
#define B_BE_GPIO6_INT BIT(6)
#define B_BE_GPIO5_INT BIT(5)
#define B_BE_GPIO4_INT BIT(4)
#define B_BE_GPIO3_INT BIT(3)
#define B_BE_GPIO2_INT BIT(2)
#define B_BE_GPIO1_INT BIT(1)
#define B_BE_GPIO0_INT BIT(0)

#define R_BE_HIMR1 0x01A8
#define B_BE_GPIO27_INT_EN BIT(11)
#define B_BE_GPIO26_INT_EN BIT(10)
#define B_BE_GPIO25_INT_EN BIT(9)
#define B_BE_GPIO24_INT_EN BIT(8)
#define B_BE_GPIO23_INT_EN BIT(7)
#define B_BE_GPIO22_INT_EN BIT(6)
#define B_BE_GPIO21_INT_EN BIT(5)
#define B_BE_GPIO20_INT_EN BIT(4)
#define B_BE_GPIO19_INT_EN BIT(3)
#define B_BE_GPIO18_INT_EN BIT(2)
#define B_BE_GPIO17_INT_EN BIT(1)
#define B_BE_GPIO16_INT_EN BIT(0)

#define R_BE_HISR1 0x01AC
#define B_BE_GPIO27_INT BIT(11)
#define B_BE_GPIO26_INT BIT(10)
#define B_BE_GPIO25_INT BIT(9)
#define B_BE_GPIO24_INT BIT(8)
#define B_BE_GPIO23_INT BIT(7)
#define B_BE_GPIO22_INT BIT(6)
#define B_BE_GPIO21_INT BIT(5)
#define B_BE_GPIO20_INT BIT(4)
#define B_BE_GPIO19_INT BIT(3)
#define B_BE_GPIO18_INT BIT(2)
#define B_BE_GPIO17_INT BIT(1)
#define B_BE_GPIO16_INT BIT(0)

#define R_BE_DRV_FW_HSK_0 0x01B0
#define B_BE_DRV_FW_HSK_0_SH 0
#define B_BE_DRV_FW_HSK_0_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_1 0x01B4
#define B_BE_DRV_FW_HSK_1_SH 0
#define B_BE_DRV_FW_HSK_1_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_2 0x01B8
#define B_BE_DRV_FW_HSK_2_SH 0
#define B_BE_DRV_FW_HSK_2_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_3 0x01BC
#define B_BE_DRV_FW_HSK_3_SH 0
#define B_BE_DRV_FW_HSK_3_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_4 0x01C0
#define B_BE_DRV_FW_HSK_4_SH 0
#define B_BE_DRV_FW_HSK_4_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_5 0x01C4
#define B_BE_DRV_FW_HSK_5_SH 0
#define B_BE_DRV_FW_HSK_5_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_6 0x01C8
#define B_BE_DRV_FW_HSK_6_SH 0
#define B_BE_DRV_FW_HSK_6_MSK 0xffffffffL

#define R_BE_DRV_FW_HSK_7 0x01CC
#define B_BE_DRV_FW_HSK_7_SH 0
#define B_BE_DRV_FW_HSK_7_MSK 0xffffffffL

#define R_BE_IO_HANG_CTRL  0x01D0
#define B_BE_AHB_AUTO_FIX_HANG_EN BIT(23)
#define B_BE_AHB_AUTO_FIX_HANG_THD_SH 16
#define B_BE_AHB_AUTO_FIX_HANG_THD_MSK 0x7f
#define B_BE_APB_AUTO_FIX_HANG_EN BIT(15)
#define B_BE_APB_AUTO_FIX_HANG_THD_SH 0
#define B_BE_APB_AUTO_FIX_HANG_THD_MSK 0x7fff

#define R_BE_WCPU_FW_CTRL 0x01E0
#define B_BE_WCPU_ROM_CUT_REQ BIT(30)
#define B_BE_FW_ENV_SH 28
#define B_BE_FW_ENV_MSK 0x3
#define B_BE_WCPU_ROM_CUT_SH 8
#define B_BE_WCPU_ROM_CUT_MSK 0xff
#define B_BE_WCPU_FWDL_STS_SH 5
#define B_BE_WCPU_FWDL_STS_MSK 0x7
#define B_BE_FW_RAM_RUN_IND BIT(4)
#define B_BE_FWDL_PATH_RDY BIT(2)
#define B_BE_H2C_PATH_RDY BIT(1)
#define B_BE_WCPU_FWDL_EN BIT(0)

#define R_BE_BOOT_REASON 0x01E6
#define B_BE_BOOT_REASON_SH 0
#define B_BE_BOOT_REASON_MSK 0x7

#define R_BE_RPWM 0x01E4
#define B_BE_RPWM_TOGGLE BIT(15)
#define B_BE_RPWM_VAL_SH 0
#define B_BE_RPWM_VAL_MSK 0x7fff

#define R_BE_LDM 0x01E8
#define B_BE_EN_32K BIT(31)
#define B_BE_LDM_SH 0
#define B_BE_LDM_MSK 0x7fffffffL

#define R_BE_UDM0 0x01F0
#define B_BE_UDM0_SEND2RA_CNT_SH 28
#define B_BE_UDM0_SEND2RA_CNT_MSK 0xf
#define B_BE_UDM0_TX_RPT_CNT_SH 24
#define B_BE_UDM0_TX_RPT_CNT_MSK 0xf
#define B_BE_UDM0_FS_CODE_SH 8
#define B_BE_UDM0_FS_CODE_MSK 0xffff
#define B_BE_NULL_POINTER_INDC BIT(7)
#define B_BE_ROM_ASSERT_INDC BIT(6)
#define B_BE_RAM_ASSERT_INDC BIT(5)
#define B_BE_FW_IMAGE_TYPE BIT(4)
#define B_BE_UDM0_TRAP_LOOP_CTRL BIT(2)
#define B_BE_UDM0_SEND_HALTC2H_CTRL BIT(1)
#define B_BE_UDM0_DBG_MODE_CTRL BIT(0)

#define R_BE_UDM1 0x01F4
#define B_BE_UDM1_ERROR_ADDR_SH 0
#define B_BE_UDM1_ERROR_ADDR_MSK 0xffffffffL

#define R_BE_UDM2 0x01F8
#define B_BE_UDM2_EPC_RA_SH 0
#define B_BE_UDM2_EPC_RA_MSK 0xffffffffL

#define R_BE_UDM3 0x01FC
#define B_BE_UDM3_SH 0
#define B_BE_UDM3_MSK 0xffffffffL

#define R_BE_WLAN_XTAL_SI_CTRL 0x0270
#define B_BE_WL_XTAL_SI_CMD_POLL BIT(31)
#define B_BE_WL_XTAL_SI_CHIPID_SH 26
#define B_BE_WL_XTAL_SI_CHIPID_MSK 0x7
#define B_BE_WL_XTAL_SI_MODE_SH 24
#define B_BE_WL_XTAL_SI_MODE_MSK 0x3
#define B_BE_WL_XTAL_SI_BITMASK_SH 16
#define B_BE_WL_XTAL_SI_BITMASK_MSK 0xff
#define B_BE_WL_XTAL_SI_DATA_SH 8
#define B_BE_WL_XTAL_SI_DATA_MSK 0xff
#define B_BE_WL_XTAL_SI_ADDR_SH 0
#define B_BE_WL_XTAL_SI_ADDR_MSK 0xff

#define R_BE_WLAN_XTAL_SI_CONFIG 0x0274
#define B_BE_XTAL_SI_RST BIT(31)
#define B_BE_BT_XTAL_SI_ERR_FLAG BIT(10)
#define B_BE_WL_XTAL_GNT BIT(9)
#define B_BE_BT_XTAL_GNT BIT(8)
#define B_BE_XTAL_SI_CLK_DIV2 BIT(1)
#define B_BE_XTAL_SI_ADDR_NOT_CHK BIT(0)

#define R_BE_GPIO0_7_FUNC_SEL 0x02D0
#define B_BE_PINMUX_GPIO7_FUNC_SEL_SH 28
#define B_BE_PINMUX_GPIO7_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO6_FUNC_SEL_SH 24
#define B_BE_PINMUX_GPIO6_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO5_FUNC_SEL_SH 20
#define B_BE_PINMUX_GPIO5_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO4_FUNC_SEL_SH 16
#define B_BE_PINMUX_GPIO4_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO3_FUNC_SEL_SH 12
#define B_BE_PINMUX_GPIO3_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO2_FUNC_SEL_SH 8
#define B_BE_PINMUX_GPIO2_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO1_FUNC_SEL_SH 4
#define B_BE_PINMUX_GPIO1_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO0_FUNC_SEL_SH 0
#define B_BE_PINMUX_GPIO0_FUNC_SEL_MSK 0xf

#define R_BE_GPIO8_15_FUNC_SEL 0x02D4
#define B_BE_PINMUX_GPIO15_FUNC_SEL_SH 28
#define B_BE_PINMUX_GPIO15_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO14_FUNC_SEL_SH 24
#define B_BE_PINMUX_GPIO14_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO13_FUNC_SEL_SH 20
#define B_BE_PINMUX_GPIO13_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO12_FUNC_SEL_SH 16
#define B_BE_PINMUX_GPIO12_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO11_FUNC_SEL_SH 12
#define B_BE_PINMUX_GPIO11_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO10_FUNC_SEL_SH 8
#define B_BE_PINMUX_GPIO10_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO9_FUNC_SEL_SH 4
#define B_BE_PINMUX_GPIO9_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO8_FUNC_SEL_SH 0
#define B_BE_PINMUX_GPIO8_FUNC_SEL_MSK 0xf

#define R_BE_GPIO16_23_FUNC_SEL 0x02D8
#define B_BE_PINMUX_GPIO23_FUNC_SEL_SH 28
#define B_BE_PINMUX_GPIO23_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO22_FUNC_SEL_SH 24
#define B_BE_PINMUX_GPIO22_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO21_FUNC_SEL_SH 20
#define B_BE_PINMUX_GPIO21_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO20_FUNC_SEL_SH 16
#define B_BE_PINMUX_GPIO20_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO19_FUNC_SEL_SH 12
#define B_BE_PINMUX_GPIO19_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO18_FUNC_SEL_SH 8
#define B_BE_PINMUX_GPIO18_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO17_FUNC_SEL_SH 4
#define B_BE_PINMUX_GPIO17_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO16_FUNC_SEL_SH 0
#define B_BE_PINMUX_GPIO16_FUNC_SEL_MSK 0xf

#define R_BE_GPIO24_27_FUNC_SEL 0x02DC
#define B_BE_PINMUX_GPIO27_FUNC_SEL_SH 12
#define B_BE_PINMUX_GPIO27_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO26_FUNC_SEL_SH 8
#define B_BE_PINMUX_GPIO26_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO25_FUNC_SEL_SH 4
#define B_BE_PINMUX_GPIO25_FUNC_SEL_MSK 0xf
#define B_BE_PINMUX_GPIO24_FUNC_SEL_SH 0
#define B_BE_PINMUX_GPIO24_FUNC_SEL_MSK 0xf

#define R_BE_GPIO0_27_PULL_HIGH_EN 0x02E0
#define B_BE_GPIO27_PULL_HIGH_EN BIT(27)
#define B_BE_GPIO26_PULL_HIGH_EN BIT(26)
#define B_BE_GPIO25_PULL_HIGH_EN BIT(25)
#define B_BE_GPIO24_PULL_HIGH_EN BIT(24)
#define B_BE_GPIO23_PULL_HIGH_EN BIT(23)
#define B_BE_GPIO22_PULL_HIGH_EN BIT(22)
#define B_BE_GPIO21_PULL_HIGH_EN BIT(21)
#define B_BE_GPIO20_PULL_HIGH_EN BIT(20)
#define B_BE_GPIO19_PULL_HIGH_EN BIT(19)
#define B_BE_GPIO18_PULL_HIGH_EN BIT(18)
#define B_BE_GPIO17_PULL_HIGH_EN BIT(17)
#define B_BE_GPIO16_PULL_HIGH_EN BIT(16)
#define B_BE_GPIO15_PULL_HIGH_EN BIT(15)
#define B_BE_GPIO14_PULL_HIGH_EN BIT(14)
#define B_BE_GPIO13_PULL_HIGH_EN BIT(13)
#define B_BE_GPIO12_PULL_HIGH_EN BIT(12)
#define B_BE_GPIO11_PULL_HIGH_EN BIT(11)
#define B_BE_GPIO10_PULL_HIGH_EN BIT(10)
#define B_BE_GPIO9_PULL_HIGH_EN BIT(9)
#define B_BE_GPIO8_PULL_HIGH_EN BIT(8)
#define B_BE_GPIO7_PULL_HIGH_EN BIT(7)
#define B_BE_GPIO6_PULL_HIGH_EN BIT(6)
#define B_BE_GPIO5_PULL_HIGH_EN BIT(5)
#define B_BE_GPIO4_PULL_HIGH_EN BIT(4)
#define B_BE_GPIO3_PULL_HIGH_EN BIT(3)
#define B_BE_GPIO2_PULL_HIGH_EN BIT(2)
#define B_BE_GPIO1_PULL_HIGH_EN BIT(1)
#define B_BE_GPIO0_PULL_HIGH_EN BIT(0)

#define R_BE_GPIO0_27_PULL_LOW_EN 0x02E4
#define B_BE_GPIO27_PULL_LOW_EN BIT(27)
#define B_BE_GPIO26_PULL_LOW_EN BIT(26)
#define B_BE_GPIO25_PULL_LOW_EN BIT(25)
#define B_BE_GPIO24_PULL_LOW_EN BIT(24)
#define B_BE_GPIO23_PULL_LOW_EN BIT(23)
#define B_BE_GPIO22_PULL_LOW_EN BIT(22)
#define B_BE_GPIO21_PULL_LOW_EN BIT(21)
#define B_BE_GPIO20_PULL_LOW_EN BIT(20)
#define B_BE_GPIO19_PULL_LOW_EN BIT(19)
#define B_BE_GPIO18_PULL_LOW_EN BIT(18)
#define B_BE_GPIO17_PULL_LOW_EN BIT(17)
#define B_BE_GPIO16_PULL_LOW_EN BIT(16)
#define B_BE_GPIO15_PULL_LOW_EN BIT(15)
#define B_BE_GPIO14_PULL_LOW_EN BIT(14)
#define B_BE_GPIO13_PULL_LOW_EN BIT(13)
#define B_BE_GPIO12_PULL_LOW_EN BIT(12)
#define B_BE_GPIO11_PULL_LOW_EN BIT(11)
#define B_BE_GPIO10_PULL_LOW_EN BIT(10)
#define B_BE_GPIO9_PULL_LOW_EN BIT(9)
#define B_BE_GPIO8_PULL_LOW_EN BIT(8)
#define B_BE_GPIO7_PULL_LOW_EN BIT(7)
#define B_BE_GPIO6_PULL_LOW_EN BIT(6)
#define B_BE_GPIO5_PULL_LOW_EN BIT(5)
#define B_BE_GPIO4_PULL_LOW_EN BIT(4)
#define B_BE_GPIO3_PULL_LOW_EN BIT(3)
#define B_BE_GPIO2_PULL_LOW_EN BIT(2)
#define B_BE_GPIO1_PULL_LOW_EN BIT(1)
#define B_BE_GPIO0_PULL_LOW_EN BIT(0)

#define R_BE_GPIO0_27_E2_EN 0x02E8
#define B_BE_SYSON_GPIO27_PAD_E2 BIT(27)
#define B_BE_SYSON_GPIO26_PAD_E2 BIT(26)
#define B_BE_SYSON_GPIO25_PAD_E2 BIT(25)
#define B_BE_SYSON_GPIO24_PAD_E2 BIT(24)
#define B_BE_SYSON_GPIO23_PAD_E2 BIT(23)
#define B_BE_SYSON_GPIO22_PAD_E2 BIT(22)
#define B_BE_SYSON_GPIO21_PAD_E2 BIT(21)
#define B_BE_SYSON_GPIO20_PAD_E2 BIT(20)
#define B_BE_SYSON_GPIO19_PAD_E2 BIT(19)
#define B_BE_SYSON_GPIO18_PAD_E2 BIT(18)
#define B_BE_SYSON_GPIO17_PAD_E2 BIT(17)
#define B_BE_SYSON_GPIO16_PAD_E2 BIT(16)
#define B_BE_SYSON_GPIO15_PAD_E2 BIT(15)
#define B_BE_SYSON_GPIO14_PAD_E2 BIT(14)
#define B_BE_SYSON_GPIO13_PAD_E2 BIT(13)
#define B_BE_SYSON_GPIO12_PAD_E2 BIT(12)
#define B_BE_SYSON_GPIO11_PAD_E2 BIT(11)
#define B_BE_SYSON_GPIO10_PAD_E2 BIT(10)
#define B_BE_SYSON_GPIO9_PAD_E2 BIT(9)
#define B_BE_SYSON_GPIO8_PAD_E2 BIT(8)
#define B_BE_SYSON_GPIO7_PAD_E2 BIT(7)
#define B_BE_SYSON_GPIO6_PAD_E2 BIT(6)
#define B_BE_SYSON_GPIO5_PAD_E2 BIT(5)
#define B_BE_SYSON_GPIO4_PAD_E2 BIT(4)
#define B_BE_SYSON_GPIO3_PAD_E2 BIT(3)
#define B_BE_SYSON_GPIO2_PAD_E2 BIT(2)
#define B_BE_SYSON_GPIO1_PAD_E2 BIT(1)
#define B_BE_SYSON_GPIO0_PAD_E2 BIT(0)

#define R_BE_GPIO0_27_SMT_EN 0x02EC
#define B_BE_GPIO27_PAD_SMT_CTRL BIT(27)
#define B_BE_GPIO26_PAD_SMT_CTRL BIT(26)
#define B_BE_GPIO25_PAD_SMT_CTRL BIT(25)
#define B_BE_GPIO24_PAD_SMT_CTRL BIT(24)
#define B_BE_GPIO23_PAD_SMT_CTRL BIT(23)
#define B_BE_GPIO22_PAD_SMT_CTRL BIT(22)
#define B_BE_GPIO21_PAD_SMT_CTRL BIT(21)
#define B_BE_GPIO20_PAD_SMT_CTRL BIT(20)
#define B_BE_GPIO19_PAD_SMT_CTRL BIT(19)
#define B_BE_GPIO18_PAD_SMT_CTRL BIT(18)
#define B_BE_GPIO17_PAD_SMT_CTRL BIT(17)
#define B_BE_GPIO16_PAD_SMT_CTRL BIT(16)
#define B_BE_GPIO15_PAD_SMT_CTRL BIT(15)
#define B_BE_GPIO14_PAD_SMT_CTRL BIT(14)
#define B_BE_GPIO13_PAD_SMT_CTRL BIT(13)
#define B_BE_GPIO12_PAD_SMT_CTRL BIT(12)
#define B_BE_GPIO11_PAD_SMT_CTRL BIT(11)
#define B_BE_GPIO10_PAD_SMT_CTRL BIT(10)
#define B_BE_GPIO9_PAD_SMT_CTRL BIT(9)
#define B_BE_GPIO8_PAD_SMT_CTRL BIT(8)
#define B_BE_GPIO7_PAD_SMT_CTRL BIT(7)
#define B_BE_GPIO6_PAD_SMT_CTRL BIT(6)
#define B_BE_GPIO5_PAD_SMT_CTRL BIT(5)
#define B_BE_GPIO4_PAD_SMT_CTRL BIT(4)
#define B_BE_GPIO3_PAD_SMT_CTRL BIT(3)
#define B_BE_GPIO2_PAD_SMT_CTRL BIT(2)
#define B_BE_GPIO1_PAD_SMT_CTRL BIT(1)
#define B_BE_GPIO0_PAD_SMT_CTRL BIT(0)

#define R_BE_WLRF_CTRL 0x02F0
#define B_BE_AFC_BUS BIT(23)
#define B_BE_AFC_REG_SETTING BIT(21)
#define B_BE_AFC_DBG BIT(20)
#define B_BE_AFC_AFEDIG BIT(17)
#define B_BE_WLRF1_CTRL_SH 8
#define B_BE_WLRF1_CTRL_MSK 0xff
#define B_BE_WLRF_CTRL_SH 0
#define B_BE_WLRF_CTRL_MSK 0xff

#define R_BE_SYM_OSC32K_CTRL 0x0390
#define B_BE_OSC32K_CAL_SEL BIT(11)
#define B_BE_SYM_OSC32K_SEL BIT(10)
#define B_BE_SYM_OSC32K_OUTSEL BIT(9)
#define B_BE_SYM_OSC32K_SELLDOVREF BIT(8)
#define B_BE_GATED_STUP_OK BIT(6)
#define B_BE_SYM_OSC32K_RCAL_SH 0
#define B_BE_SYM_OSC32K_RCAL_MSK 0x3f

#define R_BE_SEC_SIGNAL 0x0394
#define B_BE_SEC_BT_SEC1_DIS BIT(15)
#define B_BE_SEC_BT_SEC0_DIS BIT(14)
#define B_BE_BTGP_BTSPIEN_ALL BIT(6)
#define B_BE_BTGP_GJTAGEN_ALL BIT(5)
#define B_BE_WLGP_UART_RXEN_ALL BIT(4)
#define B_BE_WLGP_UART_TXEN_ALL BIT(3)
#define B_BE_WLGP_GJTAGEN_ALL BIT(2)
#define B_BE_SIC_EN_ALL BIT(1)
#define B_BE_SEC_SEC_DIS BIT(0)

#define R_BE_IC_PWR_STATE 0x03F0
#define B_BE_WHOLE_SYS_PWR_STE_SH 16
#define B_BE_WHOLE_SYS_PWR_STE_MSK 0x3ff
#define B_BE_WLMAC_PWR_STE_SH 8
#define B_BE_WLMAC_PWR_STE_MSK 0x3
#define B_BE_UART_HCISYS_PWR_STE_SH 6
#define B_BE_UART_HCISYS_PWR_STE_MSK 0x3
#define B_BE_SDIO_HCISYS_PWR_STE_SH 4
#define B_BE_SDIO_HCISYS_PWR_STE_MSK 0x3
#define B_BE_USB_HCISYS_PWR_STE_SH 2
#define B_BE_USB_HCISYS_PWR_STE_MSK 0x3
#define B_BE_PCIE_HCISYS_PWR_STE_SH 0
#define B_BE_PCIE_HCISYS_PWR_STE_MSK 0x3

#define R_BE_DBG_GNT_WL_BT_INFO 0x03F4
#define B_BE_DBG_WLAN_ACT_0_SEL BIT(5)
#define B_BE_DBG_GNT_BB_SEL BIT(4)
#define B_BE_DBG_GNT_WL_S1 BIT(3)
#define B_BE_DBG_GNT_BT_S1 BIT(2)
#define B_BE_DBG_GNT_WL_S0 BIT(1)
#define B_BE_DBG_GNT_BT_S0 BIT(0)

#define R_BE_WLCPU_PORT_PC_SET 0x03F8
#define B_BE_WLCPU_PORT_PC_SET BIT(0)

#define R_BE_WLCPU_PORT_PC 0x03FC
#define B_BE_WLCPU_PORT_PC_SH 0
#define B_BE_WLCPU_PORT_PC_MSK 0xffffffffL

#define R_BE_DCPU_PORT_PC_SET 0x0800
#define B_BE_DCPU_PORT_PC_SET BIT(0)

#define R_BE_DCPU_PORT_PC 0x0804
#define B_BE_DCPU_PORT_PC_SH 0
#define B_BE_DCPU_PORT_PC_MSK 0xffffffffL

#define R_BE_DCPU_SYS_CLK_CTRL 0x0808
#define B_BE_DCPU_IDMEM_CLK_EN BIT(15)
#define B_BE_DCPU_CLK_EN BIT(14)

#define R_BE_DCPU_SRAM_CTRL 0x0820
#define B_BE_R_SYM_DCPUPON_P3_PC_EN BIT(21)
#define B_BE_R_SYM_DCPUPON_P2_PC_EN BIT(20)
#define B_BE_R_SYM_DCPUPON_P1_PC_EN BIT(19)
#define B_BE_R_SYM_DCPUPON_PC_EN BIT(18)
#define B_BE_DCPU_PON_ISO_CTRL BIT(0)

#define R_BE_HALT_H2D_CTRL 0x0860
#define B_BE_HALT_H2D_TRIGGER BIT(0)

#define R_BE_HALT_D2H_CTRL 0x0864
#define B_BE_HALT_D2H_TRIGGER BIT(0)

#define R_BE_HALT_H2D 0x0868
#define B_BE_HALT_H2D_SH 0
#define B_BE_HALT_H2D_MSK 0xffffffffL

#define R_BE_HALT_D2H 0x086C
#define B_BE_HALT_D2H_ERROR_SENARIO_SH 28
#define B_BE_HALT_D2H_ERROR_SENARIO_MSK 0xf
#define B_BE_HALT_D2H_ERROR_CODE_SH 0
#define B_BE_HALT_D2H_ERROR_CODE_MSK 0xffff

#define R_BE_DCPU_PLATFORM_ENABLE 0x0888
#define B_BE_DCPU_SYM_DPLT_MEM_MUX_EN BIT(10)
#define B_BE_DCPU_WARM_EN BIT(9)
#define B_BE_DCPU_UART_EN BIT(7)
#define B_BE_DCPU_IDDMA_EN BIT(6)
#define B_BE_DCPU_AXIDMA_EN BIT(3)
#define B_BE_DCPU_APB_WRAP_EN BIT(2)
#define B_BE_DCPU_EN BIT(1)
#define B_BE_DCPU_PLATFORM_EN BIT(0)

#define R_BE_DCPU_FWS0IMR 0x0890
#define B_BE_FS_HALT_H2D_INT_EN BIT(31)

#define R_BE_DCPU_FWS0ISR 0x0894
#define B_BE_FS_HALT_H2D_INT BIT(31)

#define R_BE_DATA_CPU_APB_AUTO_FIX_HANG 0x08C0
#define B_BE_DATA_CPU_APB_AUTO_FIX_HANG_EN BIT(15)
#define B_BE_DATA_CPU_APB_AUTO_FIX_HANG_THD_SH 0
#define B_BE_DATA_CPU_APB_AUTO_FIX_HANG_THD_MSK 0x7fff

#define R_BE_DCPU_UDM0 0x08D0
#define B_BE_DCPU_FS_CODE_SH 8
#define B_BE_DCPU_FS_CODE_MSK 0xffff
#define B_BE_DCPU_NULL_POINTER_INDC BIT(7)
#define B_BE_DCPU_ASSERTCALLED_INDC BIT(6)
#define B_BE_DCPU_ASSERT_INDC BIT(5)
#define B_BE_DCPU_FW_IMAGE_TYPE BIT(4)
#define B_BE_DCPU_TRAP_LOOP_CTRL BIT(2)
#define B_BE_DCPU_SEND_HALTD2H_CTRL BIT(1)
#define B_BE_DCPU_DBG_MODE_CTRL BIT(0)

#define R_BE_DCPU_UDM1 0x08D4
#define B_BE_DCPU_ERROR_ADDR_SH 0
#define B_BE_DCPU_ERROR_ADDR_MSK 0xffffffffL

#define R_BE_DCPU_UDM2 0x08D8
#define B_BE_DCPU_EPC_RA_SH 0
#define B_BE_DCPU_EPC_RA_MSK 0xffffffffL

#define R_BE_DCPU_UDM3 0x08DC
#define B_BE_DCPU_UDM3_SH 0
#define B_BE_DCPU_UDM3_MSK 0xffffffffL

#define R_BE_DCPU_UDM4 0x08E0
#define B_BE_DCPU_UDM4_SH 0
#define B_BE_DCPU_UDM4_MSK 0xffffffffL

#define R_BE_DCPU_UDM5 0x08E4
#define B_BE_DCPU_UDM5_SH 0
#define B_BE_DCPU_UDM5_MSK 0xffffffffL

#define R_BE_DCPU_UDM6 0x08E8
#define B_BE_DCPU_UDM6_SH 0
#define B_BE_DCPU_UDM6_MSK 0xffffffffL

#define R_BE_DCPU_UDM7 0x08EC
#define B_BE_DCPU_UDM7_SH 0
#define B_BE_DCPU_UDM7_MSK 0xffffffffL

#define R_BE_DCPU_FW_CTRL 0x08F0
#define B_BE_DCPU_ROM_CUT_REQ BIT(30)
#define B_BE_DCPU_FW_ENV_SH 28
#define B_BE_DCPU_FW_ENV_MSK 0x3
#define B_BE_DCPU_ROM_CUT_SH 8
#define B_BE_DCPU_ROM_CUT_MSK 0xff
#define B_BE_DCPU_FWDL_STS_SH 5
#define B_BE_DCPU_FWDL_STS_MSK 0x7
#define B_BE_DCPU_FW_RAM_RUN_IND BIT(4)
#define B_BE_DCPU_FWDL_PATH_RDY BIT(2)
#define B_BE_DCPU_H2C_PATH_RDY BIT(1)
#define B_BE_DCPU_FWDL_EN BIT(0)

#define R_BE_DCPU_BOOT_REASON 0x08F4
#define B_BE_DCPU_BOOT_REASON_SH 0
#define B_BE_DCPU_BOOT_REASON_MSK 0x7

#define R_BE_DCPU_DBG_SYS_CFG 0x08F8
#define B_BE_DCPU_DBG_SYS_CFG_SH 0
#define B_BE_DCPU_DBG_SYS_CFG_MSK 0xffffffffL

#define R_BE_DCPU_BOOT_DBG 0x08FC
#define B_BE_DCPU_BOOT_STATUS_SH 16
#define B_BE_DCPU_BOOT_STATUS_MSK 0xffff
#define B_BE_DCPU_SECUREBOOT_STATUS_SH 0
#define B_BE_DCPU_SECUREBOOT_STATUS_MSK 0xffff

//
// AON_C
//

#define R_BE_SEC_CTRL 0x0C00
#define B_BE_SEC_FWDL_TIME BIT(23)
#define B_BE_SEC_AUTH_DONE BIT(22)
#define B_BE_SEC_DCPU_IDMEM_SIZE_CONFIG_SH 19
#define B_BE_SEC_DCPU_IDMEM_SIZE_CONFIG_MSK 0x7
#define B_BE_SEC_WCPU_IDMEM_SIZE_CONFIG_SH 16
#define B_BE_SEC_WCPU_IDMEM_SIZE_CONFIG_MSK 0x7
#define B_BE_SEC_UART_RX_EN BIT(4)
#define B_BE_SEC_UART_TX_EN BIT(3)
#define B_BE_SEC_JTAG_EN BIT(2)
#define B_BE_SEC_SIC_EN BIT(1)

#define R_BE_FILTER_MODEL_ADDR 0x0C04
#define B_BE_SEC_FILTER_MODEL_ADDR_SH 0
#define B_BE_SEC_FILTER_MODEL_ADDR_MSK 0xffffffffL

#define R_BE_EFUSE_CTRL_S 0x0C30
#define B_BE_EF_MODE_SEL_S_SH 30
#define B_BE_EF_MODE_SEL_S_MSK 0x3
#define B_BE_EF_RDY_S BIT(29)
#define B_BE_EF_ADDR_S_SH 0
#define B_BE_EF_ADDR_S_MSK 0xffff

#define R_BE_EFUSE_CTRL_1_V1_S 0x0C34
#define B_BE_EF_DATA_S_SH 0
#define B_BE_EF_DATA_S_MSK 0xffffffffL

#define R_BE_EFUSE_TEST_V1_S 0x0C38
#define B_BE_EF_SCAN_SADR_S_SH 16
#define B_BE_EF_SCAN_SADR_S_MSK 0xffff
#define B_BE_EF_SCAN_EADR_S_SH 0
#define B_BE_EF_SCAN_EADR_S_MSK 0xffff

#define R_BE_EFUSE_TEST_1_V1_S 0x0C3C
#define B_BE_EF_CRES_SEL_S BIT(31)
#define B_BE_EF_SCAN_TRPT_S BIT(7)
#define B_BE_EF_SCAN_FTHR_S_SH 0
#define B_BE_EF_SCAN_FTHR_S_MSK 0x7f

//
// WL_BE_Reg_CMAC_0.xls
//

//
// COMMON
//

#define R_BE_CMAC_FUNC_EN 0xC000
#define R_BE_CMAC_FUNC_EN_C1 0xE000
#define B_BE_CMAC_CRPRT BIT(31)
#define B_BE_CMAC_EN BIT(30)
#define B_BE_CMAC_TXEN BIT(29)
#define B_BE_CMAC_RXEN BIT(28)
#define B_BE_FORCE_CMACREG_GCKEN BIT(15)
#define B_BE_PHYINTF_EN BIT(5)
#define B_BE_CMAC_DMA_EN BIT(4)
#define B_BE_PTCLTOP_EN BIT(3)
#define B_BE_SCHEDULER_EN BIT(2)
#define B_BE_TMAC_EN BIT(1)
#define B_BE_RMAC_EN BIT(0)

#define R_BE_CK_EN 0xC004
#define R_BE_CK_EN_C1 0xE004
#define B_BE_CMAC_CKEN BIT(30)
#define B_BE_PHYINTF_CKEN BIT(5)
#define B_BE_CMAC_DMA_CKEN BIT(4)
#define B_BE_PTCLTOP_CKEN BIT(3)
#define B_BE_SCHEDULEB_BE_CKEN BIT(2)
#define B_BE_TMAC_CKEN BIT(1)
#define B_BE_RMAC_CKEN BIT(0)

#define R_BE_CMAC_TABLE 0xC008
#define R_BE_CMAC_TABLE_C1 0xE008
#define B_BE_CMAC_TABLE_IO_RST BIT(16)
#define B_BE_CMAC_TABLE_ADDR_HOLE_SH 0
#define B_BE_CMAC_TABLE_ADDR_HOLE_MSK 0xffff

#define R_BE_WMAC_RFMOD 0xC010
#define R_BE_WMAC_RFMOD_C1 0xE010
#define B_BE_CMAC_ASSERTION BIT(31)
#define B_BE_WMAC_RFMOD_SH 0
#define B_BE_WMAC_RFMOD_MSK 0x7

#define R_BE_CMAC_HWSSN01 0xC020
#define R_BE_CMAC_HWSSN01_C1 0xE020
#define B_BE_HW_CMAC_SSN1_SH 16
#define B_BE_HW_CMAC_SSN1_MSK 0xfff
#define B_BE_HW_CMAC_SSN0_SH 0
#define B_BE_HW_CMAC_SSN0_MSK 0xfff

#define R_BE_CMAC_HWSSN23 0xC024
#define R_BE_CMAC_HWSSN23_C1 0xE024
#define B_BE_HW_CMAC_SSN3_SH 16
#define B_BE_HW_CMAC_SSN3_MSK 0xfff
#define B_BE_HW_CMAC_SSN2_SH 0
#define B_BE_HW_CMAC_SSN2_MSK 0xfff

#define R_BE_CMAC_HWSSN45 0xC028
#define R_BE_CMAC_HWSSN45_C1 0xE028
#define B_BE_HW_CMAC_SSN5_SH 16
#define B_BE_HW_CMAC_SSN5_MSK 0xfff
#define B_BE_HW_CMAC_SSN4_SH 0
#define B_BE_HW_CMAC_SSN4_MSK 0xfff

#define R_BE_CMAC_HWSSN67 0xC02C
#define R_BE_CMAC_HWSSN67_C1 0xE02C
#define B_BE_HW_CMAC_SSN7_SH 16
#define B_BE_HW_CMAC_SSN7_MSK 0xfff
#define B_BE_HW_CMAC_SSN6_SH 0
#define B_BE_HW_CMAC_SSN6_MSK 0xfff

#define R_BE_R_BIST_CTRL 0xC040
#define R_BE_R_BIST_CTRL_C1 0xE040
#define B_BE_R_BIST_TMCK_W BIT(15)
#define B_BE_R_BIST_DYN_READ_EN BIT(14)
#define B_BE_R_BIST_LOOP_MODE BIT(13)
#define B_BE_R_BIST_LVDRF_CLKDIS BIT(12)
#define B_BE_R_BIST_DRF_RESUME BIT(3)
#define B_BE_R_BIST_DRF_MODE BIT(2)
#define B_BE_R_BIST_MODE BIT(1)
#define B_BE_R_BIST_RSTN_ALL BIT(0)

#define R_BE_SYM_MEM_RM_CTRL 0xC044
#define R_BE_SYM_MEM_RM_CTRL_C1 0xE044
#define B_BE_R_SYM_MEM_RMV_FABDBG_SH 30
#define B_BE_R_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_BE_R_SYM_MEM_RMV_SIGN BIT(29)
#define B_BE_R_SYM_MEM_RMV_2PRF BIT(27)
#define B_BE_R_SYM_MEM_RMV_1PRF BIT(26)
#define B_BE_R_SYM_MEM_RMV_1PSR BIT(25)
#define B_BE_R_SYM_MEM_RMV_ROM BIT(24)
#define B_BE_R_SYM_MEM_RME_WL_SH 4
#define B_BE_R_SYM_MEM_RME_WL_MSK 0xf

#define R_BE_PARAM_BIST_RSTN 0xC050
#define R_BE_PARAM_BIST_RSTN_C1 0xE050
#define B_BE_BIST_RST_N_SH 0
#define B_BE_BIST_RST_N_MSK 0x7ff

#define R_BE_PARAM_BIST_DONE 0xC054
#define R_BE_PARAM_BIST_DONE_C1 0xE054
#define B_BE_BIST_DONE_SH 0
#define B_BE_BIST_DONE_MSK 0xffffffffL

#define R_BE_PARAM_BIST_FAIL 0xC058
#define R_BE_PARAM_BIST_FAIL_C1 0xE058
#define B_BE_BIST_FAIL_SH 0
#define B_BE_BIST_FAIL_MSK 0xffffffffL

#define R_BE_PARAM_DRF_PAUSE 0xC05C
#define R_BE_PARAM_DRF_PAUSE_C1 0xE05C
#define B_BE_BIST_DRF_PAUSE_CMAC_SH 0
#define B_BE_BIST_DRF_PAUSE_CMAC_MSK 0xffffffffL

#define R_BE_PARAM_BIST_RSTN_SHARE 0xC060
#define R_BE_PARAM_BIST_RSTN_SHARE_C1 0xE060
#define B_BE_R_BIST_RST_N_CMAC_SHARE_SH 0
#define B_BE_R_BIST_RST_N_CMAC_SHARE_MSK 0x1f

#define R_BE_PARAM_BIST_DONE_SHARE 0xC064
#define R_BE_PARAM_BIST_DONE_SHARE_C1 0xE064
#define B_BE_BIST_DONE_CMAC_SHARE_SH 0
#define B_BE_BIST_DONE_CMAC_SHARE_MSK 0xffffffffL

#define R_BE_PARAM_BIST_FAIL_SHARE 0xC068
#define R_BE_PARAM_BIST_FAIL_SHARE_C1 0xE068
#define B_BE_BIST_FAIL_CMAC_SHARE_SH 0
#define B_BE_BIST_FAIL_CMAC_SHARE_MSK 0xffffffffL

#define R_BE_RARAM_DRF_PAUSE_SHARE 0xC06C
#define R_BE_RARAM_DRF_PAUSE_SHARE_C1 0xE06C
#define B_BE_BIST_DRF_PAUSE_CMAC_SHARE_SH 0
#define B_BE_BIST_DRF_PAUSE_CMAC_SHARE_MSK 0xffffffffL

#define R_BE_GID_POSITION0 0xC070
#define R_BE_GID_POSITION0_C1 0xE070
#define B_BE_GID_15_00_POSITION_SH 0
#define B_BE_GID_15_00_POSITION_MSK 0xffffffffL

#define R_BE_GID_POSITION1 0xC074
#define R_BE_GID_POSITION1_C1 0xE074
#define B_BE_GID_31_16_POSITION_SH 0
#define B_BE_GID_31_16_POSITION_MSK 0xffffffffL

#define R_BE_GID_POSITION2 0xC078
#define R_BE_GID_POSITION2_C1 0xE078
#define B_BE_GID_47_32_POSITION_SH 0
#define B_BE_GID_47_32_POSITION_MSK 0xffffffffL

#define R_BE_GID_POSITION3 0xC07C
#define R_BE_GID_POSITION3_C1 0xE07C
#define B_BE_GID_63_48_POSITION_SH 0
#define B_BE_GID_63_48_POSITION_MSK 0xffffffffL

#define R_BE_GID_POSITION_EN0 0xC080
#define R_BE_GID_POSITION_EN0_C1 0xE080
#define B_BE_GID_31_00_POSITION_EN_SH 0
#define B_BE_GID_31_00_POSITION_EN_MSK 0xffffffffL

#define R_BE_GID_POSITION_EN1 0xC084
#define R_BE_GID_POSITION_EN1_C1 0xE084
#define B_BE_GID_63_32_POSITION_EN_SH 0
#define B_BE_GID_63_32_POSITION_EN_MSK 0xffffffffL

#define R_BE_TX_SUB_BAND_VALUE 0xC088
#define R_BE_TX_SUB_BAND_VALUE_C1 0xE088
#define B_BE_TXSB_160M_SH 12
#define B_BE_TXSB_160M_MSK 0xf
#define B_BE_TXSB_80M_SH 8
#define B_BE_TXSB_80M_MSK 0xf
#define B_BE_TXSB_40M_SH 4
#define B_BE_TXSB_40M_MSK 0xf
#define B_BE_TXSB_20M_SH 0
#define B_BE_TXSB_20M_MSK 0xf

#define R_BE_PTCL_RRSR0 0xC08C
#define R_BE_PTCL_RRSR0_C1 0xE08C
#define B_BE_RRSR_HE_SH 24
#define B_BE_RRSR_HE_MSK 0xff
#define B_BE_RRSR_VHT_SH 16
#define B_BE_RRSR_VHT_MSK 0xff
#define B_BE_RRSR_HT_SH 8
#define B_BE_RRSR_HT_MSK 0xff
#define B_BE_RRSR_OFDM_SH 0
#define B_BE_RRSR_OFDM_MSK 0xff

#define R_BE_PTCL_RRSR1 0xC090
#define R_BE_PTCL_RRSR1_C1 0xE090
#define B_BE_RRSR_EHT_SH 16
#define B_BE_RRSR_EHT_MSK 0xff
#define B_BE_RRSR_RATE_EN_SH 8
#define B_BE_RRSR_RATE_EN_MSK 0x1f
#define B_BE_RSC_SH 6
#define B_BE_RSC_MSK 0x3
#define B_BE_RRSR_CCK_SH 0
#define B_BE_RRSR_CCK_MSK 0xf

#define R_BE_C0_EHT_SIG_MCS 0xC098
#define R_BE_C0_EHT_SIG_MCS_C1 0xE098
#define B_BE_EHT_SIG_MCS_4_SH 8
#define B_BE_EHT_SIG_MCS_4_MSK 0x3
#define B_BE_EHT_SIG_MCS_3_SH 6
#define B_BE_EHT_SIG_MCS_3_MSK 0x3
#define B_BE_EHT_SIG_MCS_2_SH 4
#define B_BE_EHT_SIG_MCS_2_MSK 0x3
#define B_BE_EHT_SIG_MCS_1_SH 2
#define B_BE_EHT_SIG_MCS_1_MSK 0x3
#define B_BE_EHT_SIG_MCS_0_SH 0
#define B_BE_EHT_SIG_MCS_0_MSK 0x3

#define R_BE_FWC00IMR 0xC100
#define R_BE_FWC00IMR_C1 0xE100
#define B_BE_FS_PSTIMER_6_INT_EN BIT(30)
#define B_BE_FS_SND_RDY_INT_EN BIT(29)
#define B_BE_FS_RP_END_INT_EN BIT(28)
#define B_BE_FS_RXBCN_TO_CNT_INT_EN BIT(27)
#define B_BE_FS_RXBCN_HIT_INT_EN BIT(26)
#define B_BE_FS_RX_MATCH_RTT_INT_EN BIT(25)
#define B_BE_FS_BCNQ_LOCK_INT_EN BIT(24)
#define B_BE_FS_P2P1_CTWEND_INT_EN BIT(23)
#define B_BE_FS_P2P1_TSF32_TOGGLE_INT_EN BIT(22)
#define B_BE_FS_P2P1_RFON_INT_EN BIT(21)
#define B_BE_FS_P2P1_RFOFF_INT_EN BIT(20)
#define B_BE_FS_P2P0_CTWEND_INT_EN BIT(19)
#define B_BE_FS_P2P0_TSF32_TOGGLE_INT_EN BIT(18)
#define B_BE_FS_P2P0_RFON_INT_EN BIT(17)
#define B_BE_FS_P2P0_RFOFF_INT_EN BIT(16)
#define B_BE_FS_MACID_PWRCHANGE3_INT_EN BIT(15)
#define B_BE_FS_MACID_PWRCHANGE2_INT_EN BIT(14)
#define B_BE_FS_MACID_PWRCHANGE1_INT_EN BIT(13)
#define B_BE_FS_MACID_PWRCHANGE0_INT_EN BIT(12)
#define B_BE_FS_RXFTMREQ_INT_EN BIT(11)
#define B_BE_FS_RXFTM_INT_EN BIT(10)
#define B_BE_FS_FTM_PTT_EN BIT(9)
#define B_BE_FS_TXFTM_INT_EN BIT(8)
#define B_BE_FS_SOUND_DONE_INT_EN BIT(7)
#define B_BE_FS_RXDONE_INT_EN BIT(6)
#define B_BE_FS_PSTIMER_5_INT_EN BIT(5)
#define B_BE_FS_PSTIMER_4_INT_EN BIT(4)
#define B_BE_FS_PSTIMER_3_INT_EN BIT(3)
#define B_BE_FS_PSTIMER_2_INT_EN BIT(2)
#define B_BE_FS_PSTIMER_1_INT_EN BIT(1)
#define B_BE_FS_PSTIMER_0_INT_EN BIT(0)

#define R_BE_FWC00ISR 0xC104
#define R_BE_FWC00ISR_C1 0xE104
#define B_BE_FS_PSTIMER_6_INT BIT(30)
#define B_BE_FS_SND_RDY_INT BIT(29)
#define B_BE_FS_RP_END_INT BIT(28)
#define B_BE_FS_RXBCN_TO_CNT_INT BIT(27)
#define B_BE_FS_RXBCN_HIT_INT BIT(26)
#define B_BE_FS_RX_MATCH_RTT_INT BIT(25)
#define B_BE_FS_BCNQ_LOCK_INT BIT(24)
#define B_BE_FS_MACID_PWRCHANGE3_INT BIT(15)
#define B_BE_FS_MACID_PWRCHANGE2_INT BIT(14)
#define B_BE_FS_MACID_PWRCHANGE1_INT BIT(13)
#define B_BE_FS_MACID_PWRCHANGE0_INT BIT(12)
#define B_BE_FS_RXFTMREQ_INT BIT(11)
#define B_BE_FS_RXFTM_INT BIT(10)
#define B_BE_FS_FTM_PTT_INT BIT(9)
#define B_BE_FS_TXFTM_INT BIT(8)
#define B_BE_FS_SOUND_DONE_INT BIT(7)
#define B_BE_FS_RXDONE_INT BIT(6)
#define B_BE_FS_PSTIMER_5_INT BIT(5)
#define B_BE_FS_PSTIMER_4_INT BIT(4)
#define B_BE_FS_PSTIMER_3_INT BIT(3)
#define B_BE_FS_PSTIMER_2_INT BIT(2)
#define B_BE_FS_PSTIMER_1_INT BIT(1)
#define B_BE_FS_PSTIMER_0_INT BIT(0)

#define R_BE_FWC01IMR 0xC108
#define R_BE_FWC01IMR_C1 0xE108
#define B_BE_FS_P0_RXBCN_NOHIT_INT_EN BIT(22)
#define B_BE_FS_P0_RXMTF1MRR0_INT_EN BIT(21)
#define B_BE_FS_P0_RXMTF0_INT_EN BIT(20)
#define B_BE_FS_P0_RX_UAPSDMD1_INT_EN BIT(19)
#define B_BE_FS_P0_RX_UAPSDMD0_INT_EN BIT(18)
#define B_BE_FS_P0_TRIGGER_PKT_INT_EN BIT(17)
#define B_BE_FS_P0_EOSP_INT_EN BIT(16)
#define B_BE_FS_P0_TXPKTIN_EN BIT(15)
#define B_BE_FS_P0_TX_NULL1_INT_EN BIT(14)
#define B_BE_FS_P0_TX_NULL0_INT_EN BIT(13)
#define B_BE_FS_P0_RX_UMD0_INT_EN BIT(12)
#define B_BE_FS_P0_RX_UMD1_INT_EN BIT(11)
#define B_BE_FS_P0_RX_BMD0_INT_EN BIT(10)
#define B_BE_FS_P0_RX_BMD1_INT_EN BIT(9)
#define B_BE_FS_P0_RXBCNOK_INT_EN BIT(8)
#define B_BE_FS_P0MB0_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P0MB0_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P0MB0_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P0MB0_TBTT_INT_EN BIT(2)
#define B_BE_FS_P0MB0_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P0MB0_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC01ISR 0xC10C
#define R_BE_FWC01ISR_C1 0xE10C
#define B_BE_FS_P0_RXBCN_NOHIT_INT BIT(22)
#define B_BE_FS_P0_RXMTF1MRR0_INT BIT(21)
#define B_BE_FS_P0_RXMTF0_INT BIT(20)
#define B_BE_FS_P0_RX_UAPSDMD1_INT BIT(19)
#define B_BE_FS_P0_RX_UAPSDMD0_INT BIT(18)
#define B_BE_FS_P0_TRIGGER_PKT_INT BIT(17)
#define B_BE_FS_P0_EOSP_INT BIT(16)
#define B_BE_FS_P0_TXPKTIN_INT BIT(15)
#define B_BE_FS_P0_TX_NULL1_INT BIT(14)
#define B_BE_FS_P0_TX_NULL0_INT BIT(13)
#define B_BE_FS_P0_RX_UMD0_INT BIT(12)
#define B_BE_FS_P0_RX_UMD1_INT BIT(11)
#define B_BE_FS_P0_RX_BMD0_INT BIT(10)
#define B_BE_FS_P0_RX_BMD1_INT BIT(9)
#define B_BE_FS_P0_RXBCNOK_INT BIT(8)
#define B_BE_FS_P0MB0_TXBCNERR_INT BIT(5)
#define B_BE_FS_P0MB0_TXBCNOK_INT BIT(4)
#define B_BE_FS_P0MB0_HIQWND_INT BIT(3)
#define B_BE_FS_P0MB0_TBTT_INT BIT(2)
#define B_BE_FS_P0MB0_TBTTERLY_INT BIT(1)
#define B_BE_FS_P0MB0_BCNERLY_INT BIT(0)

#define R_BE_FWC02IMR 0xC110
#define R_BE_FWC02IMR_C1 0xE110
#define B_BE_FS_P1_RXBCN_NOHIT_INT_EN BIT(22)
#define B_BE_FS_P1_RXMTF1MRR0_INT_EN BIT(21)
#define B_BE_FS_P1_RXMTF0_INT_EN BIT(20)
#define B_BE_FS_P1_RX_UAPSDMD1_INT_EN BIT(19)
#define B_BE_FS_P1_RX_UAPSDMD0_INT_EN BIT(18)
#define B_BE_FS_P1_TRIGGER_PKT_INT_EN BIT(17)
#define B_BE_FS_P1_EOSP_INT_EN BIT(16)
#define B_BE_FS_P1_TXPKTIN_INT_EN BIT(15)
#define B_BE_FS_P1_TX_NULL1_INT_EN BIT(14)
#define B_BE_FS_P1_TX_NULL0_INT_EN BIT(13)
#define B_BE_FS_P1_RX_UMD0_INT_EN BIT(12)
#define B_BE_FS_P1_RX_UMD1_INT_EN BIT(11)
#define B_BE_FS_P1_RX_BMD0_INT_EN BIT(10)
#define B_BE_FS_P1_RX_BMD1_INT_EN BIT(9)
#define B_BE_FS_P1_RXBCNOK_INT_EN BIT(8)
#define B_BE_FS_P1_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P1_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P1_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P1_TBTT_INT_EN BIT(2)
#define B_BE_FS_P1_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P1_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC02ISR 0xC114
#define R_BE_FWC02ISR_C1 0xE114
#define B_BE_FS_P1_RXBCN_NOHIT_INT BIT(22)
#define B_BE_FS_P1_RXMTF1MRR0_INT BIT(21)
#define B_BE_FS_P1_RXMTF0_INT BIT(20)
#define B_BE_FS_P1_RX_UAPSDMD1_INT BIT(19)
#define B_BE_FS_P1_RX_UAPSDMD0_INT BIT(18)
#define B_BE_FS_P1_TRIGGER_PKT_INT BIT(17)
#define B_BE_FS_P1_EOSP_INT BIT(16)
#define B_BE_FS_P1_TXPKTIN_INT BIT(15)
#define B_BE_FS_P1_TX_NULL1_INT BIT(14)
#define B_BE_FS_P1_TX_NULL0_INT BIT(13)
#define B_BE_FS_P1_RX_UMD0_INT BIT(12)
#define B_BE_FS_P1_RX_UMD1_INT BIT(11)
#define B_BE_FS_P1_RX_BMD0_INT BIT(10)
#define B_BE_FS_P1_RX_BMD1_INT BIT(9)
#define B_BE_FS_P1_RXBCNOK_INT BIT(8)
#define B_BE_FS_P1_TXBCNERR_INT BIT(5)
#define B_BE_FS_P1_TXBCNOK_INT BIT(4)
#define B_BE_FS_P1_HIQWND_INT BIT(3)
#define B_BE_FS_P1_TBTT_INT BIT(2)
#define B_BE_FS_P1_TBTTERLY_INT BIT(1)
#define B_BE_FS_P1_BCNERLY_INT BIT(0)

#define R_BE_FWC03IMR 0xC118
#define R_BE_FWC03IMR_C1 0xE118
#define B_BE_FS_P2_RXBCN_NOHIT_INT_EN BIT(22)
#define B_BE_FS_P2_RXMTF1MRR0_INT_EN BIT(21)
#define B_BE_FS_P2_RXMTF0_INT_EN BIT(20)
#define B_BE_FS_P2_RX_UAPSDMD1_INT_EN BIT(19)
#define B_BE_FS_P2_RX_UAPSDMD0_INT_EN BIT(18)
#define B_BE_FS_P2_TRIGGER_PKT_INT_EN BIT(17)
#define B_BE_FS_P2_EOSP_INT_EN BIT(16)
#define B_BE_FS_P2_TXPKTIN_INT_EN BIT(15)
#define B_BE_FS_P2_TX_NULL1_INT_EN BIT(14)
#define B_BE_FS_P2_TX_NULL0_INT_EN BIT(13)
#define B_BE_FS_P2_RX_UMD0_INT_EN BIT(12)
#define B_BE_FS_P2_RX_UMD1_INT_EN BIT(11)
#define B_BE_FS_P2_RX_BMD0_INT_EN BIT(10)
#define B_BE_FS_P2_RX_BMD1_INT_EN BIT(9)
#define B_BE_FS_P2_RXBCNOK_INT_EN BIT(8)
#define B_BE_FS_P2_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P2_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P2_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P2_TBTT_INT_EN BIT(2)
#define B_BE_FS_P2_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P2_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC03ISR 0xC11C
#define R_BE_FWC03ISR_C1 0xE11C
#define B_BE_FS_P2_RXBCN_NOHIT_INT BIT(22)
#define B_BE_FS_P2_RXMTF1MRR0_INT BIT(21)
#define B_BE_FS_P2_RXMTF0_INT BIT(20)
#define B_BE_FS_P2_RX_UAPSDMD1_INT BIT(19)
#define B_BE_FS_P2_RX_UAPSDMD0_INT BIT(18)
#define B_BE_FS_P2_TRIGGER_PKT_INT BIT(17)
#define B_BE_FS_P2_EOSP_INT BIT(16)
#define B_BE_FS_P2_TXPKTIN_INT BIT(15)
#define B_BE_FS_P2_TX_NULL1_INT BIT(14)
#define B_BE_FS_P2_TX_NULL0_INT BIT(13)
#define B_BE_FS_P2_RX_UMD0_INT BIT(12)
#define B_BE_FS_P2_RX_UMD1_INT BIT(11)
#define B_BE_FS_P2_RX_BMD0_INT BIT(10)
#define B_BE_FS_P2_RX_BMD1_INT BIT(9)
#define B_BE_FS_P2_RXBCNOK_INT BIT(8)
#define B_BE_FS_P2_TXBCNERR_INT BIT(5)
#define B_BE_FS_P2_TXBCNOK_INT BIT(4)
#define B_BE_FS_P2_HIQWND_INT BIT(3)
#define B_BE_FS_P2_TBTT_INT BIT(2)
#define B_BE_FS_P2_TBTTERLY_INT BIT(1)
#define B_BE_FS_P2_BCNERLY_INT BIT(0)

#define R_BE_FWC04IMR 0xC120
#define R_BE_FWC04IMR_C1 0xE120
#define B_BE_FS_P3_RXBCN_NOHIT_INT_EN BIT(22)
#define B_BE_FS_P3_RXMTF1MRR0_INT_EN BIT(21)
#define B_BE_FS_P3_RXMTF0_INT_EN BIT(20)
#define B_BE_FS_P3_RX_UAPSDMD1_INT_EN BIT(19)
#define B_BE_FS_P3_RX_UAPSDMD0_INT_EN BIT(18)
#define B_BE_FS_P3_TRIGGER_PKT_INT_EN BIT(17)
#define B_BE_FS_P3_EOSP_INT_EN BIT(16)
#define B_BE_FS_P3_TXPKTIN_INT_EN BIT(15)
#define B_BE_FS_P3_TX_NULL1_INT_EN BIT(14)
#define B_BE_FS_P3_TX_NULL0_INT_EN BIT(13)
#define B_BE_FS_P3_RX_UMD0_INT_EN BIT(12)
#define B_BE_FS_P3_RX_UMD1_INT_EN BIT(11)
#define B_BE_FS_P3_RX_BMD0_INT_EN BIT(10)
#define B_BE_FS_P3_RX_BMD1_INT_EN BIT(9)
#define B_BE_FS_P3_RXBCNOK_INT_EN BIT(8)
#define B_BE_FS_P3_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P3_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P3_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P3_TBTT_INT_EN BIT(2)
#define B_BE_FS_P3_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P3_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC04ISR 0xC124
#define R_BE_FWC04ISR_C1 0xE124
#define B_BE_FS_P3_RXBCN_NOHIT_INT BIT(22)
#define B_BE_FS_P3_RXMTF1MRR0_INT BIT(21)
#define B_BE_FS_P3_RXMTF0_INT BIT(20)
#define B_BE_FS_P3_RX_UAPSDMD1_INT BIT(19)
#define B_BE_FS_P3_RX_UAPSDMD0_INT BIT(18)
#define B_BE_FS_P3_TRIGGER_PKT_INT BIT(17)
#define B_BE_FS_P3_EOSP_INT BIT(16)
#define B_BE_FS_P3_TXPKTIN_INT BIT(15)
#define B_BE_FS_P3_TX_NULL1_INT BIT(14)
#define B_BE_FS_P3_TX_NULL0_INT BIT(13)
#define B_BE_FS_P3_RX_UMD0_INT BIT(12)
#define B_BE_FS_P3_RX_UMD1_INT BIT(11)
#define B_BE_FS_P3_RX_BMD0_INT BIT(10)
#define B_BE_FS_P3_RX_BMD1_INT BIT(9)
#define B_BE_FS_P3_RXBCNOK_INT BIT(8)
#define B_BE_FS_P3_TXBCNERR_INT BIT(5)
#define B_BE_FS_P3_TXBCNOK_INT BIT(4)
#define B_BE_FS_P3_HIQWND_INT BIT(3)
#define B_BE_FS_P3_TBTT_INT BIT(2)
#define B_BE_FS_P3_TBTTERLY_INT BIT(1)
#define B_BE_FS_P3_BCNERLY_INT BIT(0)

#define R_BE_FWC05IMR 0xC128
#define R_BE_FWC05IMR_C1 0xE128
#define B_BE_FS_P4_RXBCN_NOHIT_INT_EN BIT(22)
#define B_BE_FS_P4_RXMTF1MRR0_INT_EN BIT(21)
#define B_BE_FS_P4_RXMTF0_INT_EN BIT(20)
#define B_BE_FS_P4_RX_UAPSDMD1_INT_EN BIT(19)
#define B_BE_FS_P4_RX_UAPSDMD0_INT_EN BIT(18)
#define B_BE_FS_P4_TRIGGER_PKT_INT_EN BIT(17)
#define B_BE_FS_P4_EOSP_INT_EN BIT(16)
#define B_BE_FS_P4_TXPKTIN_INT_EN BIT(15)
#define B_BE_FS_P4_TX_NULL1_INT_EN BIT(14)
#define B_BE_FS_P4_TX_NULL0_INT_EN BIT(13)
#define B_BE_FS_P4_RX_UMD0_INT_EN BIT(12)
#define B_BE_FS_P4_RX_UMD1_INT_EN BIT(11)
#define B_BE_FS_P4_RX_BMD0_INT_EN BIT(10)
#define B_BE_FS_P4_RX_BMD1_INT_EN BIT(9)
#define B_BE_FS_P4_RXBCNOK_INT_EN BIT(8)
#define B_BE_FS_P4_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P4_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P4_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P4_TBTT_INT_EN BIT(2)
#define B_BE_FS_P4_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P4_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC05ISR 0xC12C
#define R_BE_FWC05ISR_C1 0xE12C
#define B_BE_FS_P4_RXBCN_NOHIT_INT BIT(22)
#define B_BE_FS_P4_RXMTF1MRR0_INT BIT(21)
#define B_BE_FS_P4_RXMTF0_INT BIT(20)
#define B_BE_FS_P4_RX_UAPSDMD1_INT BIT(19)
#define B_BE_FS_P4_RX_UAPSDMD0_INT BIT(18)
#define B_BE_FS_P4_TRIGGER_PKT_INT BIT(17)
#define B_BE_FS_P4_EOSP_INT BIT(16)
#define B_BE_FS_P4_TXPKTIN_INT BIT(15)
#define B_BE_FS_P4_TX_NULL1_INT BIT(14)
#define B_BE_FS_P4_TX_NULL0_INT BIT(13)
#define B_BE_FS_P4_RX_UMD0_INT BIT(12)
#define B_BE_FS_P4_RX_UMD1_INT BIT(11)
#define B_BE_FS_P4_RX_BMD0_INT BIT(10)
#define B_BE_FS_P4_RX_BMD1_INT BIT(9)
#define B_BE_FS_P4_RXBCNOK_INT BIT(8)
#define B_BE_FS_P4_TXBCNERR_INT BIT(5)
#define B_BE_FS_P4_TXBCNOK_INT BIT(4)
#define B_BE_FS_P4_HIQWND_INT BIT(3)
#define B_BE_FS_P4_TBTT_INT BIT(2)
#define B_BE_FS_P4_TBTTERLY_INT BIT(1)
#define B_BE_FS_P4_BCNERLY_INT BIT(0)

#define R_BE_FWC06IMR 0xC130
#define R_BE_FWC06IMR_C1 0xE130
#define B_BE_FS_P0MB4_TXBCNERR_INT_EN BIT(29)
#define B_BE_FS_P0MB4_TXBCNOK_INT_EN BIT(28)
#define B_BE_FS_P0MB4_HIQWND_INT_EN BIT(27)
#define B_BE_FS_P0MB4_TBTT_INT_EN BIT(26)
#define B_BE_FS_P0MB4_TBTTERLY_INT_EN BIT(25)
#define B_BE_FS_P0MB4_BCNERLY_INT_EN BIT(24)
#define B_BE_FS_P0MB3_TXBCNERR_INT_EN BIT(21)
#define B_BE_FS_P0MB3_TXBCNOK_INT_EN BIT(20)
#define B_BE_FS_P0MB3_HIQWND_INT_EN BIT(19)
#define B_BE_FS_P0MB3_TBTT_INT_EN BIT(18)
#define B_BE_FS_P0MB3_TBTTERLY_INT_EN BIT(17)
#define B_BE_FS_P0MB3_BCNERLY_INT_EN BIT(16)
#define B_BE_FS_P0MB2_TXBCNERR_INT_EN BIT(13)
#define B_BE_FS_P0MB2_TXBCNOK_INT_EN BIT(12)
#define B_BE_FS_P0MB2_HIQWND_INT_EN BIT(11)
#define B_BE_FS_P0MB2_TBTT_INT_EN BIT(10)
#define B_BE_FS_P0MB2_TBTTERLY_INT_EN BIT(9)
#define B_BE_FS_P0MB2_BCNERLY_INT_EN BIT(8)
#define B_BE_FS_P0MB1_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P0MB1_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P0MB1_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P0MB1_TBTT_INT_EN BIT(2)
#define B_BE_FS_P0MB1_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P0MB1_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC06ISR 0xC134
#define R_BE_FWC06ISR_C1 0xE134
#define B_BE_FS_P0MB4_TXBCNERR_INT BIT(29)
#define B_BE_FS_P0MB4_TXBCNOK_INT BIT(28)
#define B_BE_FS_P0MB4_HIQWND_INT BIT(27)
#define B_BE_FS_P0MB4_TBTT_INT BIT(26)
#define B_BE_FS_P0MB4_TBTTERLY_INT BIT(25)
#define B_BE_FS_P0MB4_BCNERLY_INT BIT(24)
#define B_BE_FS_P0MB3_TXBCNERR_INT BIT(21)
#define B_BE_FS_P0MB3_TXBCNOK_INT BIT(20)
#define B_BE_FS_P0MB3_HIQWND_INT BIT(19)
#define B_BE_FS_P0MB3_TBTT_INT BIT(18)
#define B_BE_FS_P0MB3_TBTTERLY_INT BIT(17)
#define B_BE_FS_P0MB3_BCNERLY_INT BIT(16)
#define B_BE_FS_P0MB2_TXBCNERR_INT BIT(13)
#define B_BE_FS_P0MB2_TXBCNOK_INT BIT(12)
#define B_BE_FS_P0MB2_HIQWND_INT BIT(11)
#define B_BE_FS_P0MB2_TBTT_INT BIT(10)
#define B_BE_FS_P0MB2_TBTTERLY_INT BIT(9)
#define B_BE_FS_P0MB2_BCNERLY_INT BIT(8)
#define B_BE_FS_P0MB1_TXBCNERR_INT BIT(5)
#define B_BE_FS_P0MB1_TXBCNOK_INT BIT(4)
#define B_BE_FS_P0MB1_HIQWND_INT BIT(3)
#define B_BE_FS_P0MB1_TBTT_INT BIT(2)
#define B_BE_FS_P0MB1_TBTTERLY_INT BIT(1)
#define B_BE_FS_P0MB1_BCNERLY_INT BIT(0)

#define R_BE_FWC07IMR 0xC138
#define R_BE_FWC07IMR_C1 0xE138
#define B_BE_FS_P0MB8_TXBCNERR_INT_EN BIT(29)
#define B_BE_FS_P0MB8_TXBCNOK_INT_EN BIT(28)
#define B_BE_FS_P0MB8_HIQWND_INT_EN BIT(27)
#define B_BE_FS_P0MB8_TBTT_INT_EN BIT(26)
#define B_BE_FS_P0MB8_TBTTERLY_INT_EN BIT(25)
#define B_BE_FS_P0MB8_BCNERLY_INT_EN BIT(24)
#define B_BE_FS_P0MB7_TXBCNERR_INT_EN BIT(21)
#define B_BE_FS_P0MB7_TXBCNOK_INT_EN BIT(20)
#define B_BE_FS_P0MB7_HIQWND_INT_EN BIT(19)
#define B_BE_FS_P0MB7_TBTT_INT_EN BIT(18)
#define B_BE_FS_P0MB7_TBTTERLY_INT_EN BIT(17)
#define B_BE_FS_P0MB7_BCNERLY_INT_EN BIT(16)
#define B_BE_FS_P0MB6_TXBCNERR_INT_EN BIT(13)
#define B_BE_FS_P0MB6_TXBCNOK_INT_EN BIT(12)
#define B_BE_FS_P0MB6_HIQWND_INT_EN BIT(11)
#define B_BE_FS_P0MB6_TBTT_INT_EN BIT(10)
#define B_BE_FS_P0MB6_TBTTERLY_INT_EN BIT(9)
#define B_BE_FS_P0MB6_BCNERLY_INT_EN BIT(8)
#define B_BE_FS_P0MB5_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P0MB5_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P0MB5_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P0MB5_TBTT_INT_EN BIT(2)
#define B_BE_FS_P0MB5_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P0MB5_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC07ISR 0xC13C
#define R_BE_FWC07ISR_C1 0xE13C
#define B_BE_FS_P0MB8_TXBCNERR_INT BIT(29)
#define B_BE_FS_P0MB8_TXBCNOK_INT BIT(28)
#define B_BE_FS_P0MB8_HIQWND_INT BIT(27)
#define B_BE_FS_P0MB8_TBTT_INT BIT(26)
#define B_BE_FS_P0MB8_TBTTERLY_INT BIT(25)
#define B_BE_FS_P0MB8_BCNERLY_INT BIT(24)
#define B_BE_FS_P0MB7_TXBCNERR_INT BIT(21)
#define B_BE_FS_P0MB7_TXBCNOK_INT BIT(20)
#define B_BE_FS_P0MB7_HIQWND_INT BIT(19)
#define B_BE_FS_P0MB7_TBTT_INT BIT(18)
#define B_BE_FS_P0MB7_TBTTERLY_INT BIT(17)
#define B_BE_FS_P0MB7_BCNERLY_INT BIT(16)
#define B_BE_FS_P0MB6_TXBCNERR_INT BIT(13)
#define B_BE_FS_P0MB6_TXBCNOK_INT BIT(12)
#define B_BE_FS_P0MB6_HIQWND_INT BIT(11)
#define B_BE_FS_P0MB6_TBTT_INT BIT(10)
#define B_BE_FS_P0MB6_TBTTERLY_INT BIT(9)
#define B_BE_FS_P0MB6_BCNERLY_INT BIT(8)
#define B_BE_FS_P0MB5_TXBCNERR_INT BIT(5)
#define B_BE_FS_P0MB5_TXBCNOK_INT BIT(4)
#define B_BE_FS_P0MB5_HIQWND_INT BIT(3)
#define B_BE_FS_P0MB5_TBTT_INT BIT(2)
#define B_BE_FS_P0MB5_TBTTERLY_INT BIT(1)
#define B_BE_FS_P0MB5_BCNERLY_INT BIT(0)

#define R_BE_FWC08IMR 0xC140
#define R_BE_FWC08IMR_C1 0xE140
#define B_BE_FS_P0MB12_TXBCNERR_INT_EN BIT(29)
#define B_BE_FS_P0MB12_TXBCNOK_INT_EN BIT(28)
#define B_BE_FS_P0MB12_HIQWND_INT_EN BIT(27)
#define B_BE_FS_P0MB12_TBTT_INT_EN BIT(26)
#define B_BE_FS_P0MB12_TBTTERLY_INT_EN BIT(25)
#define B_BE_FS_P0MB12_BCNERLY_INT_EN BIT(24)
#define B_BE_FS_P0MB11_TXBCNERR_INT_EN BIT(21)
#define B_BE_FS_P0MB11_TXBCNOK_INT_EN BIT(20)
#define B_BE_FS_P0MB11_HIQWND_INT_EN BIT(19)
#define B_BE_FS_P0MB11_TBTT_INT_EN BIT(18)
#define B_BE_FS_P0MB11_TBTTERLY_INT_EN BIT(17)
#define B_BE_FS_P0MB11_BCNERLY_INT_EN BIT(16)
#define B_BE_FS_P0MB10_TXBCNERR_INT_EN BIT(13)
#define B_BE_FS_P0MB10_TXBCNOK_INT_EN BIT(12)
#define B_BE_FS_P0MB10_HIQWND_INT_EN BIT(11)
#define B_BE_FS_P0MB10_TBTT_INT_EN BIT(10)
#define B_BE_FS_P0MB10_TBTTERLY_INT_EN BIT(9)
#define B_BE_FS_P0MB10_BCNERLY_INT_EN BIT(8)
#define B_BE_FS_P0MB9_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P0MB9_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P0MB9_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P0MB9_TBTT_INT_EN BIT(2)
#define B_BE_FS_P0MB9_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P0MB9_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC08ISR 0xC144
#define R_BE_FWC08ISR_C1 0xE144
#define B_BE_FS_P0MB12_TXBCNERR_INT BIT(29)
#define B_BE_FS_P0MB12_TXBCNOK_INT BIT(28)
#define B_BE_FS_P0MB12_HIQWND_INT BIT(27)
#define B_BE_FS_P0MB12_TBTT_INT BIT(26)
#define B_BE_FS_P0MB12_TBTTERLY_INT BIT(25)
#define B_BE_FS_P0MB12_BCNERLY_INT BIT(24)
#define B_BE_FS_P0MB11_TXBCNERR_INT BIT(21)
#define B_BE_FS_P0MB11_TXBCNOK_INT BIT(20)
#define B_BE_FS_P0MB11_HIQWND_INT BIT(19)
#define B_BE_FS_P0MB11_TBTT_INT BIT(18)
#define B_BE_FS_P0MB11_TBTTERLY_INT BIT(17)
#define B_BE_FS_P0MB11_BCNERLY_INT BIT(16)
#define B_BE_FS_P0MB10_TXBCNERR_INT BIT(13)
#define B_BE_FS_P0MB10_TXBCNOK_INT BIT(12)
#define B_BE_FS_P0MB10_HIQWND_INT BIT(11)
#define B_BE_FS_P0MB10_TBTT_INT BIT(10)
#define B_BE_FS_P0MB10_TBTTERLY_INT BIT(9)
#define B_BE_FS_P0MB10_BCNERLY_INT BIT(8)
#define B_BE_FS_P0MB9_TXBCNERR_INT BIT(5)
#define B_BE_FS_P0MB9_TXBCNOK_INT BIT(4)
#define B_BE_FS_P0MB9_HIQWND_INT BIT(3)
#define B_BE_FS_P0MB9_TBTT_INT BIT(2)
#define B_BE_FS_P0MB9_TBTTERLY_INT BIT(1)
#define B_BE_FS_P0MB9_BCNERLY_INT BIT(0)

#define R_BE_FWC09IMR 0xC148
#define R_BE_FWC09IMR_C1 0xE148
#define B_BE_FS_P0MB15_TXBCNERR_INT_EN BIT(21)
#define B_BE_FS_P0MB15_TXBCNOK_INT_EN BIT(20)
#define B_BE_FS_P0MB15_HIQWND_INT_EN BIT(19)
#define B_BE_FS_P0MB15_TBTT_INT_EN BIT(18)
#define B_BE_FS_P0MB15_TBTTERLY_INT_EN BIT(17)
#define B_BE_FS_P0MB15_BCNERLY_INT_EN BIT(16)
#define B_BE_FS_P0MB14_TXBCNERR_INT_EN BIT(13)
#define B_BE_FS_P0MB14_TXBCNOK_INT_EN BIT(12)
#define B_BE_FS_P0MB14_HIQWND_INT_EN BIT(11)
#define B_BE_FS_P0MB14_TBTT_INT_EN BIT(10)
#define B_BE_FS_P0MB14_TBTTERLY_INT_EN BIT(9)
#define B_BE_FS_P0MB14_BCNERLY_INT_EN BIT(8)
#define B_BE_FS_P0MB13_TXBCNERR_INT_EN BIT(5)
#define B_BE_FS_P0MB13_TXBCNOK_INT_EN BIT(4)
#define B_BE_FS_P0MB13_HIQWND_INT_EN BIT(3)
#define B_BE_FS_P0MB13_TBTT_INT_EN BIT(2)
#define B_BE_FS_P0MB13_TBTTERLY_INT_EN BIT(1)
#define B_BE_FS_P0MB13_BCNERLY_INT_EN BIT(0)

#define R_BE_FWC09ISR 0xC14C
#define R_BE_FWC09ISR_C1 0xE14C
#define B_BE_FS_P0MB15_TXBCNERR_INT BIT(21)
#define B_BE_FS_P0MB15_TXBCNOK_INT BIT(20)
#define B_BE_FS_P0MB15_HIQWND_INT BIT(19)
#define B_BE_FS_P0MB15_TBTT_INT BIT(18)
#define B_BE_FS_P0MB15_TBTTERLY_INT BIT(17)
#define B_BE_FS_P0MB15_BCNERLY_INT BIT(16)
#define B_BE_FS_P0MB14_TXBCNERR_INT BIT(13)
#define B_BE_FS_P0MB14_TXBCNOK_INT BIT(12)
#define B_BE_FS_P0MB14_HIQWND_INT BIT(11)
#define B_BE_FS_P0MB14_TBTT_INT BIT(10)
#define B_BE_FS_P0MB14_TBTTERLY_INT BIT(9)
#define B_BE_FS_P0MB14_BCNERLY_INT BIT(8)
#define B_BE_FS_P0MB13_TXBCNERR_INT BIT(5)
#define B_BE_FS_P0MB13_TXBCNOK_INT BIT(4)
#define B_BE_FS_P0MB13_HIQWND_INT BIT(3)
#define B_BE_FS_P0MB13_TBTT_INT BIT(2)
#define B_BE_FS_P0MB13_TBTTERLY_INT BIT(1)
#define B_BE_FS_P0MB13_BCNERLY_INT BIT(0)

#define R_BE_FWC0AIMR 0xC150
#define R_BE_FWC0AIMR_C1 0xE150
#define B_BE_FS_PPS1_CTWEND_INT_EN BIT(15)
#define B_BE_FS_PPS1_TSF32_TOGL_INT_EN BIT(14)
#define B_BE_FS_PPS1_PON_ERLY_INT_EN BIT(13)
#define B_BE_FS_PPS1_POF_ERLY_INT_EN BIT(12)
#define B_BE_FS_PPS1_PON_INT_EN BIT(11)
#define B_BE_FS_PPS1_POF_INT_EN BIT(10)
#define B_BE_FS_PPS0_CTWEND_INT_EN BIT(5)
#define B_BE_FS_PPS0_TSF32_TOGL_INT_EN BIT(4)
#define B_BE_FS_PPS0_PON_ERLY_INT_EN BIT(3)
#define B_BE_FS_PPS0_POF_ERLY_INT_EN BIT(2)
#define B_BE_FS_PPS0_PON_INT_EN BIT(1)
#define B_BE_FS_PPS0_POF_INT_EN BIT(0)

#define R_BE_FWC0AISR 0xC154
#define R_BE_FWC0AISR_C1 0xE154
#define B_BE_FS_PPS1_CTWEND_INT BIT(15)
#define B_BE_FS_PPS1_TSF32_TOGL_INT BIT(14)
#define B_BE_FS_PPS1_PON_ERLY_INT BIT(13)
#define B_BE_FS_PPS1_POF_ERLY_INT BIT(12)
#define B_BE_FS_PPS1_PON_INT BIT(11)
#define B_BE_FS_PPS1_POF_INT BIT(10)
#define B_BE_FS_PPS0_CTWEND_INT BIT(5)
#define B_BE_FS_PPS0_TSF32_TOGL_INT BIT(4)
#define B_BE_FS_PPS0_PON_ERLY_INT BIT(3)
#define B_BE_FS_PPS0_POF_ERLY_INT BIT(2)
#define B_BE_FS_PPS0_PON_INT BIT(1)
#define B_BE_FS_PPS0_POF_INT BIT(0)
#define B_BE_RDATA_158_SH 0
#define B_BE_RDATA_158_MSK 0xffffffffL
#define B_BE_RDATA_15C_SH 0
#define B_BE_RDATA_15C_MSK 0xffffffffL

#define R_BE_CMAC_ERR_IMR 0xC160
#define R_BE_CMAC_ERR_IMR_C1 0xE160
#define B_BE_CMAC_FW_ERR_IDCT_EN BIT(16)
#define B_BE_PTCL_TX_IDLETO_IDCT_EN BIT(9)
#define B_BE_WMAC_RX_IDLETO_IDCT_EN BIT(8)
#define B_BE_WMAC_TX_ERR_IND_EN BIT(7)
#define B_BE_WMAC_RX_ERR_IND_EN BIT(6)
#define B_BE_TXPWR_CTRL_ERR_IND_EN BIT(5)
#define B_BE_PHYINTF_ERR_IND_EN BIT(4)
#define B_BE_DMA_TOP_ERR_IND_EN BIT(3)
#define B_BE_PTCL_TOP_ERR_IND_EN BIT(1)
#define B_BE_SCHEDULE_TOP_ERR_IND_EN BIT(0)

#define R_BE_CMAC_ERR_ISR 0xC164
#define R_BE_CMAC_ERR_ISR_C1 0xE164
#define B_BE_CMAC_FW_ERR_IDCT BIT(16)
#define B_BE_PTCL_TX_IDLETO_IDCT BIT(9)
#define B_BE_WMAC_RX_IDLETO_IDCT BIT(8)
#define B_BE_WMAC_TX_ERR_IND BIT(7)
#define B_BE_WMAC_RX_ERR_IND BIT(6)
#define B_BE_TXPWR_CTRL_ERR_IND BIT(5)
#define B_BE_PHYINTF_ERR_IND BIT(4)
#define B_BE_DMA_TOP_ERR_IND BIT(3)
#define B_BE_PTCL_TOP_ERR_IND BIT(1)
#define B_BE_SCHEDULE_TOP_ERR_IND BIT(0)

#define R_BE_HC00IMR 0xC180
#define R_BE_HC00IMR_C1 0xE180
#define B_BE_TBTT_B0P4_INT_EN BIT(16)
#define B_BE_TBTT_B0P3_INT_EN BIT(15)
#define B_BE_TBTT_B0P2_INT_EN BIT(14)
#define B_BE_TBTT_B0P1_INT_EN BIT(13)
#define B_BE_TBTT_B0P0_INT_EN BIT(12)
#define B_BE_PKT_INFO_ERR_INT_EN BIT(11)
#define B_BE_BB_STOPRX_INT_EN BIT(10)
#define B_BE_TXERR_INT_EN BIT(9)
#define B_BE_RXERR_INT_EN BIT(8)
#define B_BE_P2P1_TSF32_TOGG_INT_EN BIT(7)
#define B_BE_P2P0_TSF32_TOGG_INT_EN BIT(6)
#define B_BE_PWR_127TO96_INT_EN BIT(5)
#define B_BE_PWR_95TO64_INT_EN BIT(4)
#define B_BE_PWR_63TO32_INT_EN BIT(3)
#define B_BE_PWR_31TO0_INT_EN BIT(2)
#define B_BE_PSTIMER_5_INT_EN BIT(1)
#define B_BE_PSTIMER_4_INT_EN BIT(0)

#define R_BE_HC00ISR 0xC184
#define R_BE_HC00ISR_C1 0xE184
#define B_BE_TBTT_B0P4_INT BIT(16)
#define B_BE_TBTT_B0P3_INT BIT(15)
#define B_BE_TBTT_B0P2_INT BIT(14)
#define B_BE_TBTT_B0P1_INT BIT(13)
#define B_BE_TBTT_B0P0_INT BIT(12)
#define B_BE_PKT_INFO_ERR_INT BIT(11)
#define B_BE_BB_STOPRX_INT BIT(10)
#define B_BE_TXERR_INT BIT(9)
#define B_BE_RXERR_INT BIT(8)
#define B_BE_P2P1_TSF32_TOGG_INT BIT(7)
#define B_BE_P2P0_TSF32_TOGG_INT BIT(6)
#define B_BE_PWR_127TO96_INT BIT(5)
#define B_BE_PWR_95TO64_INT BIT(4)
#define B_BE_PWR_63TO32_INT BIT(3)
#define B_BE_PWR_31TO0_INT BIT(2)
#define B_BE_PSTIMER_5_INT BIT(1)
#define B_BE_PSTIMER_4_INT BIT(0)

//
// SCH
//

#define R_BE_PPS0_CTRL 0xC200
#define R_BE_PPS0_CTRL_C1 0xE200
#define B_BE_PPS0_PWR_RST1 BIT(31)
#define B_BE_PPS0_PWR_RST0 BIT(30)
#define B_BE_PPS0_CTWIN_SH 16
#define B_BE_PPS0_CTWIN_MSK 0xfff
#define B_BE_PPS0_TXOP_BRK_EN BIT(15)
#define B_BE_PPS0_AGG_BRK_EN BIT(14)
#define B_BE_PPS0_POF_AND_EN BIT(13)
#define B_BE_PPS0_PSWIND_EN BIT(12)
#define B_BE_PPS0_TSFB32_RST_EN BIT(11)
#define B_BE_PPS0_PORT_SEL_SH 8
#define B_BE_PPS0_PORT_SEL_MSK 0x7
#define B_BE_PPS0_ALLSLEEP_EN BIT(7)
#define B_BE_PPS0_OFF_DISTX_EN BIT(6)
#define B_BE_PPS0_CTWIN_EN BIT(5)
#define B_BE_PPS0_BCNAREA_EN BIT(4)
#define B_BE_PPS0_WITHBCNERY BIT(3)
#define B_BE_PPS0_POF1_EN BIT(2)
#define B_BE_PPS0_POF0_EN BIT(1)
#define B_BE_PPS0_PWR_MGT_EN BIT(0)

#define R_BE_PPS0_SPEC_STATE 0xC204
#define R_BE_PPS0_SPEC_STATE_C1 0xE204
#define B_BE_PPS0_SPEC_POW_STATE BIT(7)
#define B_BE_PPS0_SPEC_CTWIN_ON BIT(6)
#define B_BE_PPS0_SPEC_BCNAREA_ON BIT(5)
#define B_BE_PPS0_SPEC_BCNERLY BIT(4)
#define B_BE_PPS0_SPEC_POF1_OFF_PERD BIT(3)
#define B_BE_PPS0_SPEC_FORCE_DOZE1 BIT(2)
#define B_BE_PPS0_SPEC_POF0_OFF_PERD BIT(1)
#define B_BE_PPS0_SPEC_FORCE_DOZE0 BIT(0)

#define R_BE_PPS0_STATE 0xC205
#define R_BE_PPS0_STATE_C1 0xE205
#define B_BE_PPS0_POW_STATE BIT(7)
#define B_BE_PPS0_CTWIN_ON BIT(6)
#define B_BE_PPS0_BCNAREA_ON BIT(5)
#define B_BE_PPS0_BCNERLY BIT(4)
#define B_BE_PPS0_POF1_OFF_PERD BIT(3)
#define B_BE_PPS0_FORCE_DOZE1 BIT(2)
#define B_BE_PPS0_POF0_OFF_PERD BIT(1)
#define B_BE_PPS0_FORCE_DOZE0 BIT(0)

#define R_BE_PPS0_PAUSE_CTRL0 0xC206
#define R_BE_PPS0_PAUSE_CTRL0_C1 0xE206
#define B_BE_PPS0_POF_STOP_TX_HANG BIT(15)
#define B_BE_PPS0_MGQ_PAUSE_EN BIT(11)
#define B_BE_PPS0_HIQ_PAUSE_EN BIT(10)
#define B_BE_PPS0_BCNQ_PAUSE_EN BIT(9)
#define B_BE_PPS0_MACID_PAUSE_EN BIT(8)
#define B_BE_PPS0_PAUSE_MACID_SH 0
#define B_BE_PPS0_PAUSE_MACID_MSK 0xff

#define R_BE_PPS0_PAUSE_CTRL1 0xC208
#define R_BE_PPS0_PAUSE_CTRL1_C1 0xE208
#define B_BE_PPS0_POWON_DISTX_SH 16
#define B_BE_PPS0_POWON_DISTX_MSK 0xffff
#define B_BE_PPS0_POWOFF_DISTX_SH 0
#define B_BE_PPS0_POWOFF_DISTX_MSK 0xffff

#define R_BE_PPS0_PAUSE_CTRL2 0xC20C
#define R_BE_PPS0_PAUSE_CTRL2_C1 0xE20C
#define B_BE_PPS0_POWOFF_ERLY_SH 16
#define B_BE_PPS0_POWOFF_ERLY_MSK 0xffff
#define B_BE_PPS0_POWON_ERLY_SH 0
#define B_BE_PPS0_POWON_ERLY_MSK 0xffff

#define R_BE_PPS0_POF0_PARAM0 0xC210
#define R_BE_PPS0_POF0_PARAM0_C1 0xE210
#define B_BE_PPS0_POF0_DUR_SH 0
#define B_BE_PPS0_POF0_DUR_MSK 0xffffffffL

#define R_BE_PPS0_POF0_PARAM1 0xC214
#define R_BE_PPS0_POF0_PARAM1_C1 0xE214
#define B_BE_PPS0_POF0_ITVL_SH 0
#define B_BE_PPS0_POF0_ITVL_MSK 0xffffffffL

#define R_BE_PPS0_POF0_PARAM2 0xC218
#define R_BE_PPS0_POF0_PARAM2_C1 0xE218
#define B_BE_PPS0_POF0_START_SH 0
#define B_BE_PPS0_POF0_START_MSK 0xffffffffL

#define R_BE_PPS0_POF0_PARAM3 0xC21C
#define R_BE_PPS0_POF0_PARAM3_C1 0xE21C
#define B_BE_PPS0_POF0_CUR_CNT_SH 8
#define B_BE_PPS0_POF0_CUR_CNT_MSK 0xff
#define B_BE_PPS0_POF0_CNT_SH 0
#define B_BE_PPS0_POF0_CNT_MSK 0xff

#define R_BE_PPS0_POF1_PARAM0 0xC220
#define R_BE_PPS0_POF1_PARAM0_C1 0xE220
#define B_BE_PPS0_POF1_DUR_SH 0
#define B_BE_PPS0_POF1_DUR_MSK 0xffffffffL

#define R_BE_PPS0_POF1_PARAM1 0xC224
#define R_BE_PPS0_POF1_PARAM1_C1 0xE224
#define B_BE_PPS0_POF1_ITVL_SH 0
#define B_BE_PPS0_POF1_ITVL_MSK 0xffffffffL

#define R_BE_PPS0_POF1_PARAM2 0xC228
#define R_BE_PPS0_POF1_PARAM2_C1 0xE228
#define B_BE_PPS0_POF1_START_SH 0
#define B_BE_PPS0_POF1_START_MSK 0xffffffffL

#define R_BE_PPS0_POF1_PARAM3 0xC22C
#define R_BE_PPS0_POF1_PARAM3_C1 0xE22C
#define B_BE_PPS0_POF1_CUR_CNT_SH 8
#define B_BE_PPS0_POF1_CUR_CNT_MSK 0xff
#define B_BE_PPS0_POF1_CNT_SH 0
#define B_BE_PPS0_POF1_CNT_MSK 0xff

#define R_BE_PPS0_CURR_DOZE0 0xC230
#define R_BE_PPS0_CURR_DOZE0_C1 0xE230
#define B_BE_PPS0_POF0_CURR_DOZE_SH 0
#define B_BE_PPS0_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_BE_PPS0_CURR_DOZE1 0xC234
#define R_BE_PPS0_CURR_DOZE1_C1 0xE234
#define B_BE_PPS0_POF1_CURR_DOZE_SH 0
#define B_BE_PPS0_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_BE_PPS1_CTRL 0xC240
#define R_BE_PPS1_CTRL_C1 0xE240
#define B_BE_PPS1_PWR_RST1 BIT(31)
#define B_BE_PPS1_PWR_RST0 BIT(30)
#define B_BE_PPS1_CTWIN_SH 16
#define B_BE_PPS1_CTWIN_MSK 0xfff
#define B_BE_PPS1_TXOP_BRK_EN BIT(15)
#define B_BE_PPS1_AGG_BRK_EN BIT(14)
#define B_BE_PPS1_POF_AND_EN BIT(13)
#define B_BE_PPS1_PSWIND_EN BIT(12)
#define B_BE_PPS1_TSFB32_RST_EN BIT(11)
#define B_BE_PPS1_PORT_SEL_SH 8
#define B_BE_PPS1_PORT_SEL_MSK 0x7
#define B_BE_PPS1_ALLSLEEP_EN BIT(7)
#define B_BE_PPS1_OFF_DISTX_EN BIT(6)
#define B_BE_PPS1_CTWIN_EN BIT(5)
#define B_BE_PPS1_BCNAREA_EN BIT(4)
#define B_BE_PPS1_WITHBCNERY BIT(3)
#define B_BE_PPS1_POF1_EN BIT(2)
#define B_BE_PPS1_POF0_EN BIT(1)
#define B_BE_PPS1_PWR_MGT_EN BIT(0)

#define R_BE_PPS1_SPEC_STATE 0xC244
#define R_BE_PPS1_SPEC_STATE_C1 0xE244
#define B_BE_PPS1_SPEC_POW_STATE BIT(7)
#define B_BE_PPS1_SPEC_CTWIN_ON BIT(6)
#define B_BE_PPS1_SPEC_BCNAREA_ON BIT(5)
#define B_BE_PPS1_SPEC_BCNERLY BIT(4)
#define B_BE_PPS1_SPEC_POF1_OFF_PERD BIT(3)
#define B_BE_PPS1_SPEC_FORCE_DOZE1 BIT(2)
#define B_BE_PPS1_SPEC_POF0_OFF_PERD BIT(1)
#define B_BE_PPS1_SPEC_FORCE_DOZE0 BIT(0)

#define R_BE_PPS1_STATE 0xC245
#define R_BE_PPS1_STATE_C1 0xE245
#define B_BE_PPS1_POW_STATE BIT(7)
#define B_BE_PPS1_CTWIN_ON BIT(6)
#define B_BE_PPS1_BCNAREA_ON BIT(5)
#define B_BE_PPS1_BCNERLY BIT(4)
#define B_BE_PPS1_POF1_OFF_PERD BIT(3)
#define B_BE_PPS1_FORCE_DOZE1 BIT(2)
#define B_BE_PPS1_POF0_OFF_PERD BIT(1)
#define B_BE_PPS1_FORCE_DOZE0 BIT(0)

#define R_BE_PPS1_PAUSE_CTRL0 0xC246
#define R_BE_PPS1_PAUSE_CTRL0_C1 0xE246
#define B_BE_PPS1_POF_STOP_TX_HANG BIT(15)
#define B_BE_PPS1_MGQ_PAUSE_EN BIT(11)
#define B_BE_PPS1_HIQ_PAUSE_EN BIT(10)
#define B_BE_PPS1_BCNQ_PAUSE_EN BIT(9)
#define B_BE_PPS1_MACID_PAUSE_EN BIT(8)
#define B_BE_PPS1_PAUSE_MACID_SH 0
#define B_BE_PPS1_PAUSE_MACID_MSK 0xff

#define R_BE_PPS1_PAUSE_CTRL1 0xC248
#define R_BE_PPS1_PAUSE_CTRL1_C1 0xE248
#define B_BE_PPS1_POWON_DISTX_SH 16
#define B_BE_PPS1_POWON_DISTX_MSK 0xffff
#define B_BE_PPS1_POWOFF_DISTX_SH 0
#define B_BE_PPS1_POWOFF_DISTX_MSK 0xffff

#define R_BE_PPS1_PAUSE_CTRL2 0xC24C
#define R_BE_PPS1_PAUSE_CTRL2_C1 0xE24C
#define B_BE_PPS1_POWOFF_ERLY_SH 16
#define B_BE_PPS1_POWOFF_ERLY_MSK 0xffff
#define B_BE_PPS1_POWON_ERLY_SH 0
#define B_BE_PPS1_POWON_ERLY_MSK 0xffff

#define R_BE_PPS1_POF0_PARAM0 0xC250
#define R_BE_PPS1_POF0_PARAM0_C1 0xE250
#define B_BE_PPS1_POF0_DUR_SH 0
#define B_BE_PPS1_POF0_DUR_MSK 0xffffffffL

#define R_BE_PPS1_POF0_PARAM1 0xC254
#define R_BE_PPS1_POF0_PARAM1_C1 0xE254
#define B_BE_PPS1_POF0_ITVL_SH 0
#define B_BE_PPS1_POF0_ITVL_MSK 0xffffffffL

#define R_BE_PPS1_POF0_PARAM2 0xC258
#define R_BE_PPS1_POF0_PARAM2_C1 0xE258
#define B_BE_PPS1_POF0_START_SH 0
#define B_BE_PPS1_POF0_START_MSK 0xffffffffL

#define R_BE_PPS1_POF0_PARAM3 0xC25C
#define R_BE_PPS1_POF0_PARAM3_C1 0xE25C
#define B_BE_PPS1_POF0_CUR_CNT_SH 8
#define B_BE_PPS1_POF0_CUR_CNT_MSK 0xff
#define B_BE_PPS1_POF0_CNT_SH 0
#define B_BE_PPS1_POF0_CNT_MSK 0xff

#define R_BE_PPS1_POF1_PARAM0 0xC260
#define R_BE_PPS1_POF1_PARAM0_C1 0xE260
#define B_BE_PPS1_POF1_DUR_SH 0
#define B_BE_PPS1_POF1_DUR_MSK 0xffffffffL

#define R_BE_PPS1_POF1_PARAM1 0xC264
#define R_BE_PPS1_POF1_PARAM1_C1 0xE264
#define B_BE_PPS1_POF1_ITVL_SH 0
#define B_BE_PPS1_POF1_ITVL_MSK 0xffffffffL

#define R_BE_PPS1_POF1_PARAM2 0xC268
#define R_BE_PPS1_POF1_PARAM2_C1 0xE268
#define B_BE_PPS1_POF1_START_SH 0
#define B_BE_PPS1_POF1_START_MSK 0xffffffffL

#define R_BE_PPS1_POF1_PARAM3 0xC26C
#define R_BE_PPS1_POF1_PARAM3_C1 0xE26C
#define B_BE_PPS1_POF1_CUR_CNT_SH 8
#define B_BE_PPS1_POF1_CUR_CNT_MSK 0xff
#define B_BE_PPS1_POF1_CNT_SH 0
#define B_BE_PPS1_POF1_CNT_MSK 0xff

#define R_BE_PPS1_CURR_DOZE0 0xC270
#define R_BE_PPS1_CURR_DOZE0_C1 0xE270
#define B_BE_PPS1_POF0_CURR_DOZE_SH 0
#define B_BE_PPS1_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_BE_PPS1_CURR_DOZE1 0xC274
#define R_BE_PPS1_CURR_DOZE1_C1 0xE274
#define B_BE_PPS1_POF1_CURR_DOZE_SH 0
#define B_BE_PPS1_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_BE_PORT_0_TSF_SYNC 0xC2A0
#define R_BE_PORT_0_TSF_SYNC_C1 0xE2A0
#define B_BE_P0_SYNC_NOW_P BIT(30)
#define B_BE_P0_SYNC_ONCE_P BIT(29)
#define B_BE_P0_AUTO_SYNC BIT(28)
#define B_BE_P0_SYNC_PORT_SRC_SEL_SH 24
#define B_BE_P0_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_BE_P0_TSFTR_SYNC_OFFSET_SH 0
#define B_BE_P0_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_BE_PORT_1_TSF_SYNC 0xC2A4
#define R_BE_PORT_1_TSF_SYNC_C1 0xE2A4
#define B_BE_P1_SYNC_NOW_P BIT(30)
#define B_BE_P1_SYNC_ONCE_P BIT(29)
#define B_BE_P1_AUTO_SYNC BIT(28)
#define B_BE_P1_SYNC_PORT_SRC_SEL_SH 24
#define B_BE_P1_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_BE_P1_TSFTR_SYNC_OFFSET_SH 0
#define B_BE_P1_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_BE_PORT_2_TSF_SYNC 0xC2A8
#define R_BE_PORT_2_TSF_SYNC_C1 0xE2A8
#define B_BE_P2_SYNC_NOW_P BIT(30)
#define B_BE_P2_SYNC_ONCE_P BIT(29)
#define B_BE_P2_AUTO_SYNC BIT(28)
#define B_BE_P2_SYNC_PORT_SRC_SEL_SH 24
#define B_BE_P2_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_BE_P2_TSFTR_SYNC_OFFSET_SH 0
#define B_BE_P2_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_BE_PORT_3_TSF_SYNC 0xC2AC
#define R_BE_PORT_3_TSF_SYNC_C1 0xE2AC
#define B_BE_P3_SYNC_NOW_P BIT(30)
#define B_BE_P3_SYNC_ONCE_P BIT(29)
#define B_BE_P3_AUTO_SYNC BIT(28)
#define B_BE_P3_SYNC_PORT_SRC_SEL_SH 24
#define B_BE_P3_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_BE_P3_TSFTR_SYNC_OFFSET_SH 0
#define B_BE_P3_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_BE_PORT_4_TSF_SYNC 0xC2B0
#define R_BE_PORT_4_TSF_SYNC_C1 0xE2B0
#define B_BE_P4_SYNC_NOW_P BIT(30)
#define B_BE_P4_SYNC_ONCE_P BIT(29)
#define B_BE_P4_AUTO_SYNC BIT(28)
#define B_BE_P4_SYNC_PORT_SRC_SEL_SH 24
#define B_BE_P4_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_BE_P4_TSFTR_SYNC_OFFSET_SH 0
#define B_BE_P4_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_BE_MACID_SLEEP_0 0xC2C0
#define R_BE_MACID_SLEEP_0_C1 0xE2C0
#define B_BE_MACID31_0_SLEEP_SH 0
#define B_BE_MACID31_0_SLEEP_MSK 0xffffffffL

#define R_BE_MACID_SLEEP_1 0xC2C4
#define R_BE_MACID_SLEEP_1_C1 0xE2C4
#define B_BE_MACID63_32_SLEEP_SH 0
#define B_BE_MACID63_32_SLEEP_MSK 0xffffffffL

#define R_BE_MACID_SLEEP_2 0xC2C8
#define R_BE_MACID_SLEEP_2_C1 0xE2C8
#define B_BE_MACID95_64_SLEEP_SH 0
#define B_BE_MACID95_64_SLEEP_MSK 0xffffffffL

#define R_BE_MACID_SLEEP_3 0xC2CC
#define R_BE_MACID_SLEEP_3_C1 0xE2CC
#define B_BE_MACID127_96_SLEEP_SH 0
#define B_BE_MACID127_96_SLEEP_MSK 0xffffffffL

#define R_BE_MACID_SLEEP_4 0xC2D0
#define R_BE_MACID_SLEEP_4_C1 0xE2D0

#define R_BE_MACID_SLEEP_5 0xC2D4
#define R_BE_MACID_SLEEP_5_C1 0xE2D4

#define R_BE_MACID_SLEEP_6 0xC2D8
#define R_BE_MACID_SLEEP_6_C1 0xE2D8

#define R_BE_MACID_SLEEP_7 0xC2DC
#define R_BE_MACID_SLEEP_7_C1 0xE2DC

#define R_BE_CMAC_MACID_DROP_0 0xC2E0
#define R_BE_CMAC_MACID_DROP_0_C1 0xE2E0
#define B_BE_CMAC_MGQ_MACID31_0_DROP_SH 0
#define B_BE_CMAC_MGQ_MACID31_0_DROP_MSK 0xffffffffL

#define R_BE_CMAC_MACID_DROP_1 0xC2E4
#define R_BE_CMAC_MACID_DROP_1_C1 0xE2E4
#define B_BE_CMAC_MGQ_MACID63_32_DROP_SH 0
#define B_BE_CMAC_MGQ_MACID63_32_DROP_MSK 0xffffffffL

#define R_BE_CMAC_MACID_DROP_2 0xC2E8
#define R_BE_CMAC_MACID_DROP_2_C1 0xE2E8
#define B_BE_CMAC_MGQ_MACID95_64_DROP_SH 0
#define B_BE_CMAC_MGQ_MACID95_64_DROP_MSK 0xffffffffL

#define R_BE_CMAC_MACID_DROP_3 0xC2EC
#define R_BE_CMAC_MACID_DROP_3_C1 0xE2EC
#define B_BE_CMAC_MGQ_MACID127_96_DROP_SH 0
#define B_BE_CMAC_MGQ_MACID127_96_DROP_MSK 0xffffffffL

#define R_BE_CMAC_MACID_DROP_4 0xC2F0
#define R_BE_CMAC_MACID_DROP_4_C1 0xE2F0

#define R_BE_CMAC_MACID_DROP_5 0xC2F4
#define R_BE_CMAC_MACID_DROP_5_C1 0xE2F4

#define R_BE_CMAC_MACID_DROP_6 0xC2F8
#define R_BE_CMAC_MACID_DROP_6_C1 0xE2F8

#define R_BE_CMAC_MACID_DROP_7 0xC2FC
#define R_BE_CMAC_MACID_DROP_7_C1 0xE2FC

#define R_BE_EDCA_BE_PARAM_0 0xC300
#define R_BE_EDCA_BE_PARAM_0_C1 0xE300
#define B_BE_BE_0_TXOPLMT_SH 16
#define B_BE_BE_0_TXOPLMT_MSK 0x7ff
#define B_BE_BE_0_CW_SH 8
#define B_BE_BE_0_CW_MSK 0xff
#define B_BE_BE_0_AIFS_SH 0
#define B_BE_BE_0_AIFS_MSK 0xff

#define R_BE_EDCA_BK_PARAM_0 0xC304
#define R_BE_EDCA_BK_PARAM_0_C1 0xE304
#define B_BE_BK_0_TXOPLMT_SH 16
#define B_BE_BK_0_TXOPLMT_MSK 0x7ff
#define B_BE_BK_0_CW_SH 8
#define B_BE_BK_0_CW_MSK 0xff
#define B_BE_BK_0_AIFS_SH 0
#define B_BE_BK_0_AIFS_MSK 0xff

#define R_BE_EDCA_VI_PARAM_0 0xC308
#define R_BE_EDCA_VI_PARAM_0_C1 0xE308
#define B_BE_VI_0_TXOPLMT_SH 16
#define B_BE_VI_0_TXOPLMT_MSK 0x7ff
#define B_BE_VI_0_CW_SH 8
#define B_BE_VI_0_CW_MSK 0xff
#define B_BE_VI_0_AIFS_SH 0
#define B_BE_VI_0_AIFS_MSK 0xff

#define R_BE_EDCA_VO_PARAM_0 0xC30C
#define R_BE_EDCA_VO_PARAM_0_C1 0xE30C
#define B_BE_VO_0_TXOPLMT_SH 16
#define B_BE_VO_0_TXOPLMT_MSK 0x7ff
#define B_BE_VO_0_CW_SH 8
#define B_BE_VO_0_CW_MSK 0xff
#define B_BE_VO_0_AIFS_SH 0
#define B_BE_VO_0_AIFS_MSK 0xff

#define R_BE_EDCA_BE_PARAM_1 0xC310
#define R_BE_EDCA_BE_PARAM_1_C1 0xE310
#define B_BE_BE_1_TXOPLMT_SH 16
#define B_BE_BE_1_TXOPLMT_MSK 0x7ff
#define B_BE_BE_1_CW_SH 8
#define B_BE_BE_1_CW_MSK 0xff
#define B_BE_BE_1_AIFS_SH 0
#define B_BE_BE_1_AIFS_MSK 0xff

#define R_BE_EDCA_BK_PARAM_1 0xC314
#define R_BE_EDCA_BK_PARAM_1_C1 0xE314
#define B_BE_BK_1_TXOPLMT_SH 16
#define B_BE_BK_1_TXOPLMT_MSK 0x7ff
#define B_BE_BK_1_CW_SH 8
#define B_BE_BK_1_CW_MSK 0xff
#define B_BE_BK_1_AIFS_SH 0
#define B_BE_BK_1_AIFS_MSK 0xff

#define R_BE_EDCA_VI_PARAM_1 0xC318
#define R_BE_EDCA_VI_PARAM_1_C1 0xE318
#define B_BE_VI_1_TXOPLMT_SH 16
#define B_BE_VI_1_TXOPLMT_MSK 0x7ff
#define B_BE_VI_1_CW_SH 8
#define B_BE_VI_1_CW_MSK 0xff
#define B_BE_VI_1_AIFS_SH 0
#define B_BE_VI_1_AIFS_MSK 0xff

#define R_BE_EDCA_VO_PARAM_1 0xC31C
#define R_BE_EDCA_VO_PARAM_1_C1 0xE31C
#define B_BE_VO_1_TXOPLMT_SH 16
#define B_BE_VO_1_TXOPLMT_MSK 0x7ff
#define B_BE_VO_1_CW_SH 8
#define B_BE_VO_1_CW_MSK 0xff
#define B_BE_VO_1_AIFS_SH 0
#define B_BE_VO_1_AIFS_MSK 0xff

#define R_BE_EDCA_MGQ_PARAM 0xC320
#define R_BE_EDCA_MGQ_PARAM_C1 0xE320
#define B_BE_CPUMGQ_CW_SH 24
#define B_BE_CPUMGQ_CW_MSK 0xff
#define B_BE_CPUMGQ_AIFS_SH 16
#define B_BE_CPUMGQ_AIFS_MSK 0xff
#define B_BE_MGQ_CW_SH 8
#define B_BE_MGQ_CW_MSK 0xff
#define B_BE_MGQ_AIFS_SH 0
#define B_BE_MGQ_AIFS_MSK 0xff

#define R_BE_EDCA_BCNQ_PARAM 0xC324
#define R_BE_EDCA_BCNQ_PARAM_C1 0xE324
#define B_BE_BCNQ_CW_SH 24
#define B_BE_BCNQ_CW_MSK 0xff
#define B_BE_BCNQ_AIFS_SH 16
#define B_BE_BCNQ_AIFS_MSK 0xff
#define B_BE_PIFS_SH 8
#define B_BE_PIFS_MSK 0xff
#define B_BE_FORCE_BCN_IFS_SH 0
#define B_BE_FORCE_BCN_IFS_MSK 0xff

#define R_BE_EDCA_ULQ_PARAM 0xC328
#define R_BE_EDCA_ULQ_PARAM_C1 0xE328
#define B_BE_ULQ_TXOPLMT_SH 16
#define B_BE_ULQ_TXOPLMT_MSK 0x7ff
#define B_BE_ULQ_CW_SH 8
#define B_BE_ULQ_CW_MSK 0xff
#define B_BE_ULQ_AIFS_SH 0
#define B_BE_ULQ_AIFS_MSK 0xff

#define R_BE_EDCA_TWT_PARAM_0 0xC32C
#define R_BE_EDCA_TWT_PARAM_0_C1 0xE32C
#define B_BE_TWT_0_TXOPLMT_SH 16
#define B_BE_TWT_0_TXOPLMT_MSK 0x7ff
#define B_BE_TWT_0_CW_SH 8
#define B_BE_TWT_0_CW_MSK 0xff
#define B_BE_TWT_0_AIFS_SH 0
#define B_BE_TWT_0_AIFS_MSK 0xff

#define R_BE_EDCA_TWT_PARAM_1 0xC330
#define R_BE_EDCA_TWT_PARAM_1_C1 0xE330
#define B_BE_TWT_1_TXOPLMT_SH 16
#define B_BE_TWT_1_TXOPLMT_MSK 0x7ff
#define B_BE_TWT_1_CW_SH 8
#define B_BE_TWT_1_CW_MSK 0xff
#define B_BE_TWT_1_AIFS_SH 0
#define B_BE_TWT_1_AIFS_MSK 0xff

#define R_BE_SLOTTIME_CFG 0xC334
#define R_BE_SLOTTIME_CFG_C1 0xE334
#define B_BE_SLOT_EXT_THD_SH 24
#define B_BE_SLOT_EXT_THD_MSK 0xf
#define B_BE_BURST_CNT_DOWN_TIME_SH 16
#define B_BE_BURST_CNT_DOWN_TIME_MSK 0x7f
#define B_BE_US_TIME_SH 8
#define B_BE_US_TIME_MSK 0xff
#define B_BE_SLOT_TIME_SH 0
#define B_BE_SLOT_TIME_MSK 0xff

#define R_BE_PREBKF_CFG_0 0xC338
#define R_BE_PREBKF_CFG_0_C1 0xE338
#define B_BE_100NS_TIME_SH 24
#define B_BE_100NS_TIME_MSK 0x1f
#define B_BE_RX_AIR_END_TIME_SH 16
#define B_BE_RX_AIR_END_TIME_MSK 0x7f
#define B_BE_MACTX_LATENCY_SH 8
#define B_BE_MACTX_LATENCY_MSK 0x7
#define B_BE_PREBKF_TIME_SH 0
#define B_BE_PREBKF_TIME_MSK 0x1f

#define R_BE_PREBKF_CFG_1 0xC33C
#define R_BE_PREBKF_CFG_1_C1 0xE33C
#define B_BE_SIFS_TIMEOUT_TB_AGGR_V1_SH 24
#define B_BE_SIFS_TIMEOUT_TB_AGGR_V1_MSK 0xff
#define B_BE_SIFS_PREBKF_SH 16
#define B_BE_SIFS_PREBKF_MSK 0xff
#define B_BE_SIFS_TIMEOUT_T2_SH 8
#define B_BE_SIFS_TIMEOUT_T2_MSK 0x7f
#define B_BE_SIFS_MACTXEN_T1_SH 0
#define B_BE_SIFS_MACTXEN_T1_MSK 0x7f

#define R_BE_CCA_CFG_0 0xC340
#define R_BE_CCA_CFG_0_C1 0xE340
#define B_BE_R_SIFS_AGGR_TIME_V1_SH 24
#define B_BE_R_SIFS_AGGR_TIME_V1_MSK 0xff
#define B_BE_TXPKTCTL_RST_EDCA_EN BIT(17)
#define B_BE_WMAC_RST_EDCA_EN BIT(16)
#define B_BE_EDCCA_PER20_BITMAP_SIFS_EN BIT(10)
#define B_BE_BTCCA_BRK_TXOP_EN BIT(9)
#define B_BE_NAV_BRK_TXOP_EN BIT(8)
#define B_BE_TX_NAV_EN BIT(7)
#define B_BE_BCN_IGNORE_EDCCA BIT(6)
#define B_BE_BTCCA_EN BIT(5)
#define B_BE_EDCCA_EN BIT(4)
#define B_BE_SEC80_EN BIT(3)
#define B_BE_SEC40_EN BIT(2)
#define B_BE_SEC20_EN BIT(1)
#define B_BE_CCA_EN BIT(0)

#define R_BE_MISC_0 0xC344
#define R_BE_MISC_0_C1 0xE344
#define B_BE_SCH_DBG_FORCE_ABORT_CNT_SH 24
#define B_BE_SCH_DBG_FORCE_ABORT_CNT_MSK 0xf
#define B_BE_CMAC_SHARE_DBG_SEL_SH 16
#define B_BE_CMAC_SHARE_DBG_SEL_MSK 0xf
#define B_BE_RST_FREERUN_P BIT(15)
#define B_BE_SCH_ABORT_BRK_TB_EN BIT(12)
#define B_BE_SCH_ABORT_BRK_BURST_EN BIT(11)
#define B_BE_PORT_FUNC_EN_LOW_AUTO_RST BIT(10)
#define B_BE_SCH_CLK_GATING_DIS BIT(9)
#define B_BE_EN_FREERUN BIT(8)
#define B_BE_SCH_DBG_RST_EDCA_CLR_P BIT(7)
#define B_BE_SCH_DBG_RST_EDCA_EN BIT(6)
#define B_BE_SCH_FORCE_ABORT_P BIT(3)
#define B_BE_SCH_FORCE_ABORT_AUTO_EN BIT(2)
#define B_BE_TXOP_RESP_EN BIT(1)
#define B_BE_EN_TBTT_AREA_FOR_BE_BB BIT(0)

#define R_BE_CTN_TXEN 0xC348
#define R_BE_CTN_TXEN_C1 0xE348
#define B_BE_CTN_TXEN_TWT_3 BIT(17)
#define B_BE_CTN_TXEN_TWT_2 BIT(16)
#define B_BE_CTN_TXEN_TWT_1 BIT(15)
#define B_BE_CTN_TXEN_TWT_0 BIT(14)
#define B_BE_CTN_TXEN_ULQ BIT(13)
#define B_BE_CTN_TXEN_BCNQ BIT(12)
#define B_BE_CTN_TXEN_HGQ BIT(11)
#define B_BE_CTN_TXEN_CPUMGQ BIT(10)
#define B_BE_CTN_TXEN_MGQ1 BIT(9)
#define B_BE_CTN_TXEN_MGQ BIT(8)
#define B_BE_CTN_TXEN_VO_1 BIT(7)
#define B_BE_CTN_TXEN_VI_1 BIT(6)
#define B_BE_CTN_TXEN_BK_1 BIT(5)
#define B_BE_CTN_TXEN_BE_1 BIT(4)
#define B_BE_CTN_TXEN_VO_0 BIT(3)
#define B_BE_CTN_TXEN_VI_0 BIT(2)
#define B_BE_CTN_TXEN_BK_0 BIT(1)
#define B_BE_CTN_TXEN_BE_0 BIT(0)

#define R_BE_CTN_CFG_0 0xC34C
#define R_BE_CTN_CFG_0_C1 0xE34C
#define B_BE_PREBKF_TIME_NONAC_SH 8
#define B_BE_PREBKF_TIME_NONAC_MSK 0x1f
#define B_BE_SR_TX_EN BIT(2)
#define B_BE_NAV_BLK_HGQ BIT(1)
#define B_BE_NAV_BLK_MGQ BIT(0)

#define R_BE_MUEDCA_BE_PARAM_0 0xC350
#define R_BE_MUEDCA_BE_PARAM_0_C1 0xE350
#define B_BE_MUEDCA_BE_PARAM_0_TIMER_SH 16
#define B_BE_MUEDCA_BE_PARAM_0_TIMER_MSK 0xffff
#define B_BE_MUEDCA_BE_PARAM_0_CW_SH 8
#define B_BE_MUEDCA_BE_PARAM_0_CW_MSK 0xff
#define B_BE_MUEDCA_BE_PARAM_0_AIFS_SH 0
#define B_BE_MUEDCA_BE_PARAM_0_AIFS_MSK 0xff

#define R_BE_MUEDCA_BK_PARAM_0 0xC354
#define R_BE_MUEDCA_BK_PARAM_0_C1 0xE354
#define B_BE_MUEDCA_BK_PARAM_0_TIMER_SH 16
#define B_BE_MUEDCA_BK_PARAM_0_TIMER_MSK 0xffff
#define B_BE_MUEDCA_BK_PARAM_0_CW_SH 8
#define B_BE_MUEDCA_BK_PARAM_0_CW_MSK 0xff
#define B_BE_MUEDCA_BK_PARAM_0_AIFS_SH 0
#define B_BE_MUEDCA_BK_PARAM_0_AIFS_MSK 0xff

#define R_BE_MUEDCA_VI_PARAM_0 0xC358
#define R_BE_MUEDCA_VI_PARAM_0_C1 0xE358
#define B_BE_MUEDCA_VI_PARAM_0_TIMER_SH 16
#define B_BE_MUEDCA_VI_PARAM_0_TIMER_MSK 0xffff
#define B_BE_MUEDCA_VI_PARAM_0_CW_SH 8
#define B_BE_MUEDCA_VI_PARAM_0_CW_MSK 0xff
#define B_BE_MUEDCA_VI_PARAM_0_AIFS_SH 0
#define B_BE_MUEDCA_VI_PARAM_0_AIFS_MSK 0xff

#define R_BE_MUEDCA_VO_PARAM_0 0xC35C
#define R_BE_MUEDCA_VO_PARAM_0_C1 0xE35C
#define B_BE_MUEDCA_VO_PARAM_0_TIMER_SH 16
#define B_BE_MUEDCA_VO_PARAM_0_TIMER_MSK 0xffff
#define B_BE_MUEDCA_VO_PARAM_0_CW_SH 8
#define B_BE_MUEDCA_VO_PARAM_0_CW_MSK 0xff
#define B_BE_MUEDCA_VO_PARAM_0_AIFS_SH 0
#define B_BE_MUEDCA_VO_PARAM_0_AIFS_MSK 0xff

#define R_BE_MUEDCA_EN 0xC370
#define R_BE_MUEDCA_EN_C1 0xE370
#define B_BE_MUEDCA_WMM_SEL BIT(8)
#define B_BE_SET_MUEDCATIMER_TF_1 BIT(5)
#define B_BE_SET_MUEDCATIMER_TF_0 BIT(4)
#define B_BE_MUEDCA_EN_0 BIT(0)

#define R_BE_RAND_SCR_BIT 0xC374
#define R_BE_RAND_SCR_BIT_C1 0xE374
#define B_BE_RAND_SCBITS_SH 0
#define B_BE_RAND_SCBITS_MSK 0x7fffff

#define R_BE_RANDOM_CFG 0xC378
#define R_BE_RANDOM_CFG_C1 0xE378
#define B_BE_RAND_SET_SH 0
#define B_BE_RAND_SET_MSK 0xffffff

#define R_BE_MUEDCATIMER_0 0xC380
#define R_BE_MUEDCATIMER_0_C1 0xE380
#define B_BE_MUEDCATIMER_BK_0_SH 16
#define B_BE_MUEDCATIMER_BK_0_MSK 0xffff
#define B_BE_MUEDCATIMER_BE_0_SH 0
#define B_BE_MUEDCATIMER_BE_0_MSK 0xffff

#define R_BE_MUEDCATIMER_1 0xC384
#define R_BE_MUEDCATIMER_1_C1 0xE384
#define B_BE_MUEDCATIMER_VO_0_SH 16
#define B_BE_MUEDCATIMER_VO_0_MSK 0xffff
#define B_BE_MUEDCATIMER_VI_0_SH 0
#define B_BE_MUEDCATIMER_VI_0_MSK 0xffff

#define R_BE_CCA_CONTROL 0xC390
#define R_BE_CCA_CONTROL_C1 0xE390
#define B_BE_TB_CHK_TX_NAV BIT(31)
#define B_BE_TB_CHK_BASIC_NAV BIT(30)
#define B_BE_TB_CHK_BTCCA BIT(29)
#define B_BE_TB_CHK_EDCCA BIT(28)
#define B_BE_TB_CHK_CCA_S80 BIT(27)
#define B_BE_TB_CHK_CCA_S40 BIT(26)
#define B_BE_TB_CHK_CCA_S20 BIT(25)
#define B_BE_TB_CHK_CCA_P20 BIT(24)
#define B_BE_SIFS_CHK_BTCCA BIT(21)
#define B_BE_SIFS_CHK_EDCCA BIT(20)
#define B_BE_SIFS_CHK_CCA_S80 BIT(19)
#define B_BE_SIFS_CHK_CCA_S40 BIT(18)
#define B_BE_SIFS_CHK_CCA_S20 BIT(17)
#define B_BE_SIFS_CHK_CCA_P20 BIT(16)
#define B_BE_CTN_CHK_TXNAV BIT(8)
#define B_BE_CTN_CHK_INTRA_NAV BIT(7)
#define B_BE_CTN_CHK_BASIC_NAV BIT(6)
#define B_BE_CTN_CHK_BTCCA BIT(5)
#define B_BE_CTN_CHK_EDCCA BIT(4)
#define B_BE_CTN_CHK_CCA_S80 BIT(3)
#define B_BE_CTN_CHK_CCA_S40 BIT(2)
#define B_BE_CTN_CHK_CCA_S20 BIT(1)
#define B_BE_CTN_CHK_CCA_P20 BIT(0)

#define R_BE_CCA_CONTROL_2 0xC394
#define R_BE_CCA_CONTROL_2_C1 0xE394
#define B_BE_TB_CHK_EDCCA_PER20 BIT(24)
#define B_BE_SR_CTN_CHK_TX_NAV BIT(7)
#define B_BE_SR_CTN_CHK__NAV BIT(6)
#define B_BE_SR_CTN_CHK_BTCCA BIT(5)
#define B_BE_SR_CTN_CHK_EDCCA BIT(4)
#define B_BE_SR_CTN_CHK_CCA_S80 BIT(3)
#define B_BE_SR_CTN_CHK_CCA_S40 BIT(2)
#define B_BE_SR_CTN_CHK_CCA_S20 BIT(1)

#define R_BE_CTN_DRV_TXEN 0xC398
#define R_BE_CTN_DRV_TXEN_C1 0xE398

#define R_BE_SCHEDULE_ERR_IMR 0xC3E8
#define R_BE_SCHEDULE_ERR_IMR_C1 0xE3E8
#define B_BE_SORT_NON_IDLE_ERR_INT_EN BIT(1)
#define B_BE_FSM_TIMEOUT_ERR_INT_EN BIT(0)

#define R_BE_SCHEDULE_ERR_ISR 0xC3EC
#define R_BE_SCHEDULE_ERR_ISR_C1 0xE3EC
#define B_BE_SORT_NON_IDLE_ERR_INT BIT(1)
#define B_BE_FSM_TIMEOUT_ERR_INT BIT(0)

#define R_BE_SCH_DBG_SEL 0xC3F4
#define R_BE_SCH_DBG_SEL_C1 0xE3F4
#define B_BE_SCH_DBG_EN BIT(16)
#define B_BE_SCH_CFG_CMD_SEL_SH 8
#define B_BE_SCH_CFG_CMD_SEL_MSK 0xff
#define B_BE_SCH_DBG_SEL_SH 0
#define B_BE_SCH_DBG_SEL_MSK 0xff

#define R_BE_SCH_DBG 0xC3F8
#define R_BE_SCH_DBG_C1 0xE3F8
#define B_BE_SCHEDULER_DBG_SH 0
#define B_BE_SCHEDULER_DBG_MSK 0xffffffffL

#define R_BE_SCH_EXT_CTRL 0xC3FC
#define R_BE_SCH_EXT_CTRL_C1 0xE3FC
#define B_BE_TXFIAL_BRK_TXOP_EN BIT(9)

#define R_BE_PORT_CFG_P0 0xC400
#define R_BE_PORT_CFG_P0_C1 0xE400
#define B_BE_PROHIB_END_CAL_EN_P0 BIT(17)
#define B_BE_BRK_SETUP_P0 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P0 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P0 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P0 BIT(13)
#define B_BE_BCNTX_EN_P0 BIT(12)
#define B_BE_NET_TYPE_P0_SH 10
#define B_BE_NET_TYPE_P0_MSK 0x3
#define B_BE_BCN_FORCETX_EN_P0 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P0 BIT(8)
#define B_BE_BCNERR_CNT_EN_P0 BIT(7)
#define B_BE_BCN_AGRES_P0 BIT(6)
#define B_BE_TSFTR_RST_P0 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P0 BIT(4)
#define B_BE_TSF_UDT_EN_P0 BIT(3)
#define B_BE_PORT_FUNC_EN_P0 BIT(2)
#define B_BE_TXBCN_RPT_EN_P0 BIT(1)
#define B_BE_RXBCN_RPT_EN_P0 BIT(0)

#define R_BE_TBTT_PROHIB_P0 0xC404
#define R_BE_TBTT_PROHIB_P0_C1 0xE404
#define B_BE_TBTT_HOLD_P0_SH 16
#define B_BE_TBTT_HOLD_P0_MSK 0xfff
#define B_BE_TBTT_SETUP_P0_SH 0
#define B_BE_TBTT_SETUP_P0_MSK 0xff

#define R_BE_BCN_AREA_P0 0xC408
#define R_BE_BCN_AREA_P0_C1 0xE408
#define B_BE_BCN_MSK_AREA_P0_SH 16
#define B_BE_BCN_MSK_AREA_P0_MSK 0xfff
#define B_BE_BCN_CTN_AREA_P0_SH 0
#define B_BE_BCN_CTN_AREA_P0_MSK 0xfff

#define R_BE_BCNERLYINT_CFG_P0 0xC40C
#define R_BE_BCNERLYINT_CFG_P0_C1 0xE40C
#define B_BE_BCNERLY_P0_SH 0
#define B_BE_BCNERLY_P0_MSK 0xfff

#define R_BE_TBTTERLYINT_CFG_P0 0xC40E
#define R_BE_TBTTERLYINT_CFG_P0_C1 0xE40E
#define B_BE_TBTTERLY_P0_SH 0
#define B_BE_TBTTERLY_P0_MSK 0xfff

#define R_BE_TBTT_AGG_P0 0xC412
#define R_BE_TBTT_AGG_P0_C1 0xE412
#define B_BE_TBTT_AGG_NUM_P0_SH 8
#define B_BE_TBTT_AGG_NUM_P0_MSK 0xff

#define R_BE_BCN_SPACE_CFG_P0 0xC414
#define R_BE_BCN_SPACE_CFG_P0_C1 0xE414
#define B_BE_SUB_BCN_SPACE_P0_SH 16
#define B_BE_SUB_BCN_SPACE_P0_MSK 0xff
#define B_BE_BCN_SPACE_P0_SH 0
#define B_BE_BCN_SPACE_P0_MSK 0xffff

#define R_BE_BCN_FORCETX_P0 0xC418
#define R_BE_BCN_FORCETX_P0_C1 0xE418
#define B_BE_FORCE_BCN_NUM_P0_SH 8
#define B_BE_FORCE_BCN_NUM_P0_MSK 0xff
#define B_BE_BCN_MAX_ERR_P0_SH 0
#define B_BE_BCN_MAX_ERR_P0_MSK 0xff

#define R_BE_BCN_ERR_CNT_P0 0xC420
#define R_BE_BCN_ERR_CNT_P0_C1 0xE420
#define B_BE_BCN_ERR_CNT_SUM_P0_SH 24
#define B_BE_BCN_ERR_CNT_SUM_P0_MSK 0xff
#define B_BE_BCN_ERR_CNT_NAV_P0_SH 16
#define B_BE_BCN_ERR_CNT_NAV_P0_MSK 0xff
#define B_BE_BCN_ERR_CNT_EDCCA_P0_SH 8
#define B_BE_BCN_ERR_CNT_EDCCA_P0_MSK 0xff
#define B_BE_BCN_ERR_CNT_CCA_P0_SH 0
#define B_BE_BCN_ERR_CNT_CCA_P0_MSK 0xff

#define R_BE_BCN_ERR_FLAG_P0 0xC424
#define R_BE_BCN_ERR_FLAG_P0_C1 0xE424
#define B_BE_BCN_ERR_FLAG_OTHERS_P0 BIT(6)
#define B_BE_BCN_ERR_FLAG_MAC_P0 BIT(5)
#define B_BE_BCN_ERR_FLAG_TXON_P0 BIT(4)
#define B_BE_BCN_ERR_FLAG_SRCHEND_P0 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P0 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P0 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P0 BIT(0)

#define R_BE_DTIM_CTRL_P0 0xC426
#define R_BE_DTIM_CTRL_P0_C1 0xE426
#define B_BE_DTIM_NUM_P0_SH 8
#define B_BE_DTIM_NUM_P0_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0_SH 0
#define B_BE_DTIM_CURRCNT_P0_MSK 0xff

#define R_BE_TBTT_SHIFT_P0 0xC428
#define R_BE_TBTT_SHIFT_P0_C1 0xE428
#define B_BE_TBTT_SHIFT_OFST_P0_SH 0
#define B_BE_TBTT_SHIFT_OFST_P0_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P0 0xC434
#define R_BE_BCN_CNT_TMR_P0_C1 0xE434
#define B_BE_BCN_CNT_TMR_P0_SH 0
#define B_BE_BCN_CNT_TMR_P0_MSK 0xffffffffL

#define R_BE_TSFTR_LOW_P0 0xC438
#define R_BE_TSFTR_LOW_P0_C1 0xE438
#define B_BE_TSFTR_LOW_P0_SH 0
#define B_BE_TSFTR_LOW_P0_MSK 0xffffffffL

#define R_BE_TSFTR_HIGH_P0 0xC43C
#define R_BE_TSFTR_HIGH_P0_C1 0xE43C
#define B_BE_TSFTR_HIGH_P0_SH 0
#define B_BE_TSFTR_HIGH_P0_MSK 0xffffffffL

#define R_BE_PORT_CFG_P1 0xC440
#define R_BE_PORT_CFG_P1_C1 0xE440
#define B_BE_PROHIB_END_CAL_EN_P1 BIT(17)
#define B_BE_BRK_SETUP_P1 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P1 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P1 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P1 BIT(13)
#define B_BE_BCNTX_EN_P1 BIT(12)
#define B_BE_NET_TYPE_P1_SH 10
#define B_BE_NET_TYPE_P1_MSK 0x3
#define B_BE_BCN_FORCETX_EN_P1 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P1 BIT(8)
#define B_BE_BCNERR_CNT_EN_P1 BIT(7)
#define B_BE_BCN_AGRES_P1 BIT(6)
#define B_BE_TSFTR_RST_P1 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P1 BIT(4)
#define B_BE_TSF_UDT_EN_P1 BIT(3)
#define B_BE_PORT_FUNC_EN_P1 BIT(2)
#define B_BE_TXBCN_RPT_EN_P1 BIT(1)
#define B_BE_RXBCN_RPT_EN_P1 BIT(0)

#define R_BE_TBTT_PROHIB_P1 0xC444
#define R_BE_TBTT_PROHIB_P1_C1 0xE444
#define B_BE_TBTT_HOLD_P1_SH 16
#define B_BE_TBTT_HOLD_P1_MSK 0xfff
#define B_BE_TBTT_SETUP_P1_SH 0
#define B_BE_TBTT_SETUP_P1_MSK 0xff

#define R_BE_BCN_AREA_P1 0xC448
#define R_BE_BCN_AREA_P1_C1 0xE448
#define B_BE_BCN_MSK_AREA_P1_SH 16
#define B_BE_BCN_MSK_AREA_P1_MSK 0xfff
#define B_BE_BCN_CTN_AREA_P1_SH 0
#define B_BE_BCN_CTN_AREA_P1_MSK 0xfff

#define R_BE_BCNERLYINT_CFG_P1 0xC44C
#define R_BE_BCNERLYINT_CFG_P1_C1 0xE44C
#define B_BE_BCNERLY_P1_SH 0
#define B_BE_BCNERLY_P1_MSK 0xfff

#define R_BE_TBTTERLYINT_CFG_P1 0xC44E
#define R_BE_TBTTERLYINT_CFG_P1_C1 0xE44E
#define B_BE_TBTTERLY_P1_SH 0
#define B_BE_TBTTERLY_P1_MSK 0xfff

#define R_BE_TBTT_AGG_P1 0xC452
#define R_BE_TBTT_AGG_P1_C1 0xE452
#define B_BE_TBTT_AGG_NUM_P1_SH 8
#define B_BE_TBTT_AGG_NUM_P1_MSK 0xff

#define R_BE_BCN_SPACE_CFG_P1 0xC454
#define R_BE_BCN_SPACE_CFG_P1_C1 0xE454
#define B_BE_BCN_SPACE_P1_SH 0
#define B_BE_BCN_SPACE_P1_MSK 0xffff

#define R_BE_BCN_FORCETX_P1 0xC458
#define R_BE_BCN_FORCETX_P1_C1 0xE458
#define B_BE_FORCE_BCN_NUM_P1_SH 8
#define B_BE_FORCE_BCN_NUM_P1_MSK 0xff
#define B_BE_BCN_MAX_ERR_P1_SH 0
#define B_BE_BCN_MAX_ERR_P1_MSK 0xff

#define R_BE_BCN_ERR_CNT_P1 0xC460
#define R_BE_BCN_ERR_CNT_P1_C1 0xE460
#define B_BE_BCN_ERR_CNT_SUM_P1_SH 24
#define B_BE_BCN_ERR_CNT_SUM_P1_MSK 0xff
#define B_BE_BCN_ERR_CNT_NAV_P1_SH 16
#define B_BE_BCN_ERR_CNT_NAV_P1_MSK 0xff
#define B_BE_BCN_ERR_CNT_EDCCA_P1_SH 8
#define B_BE_BCN_ERR_CNT_EDCCA_P1_MSK 0xff
#define B_BE_BCN_ERR_CNT_CCA_P1_SH 0
#define B_BE_BCN_ERR_CNT_CCA_P1_MSK 0xff

#define R_BE_BCN_ERR_FLAG_P1 0xC464
#define R_BE_BCN_ERR_FLAG_P1_C1 0xE464
#define B_BE_BCN_ERR_FLAG_OTHERS_P1 BIT(6)
#define B_BE_BCN_ERR_FLAG_MAC_P1 BIT(5)
#define B_BE_BCN_ERR_FLAG_TXON_P1 BIT(4)
#define B_BE_BCN_ERR_FLAG_SRCHEND_P1 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P1 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P1 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P1 BIT(0)

#define R_BE_DTIM_CTRL_P1 0xC466
#define R_BE_DTIM_CTRL_P1_C1 0xE466
#define B_BE_DTIM_NUM_P1_SH 8
#define B_BE_DTIM_NUM_P1_MSK 0xff
#define B_BE_DTIM_CURRCNT_P1_SH 0
#define B_BE_DTIM_CURRCNT_P1_MSK 0xff

#define R_BE_TBTT_SHIFT_P1 0xC468
#define R_BE_TBTT_SHIFT_P1_C1 0xE468
#define B_BE_TBTT_SHIFT_OFST_P1_SH 0
#define B_BE_TBTT_SHIFT_OFST_P1_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P1 0xC474
#define R_BE_BCN_CNT_TMR_P1_C1 0xE474
#define B_BE_BCN_CNT_TMR_P1_SH 0
#define B_BE_BCN_CNT_TMR_P1_MSK 0xffffffffL

#define R_BE_TSFTR_LOW_P1 0xC478
#define R_BE_TSFTR_LOW_P1_C1 0xE478
#define B_BE_TSFTR_LOW_P1_SH 0
#define B_BE_TSFTR_LOW_P1_MSK 0xffffffffL

#define R_BE_TSFTR_HIGH_P1 0xC47C
#define R_BE_TSFTR_HIGH_P1_C1 0xE47C
#define B_BE_TSFTR_HIGH_P1_SH 0
#define B_BE_TSFTR_HIGH_P1_MSK 0xffffffffL

#define R_BE_PORT_CFG_P2 0xC480
#define R_BE_PORT_CFG_P2_C1 0xE480
#define B_BE_PROHIB_END_CAL_EN_P2 BIT(17)
#define B_BE_BRK_SETUP_P2 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P2 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P2 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P2 BIT(13)
#define B_BE_BCNTX_EN_P2 BIT(12)
#define B_BE_NET_TYPE_P2_SH 10
#define B_BE_NET_TYPE_P2_MSK 0x3
#define B_BE_BCN_FORCETX_EN_P2 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P2 BIT(8)
#define B_BE_BCNERR_CNT_EN_P2 BIT(7)
#define B_BE_BCN_AGRES_P2 BIT(6)
#define B_BE_TSFTR_RST_P2 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P2 BIT(4)
#define B_BE_TSF_UDT_EN_P2 BIT(3)
#define B_BE_PORT_FUNC_EN_P2 BIT(2)
#define B_BE_TXBCN_RPT_EN_P2 BIT(1)
#define B_BE_RXBCN_RPT_EN_P2 BIT(0)

#define R_BE_TBTT_PROHIB_P2 0xC484
#define R_BE_TBTT_PROHIB_P2_C1 0xE484
#define B_BE_TBTT_HOLD_P2_SH 16
#define B_BE_TBTT_HOLD_P2_MSK 0xfff
#define B_BE_TBTT_SETUP_P2_SH 0
#define B_BE_TBTT_SETUP_P2_MSK 0xff

#define R_BE_BCN_AREA_P2 0xC488
#define R_BE_BCN_AREA_P2_C1 0xE488
#define B_BE_BCN_MSK_AREA_P2_SH 16
#define B_BE_BCN_MSK_AREA_P2_MSK 0xfff
#define B_BE_BCN_CTN_AREA_P2_SH 0
#define B_BE_BCN_CTN_AREA_P2_MSK 0xfff

#define R_BE_BCNERLYINT_CFG_P2 0xC48C
#define R_BE_BCNERLYINT_CFG_P2_C1 0xE48C
#define B_BE_BCNERLY_P2_SH 0
#define B_BE_BCNERLY_P2_MSK 0xfff

#define R_BE_TBTTERLYINT_CFG_P2 0xC48E
#define R_BE_TBTTERLYINT_CFG_P2_C1 0xE48E
#define B_BE_TBTTERLY_P2_SH 0
#define B_BE_TBTTERLY_P2_MSK 0xfff

#define R_BE_TBTT_AGG_P2 0xC492
#define R_BE_TBTT_AGG_P2_C1 0xE492
#define B_BE_TBTT_AGG_NUM_P2_SH 8
#define B_BE_TBTT_AGG_NUM_P2_MSK 0xff

#define R_BE_BCN_SPACE_CFG_P2 0xC494
#define R_BE_BCN_SPACE_CFG_P2_C1 0xE494
#define B_BE_BCN_SPACE_P2_SH 0
#define B_BE_BCN_SPACE_P2_MSK 0xffff

#define R_BE_BCN_FORCETX_P2 0xC498
#define R_BE_BCN_FORCETX_P2_C1 0xE498
#define B_BE_FORCE_BCN_NUM_P2_SH 8
#define B_BE_FORCE_BCN_NUM_P2_MSK 0xff
#define B_BE_BCN_MAX_ERR_P2_SH 0
#define B_BE_BCN_MAX_ERR_P2_MSK 0xff

#define R_BE_BCN_ERR_CNT_P2 0xC4A0
#define R_BE_BCN_ERR_CNT_P2_C1 0xE4A0
#define B_BE_BCN_ERR_CNT_SUM_P2_SH 24
#define B_BE_BCN_ERR_CNT_SUM_P2_MSK 0xff
#define B_BE_BCN_ERR_CNT_NAV_P2_SH 16
#define B_BE_BCN_ERR_CNT_NAV_P2_MSK 0xff
#define B_BE_BCN_ERR_CNT_EDCCA_P2_SH 8
#define B_BE_BCN_ERR_CNT_EDCCA_P2_MSK 0xff
#define B_BE_BCN_ERR_CNT_CCA_P2_SH 0
#define B_BE_BCN_ERR_CNT_CCA_P2_MSK 0xff

#define R_BE_BCN_ERR_FLAG_P2 0xC4A4
#define R_BE_BCN_ERR_FLAG_P2_C1 0xE4A4
#define B_BE_BCN_ERR_FLAG_OTHERS_P2 BIT(6)
#define B_BE_BCN_ERR_FLAG_MAC_P2 BIT(5)
#define B_BE_BCN_ERR_FLAG_TXON_P2 BIT(4)
#define B_BE_BCN_ERR_FLAG_SRCHEND_P2 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P2 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P2 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P2 BIT(0)

#define R_BE_DTIM_CTRL_P2 0xC4A6
#define R_BE_DTIM_CTRL_P2_C1 0xE4A6
#define B_BE_DTIM_NUM_P2_SH 8
#define B_BE_DTIM_NUM_P2_MSK 0xff
#define B_BE_DTIM_CURRCNT_P2_SH 0
#define B_BE_DTIM_CURRCNT_P2_MSK 0xff

#define R_BE_TBTT_SHIFT_P2 0xC4A8
#define R_BE_TBTT_SHIFT_P2_C1 0xE4A8
#define B_BE_TBTT_SHIFT_OFST_P2_SH 0
#define B_BE_TBTT_SHIFT_OFST_P2_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P2 0xC4B4
#define R_BE_BCN_CNT_TMR_P2_C1 0xE4B4
#define B_BE_BCN_CNT_TMR_P2_SH 0
#define B_BE_BCN_CNT_TMR_P2_MSK 0xffffffffL

#define R_BE_TSFTR_LOW_P2 0xC4B8
#define R_BE_TSFTR_LOW_P2_C1 0xE4B8
#define B_BE_TSFTR_LOW_P2_SH 0
#define B_BE_TSFTR_LOW_P2_MSK 0xffffffffL

#define R_BE_TSFTR_HIGH_P2 0xC4BC
#define R_BE_TSFTR_HIGH_P2_C1 0xE4BC
#define B_BE_TSFTR_HIGH_P2_SH 0
#define B_BE_TSFTR_HIGH_P2_MSK 0xffffffffL

#define R_BE_PORT_CFG_P3 0xC4C0
#define R_BE_PORT_CFG_P3_C1 0xE4C0
#define B_BE_PROHIB_END_CAL_EN_P3 BIT(17)
#define B_BE_BRK_SETUP_P3 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P3 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P3 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P3 BIT(13)
#define B_BE_BCNTX_EN_P3 BIT(12)
#define B_BE_NET_TYPE_P3_SH 10
#define B_BE_NET_TYPE_P3_MSK 0x3
#define B_BE_BCN_FORCETX_EN_P3 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P3 BIT(8)
#define B_BE_BCNERR_CNT_EN_P3 BIT(7)
#define B_BE_BCN_AGRES_P3 BIT(6)
#define B_BE_TSFTR_RST_P3 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P3 BIT(4)
#define B_BE_TSF_UDT_EN_P3 BIT(3)
#define B_BE_PORT_FUNC_EN_P3 BIT(2)
#define B_BE_TXBCN_RPT_EN_P3 BIT(1)
#define B_BE_RXBCN_RPT_EN_P3 BIT(0)

#define R_BE_TBTT_PROHIB_P3 0xC4C4
#define R_BE_TBTT_PROHIB_P3_C1 0xE4C4
#define B_BE_TBTT_HOLD_P3_SH 16
#define B_BE_TBTT_HOLD_P3_MSK 0xfff
#define B_BE_TBTT_SETUP_P3_SH 0
#define B_BE_TBTT_SETUP_P3_MSK 0xff

#define R_BE_BCN_AREA_P3 0xC4C8
#define R_BE_BCN_AREA_P3_C1 0xE4C8
#define B_BE_BCN_MSK_AREA_P3_SH 16
#define B_BE_BCN_MSK_AREA_P3_MSK 0xfff

#define R_BE_BCNERLYINT_CFG_P3 0xC4CC
#define R_BE_BCNERLYINT_CFG_P3_C1 0xE4CC
#define B_BE_BCNERLY_P3_SH 0
#define B_BE_BCNERLY_P3_MSK 0xfff

#define R_BE_TBTTERLYINT_CFG_P3 0xC4CE
#define R_BE_TBTTERLYINT_CFG_P3_C1 0xE4CE
#define B_BE_TBTTERLY_P3_SH 0
#define B_BE_TBTTERLY_P3_MSK 0xfff

#define R_BE_TBTT_AGG_P3 0xC4D2
#define R_BE_TBTT_AGG_P3_C1 0xE4D2
#define B_BE_TBTT_AGG_NUM_P3_SH 8
#define B_BE_TBTT_AGG_NUM_P3_MSK 0xff

#define R_BE_BCN_SPACE_CFG_P3 0xC4D4
#define R_BE_BCN_SPACE_CFG_P3_C1 0xE4D4
#define B_BE_BCN_SPACE_P3_SH 0
#define B_BE_BCN_SPACE_P3_MSK 0xffff

#define R_BE_BCN_FORCETX_P3 0xC4D8
#define R_BE_BCN_FORCETX_P3_C1 0xE4D8
#define B_BE_FORCE_BCN_NUM_P3_SH 8
#define B_BE_FORCE_BCN_NUM_P3_MSK 0xff
#define B_BE_BCN_MAX_ERR_P3_SH 0
#define B_BE_BCN_MAX_ERR_P3_MSK 0xff

#define R_BE_BCN_ERR_CNT_P3 0xC4E0
#define R_BE_BCN_ERR_CNT_P3_C1 0xE4E0
#define B_BE_BCN_ERR_CNT_SUM_P3_SH 24
#define B_BE_BCN_ERR_CNT_SUM_P3_MSK 0xff
#define B_BE_BCN_ERR_CNT_NAV_P3_SH 16
#define B_BE_BCN_ERR_CNT_NAV_P3_MSK 0xff
#define B_BE_BCN_ERR_CNT_EDCCA_P3_SH 8
#define B_BE_BCN_ERR_CNT_EDCCA_P3_MSK 0xff
#define B_BE_BCN_ERR_CNT_CCA_P3_SH 0
#define B_BE_BCN_ERR_CNT_CCA_P3_MSK 0xff

#define R_BE_BCN_ERR_FLAG_P3 0xC4E4
#define R_BE_BCN_ERR_FLAG_P3_C1 0xE4E4
#define B_BE_BCN_ERR_FLAG_OTHERS_P3 BIT(6)
#define B_BE_BCN_ERR_FLAG_MAC_P3 BIT(5)
#define B_BE_BCN_ERR_FLAG_TXON_P3 BIT(4)
#define B_BE_BCN_ERR_FLAG_SRCHEND_P3 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P3 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P3 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P3 BIT(0)

#define R_BE_DTIM_CTRL_P3 0xC4E6
#define R_BE_DTIM_CTRL_P3_C1 0xE4E6
#define B_BE_DTIM_NUM_P3_SH 8
#define B_BE_DTIM_NUM_P3_MSK 0xff
#define B_BE_DTIM_CURRCNT_P3_SH 0
#define B_BE_DTIM_CURRCNT_P3_MSK 0xff

#define R_BE_TBTT_SHIFT_P3 0xC4E8
#define R_BE_TBTT_SHIFT_P3_C1 0xE4E8
#define B_BE_TBTT_SHIFT_OFST_P3_SH 0
#define B_BE_TBTT_SHIFT_OFST_P3_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P3 0xC4F4
#define R_BE_BCN_CNT_TMR_P3_C1 0xE4F4
#define B_BE_BCN_CNT_TMR_P3_SH 0
#define B_BE_BCN_CNT_TMR_P3_MSK 0xffffffffL

#define R_BE_TSFTR_LOW_P3 0xC4F8
#define R_BE_TSFTR_LOW_P3_C1 0xE4F8
#define B_BE_TSFTR_LOW_P3_SH 0
#define B_BE_TSFTR_LOW_P3_MSK 0xffffffffL

#define R_BE_TSFTR_HIGH_P3 0xC4FC
#define R_BE_TSFTR_HIGH_P3_C1 0xE4FC
#define B_BE_TSFTR_HIGH_P3_SH 0
#define B_BE_TSFTR_HIGH_P3_MSK 0xffffffffL

#define R_BE_PORT_CFG_P4 0xC500
#define R_BE_PORT_CFG_P4_C1 0xE500
#define B_BE_PROHIB_END_CAL_EN_P4 BIT(17)
#define B_BE_BRK_SETUP_P4 BIT(16)
#define B_BE_TBTT_UPD_SHIFT_SEL_P4 BIT(15)
#define B_BE_BCN_DROP_ALLOW_P4 BIT(14)
#define B_BE_TBTT_PROHIB_EN_P4 BIT(13)
#define B_BE_BCNTX_EN_P4 BIT(12)
#define B_BE_NET_TYPE_P4_SH 10
#define B_BE_NET_TYPE_P4_MSK 0x3
#define B_BE_BCN_FORCETX_EN_P4 BIT(9)
#define B_BE_TXBCN_BTCCA_EN_P4 BIT(8)
#define B_BE_BCNERR_CNT_EN_P4 BIT(7)
#define B_BE_BCN_AGRES_P4 BIT(6)
#define B_BE_TSFTR_RST_P4 BIT(5)
#define B_BE_RX_BSSID_FIT_EN_P4 BIT(4)
#define B_BE_TSF_UDT_EN_P4 BIT(3)
#define B_BE_PORT_FUNC_EN_P4 BIT(2)
#define B_BE_TXBCN_RPT_EN_P4 BIT(1)
#define B_BE_RXBCN_RPT_EN_P4 BIT(0)

#define R_BE_TBTT_PROHIB_P4 0xC504
#define R_BE_TBTT_PROHIB_P4_C1 0xE504
#define B_BE_TBTT_HOLD_P4_SH 16
#define B_BE_TBTT_HOLD_P4_MSK 0xfff
#define B_BE_TBTT_SETUP_P4_SH 0
#define B_BE_TBTT_SETUP_P4_MSK 0xff

#define R_BE_BCN_AREA_P4 0xC508
#define R_BE_BCN_AREA_P4_C1 0xE508
#define B_BE_BCN_MSK_AREA_P4_SH 16
#define B_BE_BCN_MSK_AREA_P4_MSK 0xfff

#define R_BE_BCNERLYINT_CFG_P4 0xC50C
#define R_BE_BCNERLYINT_CFG_P4_C1 0xE50C
#define B_BE_BCNERLY_P4_SH 0
#define B_BE_BCNERLY_P4_MSK 0xfff

#define R_BE_TBTTERLYINT_CFG_P4 0xC50E
#define R_BE_TBTTERLYINT_CFG_P4_C1 0xE50E
#define B_BE_TBTTERLY_P4_SH 0
#define B_BE_TBTTERLY_P4_MSK 0xfff

#define R_BE_TBTT_AGG_P4 0xC512
#define R_BE_TBTT_AGG_P4_C1 0xE512
#define B_BE_TBTT_AGG_NUM_P4_SH 8
#define B_BE_TBTT_AGG_NUM_P4_MSK 0xff

#define R_BE_BCN_SPACE_CFG_P4 0xC514
#define R_BE_BCN_SPACE_CFG_P4_C1 0xE514
#define B_BE_BCN_SPACE_P4_SH 0
#define B_BE_BCN_SPACE_P4_MSK 0xffff

#define R_BE_BCN_FORCETX_P4 0xC518
#define R_BE_BCN_FORCETX_P4_C1 0xE518
#define B_BE_FORCE_BCN_NUM_P4_SH 8
#define B_BE_FORCE_BCN_NUM_P4_MSK 0xff
#define B_BE_BCN_MAX_ERR_P4_SH 0
#define B_BE_BCN_MAX_ERR_P4_MSK 0xff

#define R_BE_BCN_ERR_CNT_P4 0xC520
#define R_BE_BCN_ERR_CNT_P4_C1 0xE520
#define B_BE_BCN_ERR_CNT_SUM_P4_SH 24
#define B_BE_BCN_ERR_CNT_SUM_P4_MSK 0xff
#define B_BE_BCN_ERR_CNT_NAV_P4_SH 16
#define B_BE_BCN_ERR_CNT_NAV_P4_MSK 0xff
#define B_BE_BCN_ERR_CNT_EDCCA_P4_SH 8
#define B_BE_BCN_ERR_CNT_EDCCA_P4_MSK 0xff
#define B_BE_BCN_ERR_CNT_CCA_P4_SH 0
#define B_BE_BCN_ERR_CNT_CCA_P4_MSK 0xff

#define R_BE_BCN_ERR_FLAG_P4 0xC524
#define R_BE_BCN_ERR_FLAG_P4_C1 0xE524
#define B_BE_BCN_ERR_FLAG_OTHERS_P4 BIT(6)
#define B_BE_BCN_ERR_FLAG_MAC_P4 BIT(5)
#define B_BE_BCN_ERR_FLAG_TXON_P4 BIT(4)
#define B_BE_BCN_ERR_FLAG_SRCHEND_P4 BIT(3)
#define B_BE_BCN_ERR_FLAG_INVALID_P4 BIT(2)
#define B_BE_BCN_ERR_FLAG_CMP_P4 BIT(1)
#define B_BE_BCN_ERR_FLAG_LOCK_P4 BIT(0)

#define R_BE_DTIM_CTRL_P4 0xC526
#define R_BE_DTIM_CTRL_P4_C1 0xE526
#define B_BE_DTIM_NUM_P4_SH 8
#define B_BE_DTIM_NUM_P4_MSK 0xff
#define B_BE_DTIM_CURRCNT_P4_SH 0
#define B_BE_DTIM_CURRCNT_P4_MSK 0xff

#define R_BE_TBTT_SHIFT_P4 0xC528
#define R_BE_TBTT_SHIFT_P4_C1 0xE528
#define B_BE_TBTT_SHIFT_OFST_P4_SH 0
#define B_BE_TBTT_SHIFT_OFST_P4_MSK 0xfff

#define R_BE_BCN_CNT_TMR_P4 0xC534
#define R_BE_BCN_CNT_TMR_P4_C1 0xE534
#define B_BE_BCN_CNT_TMR_P4_SH 0
#define B_BE_BCN_CNT_TMR_P4_MSK 0xffffffffL

#define R_BE_TSFTR_LOW_P4 0xC538
#define R_BE_TSFTR_LOW_P4_C1 0xE538
#define B_BE_TSFTR_LOW_P4_SH 0
#define B_BE_TSFTR_LOW_P4_MSK 0xffffffffL

#define R_BE_TSFTR_HIGH_P4 0xC53C
#define R_BE_TSFTR_HIGH_P4_C1 0xE53C
#define B_BE_TSFTR_HIGH_P4_SH 0
#define B_BE_TSFTR_HIGH_P4_MSK 0xffffffffL

#define R_BE_DTIM_NUM0 0xC540
#define R_BE_DTIM_NUM0_C1 0xE540
#define B_BE_DTIM_NUM_P0MB3_SH 24
#define B_BE_DTIM_NUM_P0MB3_MSK 0xff
#define B_BE_DTIM_NUM_P0MB2_SH 16
#define B_BE_DTIM_NUM_P0MB2_MSK 0xff
#define B_BE_DTIM_NUM_P0MB1_SH 8
#define B_BE_DTIM_NUM_P0MB1_MSK 0xff

#define R_BE_DTIM_NUM1 0xC544
#define R_BE_DTIM_NUM1_C1 0xE544
#define B_BE_DTIM_NUM_P0MB7_SH 24
#define B_BE_DTIM_NUM_P0MB7_MSK 0xff
#define B_BE_DTIM_NUM_P0MB6_SH 16
#define B_BE_DTIM_NUM_P0MB6_MSK 0xff
#define B_BE_DTIM_NUM_P0MB5_SH 8
#define B_BE_DTIM_NUM_P0MB5_MSK 0xff
#define B_BE_DTIM_NUM_P0MB4_SH 0
#define B_BE_DTIM_NUM_P0MB4_MSK 0xff

#define R_BE_DTIM_NUM2 0xC548
#define R_BE_DTIM_NUM2_C1 0xE548
#define B_BE_DTIM_NUM_P0MB11_SH 24
#define B_BE_DTIM_NUM_P0MB11_MSK 0xff
#define B_BE_DTIM_NUM_P0MB10_SH 16
#define B_BE_DTIM_NUM_P0MB10_MSK 0xff
#define B_BE_DTIM_NUM_P0MB9_SH 8
#define B_BE_DTIM_NUM_P0MB9_MSK 0xff
#define B_BE_DTIM_NUM_P0MB8_SH 0
#define B_BE_DTIM_NUM_P0MB8_MSK 0xff

#define R_BE_DTIM_NUM3 0xC54C
#define R_BE_DTIM_NUM3_C1 0xE54C
#define B_BE_DTIM_NUM_P0MB15_SH 24
#define B_BE_DTIM_NUM_P0MB15_MSK 0xff
#define B_BE_DTIM_NUM_P0MB14_SH 16
#define B_BE_DTIM_NUM_P0MB14_MSK 0xff
#define B_BE_DTIM_NUM_P0MB13_SH 8
#define B_BE_DTIM_NUM_P0MB13_MSK 0xff
#define B_BE_DTIM_NUM_P0MB12_SH 0
#define B_BE_DTIM_NUM_P0MB12_MSK 0xff

#define R_BE_DTIM_CURRCNT0 0xC550
#define R_BE_DTIM_CURRCNT0_C1 0xE550
#define B_BE_DTIM_CURRCNT_P0MB3_SH 24
#define B_BE_DTIM_CURRCNT_P0MB3_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB2_SH 16
#define B_BE_DTIM_CURRCNT_P0MB2_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB1_SH 8
#define B_BE_DTIM_CURRCNT_P0MB1_MSK 0xff

#define R_BE_DTIM_CURRCNT1 0xC554
#define R_BE_DTIM_CURRCNT1_C1 0xE554
#define B_BE_DTIM_CURRCNT_P0MB7_SH 24
#define B_BE_DTIM_CURRCNT_P0MB7_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB6_SH 16
#define B_BE_DTIM_CURRCNT_P0MB6_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB5_SH 8
#define B_BE_DTIM_CURRCNT_P0MB5_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB4_SH 0
#define B_BE_DTIM_CURRCNT_P0MB4_MSK 0xff

#define R_BE_DTIM_CURRCNT2 0xC558
#define R_BE_DTIM_CURRCNT2_C1 0xE558
#define B_BE_DTIM_CURRCNT_P0MB11_SH 24
#define B_BE_DTIM_CURRCNT_P0MB11_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB10_SH 16
#define B_BE_DTIM_CURRCNT_P0MB10_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB9_SH 8
#define B_BE_DTIM_CURRCNT_P0MB9_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB8_SH 0
#define B_BE_DTIM_CURRCNT_P0MB8_MSK 0xff

#define R_BE_DTIM_CURRCNT3 0xC55C
#define R_BE_DTIM_CURRCNT3_C1 0xE55C
#define B_BE_DTIM_CURRCNT_P0MB15_SH 24
#define B_BE_DTIM_CURRCNT_P0MB15_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB14_SH 16
#define B_BE_DTIM_CURRCNT_P0MB14_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB13_SH 8
#define B_BE_DTIM_CURRCNT_P0MB13_MSK 0xff
#define B_BE_DTIM_CURRCNT_P0MB12_SH 0
#define B_BE_DTIM_CURRCNT_P0MB12_MSK 0xff

#define R_BE_BCN_DROP_ALL0 0xC560
#define R_BE_BCN_DROP_ALL0_C1 0xE560
#define B_BE_BCN_DROP_ALL_P4 BIT(4)
#define B_BE_BCN_DROP_ALL_P3 BIT(3)
#define B_BE_BCN_DROP_ALL_P2 BIT(2)
#define B_BE_BCN_DROP_ALL_P1 BIT(1)
#define B_BE_BCN_DROP_ALL_P0 BIT(0)

#define R_BE_BCN_DROP_ALL0_P0MB 0xC564
#define R_BE_BCN_DROP_ALL0_P0MB_C1 0xE564
#define B_BE_BCN_DROP_ALL_P0MB15 BIT(15)
#define B_BE_BCN_DROP_ALL_P0MB14 BIT(14)
#define B_BE_BCN_DROP_ALL_P0MB13 BIT(13)
#define B_BE_BCN_DROP_ALL_P0MB12 BIT(12)
#define B_BE_BCN_DROP_ALL_P0MB11 BIT(11)
#define B_BE_BCN_DROP_ALL_P0MB10 BIT(10)
#define B_BE_BCN_DROP_ALL_P0MB9 BIT(9)
#define B_BE_BCN_DROP_ALL_P0MB8 BIT(8)
#define B_BE_BCN_DROP_ALL_P0MB7 BIT(7)
#define B_BE_BCN_DROP_ALL_P0MB6 BIT(6)
#define B_BE_BCN_DROP_ALL_P0MB5 BIT(5)
#define B_BE_BCN_DROP_ALL_P0MB4 BIT(4)
#define B_BE_BCN_DROP_ALL_P0MB3 BIT(3)
#define B_BE_BCN_DROP_ALL_P0MB2 BIT(2)
#define B_BE_BCN_DROP_ALL_P0MB1 BIT(1)

#define R_BE_MBSSID_CTRL 0xC568
#define R_BE_MBSSID_CTRL_C1 0xE568
#define B_BE_P0MB_NUM_SH 16
#define B_BE_P0MB_NUM_MSK 0xf
#define B_BE_P0MB15_EN BIT(15)
#define B_BE_P0MB14_EN BIT(14)
#define B_BE_P0MB13_EN BIT(13)
#define B_BE_P0MB12_EN BIT(12)
#define B_BE_P0MB11_EN BIT(11)
#define B_BE_P0MB10_EN BIT(10)
#define B_BE_P0MB9_EN BIT(9)
#define B_BE_P0MB8_EN BIT(8)
#define B_BE_P0MB7_EN BIT(7)
#define B_BE_P0MB6_EN BIT(6)
#define B_BE_P0MB5_EN BIT(5)
#define B_BE_P0MB4_EN BIT(4)
#define B_BE_P0MB3_EN BIT(3)
#define B_BE_P0MB2_EN BIT(2)
#define B_BE_P0MB1_EN BIT(1)

#define R_BE_RXTSF_OFST 0xC570
#define R_BE_RXTSF_OFST_C1 0xE570
#define B_BE_RXTSF_OFST_OFDM_SH 8
#define B_BE_RXTSF_OFST_OFDM_MSK 0xff
#define B_BE_RXTSF_OFST_CCK_SH 0
#define B_BE_RXTSF_OFST_CCK_MSK 0xff

#define R_BE_RXBCN_TIME_CTRL 0xC574
#define R_BE_RXBCN_TIME_CTRL_C1 0xE574
#define B_BE_RXBCN_TIME_PORT_SH 28
#define B_BE_RXBCN_TIME_PORT_MSK 0x7
#define B_BE_RXBCN_TIME_VLD BIT(17)
#define B_BE_RXBCN_TIME_UDFW BIT(16)
#define B_BE_RXBCN_TIME_DIFF_SH 0
#define B_BE_RXBCN_TIME_DIFF_MSK 0xffff

#define R_BE_RXBCN_TIME_SYNC 0xC578
#define R_BE_RXBCN_TIME_SYNC_C1 0xE578
#define B_BE_RXBCN_TIME_SYNC_SH 0
#define B_BE_RXBCN_TIME_SYNC_MSK 0xffffffffL

#define R_BE_TBTT_TSF_INFO 0xC57C
#define R_BE_TBTT_TSF_INFO_C1 0xE57C
#define B_BE_TBTT_TSF_INFO_SH 0
#define B_BE_TBTT_TSF_INFO_MSK 0xffffffffL

#define R_BE_P0MB_HGQ_WINDOW_CFG_0 0xC590
#define R_BE_P0MB_HGQ_WINDOW_CFG_0_C1 0xE590
#define B_BE_HGQWND_3_SH 24
#define B_BE_HGQWND_3_MSK 0xff
#define B_BE_HGQWND_2_SH 16
#define B_BE_HGQWND_2_MSK 0xff
#define B_BE_HGQWND_1_SH 8
#define B_BE_HGQWND_1_MSK 0xff
#define B_BE_HGQWND_0_SH 0
#define B_BE_HGQWND_0_MSK 0xff

#define R_BE_P0MB_HGQ_WINDOW_CFG_1 0xC594
#define R_BE_P0MB_HGQ_WINDOW_CFG_1_C1 0xE594
#define B_BE_HGQWND_7_SH 24
#define B_BE_HGQWND_7_MSK 0xff
#define B_BE_HGQWND_6_SH 16
#define B_BE_HGQWND_6_MSK 0xff
#define B_BE_HGQWND_5_SH 8
#define B_BE_HGQWND_5_MSK 0xff
#define B_BE_HGQWND_4_SH 0
#define B_BE_HGQWND_4_MSK 0xff

#define R_BE_P0MB_HGQ_WINDOW_CFG_2 0xC598
#define R_BE_P0MB_HGQ_WINDOW_CFG_2_C1 0xE598
#define B_BE_HGQWND_11_SH 24
#define B_BE_HGQWND_11_MSK 0xff
#define B_BE_HGQWND_10_SH 16
#define B_BE_HGQWND_10_MSK 0xff
#define B_BE_HGQWND_9_SH 8
#define B_BE_HGQWND_9_MSK 0xff
#define B_BE_HGQWND_8_SH 0
#define B_BE_HGQWND_8_MSK 0xff

#define R_BE_P0MB_HGQ_WINDOW_CFG_3 0xC59C
#define R_BE_P0MB_HGQ_WINDOW_CFG_3_C1 0xE59C
#define B_BE_HGQWND_15_SH 24
#define B_BE_HGQWND_15_MSK 0xff
#define B_BE_HGQWND_14_SH 16
#define B_BE_HGQWND_14_MSK 0xff
#define B_BE_HGQWND_13_SH 8
#define B_BE_HGQWND_13_MSK 0xff
#define B_BE_HGQWND_12_SH 0
#define B_BE_HGQWND_12_MSK 0xff

#define R_BE_PORT_HGQ_WINDOW_CFG 0xC5A0
#define R_BE_PORT_HGQ_WINDOW_CFG_C1 0xE5A0
#define B_BE_HGQWND_19_SH 24
#define B_BE_HGQWND_19_MSK 0xff
#define B_BE_HGQWND_18_SH 16
#define B_BE_HGQWND_18_MSK 0xff
#define B_BE_HGQWND_17_SH 8
#define B_BE_HGQWND_17_MSK 0xff
#define B_BE_HGQWND_16_SH 0
#define B_BE_HGQWND_16_MSK 0xff

#define R_BE_EN_HGQ_NOLIMIT 0xC5A4
#define R_BE_EN_HGQ_NOLIMIT_C1 0xE5A4
#define B_BE_HIQ_NO_LMT_EN_P4 BIT(19)
#define B_BE_HIQ_NO_LMT_EN_P3 BIT(18)
#define B_BE_HIQ_NO_LMT_EN_P2 BIT(17)
#define B_BE_HIQ_NO_LMT_EN_P1 BIT(16)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP15 BIT(15)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP14 BIT(14)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP13 BIT(13)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP12 BIT(12)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP11 BIT(11)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP10 BIT(10)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP9 BIT(9)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP8 BIT(8)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP7 BIT(7)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP6 BIT(6)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP5 BIT(5)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP4 BIT(4)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP3 BIT(3)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP2 BIT(2)
#define B_BE_HIQ_NO_LMT_EN_P0_VAP1 BIT(1)
#define B_BE_HIQ_NO_LMT_EN_P0_ROOT BIT(0)

#define R_BE_C0_SCH_DBG_INFO_0 0xC5B0
#define R_BE_C0_SCH_DBG_INFO_0_C1 0xE5B0
#define B_BE_SCH_EDCA_RST_DBG_SH 0
#define B_BE_SCH_EDCA_RST_DBG_MSK 0xffffffffL

#define R_BE_C0_SCH_DBG_INFO_1 0xC5B4
#define R_BE_C0_SCH_DBG_INFO_1_C1 0xE5B4
#define B_BE_SCH_PREBKF_DBG_SH 0
#define B_BE_SCH_PREBKF_DBG_MSK 0xffffffffL

#define R_BE_LPS_RX_PERIOD_CTRL 0xC5B8
#define R_BE_LPS_RX_PERIOD_CTRL_C1 0xE5B8
#define B_BE_RXBCN_PERIOD_SH 16
#define B_BE_RXBCN_PERIOD_MSK 0xff
#define B_BE_CAT_PERIOD_SH 8
#define B_BE_CAT_PERIOD_MSK 0xff
#define B_BE_LPS_RX_CTRL_EN BIT(3)
#define B_BE_LPS_PORT_SEL_SH 0
#define B_BE_LPS_PORT_SEL_MSK 0x7

#define R_BE_LPS_BCN_CNT 0xC5BC
#define R_BE_LPS_BCN_CNT_C1 0xE5BC
#define B_BE_BCN_TO_ACC_CNT_SH 24
#define B_BE_BCN_TO_ACC_CNT_MSK 0xff
#define B_BE_BCN_OK_ACC_CNT_SH 16
#define B_BE_BCN_OK_ACC_CNT_MSK 0xff
#define B_BE_BCN_TO_CNT_THD_SH 8
#define B_BE_BCN_TO_CNT_THD_MSK 0xff
#define B_BE_BCN_TO_CNT_SH 0
#define B_BE_BCN_TO_CNT_MSK 0xff

#define R_BE_FREERUN_CNT_LOW 0xC5C0
#define R_BE_FREERUN_CNT_LOW_C1 0xE5C0
#define B_BE_FREERUN_CNT_LOW_SH 0
#define B_BE_FREERUN_CNT_LOW_MSK 0xffffffffL

#define R_BE_FREERUN_CNT_HIGH 0xC5C4
#define R_BE_FREERUN_CNT_HIGH_C1 0xE5C4
#define B_BE_FREERUN_CNT_HIGH_SH 0
#define B_BE_FREERUN_CNT_HIGH_MSK 0xffffffffL

#define R_BE_PSTIMER0 0xC5CC
#define R_BE_PSTIMER0_C1 0xE5CC
#define B_BE_PSTIMER0_VAL_SH 0
#define B_BE_PSTIMER0_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER1 0xC5D0
#define R_BE_PSTIMER1_C1 0xE5D0
#define B_BE_PSTIMER1_VAL_SH 0
#define B_BE_PSTIMER1_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER2 0xC5D4
#define R_BE_PSTIMER2_C1 0xE5D4
#define B_BE_PSTIMER2_VAL_SH 0
#define B_BE_PSTIMER2_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER3 0xC5D8
#define R_BE_PSTIMER3_C1 0xE5D8
#define B_BE_PSTIMER3_VAL_SH 0
#define B_BE_PSTIMER3_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER4 0xC5DC
#define R_BE_PSTIMER4_C1 0xE5DC
#define B_BE_PSTIMER4_VAL_SH 0
#define B_BE_PSTIMER4_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER5 0xC5E0
#define R_BE_PSTIMER5_C1 0xE5E0
#define B_BE_PSTIMER5_VAL_SH 0
#define B_BE_PSTIMER5_VAL_MSK 0xffffffffL

#define R_BE_PSTIMER_CTRL 0xC5E4
#define R_BE_PSTIMER_CTRL_C1 0xE5E4
#define B_BE_PSTIMER6_EN BIT(27)
#define B_BE_PSTIMER6_SEL_SH 24
#define B_BE_PSTIMER6_SEL_MSK 0x7
#define B_BE_PSTIMER5_EN BIT(23)
#define B_BE_PSTIMER5_SEL_SH 20
#define B_BE_PSTIMER5_SEL_MSK 0x7
#define B_BE_PSTIMER4_EN BIT(19)
#define B_BE_PSTIMER4_SEL_SH 16
#define B_BE_PSTIMER4_SEL_MSK 0x7
#define B_BE_PSTIMER3_EN BIT(15)
#define B_BE_PSTIMER3_SEL_SH 12
#define B_BE_PSTIMER3_SEL_MSK 0x7
#define B_BE_PSTIMER2_EN BIT(11)
#define B_BE_PSTIMER2_SEL_SH 8
#define B_BE_PSTIMER2_SEL_MSK 0x7
#define B_BE_PSTIMER1_EN BIT(7)
#define B_BE_PSTIMER1_SEL_SH 4
#define B_BE_PSTIMER1_SEL_MSK 0x7
#define B_BE_PSTIMER0_EN BIT(3)
#define B_BE_PSTIMER0_SEL_SH 0
#define B_BE_PSTIMER0_SEL_MSK 0x7

#define R_BE_TIMER_COMPARE 0xC5E8
#define R_BE_TIMER_COMPARE_C1 0xE5E8
#define B_BE_X_COMP_Y_TSFT_P BIT(7)
#define B_BE_Y_COMP_SEL_SH 4
#define B_BE_Y_COMP_SEL_MSK 0x7
#define B_BE_X_COMP_Y_OVER BIT(3)
#define B_BE_X_COMP_SEL_SH 0
#define B_BE_X_COMP_SEL_MSK 0x7

#define R_BE_TIMER_COMPARE_VALUE_LOW 0xC5EC
#define R_BE_TIMER_COMPARE_VALUE_LOW_C1 0xE5EC
#define B_BE_X_COMP_Y_VAL_LOW_SH 0
#define B_BE_X_COMP_Y_VAL_LOW_MSK 0xffffffffL

#define R_BE_TIMER_COMPARE_VALUE_HIGH 0xC5F0
#define R_BE_TIMER_COMPARE_VALUE_HIGH_C1 0xE5F0
#define B_BE_X_COMP_Y_VAL_HIGH_SH 0
#define B_BE_X_COMP_Y_VAL_HIGH_MSK 0xffffffffL

#define R_BE_PSTIMER6 0xC5F4
#define R_BE_PSTIMER6_C1 0xE5F4
#define B_BE_PSTIMER6_VAL_SH 0
#define B_BE_PSTIMER6_VAL_MSK 0xffffffffL

//
// PTCL
//

#define R_BE_PTCL_COMMON_SETTING_0 0xC600
#define R_BE_PTCL_COMMON_SETTING_0_C1 0xE600
#define B_BE_PCIE_MODE_SH 14
#define B_BE_PCIE_MODE_MSK 0x3
#define B_BE_CPUMGQ_LIFETIME_EN BIT(8)
#define B_BE_MGQ_LIFETIME_EN BIT(7)
#define B_BE_LIFETIME_EN BIT(6)
#define B_BE_DIS_PTCL_CLK_GATING BIT(5)
#define B_BE_PTCL_TRIGGER_SS_EN_UL BIT(4)
#define B_BE_PTCL_TRIGGER_SS_EN_1 BIT(3)
#define B_BE_PTCL_TRIGGER_SS_EN_0 BIT(2)
#define B_BE_CMAC_TX_MODE_1 BIT(1)
#define B_BE_CMAC_TX_MODE_0 BIT(0)

#define R_BE_AGG_BK_0 0xC604
#define R_BE_AGG_BK_0_C1 0xE604
#define B_BE_DIS_SIFS_BK_AGG_AMPDU BIT(20)
#define B_BE_EN_MU2SU_CHK_PROTECT_PPDU BIT(19)
#define B_BE_RPT_TXOP_START_PROTECT BIT(18)
#define B_BE_RANDOM_GEN_CMD_ABORT_EN BIT(17)
#define B_BE_PHYTXON_ENDPS_RESP_CHK BIT(16)
#define B_BE_CTN_CHK_SEQ_REQ_EN BIT(15)
#define B_BE_PTCL_RLS_ALLFAIL_EN BIT(14)
#define B_BE_MAX_AGG_NUM_FIX_MODE_EN BIT(13)
#define B_BE_DIS_MURU_SEC_Q_EMPTY_CHK BIT(12)
#define B_BE_EN_SAMPDU_TXIME_TWT_CHECK BIT(11)
#define B_BE_DIS_SAMPDU_TXIME_P2P_CHECK BIT(10)
#define B_BE_DIS_SAMPDU_TXIME_BCN_CHECK BIT(9)
#define B_BE_DIS_UL_SEQ_ABORT_CHECK BIT(8)
#define B_BE_DIS_SND_STS_CHECK BIT(7)
#define B_BE_NAV_PAUS_PHB_EN BIT(6)
#define B_BE_TXOP_SHT_PHB_EN BIT(5)
#define B_BE_AGG_BRK_PHB_EN BIT(4)
#define B_BE_DIS_SSN_CHK BIT(3)
#define B_BE_WDBK_CFG BIT(2)
#define B_BE_EN_RTY_BK BIT(1)
#define B_BE_EN_RTY_BK_COD BIT(0)

#define R_BE_TX_CTRL 0xC608
#define R_BE_TX_CTRL_C1 0xE608
#define B_BE_DROP_CHK_MAX_NUM_SH 24
#define B_BE_DROP_CHK_MAX_NUM_MSK 0xff
#define B_BE_DROP_CHK_TIMEOUT_SH 20
#define B_BE_DROP_CHK_TIMEOUT_MSK 0xf
#define B_BE_FWD_SRCH_TIMEOUT_SH 16
#define B_BE_FWD_SRCH_TIMEOUT_MSK 0xf
#define B_BE_PTCL_STOP_WMM BIT(7)
#define B_BE_TXOP_DELAY_TX_SH 0
#define B_BE_TXOP_DELAY_TX_MSK 0x1f

#define R_BE_TB_PPDU_CTRL 0xC60C
#define R_BE_TB_PPDU_CTRL_C1 0xE60C
#define B_BE_TB_PPDU_BK_DIS BIT(15)
#define B_BE_TB_PPDU_BE_DIS BIT(14)
#define B_BE_TB_PPDU_VI_DIS BIT(13)
#define B_BE_TB_PPDU_VO_DIS BIT(12)
#define B_BE_TB_BYPASS_TXPWR BIT(2)
#define B_BE_SW_PREFER_AC_SH 0
#define B_BE_SW_PREFER_AC_MSK 0x3

#define R_BE_AMPDU_AGG_LIMIT 0xC610
#define R_BE_AMPDU_AGG_LIMIT_C1 0xE610
#define B_BE_AMPDU_MAX_TIME_SH 24
#define B_BE_AMPDU_MAX_TIME_MSK 0xff
#define B_BE_RA_TRY_RATE_AGG_LMT_SH 16
#define B_BE_RA_TRY_RATE_AGG_LMT_MSK 0xff
#define B_BE_RTS_MAX_AGG_NUM_SH 8
#define B_BE_RTS_MAX_AGG_NUM_MSK 0xff
#define B_BE_MAX_AGG_NUM_SH 0
#define B_BE_MAX_AGG_NUM_MSK 0xff

#define R_BE_AGG_LEN_HT_0 0xC614
#define R_BE_AGG_LEN_HT_0_C1 0xE614
#define B_BE_AMPDU_MAX_LEN_HT_SH 16
#define B_BE_AMPDU_MAX_LEN_HT_MSK 0xffff
#define B_BE_RTS_TXTIME_TH_SH 8
#define B_BE_RTS_TXTIME_TH_MSK 0xff
#define B_BE_RTS_LEN_TH_SH 0
#define B_BE_RTS_LEN_TH_MSK 0xff

#define R_BE_AGG_LEN_VHT_0 0xC618
#define R_BE_AGG_LEN_VHT_0_C1 0xE618
#define B_BE_OFDM_LEN_TH_SH 20
#define B_BE_OFDM_LEN_TH_MSK 0xfff
#define B_BE_AMPDU_MAX_LEN_VHT_SH 0
#define B_BE_AMPDU_MAX_LEN_VHT_MSK 0xfffff

#define R_BE_AGG_LEN_HE_0 0xC61C
#define R_BE_AGG_LEN_HE_0_C1 0xE61C
#define B_BE_AMPDU_MAX_LEN_HE_SH 0
#define B_BE_AMPDU_MAX_LEN_HE_MSK 0x7fffff

#define R_BE_SPECIAL_TX_SETTING 0xC620
#define R_BE_SPECIAL_TX_SETTING_C1 0xE620
#define B_BE_TRI_PADDING_EXTEND BIT(31)
#define B_BE_USE_DATA_BW BIT(29)
#define B_BE_BW_SIGTA_SH 27
#define B_BE_BW_SIGTA_MSK 0x3
#define B_BE_BMC_NAV_PROTECT BIT(26)
#define B_BE_BAR_TXRATE_FOR_NULL_WD_SH 20
#define B_BE_BAR_TXRATE_FOR_NULL_WD_MSK 0xf
#define B_BE_STBC_CFEND_SH 18
#define B_BE_STBC_CFEND_MSK 0x3
#define B_BE_STBC_CFEND_RATE_SH 9
#define B_BE_STBC_CFEND_RATE_MSK 0x1ff
#define B_BE_BASIC_CFEND_RATE_SH 0
#define B_BE_BASIC_CFEND_RATE_MSK 0x1ff

#define R_BE_SIFS_SETTING 0xC624
#define R_BE_SIFS_SETTING_C1 0xE624
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_SH 24
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_MSK 0xff
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_TWW_SH 18
#define B_BE_HW_CTS2SELF_PKT_LEN_TH_TWW_MSK 0x3f
#define B_BE_HW_CTS2SELF_EN BIT(16)
#define B_BE_SPEC_SIFS_OFDM_PTCL_SH 8
#define B_BE_SPEC_SIFS_OFDM_PTCL_MSK 0xff
#define B_BE_SPEC_SIFS_CCK_PTCL_SH 0
#define B_BE_SPEC_SIFS_CCK_PTCL_MSK 0xff

#define R_BE_TXRATE_CHK 0xC628
#define R_BE_TXRATE_CHK_C1 0xE628
#define B_BE_LATENCY_PADDING_PKT_TH_SH 24
#define B_BE_LATENCY_PADDING_PKT_TH_MSK 0xff
#define B_BE_PLCP_FETCH_BUFF_SH 16
#define B_BE_PLCP_FETCH_BUFF_MSK 0xff
#define B_BE_DEFT_RATE_SH 7
#define B_BE_DEFT_RATE_MSK 0x1ff
#define B_BE_OFDM_CCK_ERR_PROC BIT(6)
#define B_BE_PKT_LAST_TX BIT(5)
#define B_BE_BAND_MODE BIT(4)
#define B_BE_MAX_TXNSS_SH 2
#define B_BE_MAX_TXNSS_MSK 0x3
#define B_BE_RTS_LIMIT_IN_OFDM6 BIT(1)
#define B_BE_CHECK_CCK_EN BIT(0)

#define R_BE_TXCNT 0xC62C
#define R_BE_TXCNT_C1 0xE62C
#define B_BE_ADD_TXCNT_BY BIT(31)
#define B_BE_S_TXCNT_LMT_SH 24
#define B_BE_S_TXCNT_LMT_MSK 0x3f
#define B_BE_L_TXCNT_LMT_SH 16
#define B_BE_L_TXCNT_LMT_MSK 0x3f

#define R_BE_LIFETIME_0 0xC630
#define R_BE_LIFETIME_0_C1 0xE630
#define B_BE_PKT_LIFETIME_2_SH 16
#define B_BE_PKT_LIFETIME_2_MSK 0xffff
#define B_BE_PKT_LIFETIME_1_SH 0
#define B_BE_PKT_LIFETIME_1_MSK 0xffff

#define R_BE_LIFETIME_1 0xC634
#define R_BE_LIFETIME_1_C1 0xE634
#define B_BE_PKT_LIFETIME_4_SH 16
#define B_BE_PKT_LIFETIME_4_MSK 0xffff
#define B_BE_PKT_LIFETIME_3_SH 0
#define B_BE_PKT_LIFETIME_3_MSK 0xffff

#define R_BE_LIFETIME_2 0xC638
#define R_BE_LIFETIME_2_C1 0xE638
#define B_BE_CPUMGQ_LIFETIME_SH 16
#define B_BE_CPUMGQ_LIFETIME_MSK 0xffff
#define B_BE_MGQ_LIFETIME_SH 0
#define B_BE_MGQ_LIFETIME_MSK 0xffff

#define R_BE_MBSSID_DROP_0 0xC63C
#define R_BE_MBSSID_DROP_0_C1 0xE63C
#define B_BE_GI_LTF_FB_SEL BIT(30)
#define B_BE_RATE_SEL_SH 24
#define B_BE_RATE_SEL_MSK 0x3f
#define B_BE_PORT_DROP_4_0_SH 16
#define B_BE_PORT_DROP_4_0_MSK 0x1f
#define B_BE_MBSSID_DROP_15_0_SH 0
#define B_BE_MBSSID_DROP_15_0_MSK 0xffff

#define R_BE_ARFR_WT_0 0xC640
#define R_BE_ARFR_WT_0_C1 0xE640
#define B_BE_RATE7_WEIGHTING_SH 28
#define B_BE_RATE7_WEIGHTING_MSK 0xf
#define B_BE_RATE6_WEIGHTING_SH 24
#define B_BE_RATE6_WEIGHTING_MSK 0xf
#define B_BE_RATE5_WEIGHTING_SH 20
#define B_BE_RATE5_WEIGHTING_MSK 0xf
#define B_BE_RATE4_WEIGHTING_SH 16
#define B_BE_RATE4_WEIGHTING_MSK 0xf
#define B_BE_RATE3_WEIGHTING_SH 12
#define B_BE_RATE3_WEIGHTING_MSK 0xf
#define B_BE_RATE2_WEIGHTING_SH 8
#define B_BE_RATE2_WEIGHTING_MSK 0xf
#define B_BE_RATE1_WEIGHTING_SH 4
#define B_BE_RATE1_WEIGHTING_MSK 0xf
#define B_BE_RATE0_WEIGHTING_SH 0
#define B_BE_RATE0_WEIGHTING_MSK 0xf

#define R_BE_DARF_TC 0xC648
#define R_BE_DARF_TC_C1 0xE648
#define B_BE_DARF_TC9_SH 28
#define B_BE_DARF_TC9_MSK 0xf
#define B_BE_DARF_TC8_SH 24
#define B_BE_DARF_TC8_MSK 0xf
#define B_BE_DARF_TC7_SH 20
#define B_BE_DARF_TC7_MSK 0xf
#define B_BE_DARF_TC6_SH 16
#define B_BE_DARF_TC6_MSK 0xf
#define B_BE_DARF_TC5_SH 12
#define B_BE_DARF_TC5_MSK 0xf
#define B_BE_DARF_TC4_SH 8
#define B_BE_DARF_TC4_MSK 0xf
#define B_BE_DARF_TC3_SH 4
#define B_BE_DARF_TC3_MSK 0xf
#define B_BE_DARF_TC2_SH 0
#define B_BE_DARF_TC2_MSK 0xf

#define R_BE_DARF1_TC 0xC64C
#define R_BE_DARF1_TC_C1 0xE64C
#define B_BE_DARF1_TC9_SH 28
#define B_BE_DARF1_TC9_MSK 0xf
#define B_BE_DARF1_TC8_SH 24
#define B_BE_DARF1_TC8_MSK 0xf
#define B_BE_DARF1_TC7_SH 20
#define B_BE_DARF1_TC7_MSK 0xf
#define B_BE_DARF1_TC6_SH 16
#define B_BE_DARF1_TC6_MSK 0xf
#define B_BE_DARF1_TC5_SH 12
#define B_BE_DARF1_TC5_MSK 0xf
#define B_BE_DARF1_TC4_SH 8
#define B_BE_DARF1_TC4_MSK 0xf
#define B_BE_DARF1_TC3_SH 4
#define B_BE_DARF1_TC3_MSK 0xf
#define B_BE_DARF1_TC2_SH 0
#define B_BE_DARF1_TC2_MSK 0xf

#define R_BE_RARF_TC 0xC650
#define R_BE_RARF_TC_C1 0xE650
#define B_BE_RARF_TC9_SH 28
#define B_BE_RARF_TC9_MSK 0xf
#define B_BE_RARF_TC8_SH 24
#define B_BE_RARF_TC8_MSK 0xf
#define B_BE_RARF_TC7_SH 20
#define B_BE_RARF_TC7_MSK 0xf
#define B_BE_RARF_TC6_SH 16
#define B_BE_RARF_TC6_MSK 0xf
#define B_BE_RARF_TC5_SH 12
#define B_BE_RARF_TC5_MSK 0xf
#define B_BE_RARF_TC4_SH 8
#define B_BE_RARF_TC4_MSK 0xf
#define B_BE_RARF_TC3_SH 4
#define B_BE_RARF_TC3_MSK 0xf
#define B_BE_RARF_TC2_SH 0
#define B_BE_RARF_TC2_MSK 0xf

#define R_BE_PTCL_ATM 0xC654
#define R_BE_PTCL_ATM_C1 0xE654
#define B_BE_CHNL_REF_RX_BASIC_NAV BIT(31)
#define B_BE_CHNL_REF_RX_INTRA_NAV BIT(30)
#define B_BE_CHNL_REF_DATA_ON BIT(29)
#define B_BE_CHNL_REF_EDCCA_P20 BIT(28)
#define B_BE_CHNL_REF_CCA_P20 BIT(27)
#define B_BE_CHNL_REF_CCA_S20 BIT(26)
#define B_BE_CHNL_REF_CCA_S40 BIT(25)
#define B_BE_CHNL_REF_CCA_S80 BIT(24)
#define B_BE_CHNL_REF_PHY_TXON BIT(23)
#define B_BE_RST_CHNL_BUSY BIT(19)
#define B_BE_RST_CHNL_IDLE BIT(18)
#define B_BE_CHNL_INFO_EN BIT(17)
#define B_BE_ATM_AIRTIME_EN BIT(16)
#define B_BE_ATM_PRI BIT(13)
#define B_BE_ATM_TF_UD BIT(12)
#define B_BE_ATM_SR_UD_1_SH 10
#define B_BE_ATM_SR_UD_1_MSK 0x3
#define B_BE_ATM_SR_UD_0_SH 8
#define B_BE_ATM_SR_UD_0_MSK 0x3
#define B_BE_ATM_TB_UD_1_SH 6
#define B_BE_ATM_TB_UD_1_MSK 0x3
#define B_BE_ATM_TB_UD_0_SH 4
#define B_BE_ATM_TB_UD_0_MSK 0x3
#define B_BE_ATM_TX_UD_1_SH 2
#define B_BE_ATM_TX_UD_1_MSK 0x3
#define B_BE_ATM_TX_UD_0_SH 0
#define B_BE_ATM_TX_UD_0_MSK 0x3

#define R_BE_CHNL_IDLE_TIME_0 0xC658
#define R_BE_CHNL_IDLE_TIME_0_C1 0xE658
#define B_BE_CHNL_IDLE_TIME_SH 0
#define B_BE_CHNL_IDLE_TIME_MSK 0xffffffffL

#define R_BE_CHNL_BUSY_TIME_0 0xC65C
#define R_BE_CHNL_BUSY_TIME_0_C1 0xE65C
#define B_BE_CHNL_BUSY_TIME_SH 0
#define B_BE_CHNL_BUSY_TIME_MSK 0xffffffffL

#define R_BE_PTCLRPT_FULL_HDL 0xC660
#define R_BE_PTCLRPT_FULL_HDL_C1 0xE660
#define B_BE_CMAC_DMA_BLOCK_TX_THD_SH 16
#define B_BE_CMAC_DMA_BLOCK_TX_THD_MSK 0x3f
#define B_BE_RPT_LATCH_PHY_TIME_SH 12
#define B_BE_RPT_LATCH_PHY_TIME_MSK 0xf
#define B_BE_TXOP_END_RPT_EN BIT(10)
#define B_BE_F2PCMD_FWWD_RLS_MODE BIT(9)
#define B_BE_F2PCMD_RPT_EN BIT(8)
#define B_BE_BCN_RPT_PATH_SH 6
#define B_BE_BCN_RPT_PATH_MSK 0x3
#define B_BE_SPE_RPT_PATH_SH 4
#define B_BE_SPE_RPT_PATH_MSK 0x3
#define B_BE_TX_RPT_PATH_SH 2
#define B_BE_TX_RPT_PATH_MSK 0x3
#define B_BE_F2PCMDRPT_FULL_DROP BIT(1)
#define B_BE_NON_F2PCMDRPT_FULL_DROP BIT(0)

#define R_BE_PTCL_F2P_RLS 0xC664
#define R_BE_PTCL_F2P_RLS_C1 0xE664
#define B_BE_F2PRLS_PRTID_NEED_RPT_SH 24
#define B_BE_F2PRLS_PRTID_NEED_RPT_MSK 0x7
#define B_BE_F2PRLS_QUEID_NEED_RPT_SH 16
#define B_BE_F2PRLS_QUEID_NEED_RPT_MSK 0x3f
#define B_BE_F2PRLS_PRTID_NO_RPT_SH 8
#define B_BE_F2PRLS_PRTID_NO_RPT_MSK 0x7
#define B_BE_F2PRLS_QUEID_NO_RPT_SH 0
#define B_BE_F2PRLS_QUEID_NO_RPT_MSK 0x3f

#define R_BE_PTCL_PRELD_CTRL 0xC668
#define R_BE_PTCL_PRELD_CTRL_C1 0xE668
#define B_BE_PRELD_MGQ2_EN BIT(22)
#define B_BE_PRELD_MGQ1_EN BIT(21)
#define B_BE_PRELD_MGQ0_EN BIT(20)
#define B_BE_PRELD_HIQ_P4_EN BIT(19)
#define B_BE_PRELD_HIQ_P3_EN BIT(18)
#define B_BE_PRELD_HIQ_P2_EN BIT(17)
#define B_BE_PRELD_HIQ_P1_EN BIT(16)
#define B_BE_PRELD_HIQ_P0MB15_EN BIT(15)
#define B_BE_PRELD_HIQ_P0MB14_EN BIT(14)
#define B_BE_PRELD_HIQ_P0MB13_EN BIT(13)
#define B_BE_PRELD_HIQ_P0MB12_EN BIT(12)
#define B_BE_PRELD_HIQ_P0MB11_EN BIT(11)
#define B_BE_PRELD_HIQ_P0MB10_EN BIT(10)
#define B_BE_PRELD_HIQ_P0MB9_EN BIT(9)
#define B_BE_PRELD_HIQ_P0MB8_EN BIT(8)
#define B_BE_PRELD_HIQ_P0MB7_EN BIT(7)
#define B_BE_PRELD_HIQ_P0MB6_EN BIT(6)
#define B_BE_PRELD_HIQ_P0MB5_EN BIT(5)
#define B_BE_PRELD_HIQ_P0MB4_EN BIT(4)
#define B_BE_PRELD_HIQ_P0MB3_EN BIT(3)
#define B_BE_PRELD_HIQ_P0MB2_EN BIT(2)
#define B_BE_PRELD_HIQ_P0MB1_EN BIT(1)
#define B_BE_PRELD_HIQ_P0_EN BIT(0)

#define R_BE_PTCL_TXOP_BK 0xC670
#define R_BE_PTCL_TXOP_BK_C1 0xE670
#define B_BE_DISABLE_TXOP_CFE BIT(31)
#define B_BE_DISABLE_LSIG_CFE BIT(30)
#define B_BE_CMAC_DMA_BLOCK_TX BIT(26)
#define B_BE_CMAC_DMA_BREAK_TXOP BIT(25)
#define B_BE_TXOP_BK_EN_V1_SH 16
#define B_BE_TXOP_BK_EN_V1_MSK 0x1ff
#define B_BE_TXOP_BK_PKT_NUM_SH 8
#define B_BE_TXOP_BK_PKT_NUM_MSK 0xff
#define B_BE_TXOP_BK_TX_TIME_SH 0
#define B_BE_TXOP_BK_TX_TIME_MSK 0xff

#define R_BE_PTCL_NAV_PROT_LEN 0xC674
#define R_BE_PTCL_NAV_PROT_LEN_C1 0xE674
#define B_BE_SPEC_MBA_HE_PTCL_SH 16
#define B_BE_SPEC_MBA_HE_PTCL_MSK 0xffff
#define B_BE_NAV_PROT_LEN_SH 0
#define B_BE_NAV_PROT_LEN_MSK 0xffff

#define R_BE_PROT 0xC678
#define R_BE_PROT_C1 0xE678
#define B_BE_TXQ_NAV_MSK_SH 24
#define B_BE_TXQ_NAV_MSK_MSK 0xff
#define B_BE_LSIG_TXOP_TXCMD_NAV BIT(18)
#define B_BE_RTS_NAV_TXOP BIT(17)
#define B_BE_NAV_OVER_TXOP_EN BIT(16)
#define B_BE_NAV_PROT_LEN_CTN_MODE_SH 0
#define B_BE_NAV_PROT_LEN_CTN_MODE_MSK 0xffff

#define R_BE_BT_PLT 0xC67C
#define R_BE_BT_PLT_C1 0xE67C
#define B_BE_BT_PLT_PKT_CNT_SH 16
#define B_BE_BT_PLT_PKT_CNT_MSK 0xffff
#define B_BE_BT_PLT_RST BIT(9)
#define B_BE_PLT_EN BIT(8)
#define B_BE_RX_PLT_GNT_LTE_RX BIT(7)
#define B_BE_RX_PLT_GNT_BT_RX BIT(6)
#define B_BE_RX_PLT_GNT_BT_TX BIT(5)
#define B_BE_RX_PLT_GNT_WL BIT(4)
#define B_BE_TX_PLT_GNT_LTE_RX BIT(3)
#define B_BE_TX_PLT_GNT_BT_RX BIT(2)
#define B_BE_TX_PLT_GNT_BT_TX BIT(1)
#define B_BE_TX_PLT_GNT_WL BIT(0)

#define R_BE_TWTQ_CTRL1 0xC680
#define R_BE_TWTQ_CTRL1_C1 0xE680
#define B_BE_TWTQ_ULTRHD_SH 16
#define B_BE_TWTQ_ULTRHD_MSK 0xffff
#define B_BE_TWTQ_TXOPTRHD_SH 0
#define B_BE_TWTQ_TXOPTRHD_MSK 0xffff

#define R_BE_TWTQ_CTRL2 0xC684
#define R_BE_TWTQ_CTRL2_C1 0xE684
#define B_BE_TWTQ_AGGTRHD_SH 0
#define B_BE_TWTQ_AGGTRHD_MSK 0xffff

#define R_BE_BCNQ_CTRL 0xC690
#define R_BE_BCNQ_CTRL_C1 0xE690
#define B_BE_BCNQ_LOCK_STUS BIT(31)
#define B_BE_BCN_DROP_DSTQUEID_SH 8
#define B_BE_BCN_DROP_DSTQUEID_MSK 0x3f
#define B_BE_BCN_DROP_PRTQUEID_SH 4
#define B_BE_BCN_DROP_PRTQUEID_MSK 0x7
#define B_BE_BCNQ_PKTIN_EN BIT(1)
#define B_BE_BCNQ_LOCK BIT(0)

#define R_BE_PTCL_BSS_COLOR_0 0xC6A0
#define R_BE_PTCL_BSS_COLOR_0_C1 0xE6A0
#define B_BE_BSS_COLOB_BE_PORT_3_SH 24
#define B_BE_BSS_COLOB_BE_PORT_3_MSK 0x3f
#define B_BE_BSS_COLOB_BE_PORT_2_SH 16
#define B_BE_BSS_COLOB_BE_PORT_2_MSK 0x3f
#define B_BE_BSS_COLOB_BE_PORT_1_SH 8
#define B_BE_BSS_COLOB_BE_PORT_1_MSK 0x3f
#define B_BE_BSS_COLOB_BE_PORT_0_SH 0
#define B_BE_BSS_COLOB_BE_PORT_0_MSK 0x3f

#define R_BE_PTCL_BSS_COLOR_1 0xC6A4
#define R_BE_PTCL_BSS_COLOR_1_C1 0xE6A4
#define B_BE_BSS_COLOB_BE_PORT_4_SH 0
#define B_BE_BSS_COLOB_BE_PORT_4_MSK 0x3f

#define R_BE_PTCL_F2P_TX_SETTING 0xC6B0
#define R_BE_PTCL_F2P_TX_SETTING_C1 0xE6B0
#define B_BE_TF_MURTS_TXTIME_SH 8
#define B_BE_TF_MURTS_TXTIME_MSK 0xff
#define B_BE_TF_DATA_TF_LENGTH_SH 0
#define B_BE_TF_DATA_TF_LENGTH_MSK 0xff

#define R_BE_PTCL_IMR_2 0xC6B8
#define R_BE_PTCL_IMR_2_C1 0xE6B8
#define B_BE_PTCL_IMR2_SH 0
#define B_BE_PTCL_IMR2_MSK 0xffffffffL

#define R_BE_PTCL_ISR_2 0xC6BC
#define R_BE_PTCL_ISR_2_C1 0xE6BC
#define B_BE_PTCL_ISR2_SH 0
#define B_BE_PTCL_ISR2_MSK 0xffffffffL

#define R_BE_PTCL_IMR0 0xC6C0
#define R_BE_PTCL_IMR0_C1 0xE6C0
#define B_BE_F2PCMD_PKTID_ERR_INT_EN BIT(31)
#define B_BE_F2PCMD_RD_PKTID_ERR_INT_EN BIT(30)
#define B_BE_F2PCMD_ASSIGN_PKTID_ERR_INT_EN BIT(29)
#define B_BE_F2PCMD_USER_ALLC_ERR_INT_EN BIT(28)
#define B_BE_RX_SPF_U0_PKTID_ERR_INT_EN BIT(27)
#define B_BE_TX_SPF_U1_PKTID_ERR_INT_EN BIT(26)
#define B_BE_TX_SPF_U2_PKTID_ERR_INT_EN BIT(25)
#define B_BE_TX_SPF_U3_PKTID_ERR_INT_EN BIT(24)
#define B_BE_TX_RECORD_PKTID_ERR_INT_EN BIT(23)
#define B_BE_F2PCMD_EMPTY_ERR_INT_EN BIT(15)
#define B_BE_TWTSP_QSEL_ERR_INT_EN BIT(14)
#define B_BE_BCNQ_ORDER_ERR_INT_EN BIT(12)
#define B_BE_Q_PKTID_ERR_INT_EN BIT(11)
#define B_BE_D_PKTID_ERR_INT_EN BIT(10)
#define B_BE_TXPRT_FULL_DROP_ERR_INT_EN BIT(9)
#define B_BE_F2PCMDRPT_FULL_DROP_ERR_INT_EN BIT(8)
#define B_BE_FSM1_TIMEOUT_ERR_INT_EN BIT(1)

#define R_BE_PTCL_ISR0 0xC6C4
#define R_BE_PTCL_ISR0_C1 0xE6C4
#define B_BE_F2PCMD_PKTID_ERR BIT(31)
#define B_BE_F2PCMD_RD_PKTID_ERR BIT(30)
#define B_BE_F2PCMD_ASSIGN_PKTID_ERR BIT(29)
#define B_BE_F2PCMD_USER_ALLC_ERR BIT(28)
#define B_BE_RX_SPF_U0_PKTID_ERR BIT(27)
#define B_BE_TX_SPF_U1_PKTID_ERR BIT(26)
#define B_BE_TX_SPF_U2_PKTID_ERR BIT(25)
#define B_BE_TX_SPF_U3_PKTID_ERR BIT(24)
#define B_BE_TX_RECORD_PKTID_ERR BIT(23)
#define B_BE_F2PCMD_EMPTY_ERR BIT(15)
#define B_BE_TWTSP_QSEL_ERR BIT(14)
#define B_BE_BCNQ_ORDER_ERR BIT(12)
#define B_BE_Q_PKTID_ERR BIT(11)
#define B_BE_D_PKTID_ERR BIT(10)
#define B_BE_TXPRT_FULL_DROP_ERR BIT(9)
#define B_BE_F2PCMDRPT_FULL_DROP_ERR BIT(8)
#define B_BE_FSM_TIMEOUT_ERR BIT(0)

#define R_BE_PTCL_IMR1 0xC6C8
#define R_BE_PTCL_IMR1_C1 0xE6C8
#define B_BE_PTCL_IMR1_SH 0
#define B_BE_PTCL_IMR1_MSK 0xffffffffL

#define R_BE_PTCL_ISR1 0xC6CC
#define R_BE_PTCL_ISR1_C1 0xE6CC
#define B_BE_PTCL_ISR1_SH 0
#define B_BE_PTCL_ISR1_MSK 0xffffffffL

#define R_BE_PTCL_F2P_INFO_PRI 0xC6D0
#define R_BE_PTCL_F2P_INFO_PRI_C1 0xE6D0
#define B_BE_F2PCMD_PKTID_INFO_PRI_SH 0
#define B_BE_F2PCMD_PKTID_INFO_PRI_MSK 0xffffffffL

#define R_BE_PTCL_F2P_INFO_0_1 0xC6D4
#define R_BE_PTCL_F2P_INFO_0_1_C1 0xE6D4
#define B_BE_F2PCMD_PKTID_INFO_S1_S0_SH 0
#define B_BE_F2PCMD_PKTID_INFO_S1_S0_MSK 0xffffffffL

#define R_BE_PTCL_F2P_INFO_2_3 0xC6D8
#define R_BE_PTCL_F2P_INFO_2_3_C1 0xE6D8
#define B_BE_F2PCMD_PKTID_INFO_S3_S2_SH 0
#define B_BE_F2PCMD_PKTID_INFO_S3_S2_MSK 0xffffffffL

#define R_BE_PTCL_F2P_INFO_4_5 0xC6DC
#define R_BE_PTCL_F2P_INFO_4_5_C1 0xE6DC
#define B_BE_F2PCMD_PKTID_INFO_S5_S4_SH 0
#define B_BE_F2PCMD_PKTID_INFO_S5_S4_MSK 0xffffffffL

#define R_BE_PTCL_RST_CTRL 0xC6E0
#define R_BE_PTCL_RST_CTRL_C1 0xE6E0
#define B_BE_PTCL_TX_FINISH_REQ_STATUS BIT(24)
#define B_BE_FSM1_TIMEOUT_THB_BE_UNIT_SH 8
#define B_BE_FSM1_TIMEOUT_THB_BE_UNIT_MSK 0x3
#define B_BE_RPT_ABORT_CNT_RST BIT(4)
#define B_BE_TX_ABORT_ALWAYS_END_CMD BIT(2)
#define B_BE_PTCL_WDE_EN BIT(1)
#define B_BE_PTCL_TX_FINISH_REQ BIT(0)

#define R_BE_PTCL_FSM_MON 0xC6E8
#define R_BE_PTCL_FSM_MON_C1 0xE6E8
#define B_BE_PTCL_FSM2_TO_MODE BIT(30)
#define B_BE_PTCL_FSM2_TO_THR_SH 24
#define B_BE_PTCL_FSM2_TO_THR_MSK 0x3f
#define B_BE_PTCL_FSM1_TO_MODE BIT(22)
#define B_BE_PTCL_FSM1_TO_THR_SH 16
#define B_BE_PTCL_FSM1_TO_THR_MSK 0x3f
#define B_BE_PTCL_FSM0_TO_MODE BIT(14)
#define B_BE_PTCL_FSM0_TO_THR_SH 8
#define B_BE_PTCL_FSM0_TO_THR_MSK 0x3f
#define B_BE_PTCL_TX_ARB_TO_MODE BIT(6)
#define B_BE_PTCL_TX_ARB_TO_THR_SH 0
#define B_BE_PTCL_TX_ARB_TO_THR_MSK 0x3f

#define R_BE_PTCL_TX_CTN_SEL 0xC6EC
#define R_BE_PTCL_TX_CTN_SEL_C1 0xE6EC
#define B_BE_PTCL_TXOP_STAT BIT(8)
#define B_BE_PTCL_TX_ON_STAT BIT(7)
#define B_BE_PTCL_DROP BIT(5)
#define B_BE_PTCL_TX_QUEUE_IDX_SH 0
#define B_BE_PTCL_TX_QUEUE_IDX_MSK 0x1f

#define R_BE_PTCL_DBG_INFO 0xC6F0
#define R_BE_PTCL_DBG_INFO_C1 0xE6F0
#define B_BE_PTCL_DBG_INFO_SH 0
#define B_BE_PTCL_DBG_INFO_MSK 0xffffffffL

#define R_BE_NULL_PKT_STATUS 0xC6F6
#define R_BE_NULL_PKT_STATUS_C1 0xE6F6
#define B_BE_P4_NULL_1_STATUS BIT(9)
#define B_BE_P4_NULL_0_STATUS BIT(8)
#define B_BE_P3_NULL_1_STATUS BIT(7)
#define B_BE_P3_NULL_0_STATUS BIT(6)
#define B_BE_P2_NULL_1_STATUS BIT(5)
#define B_BE_P2_NULL_0_STATUS BIT(4)
#define B_BE_P1_NULL_1_STATUS BIT(3)
#define B_BE_P1_NULL_0_STATUS BIT(2)
#define B_BE_P0_NULL_1_STATUS BIT(1)
#define B_BE_P0_NULL_0_STATUS BIT(0)

#define R_BE_PTCL_DBG 0xC6F4
#define R_BE_PTCL_DBG_C1 0xE6F4
#define B_BE_RPT_CMAC_DBG_INFO_SEL_SH 12
#define B_BE_RPT_CMAC_DBG_INFO_SEL_MSK 0xf
#define B_BE_PTCL_DBG_EN BIT(8)
#define B_BE_PTCL_DBG_SEL_SH 0
#define B_BE_PTCL_DBG_SEL_MSK 0xff

#define R_BE_PTCL_ERR_FLAG 0xC6F8
#define R_BE_PTCL_ERR_FLAG_C1 0xE6F8
#define B_BE_PTCLERR_FLAG_W1C_15 BIT(15)
#define B_BE_PTCLERR_FLAG_W1C_14 BIT(14)
#define B_BE_PTCLERR_FLAG_W1C_13 BIT(13)
#define B_BE_PTCLERR_FLAG_W1C_12 BIT(12)
#define B_BE_PTCLERR_FLAG_W1C_11 BIT(11)
#define B_BE_PTCLERR_FLAG_W1C_10 BIT(10)
#define B_BE_PTCLERR_FLAG_W1C_9 BIT(9)
#define B_BE_PTCLERR_FLAG_W1C_8 BIT(8)
#define B_BE_PTCLERR_FLAG_W1C_7 BIT(7)
#define B_BE_PTCLERR_FLAG_W1C_6 BIT(6)
#define B_BE_PTCLERR_FLAG_W1C_5 BIT(5)
#define B_BE_PTCLERR_FLAG_W1C_4 BIT(4)
#define B_BE_PTCLERR_FLAG_W1C_3 BIT(3)
#define B_BE_PTCLERR_FLAG_W1C_2 BIT(2)
#define B_BE_PTCLERR_FLAG_W1C_1 BIT(1)
#define B_BE_PTCLERR_FLAG_W1C_0 BIT(0)

#define R_BE_PTCL_DBG_INFO_1 0xC6FC
#define R_BE_PTCL_DBG_INFO_1_C1 0xE6FC
#define B_BE_PTCL_RPT_CMAC_DBG_INFO_SH 0
#define B_BE_PTCL_RPT_CMAC_DBG_INFO_MSK 0xffff

#define R_BE_TXCMD_DBG_SEL 0xC700
#define R_BE_TXCMD_DBG_SEL_C1 0xE700
#define B_BE_USER_CMD_VALID_SH 24
#define B_BE_USER_CMD_VALID_MSK 0xff
#define B_BE_DBG_SEL_F2P_COMMON_SH 20
#define B_BE_DBG_SEL_F2P_COMMON_MSK 0xf
#define B_BE_DBG_SEL_USER_CMD_U3_SH 16
#define B_BE_DBG_SEL_USER_CMD_U3_MSK 0xf
#define B_BE_DBG_SEL_USER_CMD_U2_SH 12
#define B_BE_DBG_SEL_USER_CMD_U2_MSK 0xf
#define B_BE_DBG_SEL_USER_CMD_U1_SH 8
#define B_BE_DBG_SEL_USER_CMD_U1_MSK 0xf
#define B_BE_DBG_SEL_USER_CMD_U0_SH 4
#define B_BE_DBG_SEL_USER_CMD_U0_MSK 0xf
#define B_BE_DBG_SEL_PPDU_CMD_SH 0
#define B_BE_DBG_SEL_PPDU_CMD_MSK 0xf

#define R_BE_PPDU_CMD 0xC704
#define R_BE_PPDU_CMD_C1 0xE704
#define B_BE_PPDU_CMD_SH 0
#define B_BE_PPDU_CMD_MSK 0xffffffffL

#define R_BE_USER_CMD_U0 0xC708
#define R_BE_USER_CMD_U0_C1 0xE708
#define B_BE_USER_CMD_U0_SH 0
#define B_BE_USER_CMD_U0_MSK 0xffffffffL

#define R_BE_USER_CMD_U1 0xC70C
#define R_BE_USER_CMD_U1_C1 0xE70C
#define B_BE_USER_CMD_U1_SH 0
#define B_BE_USER_CMD_U1_MSK 0xffffffffL

#define R_BE_USER_CMD_U2 0xC710
#define R_BE_USER_CMD_U2_C1 0xE710
#define B_BE_USER_CMD_U2_SH 0
#define B_BE_USER_CMD_U2_MSK 0xffffffffL

#define R_BE_USER_CMD_U3 0xC714
#define R_BE_USER_CMD_U3_C1 0xE714
#define B_BE_USER_CMD_U3_SH 0
#define B_BE_USER_CMD_U3_MSK 0xffffffffL

#define R_BE_USR_CMD_U4 0xC718
#define R_BE_USR_CMD_U4_C1 0xE718
#define B_BE_USER_CMD_U4_SH 0
#define B_BE_USER_CMD_U4_MSK 0xffffffffL

#define R_BE_USR_CMD_U5 0xC71C
#define R_BE_USR_CMD_U5_C1 0xE71C
#define B_BE_USER_CMD_U5_SH 0
#define B_BE_USER_CMD_U5_MSK 0xffffffffL

#define R_BE_USR_CMD_U6 0xC720
#define R_BE_USR_CMD_U6_C1 0xE720
#define B_BE_USER_CMD_U6_SH 0
#define B_BE_USER_CMD_U6_MSK 0xffffffffL

#define R_BE_USR_CMD_U7 0xC724
#define R_BE_USR_CMD_U7_C1 0xE724
#define B_BE_USER_CMD_U7_SH 0
#define B_BE_USER_CMD_U7_MSK 0xffffffffL

#define R_BE_F2P_COMMON 0xC728
#define R_BE_F2P_COMMON_C1 0xE728
#define B_BE_F2P_COMMON_SH 0
#define B_BE_F2P_COMMON_MSK 0xffffffffL

#define R_BE_LEN_CMD_U0_V1 0xC72C
#define R_BE_LEN_CMD_U0_V1_C1 0xE72C
#define B_BE_LEN_CMD_U0_SH 0
#define B_BE_LEN_CMD_U0_MSK 0xffffffffL

#define R_BE_LEN_CMD_U1_V1 0xC730
#define R_BE_LEN_CMD_U1_V1_C1 0xE730
#define B_BE_LEN_CMD_U1_SH 0
#define B_BE_LEN_CMD_U1_MSK 0xffffffffL

#define R_BE_LEN_CMD_U2_V1 0xC734
#define R_BE_LEN_CMD_U2_V1_C1 0xE734
#define B_BE_LEN_CMD_U2_SH 0
#define B_BE_LEN_CMD_U2_MSK 0xffffffffL

#define R_BE_LEN_CMD_U3_V1 0xC738
#define R_BE_LEN_CMD_U3_V1_C1 0xE738
#define B_BE_LEN_CMD_U3_SH 0
#define B_BE_LEN_CMD_U3_MSK 0xffffffffL

#define R_BE_LEN_CMD_U4 0xC73C
#define R_BE_LEN_CMD_U4_C1 0xE73C
#define B_BE_LEN_CMD_U4_SH 0
#define B_BE_LEN_CMD_U4_MSK 0xffffffffL

#define R_BE_LEN_CMD_U5 0xC740
#define R_BE_LEN_CMD_U5_C1 0xE740
#define B_BE_LEN_CMD_U5_SH 0
#define B_BE_LEN_CMD_U5_MSK 0xffffffffL

#define R_BE_LEN_CMD_U6 0xC744
#define R_BE_LEN_CMD_U6_C1 0xE744
#define B_BE_LEN_CMD_U6_SH 0
#define B_BE_LEN_CMD_U6_MSK 0xffffffffL

#define R_BE_LEN_CMD_U7 0xC748
#define R_BE_LEN_CMD_U7_C1 0xE748
#define B_BE_LEN_CMD_U7_SH 0
#define B_BE_LEN_CMD_U7_MSK 0xffffffffL

#define R_BE_USR_INFO_U0 0xC74C
#define R_BE_USR_INFO_U0_C1 0xE74C
#define B_BE_USB_BE_IFO_U0_SH 0
#define B_BE_USB_BE_IFO_U0_MSK 0xffffffffL

#define R_BE_USR_INFO_U1 0xC750
#define R_BE_USR_INFO_U1_C1 0xE750
#define B_BE_USB_BE_IFO_U1_SH 0
#define B_BE_USB_BE_IFO_U1_MSK 0xffffffffL

#define R_BE_USR_INFO_U2 0xC754
#define R_BE_USR_INFO_U2_C1 0xE754
#define B_BE_USB_BE_IFO_U2_SH 0
#define B_BE_USB_BE_IFO_U2_MSK 0xffffffffL

#define R_BE_USR_INFO_U3 0xC758
#define R_BE_USR_INFO_U3_C1 0xE758
#define B_BE_USB_BE_IFO_U3_SH 0
#define B_BE_USB_BE_IFO_U3_MSK 0xffffffffL

#define R_BE_USR_INFO_U4 0xC75C
#define R_BE_USR_INFO_U4_C1 0xE75C
#define B_BE_USB_BE_IFO_U4_SH 0
#define B_BE_USB_BE_IFO_U4_MSK 0xffffffffL

#define R_BE_USR_INFO_U5 0xC760
#define R_BE_USR_INFO_U5_C1 0xE760
#define B_BE_USB_BE_IFO_U5_SH 0
#define B_BE_USB_BE_IFO_U5_MSK 0xffffffffL

#define R_BE_USR_INFO_U6 0xC764
#define R_BE_USR_INFO_U6_C1 0xE764
#define B_BE_USB_BE_IFO_U6_SH 0
#define B_BE_USB_BE_IFO_U6_MSK 0xffffffffL

#define R_BE_USR_INFO_U7 0xC768
#define R_BE_USR_INFO_U7_C1 0xE768
#define B_BE_USB_BE_IFO_U7_SH 0
#define B_BE_USB_BE_IFO_U7_MSK 0xffffffffL

#define R_BE_PTCL_TX_MACID_0_V1 0xC76C
#define R_BE_PTCL_TX_MACID_0_V1_C1 0xE76C
#define B_BE_TX_MACID_3_SH 24
#define B_BE_TX_MACID_3_MSK 0xff
#define B_BE_TX_MACID_2_SH 16
#define B_BE_TX_MACID_2_MSK 0xff
#define B_BE_TX_MACID_1_SH 8
#define B_BE_TX_MACID_1_MSK 0xff
#define B_BE_TX_MACID_0_SH 0
#define B_BE_TX_MACID_0_MSK 0xff

#define R_BE_PTCL_TX_MACID_1 0xC770
#define R_BE_PTCL_TX_MACID_1_C1 0xE770
#define B_BE_TX_MACID_7_SH 24
#define B_BE_TX_MACID_7_MSK 0xff
#define B_BE_TX_MACID_6_SH 16
#define B_BE_TX_MACID_6_MSK 0xff
#define B_BE_TX_MACID_5_SH 8
#define B_BE_TX_MACID_5_MSK 0xff
#define B_BE_TX_MACID_4_SH 0
#define B_BE_TX_MACID_4_MSK 0xff

#define R_BE_PTCL_F2P_INFO_6_7 0xC774
#define R_BE_PTCL_F2P_INFO_6_7_C1 0xE774
#define B_BE_F2PCMD_PKTID_INFO_S7_S6_SH 0
#define B_BE_F2PCMD_PKTID_INFO_S7_S6_MSK 0xffffffffL

#define R_BE_PTCL_F2P_INFO_8_9 0xC778
#define R_BE_PTCL_F2P_INFO_8_9_C1 0xE778
#define B_BE_F2PCMD_PKTID_INFO_S9_S8_SH 0
#define B_BE_F2PCMD_PKTID_INFO_S9_S8_MSK 0xffffffffL

#define R_BE_PTCL_SIGB_PADDING_0 0xC7E0
#define R_BE_PTCL_SIGB_PADDING_0_C1 0xE7E0
#define B_BE_SIGB_PADDING_0_SH 0
#define B_BE_SIGB_PADDING_0_MSK 0xffffffffL

#define R_BE_PTCL_SIGB_PADDING_1 0xC7E4
#define R_BE_PTCL_SIGB_PADDING_1_C1 0xE7E4
#define B_BE_SIGB_PADDING_1_SH 0
#define B_BE_SIGB_PADDING_1_MSK 0xffffffffL

#define R_BE_PTCL_SIGB_PADDING_2 0xC7E8
#define R_BE_PTCL_SIGB_PADDING_2_C1 0xE7E8
#define B_BE_SIGB_PADDING_2_SH 0
#define B_BE_SIGB_PADDING_2_MSK 0xffffffffL

#define R_BE_PTCL_SIGB_PADDING_3 0xC7EC
#define R_BE_PTCL_SIGB_PADDING_3_C1 0xE7EC
#define B_BE_SIGB_PADDING_3_SH 0
#define B_BE_SIGB_PADDING_3_MSK 0xffffffffL

#define R_BE_PTCL_SIGB_HW_SETTING 0xC7F0
#define R_BE_PTCL_SIGB_HW_SETTING_C1 0xE7F0
#define B_BE_SIGB_HW_TIME_LMT_SH 0
#define B_BE_SIGB_HW_TIME_LMT_MSK 0x7

//
// CMAC_DMA
//

#define R_BE_RX_ERROR_FLAG 0xC800
#define R_BE_RX_ERROR_FLAG_C1 0xE800
#define B_BE_RX_CSI_NOT_RELEASE_ERROR BIT(31)
#define B_BE_RX_GET_NULL_PKT_ERROR BIT(30)
#define B_BE_RX_RU0_FSM_HANG_ERROR BIT(29)
#define B_BE_RX_RU1_FSM_HANG_ERROR BIT(28)
#define B_BE_RX_RU2_FSM_HANG_ERROR BIT(27)
#define B_BE_RX_RU3_FSM_HANG_ERROR BIT(26)
#define B_BE_RX_RU4_FSM_HANG_ERROR BIT(25)
#define B_BE_RX_RU5_FSM_HANG_ERROR BIT(24)
#define B_BE_RX_RU6_FSM_HANG_ERROR BIT(23)
#define B_BE_RX_RU7_FSM_HANG_ERROR BIT(22)
#define B_BE_RX_RXSTS_FSM_HANG_ERROR BIT(21)
#define B_BE_RX_CSI_FSM_HANG_ERROR BIT(20)
#define B_BE_RX_TXRPT_FSM_HANG_ERROR BIT(19)
#define B_BE_RX_F2PCMD_FSM_HANG_ERROR BIT(18)
#define B_BE_RX_RU0_ZERO_LENGTH_ERROR BIT(17)
#define B_BE_RX_RU1_ZERO_LENGTH_ERROR BIT(16)
#define B_BE_RX_RU2_ZERO_LENGTH_ERROR BIT(15)
#define B_BE_RX_RU3_ZERO_LENGTH_ERROR BIT(14)
#define B_BE_RX_RU4_ZERO_LENGTH_ERROR BIT(13)
#define B_BE_RX_RU5_ZERO_LENGTH_ERROR BIT(12)
#define B_BE_RX_RU6_ZERO_LENGTH_ERROR BIT(11)
#define B_BE_RX_RU7_ZERO_LENGTH_ERROR BIT(10)
#define B_BE_RX_RXSTS_ZERO_LENGTH_ERROR BIT(9)
#define B_BE_RX_CSI_ZERO_LENGTH_ERROR BIT(8)
#define B_BE_PLE_DATA_OPT_FSM_HANG BIT(7)
#define B_BE_PLE_RXDATA_REQUEST_BUFFER_FSM_HANG BIT(6)
#define B_BE_PLE_TXRPT_REQUEST_BUFFER_FSM_HANG BIT(5)
#define B_BE_PLE_WD_OPT_FSM_HANG BIT(4)
#define B_BE_PLE_ENQ_FSM_HANG BIT(3)
#define B_BE_RXDATA_ENQUE_ORDER_ERROR BIT(2)
#define B_BE_RXSTS_ENQUE_ORDER_ERROR BIT(1)
#define B_BE_RX_CSI_PKT_NUM_ERROR BIT(0)

#define R_BE_RX_ERROR_FLAG_IMR 0xC804
#define R_BE_RX_ERROR_FLAG_IMR_C1 0xE804
#define B_BE_RX_CSI_NOT_RELEASE_ERROR_IMR BIT(31)
#define B_BE_RX_GET_NULL_PKT_ERROR_IMR BIT(30)
#define B_BE_RX_RU0_FSM_HANG_ERROR_IMR BIT(29)
#define B_BE_RX_RU1_FSM_HANG_ERROR_IMR BIT(28)
#define B_BE_RX_RU2_FSM_HANG_ERROR_IMR BIT(27)
#define B_BE_RX_RU3_FSM_HANG_ERROR_IMR BIT(26)
#define B_BE_RX_RU4_FSM_HANG_ERROR_IMR BIT(25)
#define B_BE_RX_RU5_FSM_HANG_ERROR_IMR BIT(24)
#define B_BE_RX_RU6_FSM_HANG_ERROR_IMR BIT(23)
#define B_BE_RX_RU7_FSM_HANG_ERROR_IMR BIT(22)
#define B_BE_RX_RXSTS_FSM_HANG_ERROR_IMR BIT(21)
#define B_BE_RX_CSI_FSM_HANG_ERROR_IMR BIT(20)
#define B_BE_RX_TXRPT_FSM_HANG_ERROR_IMR BIT(19)
#define B_BE_RX_F2PCMD_FSM_HANG_ERROR_IMR BIT(18)
#define B_BE_RX_RU0_ZERO_LENGTH_ERROR_IMR BIT(17)
#define B_BE_RX_RU1_ZERO_LENGTH_ERROR_IMR BIT(16)
#define B_BE_RX_RU2_ZERO_LENGTH_ERROR_IMR BIT(15)
#define B_BE_RX_RU3_ZERO_LENGTH_ERROR_IMR BIT(14)
#define B_BE_RX_RU4_ZERO_LENGTH_ERROR_IMR BIT(13)
#define B_BE_RX_RU5_ZERO_LENGTH_ERROR_IMR BIT(12)
#define B_BE_RX_RU6_ZERO_LENGTH_ERROR_IMR BIT(11)
#define B_BE_RX_RU7_ZERO_LENGTH_ERROR_IMR BIT(10)
#define B_BE_RX_RXSTS_ZERO_LENGTH_ERROR_IMR BIT(9)
#define B_BE_RX_CSI_ZERO_LENGTH_ERROR_IMR BIT(8)
#define B_BE_PLE_DATA_OPT_FSM_HANG_IMR BIT(7)
#define B_BE_PLE_RXDATA_REQUEST_BUFFER_FSM_HANG_IMR BIT(6)
#define B_BE_PLE_TXRPT_REQUEST_BUFFER_FSM_HANG_IMR BIT(5)
#define B_BE_PLE_WD_OPT_FSM_HANG_IMR BIT(4)
#define B_BE_PLE_ENQ_FSM_HANG_IMR BIT(3)
#define B_BE_RXDATA_ENQUE_ORDER_ERROR_IMR BIT(2)
#define B_BE_RXSTS_ENQUE_ORDER_ERROR_IMR BIT(1)
#define B_BE_RX_CSI_PKT_NUM_ERROR_IMR BIT(0)

#define R_BE_RX_CTRL_0 0xC808
#define R_BE_RX_CTRL_0_C1 0xE808
#define B_BE_DLE_CLOCK_FORCE BIT(31)
#define B_BE_TXDMA_CLOCK_FORCE BIT(30)
#define B_BE_RXDMA_CLOCK_FORCE BIT(29)
#define B_BE_RXDMA_DEFAULT_PAGE_SH 24
#define B_BE_RXDMA_DEFAULT_PAGE_MSK 0x1f
#define B_BE_RXDMA_CSI_TGT_QUEID_SH 18
#define B_BE_RXDMA_CSI_TGT_QUEID_MSK 0x3f
#define B_BE_RXDMA_CSI_TGT_PRID_SH 15
#define B_BE_RXDMA_CSI_TGT_PRID_MSK 0x7
#define B_BE_RXDMA_DIS_CSI_RELEASE BIT(14)
#define B_BE_CSI_PTR_FULL_MODE BIT(13)
#define B_BE_RXDATA_PTR_FULL_MODE BIT(12)
#define B_BE_RXSTS_PTR_FULL_MODE BIT(11)
#define B_BE_TXRPT_FULL_RSV_DEPTH_SH 8
#define B_BE_TXRPT_FULL_RSV_DEPTH_MSK 0x7
#define B_BE_RXDATA_FULL_RSV_DEPTH_SH 5
#define B_BE_RXDATA_FULL_RSV_DEPTH_MSK 0x7
#define B_BE_RXSTS_FULL_RSV_DEPTH_SH 2
#define B_BE_RXSTS_FULL_RSV_DEPTH_MSK 0x7
#define B_BE_ORDER_FIFO_CNT_SH 0
#define B_BE_ORDER_FIFO_CNT_MSK 0x3

#define R_BE_RX_CTRL_1 0xC80C
#define R_BE_RX_CTRL_1_C1 0xE80C
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_SW_EN BIT(31)
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_SW_SH 25
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_SW_MSK 0x3f
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_SW_EN BIT(24)
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_SW_SH 18
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_SW_MSK 0x3f
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_EN BIT(17)
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_1_SH 11
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_1_MSK 0x3f
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_EN BIT(10)
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_1_SH 4
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_1_MSK 0x3f
#define B_BE_ORDER_FIFO_OUT BIT(3)
#define B_BE_ORDER_FIFO_EMPTY BIT(2)
#define B_BE_DBG_SEL_SH 0
#define B_BE_DBG_SEL_MSK 0x3

#define R_BE_RX_CTRL_2 0xC810
#define R_BE_RX_CTRL_2_C1 0xE810
#define B_BE_DLE_WDE_STATE_SH 30
#define B_BE_DLE_WDE_STATE_MSK 0x3
#define B_BE_DLE_PLE_STATE_SH 28
#define B_BE_DLE_PLE_STATE_MSK 0x3
#define B_BE_DLE_REQUEST_BUFF_STATE_SH 26
#define B_BE_DLE_REQUEST_BUFF_STATE_MSK 0x3
#define B_BE_DLE_ENQ_STATE BIT(25)
#define B_BE_RX_DBG_SEL_SH 19
#define B_BE_RX_DBG_SEL_MSK 0x3f
#define B_BE_MACRX_CS_SH 14
#define B_BE_MACRX_CS_MSK 0x1f
#define B_BE_RXSTS_CS_SH 9
#define B_BE_RXSTS_CS_MSK 0x1f
#define B_BE_ERROR_INDICATOR BIT(5)
#define B_BE_TXRPT_CS_SH 0
#define B_BE_TXRPT_CS_MSK 0x1f

#define R_BE_RX_INFO_RU1_RU0 0xC814
#define R_BE_RX_INFO_RU1_RU0_C1 0xE814
#define B_BE_RU1_IS_IDLE BIT(31)
#define B_BE_RU1_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU1_IS_REQ_BUFFER BIT(29)
#define B_BE_RU1_IS_ENQUE BIT(28)
#define B_BE_RU1_WR_PKT_ID_SH 16
#define B_BE_RU1_WR_PKT_ID_MSK 0xfff
#define B_BE_RU0_IS_IDLE BIT(15)
#define B_BE_RU0_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU0_IS_REQ_BUFFER BIT(13)
#define B_BE_RU0_IS_ENQUE BIT(12)
#define B_BE_RU0_WR_PKT_ID_SH 0
#define B_BE_RU0_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU3_RU2 0xC818
#define R_BE_RX_INFO_RU3_RU2_C1 0xE818
#define B_BE_RU3_IS_IDLE BIT(31)
#define B_BE_RU3_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU3_IS_REQ_BUFFER BIT(29)
#define B_BE_RU3_IS_ENQUE BIT(28)
#define B_BE_RU3_WR_PKT_ID_SH 16
#define B_BE_RU3_WR_PKT_ID_MSK 0xfff
#define B_BE_RU2_IS_IDLE BIT(15)
#define B_BE_RU2_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU2_IS_REQ_BUFFER BIT(13)
#define B_BE_RU2_IS_ENQUE BIT(12)
#define B_BE_RU2_WR_PKT_ID_SH 0
#define B_BE_RU2_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU5_RU4 0xC81C
#define R_BE_RX_INFO_RU5_RU4_C1 0xE81C
#define B_BE_RU5_IS_IDLE BIT(31)
#define B_BE_RU5_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU5_IS_REQ_BUFFER BIT(29)
#define B_BE_RU5_IS_ENQUE BIT(28)
#define B_BE_RU5_WR_PKT_ID_SH 16
#define B_BE_RU5_WR_PKT_ID_MSK 0xfff
#define B_BE_RU4_IS_IDLE BIT(15)
#define B_BE_RU4_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU4_IS_REQ_BUFFER BIT(13)
#define B_BE_RU4_IS_ENQUE BIT(12)
#define B_BE_RU4_WR_PKT_ID_SH 0
#define B_BE_RU4_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU7_RU6 0xC820
#define R_BE_RX_INFO_RU7_RU6_C1 0xE820
#define B_BE_RU7_IS_IDLE BIT(31)
#define B_BE_RU7_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU7_IS_REQ_BUFFER BIT(29)
#define B_BE_RU7_IS_ENQUE BIT(28)
#define B_BE_RU7_WR_PKT_ID_SH 16
#define B_BE_RU7_WR_PKT_ID_MSK 0xfff
#define B_BE_RU6_IS_IDLE BIT(15)
#define B_BE_RU6_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU6_IS_REQ_BUFFER BIT(13)
#define B_BE_RU6_IS_ENQUE BIT(12)
#define B_BE_RU6_WR_PKT_ID_SH 0
#define B_BE_RU6_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_F2PCMD_TXRPT 0xC824
#define R_BE_RX_INFO_F2PCMD_TXRPT_C1 0xE824
#define B_BE_F2PCMD_IS_IDLE BIT(31)
#define B_BE_F2PCMD_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_F2PCMD_IS_REQ_BUFFER BIT(29)
#define B_BE_F2PCMD_IS_ENQUE BIT(28)
#define B_BE_F2PCMD_WR_PKT_ID_SH 16
#define B_BE_F2PCMD_WR_PKT_ID_MSK 0xfff
#define B_BE_TXRPT_IS_IDLE BIT(15)
#define B_BE_TXRPT_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_TXRPT_IS_REQ_BUFFER BIT(13)
#define B_BE_TXRPT_IS_ENQUE BIT(12)
#define B_BE_TXRPT_WR_PKT_ID_SH 0
#define B_BE_TXRPT_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RXSTS 0xC828
#define R_BE_RX_INFO_RXSTS_C1 0xE828
#define B_BE_ENQ_FIFO_EMPTY BIT(31)
#define B_BE_CSI_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RXSTS_IS_IDLE BIT(15)
#define B_BE_RXSTS_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RXSTS_IS_REQ_BUFFER BIT(13)
#define B_BE_RXSTS_IS_ENQUE BIT(12)
#define B_BE_RXSTS_WR_PKT_ID_SH 0
#define B_BE_RXSTS_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_CSI 0xC82C
#define R_BE_RX_INFO_CSI_C1 0xE82C
#define B_BE_CSI_PKTID_1_VALID BIT(31)
#define B_BE_CSI_PKTID_1_SH 16
#define B_BE_CSI_PKTID_1_MSK 0xfff
#define B_BE_CSI_PKTID_0_VALID BIT(15)
#define B_BE_CSI_PKTID_0_SH 0
#define B_BE_CSI_PKTID_0_MSK 0xfff

#define R_BE_RX_DEBUG_OUT 0xC830
#define R_BE_RX_DEBUG_OUT_C1 0xE830
#define B_BE_RXDMA_DBG_OUT_SH 0
#define B_BE_RXDMA_DBG_OUT_MSK 0xffffffffL

#define R_BE_TX_FIFO_INFO_RU1_RU0 0xC834
#define R_BE_TX_FIFO_INFO_RU1_RU0_C1 0xE834
#define B_BE_TXDMA_RU1_CNT_SH 16
#define B_BE_TXDMA_RU1_CNT_MSK 0xffff
#define B_BE_TXDMA_RU0_CNT_SH 0
#define B_BE_TXDMA_RU0_CNT_MSK 0xffff

#define R_BE_TX_FIFO_INFO_RU3_RU2 0xC838
#define R_BE_TX_FIFO_INFO_RU3_RU2_C1 0xE838
#define B_BE_TXDMA_RU3_CNT_SH 16
#define B_BE_TXDMA_RU3_CNT_MSK 0xffff
#define B_BE_TXDMA_RU2_CNT_SH 0
#define B_BE_TXDMA_RU2_CNT_MSK 0xffff

#define R_BE_TX_FIFO_INFO_RU5_RU4 0xC83C
#define R_BE_TX_FIFO_INFO_RU5_RU4_C1 0xE83C
#define B_BE_TXDMA_RU5_CNT_SH 16
#define B_BE_TXDMA_RU5_CNT_MSK 0xffff
#define B_BE_TXDMA_RU4_CNT_SH 0
#define B_BE_TXDMA_RU4_CNT_MSK 0xffff

#define R_BE_TX_FIFO_INFO_RU7_RU6 0xC840
#define R_BE_TX_FIFO_INFO_RU7_RU6_C1 0xE840
#define B_BE_TXDMA_RU7_CNT_SH 16
#define B_BE_TXDMA_RU7_CNT_MSK 0xffff
#define B_BE_TXDMA_RU6_CNT_SH 0
#define B_BE_TXDMA_RU6_CNT_MSK 0xffff

#define R_BE_CDMA_TX_CTRL 0xC844
#define R_BE_CDMA_TX_CTRL_C1 0xE844
#define B_BE_TX_CSI_MODE BIT(31)
#define B_BE_TX_FINISH_REQ BIT(30)
#define B_BE_REQ_WD_PLD_ID_CS_SH 28
#define B_BE_REQ_WD_PLD_ID_CS_MSK 0x3
#define B_BE_WD_ARB_RU_SH 25
#define B_BE_WD_ARB_RU_MSK 0x7
#define B_BE_PL_ARB_RU_SH 22
#define B_BE_PL_ARB_RU_MSK 0x7
#define B_BE_TXDMA_DBG_SEL_SH 16
#define B_BE_TXDMA_DBG_SEL_MSK 0x3f
#define B_BE_TXDMA_DEFAULT_PAGE_SH 11
#define B_BE_TXDMA_DEFAULT_PAGE_MSK 0x1f
#define B_BE_WORD044_RSV_SH 0
#define B_BE_WORD044_RSV_MSK 0x7ff

#define R_BE_TX_INFO_RU0 0xC848
#define R_BE_TX_INFO_RU0_C1 0xE848
#define B_BE_RU0_VLD BIT(31)
#define B_BE_RU0_WAIT_FINISH BIT(30)
#define B_BE_RU0_CUR_WD_ID_SH 18
#define B_BE_RU0_CUR_WD_ID_MSK 0xfff
#define B_BE_RU0_CUR_PL_ID_SH 6
#define B_BE_RU0_CUR_PL_ID_MSK 0xfff
#define B_BE_RU0_READ_CS_SH 3
#define B_BE_RU0_READ_CS_MSK 0x7
#define B_BE_RU0_WRITE_CS_SH 0
#define B_BE_RU0_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU1 0xC84C
#define R_BE_TX_INFO_RU1_C1 0xE84C
#define B_BE_RU1_VLD BIT(31)
#define B_BE_RU1_WAIT_FINISH BIT(30)
#define B_BE_RU1_CUR_WD_ID_SH 18
#define B_BE_RU1_CUR_WD_ID_MSK 0xfff
#define B_BE_RU1_CUR_PL_ID_SH 6
#define B_BE_RU1_CUR_PL_ID_MSK 0xfff
#define B_BE_RU1_READ_CS_SH 3
#define B_BE_RU1_READ_CS_MSK 0x7
#define B_BE_RU1_WRITE_CS_SH 0
#define B_BE_RU1_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU2 0xC850
#define R_BE_TX_INFO_RU2_C1 0xE850
#define B_BE_RU2_VLD BIT(31)
#define B_BE_RU2_WAIT_FINISH BIT(30)
#define B_BE_RU2_CUR_WD_ID_SH 18
#define B_BE_RU2_CUR_WD_ID_MSK 0xfff
#define B_BE_RU2_CUR_PL_ID_SH 6
#define B_BE_RU2_CUR_PL_ID_MSK 0xfff
#define B_BE_RU2_READ_CS_SH 3
#define B_BE_RU2_READ_CS_MSK 0x7
#define B_BE_RU2_WRITE_CS_SH 0
#define B_BE_RU2_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU3 0xC854
#define R_BE_TX_INFO_RU3_C1 0xE854
#define B_BE_RU3_VLD BIT(31)
#define B_BE_RU3_WAIT_FINISH BIT(30)
#define B_BE_RU3_CUR_WD_ID_SH 18
#define B_BE_RU3_CUR_WD_ID_MSK 0xfff
#define B_BE_RU3_CUR_PL_ID_SH 6
#define B_BE_RU3_CUR_PL_ID_MSK 0xfff
#define B_BE_RU3_READ_CS_SH 3
#define B_BE_RU3_READ_CS_MSK 0x7
#define B_BE_RU3_WRITE_CS_SH 0
#define B_BE_RU3_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU4 0xC858
#define R_BE_TX_INFO_RU4_C1 0xE858
#define B_BE_RU4_VLD BIT(31)
#define B_BE_RU4_WAIT_FINISH BIT(30)
#define B_BE_RU4_CUR_WD_ID_SH 18
#define B_BE_RU4_CUR_WD_ID_MSK 0xfff
#define B_BE_RU4_CUR_PL_ID_SH 6
#define B_BE_RU4_CUR_PL_ID_MSK 0xfff
#define B_BE_RU4_READ_CS_SH 3
#define B_BE_RU4_READ_CS_MSK 0x7
#define B_BE_RU4_WRITE_CS_SH 0
#define B_BE_RU4_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU5 0xC85C
#define R_BE_TX_INFO_RU5_C1 0xE85C
#define B_BE_RU5_VLD BIT(31)
#define B_BE_RU5_WAIT_FINISH BIT(30)
#define B_BE_RU5_CUR_WD_ID_SH 18
#define B_BE_RU5_CUR_WD_ID_MSK 0xfff
#define B_BE_RU5_CUR_PL_ID_SH 6
#define B_BE_RU5_CUR_PL_ID_MSK 0xfff
#define B_BE_RU5_READ_CS_SH 3
#define B_BE_RU5_READ_CS_MSK 0x7
#define B_BE_RU5_WRITE_CS_SH 0
#define B_BE_RU5_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU6 0xC860
#define R_BE_TX_INFO_RU6_C1 0xE860
#define B_BE_RU6_VLD BIT(31)
#define B_BE_RU6_WAIT_FINISH BIT(30)
#define B_BE_RU6_CUR_WD_ID_SH 18
#define B_BE_RU6_CUR_WD_ID_MSK 0xfff
#define B_BE_RU6_CUR_PL_ID_SH 6
#define B_BE_RU6_CUR_PL_ID_MSK 0xfff
#define B_BE_RU6_READ_CS_SH 3
#define B_BE_RU6_READ_CS_MSK 0x7
#define B_BE_RU6_WRITE_CS_SH 0
#define B_BE_RU6_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU7 0xC864
#define R_BE_TX_INFO_RU7_C1 0xE864
#define B_BE_RU7_VLD BIT(31)
#define B_BE_RU7_WAIT_FINISH BIT(30)
#define B_BE_RU7_CUR_WD_ID_SH 18
#define B_BE_RU7_CUR_WD_ID_MSK 0xfff
#define B_BE_RU7_CUR_PL_ID_SH 6
#define B_BE_RU7_CUR_PL_ID_MSK 0xfff
#define B_BE_RU7_READ_CS_SH 3
#define B_BE_RU7_READ_CS_MSK 0x7
#define B_BE_RU7_WRITE_CS_SH 0
#define B_BE_RU7_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_CSI 0xC868
#define R_BE_TX_INFO_CSI_C1 0xE868
#define B_BE_CSI_VLD BIT(31)
#define B_BE_CSI_WAIT_FINISH BIT(30)
#define B_BE_CSI_PRE_EN BIT(29)
#define B_BE_CSI_TX_DONE_MONITOR BIT(28)
#define B_BE_CSI_CUR_PL_ID_SH 6
#define B_BE_CSI_CUR_PL_ID_MSK 0xfff
#define B_BE_CSI_READ_CS_SH 3
#define B_BE_CSI_READ_CS_MSK 0x7
#define B_BE_CSI_WRITE_CS_SH 0
#define B_BE_CSI_WRITE_CS_MSK 0x7

#define R_BE_TX_ERROR_FLAG 0xC86C
#define R_BE_TX_ERROR_FLAG_C1 0xE86C
#define B_BE_TX_RU0_FSM_HANG_ERROR BIT(31)
#define B_BE_TX_RU1_FSM_HANG_ERROR BIT(30)
#define B_BE_TX_RU2_FSM_HANG_ERROR BIT(29)
#define B_BE_TX_RU3_FSM_HANG_ERROR BIT(28)
#define B_BE_TX_RU4_FSM_HANG_ERROR BIT(27)
#define B_BE_TX_RU5_FSM_HANG_ERROR BIT(26)
#define B_BE_TX_RU6_FSM_HANG_ERROR BIT(25)
#define B_BE_TX_RU7_FSM_HANG_ERROR BIT(24)
#define B_BE_TX_RU8_FSM_HANG_ERROR BIT(23)
#define B_BE_TX_RU9_FSM_HANG_ERROR BIT(22)
#define B_BE_TX_RU10_FSM_HANG_ERROR BIT(21)
#define B_BE_TX_RU11_FSM_HANG_ERROR BIT(20)
#define B_BE_TX_RU12_FSM_HANG_ERROR BIT(19)
#define B_BE_TX_RU13_FSM_HANG_ERROR BIT(18)
#define B_BE_TX_RU14_FSM_HANG_ERROR BIT(17)
#define B_BE_TX_RU15_FSM_HANG_ERROR BIT(16)
#define B_BE_TX_CSI_FSM_HANG_ERROR BIT(15)
#define B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR BIT(14)

#define R_BE_TX_ERROR_FLAG_IMR 0xC870
#define R_BE_TX_ERROR_FLAG_IMR_C1 0xE870
#define B_BE_TX_RU0_FSM_HANG_ERROR_IMR BIT(31)
#define B_BE_TX_RU1_FSM_HANG_ERROR_IMR BIT(30)
#define B_BE_TX_RU2_FSM_HANG_ERROR_IMR BIT(29)
#define B_BE_TX_RU3_FSM_HANG_ERROR_IMR BIT(28)
#define B_BE_TX_RU4_FSM_HANG_ERROR_IMR BIT(27)
#define B_BE_TX_RU5_FSM_HANG_ERROR_IMR BIT(26)
#define B_BE_TX_RU6_FSM_HANG_ERROR_IMR BIT(25)
#define B_BE_TX_RU7_FSM_HANG_ERROR_IMR BIT(24)
#define B_BE_TX_RU8_FSM_HANG_ERROR_IMR BIT(23)
#define B_BE_TX_RU9_FSM_HANG_ERROR_IMR BIT(22)
#define B_BE_TX_RU10_FSM_HANG_ERROR_IMR BIT(21)
#define B_BE_TX_RU11_FSM_HANG_ERROR_IMR BIT(20)
#define B_BE_TX_RU12_FSM_HANG_ERROR_IMR BIT(19)
#define B_BE_TX_RU13_FSM_HANG_ERROR_IMR BIT(18)
#define B_BE_TX_RU14_FSM_HANG_ERROR_IMR BIT(17)
#define B_BE_TX_RU15_FSM_HANG_ERROR_IMR BIT(16)
#define B_BE_TX_CSI_FSM_HANG_ERROR_IMR BIT(15)
#define B_BE_TX_WD_PLD_ID_FSM_HANG_ERROR_IMR BIT(14)

#define R_BE_TX_DEBUG_OUT 0xC874
#define R_BE_TX_DEBUG_OUT_C1 0xE874
#define B_BE_TXDMA_DBG_OUT_SH 0
#define B_BE_TXDMA_DBG_OUT_MSK 0xffffffffL

#define R_BE_MISC_CTRL 0xC878
#define R_BE_MISC_CTRL_C1 0xE878
#define B_BE_QARBIT_SEL BIT(31)
#define B_BE_RX_FSM_1MS_TIMEOUT_SH 24
#define B_BE_RX_FSM_1MS_TIMEOUT_MSK 0x7f
#define B_BE_TX_FSM_1MS_TIMEOUT_SH 17
#define B_BE_TX_FSM_1MS_TIMEOUT_MSK 0x7f
#define B_BE_QARBIT_FORCE BIT(16)
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_2_SH 10
#define B_BE_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_2_MSK 0x3f
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_2_SH 4
#define B_BE_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_2_MSK 0x3f
#define B_BE_QARBIT_FORCE2 BIT(3)
#define B_BE_FSM_LOCK_SEL BIT(2)

#define R_BE_RX_INFO_CSI_1 0xC87C
#define R_BE_RX_INFO_CSI_1_C1 0xE87C
#define B_BE_CSI_PKTID_3_VALID BIT(31)
#define B_BE_CSI_PKTID_3_SH 16
#define B_BE_CSI_PKTID_3_MSK 0xfff
#define B_BE_CSI_PKTID_2_VALID BIT(15)
#define B_BE_CSI_PKTID_2_SH 0
#define B_BE_CSI_PKTID_2_MSK 0xfff

#define R_BE_MISC_CTRL_2 0xC880
#define R_BE_MISC_CTRL_2_C1 0xE880
#define B_BE_RXSTS_ENQUE_THRESHOLD_SH 16
#define B_BE_RXSTS_ENQUE_THRESHOLD_MSK 0xffff
#define B_BE_WORD0080_RSV_SH 2
#define B_BE_WORD0080_RSV_MSK 0x3fff
#define B_BE_CSI_AUTO_UNLOCK BIT(1)
#define B_BE_SRAM_IO_PROTECT BIT(0)

#define R_BE_RX_ERROR_FLAG_1 0xC884
#define R_BE_RX_ERROR_FLAG_1_C1 0xE884
#define B_BE_RX_RU8_FSM_HANG_ERROR BIT(29)
#define B_BE_RX_RU9_FSM_HANG_ERROR BIT(28)
#define B_BE_RX_RU10_FSM_HANG_ERROR BIT(27)
#define B_BE_RX_RU11_FSM_HANG_ERROR BIT(26)
#define B_BE_RX_RU12_FSM_HANG_ERROR BIT(25)
#define B_BE_RX_RU13_FSM_HANG_ERROR BIT(24)
#define B_BE_RX_RU14_FSM_HANG_ERROR BIT(23)
#define B_BE_RX_RU15_FSM_HANG_ERROR BIT(22)
#define B_BE_RX_RU8_ZERO_LENGTH_ERROR BIT(17)
#define B_BE_RX_RU9_ZERO_LENGTH_ERROR BIT(16)
#define B_BE_RX_RU10_ZERO_LENGTH_ERROR BIT(15)
#define B_BE_RX_RU11_ZERO_LENGTH_ERROR BIT(14)
#define B_BE_RX_RU12_ZERO_LENGTH_ERROR BIT(13)
#define B_BE_RX_RU13_ZERO_LENGTH_ERROR BIT(12)
#define B_BE_RX_RU14_ZERO_LENGTH_ERROR BIT(11)
#define B_BE_RX_RU15_ZERO_LENGTH_ERROR BIT(10)

#define R_BE_RX_ERROR_FLAG_IMR_1 0xC888
#define R_BE_RX_ERROR_FLAG_IMR_1_C1 0xE888

#define R_BE_RX_INFO_RU9_RU8 0xC88C
#define R_BE_RX_INFO_RU9_RU8_C1 0xE88C
#define B_BE_RU9_IS_IDLE BIT(31)
#define B_BE_RU9_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU9_IS_REQ_BUFFER BIT(29)
#define B_BE_RU9_IS_ENQUE BIT(28)
#define B_BE_RU9_WR_PKT_ID_SH 16
#define B_BE_RU9_WR_PKT_ID_MSK 0xfff
#define B_BE_RU8_IS_IDLE BIT(15)
#define B_BE_RU8_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU8_IS_REQ_BUFFER BIT(13)
#define B_BE_RU8_IS_ENQUE BIT(12)
#define B_BE_RU8_WR_PKT_ID_SH 0
#define B_BE_RU8_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU11_RU10 0xC890
#define R_BE_RX_INFO_RU11_RU10_C1 0xE890
#define B_BE_RU11_IS_IDLE BIT(31)
#define B_BE_RU11_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU11_IS_REQ_BUFFER BIT(29)
#define B_BE_RU11_IS_ENQUE BIT(28)
#define B_BE_RU11_WR_PKT_ID_SH 16
#define B_BE_RU11_WR_PKT_ID_MSK 0xfff
#define B_BE_RU10_IS_IDLE BIT(15)
#define B_BE_RU10_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU10_IS_REQ_BUFFER BIT(13)
#define B_BE_RU10_IS_ENQUE BIT(12)
#define B_BE_RU10_WR_PKT_ID_SH 0
#define B_BE_RU10_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU13_RU12 0xC894
#define R_BE_RX_INFO_RU13_RU12_C1 0xE894
#define B_BE_RU13_IS_IDLE BIT(31)
#define B_BE_RU13_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU13_IS_REQ_BUFFER BIT(29)
#define B_BE_RU13_IS_ENQUE BIT(28)
#define B_BE_RU13_WR_PKT_ID_SH 16
#define B_BE_RU13_WR_PKT_ID_MSK 0xfff
#define B_BE_RU12_IS_IDLE BIT(15)
#define B_BE_RU12_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU12_IS_REQ_BUFFER BIT(13)
#define B_BE_RU12_IS_ENQUE BIT(12)
#define B_BE_RU12_WR_PKT_ID_SH 0
#define B_BE_RU12_WR_PKT_ID_MSK 0xfff

#define R_BE_RX_INFO_RU15_RU14 0xC898
#define R_BE_RX_INFO_RU15_RU14_C1 0xE898
#define B_BE_RU15_IS_IDLE BIT(31)
#define B_BE_RU15_RXDATA_RECOVER_MANNUL BIT(30)
#define B_BE_RU15_IS_REQ_BUFFER BIT(29)
#define B_BE_RU15_IS_ENQUE BIT(28)
#define B_BE_RU15_WR_PKT_ID_SH 16
#define B_BE_RU15_WR_PKT_ID_MSK 0xfff
#define B_BE_RU14_IS_IDLE BIT(15)
#define B_BE_RU14_RXDATA_RECOVER_MANNUL BIT(14)
#define B_BE_RU14_IS_REQ_BUFFER BIT(13)
#define B_BE_RU14_IS_ENQUE BIT(12)
#define B_BE_RU14_WR_PKT_ID_SH 0
#define B_BE_RU14_WR_PKT_ID_MSK 0xfff

#define R_BE_TX_INFO_RU8 0xC89C
#define R_BE_TX_INFO_RU8_C1 0xE89C
#define B_BE_RU8_VLD BIT(31)
#define B_BE_RU8_WAIT_FINISH BIT(30)
#define B_BE_RU8_CUR_WD_ID_SH 18
#define B_BE_RU8_CUR_WD_ID_MSK 0xfff
#define B_BE_RU8_CUR_PL_ID_SH 6
#define B_BE_RU8_CUR_PL_ID_MSK 0xfff
#define B_BE_RU8_READ_CS_SH 3
#define B_BE_RU8_READ_CS_MSK 0x7
#define B_BE_RU8_WRITE_CS_SH 0
#define B_BE_RU8_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU9 0xC8A0
#define R_BE_TX_INFO_RU9_C1 0xE8A0
#define B_BE_RU9_VLD BIT(31)
#define B_BE_RU9_WAIT_FINISH BIT(30)
#define B_BE_RU9_CUR_WD_ID_SH 18
#define B_BE_RU9_CUR_WD_ID_MSK 0xfff
#define B_BE_RU9_CUR_PL_ID_SH 6
#define B_BE_RU9_CUR_PL_ID_MSK 0xfff
#define B_BE_RU9_READ_CS_SH 3
#define B_BE_RU9_READ_CS_MSK 0x7
#define B_BE_RU9_WRITE_CS_SH 0
#define B_BE_RU9_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU10 0xC8A4
#define R_BE_TX_INFO_RU10_C1 0xE8A4
#define B_BE_RU10_VLD BIT(31)
#define B_BE_RU10_WAIT_FINISH BIT(30)
#define B_BE_RU10_CUR_WD_ID_SH 18
#define B_BE_RU10_CUR_WD_ID_MSK 0xfff
#define B_BE_RU10_CUR_PL_ID_SH 6
#define B_BE_RU10_CUR_PL_ID_MSK 0xfff
#define B_BE_RU10_READ_CS_SH 3
#define B_BE_RU10_READ_CS_MSK 0x7
#define B_BE_RU10_WRITE_CS_SH 0
#define B_BE_RU10_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU11 0xC8A8
#define R_BE_TX_INFO_RU11_C1 0xE8A8
#define B_BE_RU11_VLD BIT(31)
#define B_BE_RU11_WAIT_FINISH BIT(30)
#define B_BE_RU11_CUR_WD_ID_SH 18
#define B_BE_RU11_CUR_WD_ID_MSK 0xfff
#define B_BE_RU11_CUR_PL_ID_SH 6
#define B_BE_RU11_CUR_PL_ID_MSK 0xfff
#define B_BE_RU11_READ_CS_SH 3
#define B_BE_RU11_READ_CS_MSK 0x7
#define B_BE_RU11_WRITE_CS_SH 0
#define B_BE_RU11_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU12 0xC8AC
#define R_BE_TX_INFO_RU12_C1 0xE8AC
#define B_BE_RU12_VLD BIT(31)
#define B_BE_RU12_WAIT_FINISH BIT(30)
#define B_BE_RU12_CUR_WD_ID_SH 18
#define B_BE_RU12_CUR_WD_ID_MSK 0xfff
#define B_BE_RU12_CUR_PL_ID_SH 6
#define B_BE_RU12_CUR_PL_ID_MSK 0xfff
#define B_BE_RU12_READ_CS_SH 3
#define B_BE_RU12_READ_CS_MSK 0x7
#define B_BE_RU12_WRITE_CS_SH 0
#define B_BE_RU12_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU13 0xC8B0
#define R_BE_TX_INFO_RU13_C1 0xE8B0
#define B_BE_RU13_VLD BIT(31)
#define B_BE_RU13_WAIT_FINISH BIT(30)
#define B_BE_RU13_CUR_WD_ID_SH 18
#define B_BE_RU13_CUR_WD_ID_MSK 0xfff
#define B_BE_RU13_CUR_PL_ID_SH 6
#define B_BE_RU13_CUR_PL_ID_MSK 0xfff
#define B_BE_RU13_READ_CS_SH 3
#define B_BE_RU13_READ_CS_MSK 0x7
#define B_BE_RU13_WRITE_CS_SH 0
#define B_BE_RU13_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU14 0xC8B4
#define R_BE_TX_INFO_RU14_C1 0xE8B4
#define B_BE_RU14_VLD BIT(31)
#define B_BE_RU14_WAIT_FINISH BIT(30)
#define B_BE_RU14_CUR_WD_ID_SH 18
#define B_BE_RU14_CUR_WD_ID_MSK 0xfff
#define B_BE_RU14_CUR_PL_ID_SH 6
#define B_BE_RU14_CUR_PL_ID_MSK 0xfff
#define B_BE_RU14_READ_CS_SH 3
#define B_BE_RU14_READ_CS_MSK 0x7
#define B_BE_RU14_WRITE_CS_SH 0
#define B_BE_RU14_WRITE_CS_MSK 0x7

#define R_BE_TX_INFO_RU15 0xC8B8
#define R_BE_TX_INFO_RU15_C1 0xE8B8
#define B_BE_RU15_VLD BIT(31)
#define B_BE_RU15_WAIT_FINISH BIT(30)
#define B_BE_RU15_CUR_WD_ID_SH 18
#define B_BE_RU15_CUR_WD_ID_MSK 0xfff
#define B_BE_RU15_CUR_PL_ID_SH 6
#define B_BE_RU15_CUR_PL_ID_MSK 0xfff
#define B_BE_RU15_READ_CS_SH 3
#define B_BE_RU15_READ_CS_MSK 0x7
#define B_BE_RU15_WRITE_CS_SH 0
#define B_BE_RU15_WRITE_CS_MSK 0x7

//
// TMAC
//

#define R_BE_C0_WMTX_TCR_BE_0 0x0000
#define R_BE_C0_WMTX_TCR_BE_0_C1 0x2000
#define B_BE_TCR_ZLD_NUM_SH 24
#define B_BE_TCR_ZLD_NUM_MSK 0xff
#define B_BE_TCR_UDF_EN BIT(23)
#define B_BE_TCR_UDF_THSD_SH 16
#define B_BE_TCR_UDF_THSD_MSK 0x7f
#define B_BE_CSI_SEQ_SEL_SH 13
#define B_BE_CSI_SEQ_SEL_MSK 0x7
#define B_BE_TCR_EOF_BIT_CHK_ACK_POLICY BIT(12)
#define B_BE_HW_SIGB_GEN_ERR_RST_EN BIT(11)
#define B_BE_TXDFIFO_ACCESS_RST_OPT BIT(10)
#define B_BE_TCR_VHTSIGA1_TXPS BIT(9)
#define B_BE_TCR_PLCP_ERRHDL_EN BIT(8)
#define B_BE_TCR_PADSEL BIT(7)
#define B_BE_TCR_MASK_SIGBCRC BIT(6)
#define B_BE_TCR_SR_VAL15_ALLOW BIT(5)
#define B_BE_TCR_EN_EOF BIT(4)
#define B_BE_TCR_EN_SCRAM_INC BIT(3)
#define B_BE_TCR_EN_20MST BIT(2)
#define B_BE_TCR_CRC BIT(1)
#define B_BE_TCR_DISGCLK BIT(0)

#define R_BE_C0_WMTX_TCR_BE_1 0x0004
#define R_BE_C0_WMTX_TCR_BE_1_C1 0x2004
#define B_BE_TCR_AMPDU_FINAL_PAD_CTRL BIT(31)
#define B_BE_TCR_EN_BB_FET_EOF_PADD_LEN_ERR_FLAG BIT(30)
#define B_BE_TCR_PSDU_PADD_LEN_UNIT BIT(29)
#define B_BE_TCR_VHT_SIGB_LENGTH BIT(28)
#define B_BE_TCR_CCK_LOCK_CLK BIT(27)
#define B_BE_TCR_FORCE_READ_TXDFIFO BIT(26)
#define B_BE_TCR_USTIME_SH 16
#define B_BE_TCR_USTIME_MSK 0xff
#define B_BE_TCR_SMOOTH_VAL BIT(15)
#define B_BE_TCR_SMOOTH_CTRL BIT(14)
#define B_BE_CS_REQ_VAL BIT(13)
#define B_BE_CS_REQ_SEL BIT(12)
#define B_BE_TCR_BB_FET_EOF_PADD_LIMIT_SH 8
#define B_BE_TCR_BB_FET_EOF_PADD_LIMIT_MSK 0xf
#define B_BE_TCR_TXTIMEOUT_SH 0
#define B_BE_TCR_TXTIMEOUT_MSK 0xff

#define R_BE_C0_WMTX_MOREDATA_TSFT_STMP_CTL 0x0008
#define R_BE_C0_WMTX_MOREDATA_TSFT_STMP_CTL_C1 0x2008
#define B_BE_TSFT_OFS_SH 16
#define B_BE_TSFT_OFS_MSK 0xffff
#define B_BE_STMP_THSD_SH 8
#define B_BE_STMP_THSD_MSK 0xff
#define B_BE_UPD_HGQMD BIT(1)
#define B_BE_UPD_TIMIE BIT(0)

#define R_BE_C0_WMTX_POWER_BE_BIT_CTL 0x000C
#define R_BE_C0_WMTX_POWER_BE_BIT_CTL_C1 0x200C
#define B_BE_CLI4_PWRBIT_CTL_EN BIT(19)
#define B_BE_CLI4_PWRBIT_DATA_EN BIT(18)
#define B_BE_CLI4_PWRBIT_ACT_EN BIT(17)
#define B_BE_CLI4_PWRBIT_VAL BIT(16)
#define B_BE_CLI3_PWRBIT_CTL_EN BIT(15)
#define B_BE_CLI3_PWRBIT_DATA_EN BIT(14)
#define B_BE_CLI3_PWRBIT_ACT_EN BIT(13)
#define B_BE_CLI3_PWRBIT_VAL BIT(12)
#define B_BE_CLI2_PWRBIT_CTL_EN BIT(11)
#define B_BE_CLI2_PWRBIT_DATA_EN BIT(10)
#define B_BE_CLI2_PWRBIT_ACT_EN BIT(9)
#define B_BE_CLI2_PWRBIT_VAL BIT(8)
#define B_BE_CLI1_PWRBIT_CTL_EN BIT(7)
#define B_BE_CLI1_PWRBIT_DATA_EN BIT(6)
#define B_BE_CLI1_PWRBIT_ACT_EN BIT(5)
#define B_BE_CLI1_PWRBIT_VAL BIT(4)
#define B_BE_CLI0_PWRBIT_CTL_EN BIT(3)
#define B_BE_CLI0_PWRBIT_DATA_EN BIT(2)
#define B_BE_CLI0_PWRBIT_ACT_EN BIT(1)
#define B_BE_CLI0_PWRBIT_VAL BIT(0)

#define R_BE_C0_WMTX_HTC 0x0010
#define R_BE_C0_WMTX_HTC_C1 0x2010
#define B_BE_MHDR_HTC_SH 0
#define B_BE_MHDR_HTC_MSK 0xffffffffL

#define R_BE_C0_WMTX_SOUNDING 0x0014
#define R_BE_C0_WMTX_SOUNDING_C1 0x2014
#define B_BE_USE_NSTS BIT(22)
#define B_BE_RETRY_BFRPT_SEQ_UPD BIT(21)
#define B_BE_TXNDP_SIGB_SH 0
#define B_BE_TXNDP_SIGB_MSK 0x1fffff

#define R_BE_C0_WMTX_HTC_A_CTRL 0x0018
#define R_BE_C0_WMTX_HTC_A_CTRL_C1 0x2018
#define B_BE_RO_MIN_TX_PWR_FLAG BIT(21)
#define B_BE_RO_UPH_SH 16
#define B_BE_RO_UPH_MSK 0x1f
#define B_BE_CAS_PSRT_PPDU_CTRL BIT(5)
#define B_BE_BSR_BK_TID_SEL BIT(4)
#define B_BE_BSR_BE_TID_SEL BIT(3)
#define B_BE_BSR_VI_TID_SEL BIT(2)
#define B_BE_BSR_VO_TID_SEL BIT(1)
#define B_BE_BSR_QOS_SEL BIT(0)

#define R_BE_C0_WMTX_TCR_BE_2 0x001C
#define R_BE_C0_WMTX_TCR_BE_2_C1 0x201C
#define B_BE_TCR_SET_SR_FIELD_EN BIT(25)
#define B_BE_FIX_EHT_NLTF_EN BIT(24)
#define B_BE_EHT_2XNSTS_NLTF_SH 21
#define B_BE_EHT_2XNSTS_NLTF_MSK 0x7
#define B_BE_TXDFIFO_HIGH_MCS_THRE_SH 16
#define B_BE_TXDFIFO_HIGH_MCS_THRE_MSK 0x1f
#define B_BE_EHT_1XNSTS_NLTF_SH 13
#define B_BE_EHT_1XNSTS_NLTF_MSK 0x7
#define B_BE_TXDFIFO_LOW_MCS_THRE_SH 8
#define B_BE_TXDFIFO_LOW_MCS_THRE_MSK 0x1f
#define B_BE_HIGH_MCS_PHY_RATE_SH 3
#define B_BE_HIGH_MCS_PHY_RATE_MSK 0x1f
#define B_BE_BW_PHY_RATE_SH 0
#define B_BE_BW_PHY_RATE_MSK 0x7

#define R_BE_C0_WMTX_DBG_SEL 0x0020
#define R_BE_C0_WMTX_DBG_SEL_C1 0x2020
#define B_BE_RO_TX_GEN_MPDU_CNT_SH 24
#define B_BE_RO_TX_GEN_MPDU_CNT_MSK 0xff
#define B_BE_RO_TX_DMA_PKT_CNT_SH 16
#define B_BE_RO_TX_DMA_PKT_CNT_MSK 0xff
#define B_BE_HW_SIGB_GEN_ERROR_FLAG BIT(14)
#define B_BE_DBG_USER_SEL_SH 10
#define B_BE_DBG_USER_SEL_MSK 0xf
#define B_BE_TXBF_EN_ERROR_FLAG_CLR BIT(9)
#define B_BE_TXCNT_CLEAR_PER_TXPPDU BIT(8)
#define B_BE_ZLD_FLAG_CLEAR_PER_TXPPDU BIT(7)
#define B_BE_DBGSEL_MACTX_SH 0
#define B_BE_DBGSEL_MACTX_MSK 0x7f

#define R_BE_C0_WMTX_DBG_ZLD_COUNTER 0x0024
#define R_BE_C0_WMTX_DBG_ZLD_COUNTER_C1 0x2024
#define B_BE_RO_TX_ZLD_CNT_SH 0
#define B_BE_RO_TX_ZLD_CNT_MSK 0x3ff

#define R_BE_C0_WMTX_USER_BE_ERROR_BE_FLAG 0x0028
#define R_BE_C0_WMTX_USER_BE_ERROR_BE_FLAG_C1 0x2028
#define B_BE_TXDMA_LENGTH_STUCK_FLAG_SH 24
#define B_BE_TXDMA_LENGTH_STUCK_FLAG_MSK 0xff
#define B_BE_TXBF_NSTS_ERROB_BE_FLAG_SH 16
#define B_BE_TXBF_NSTS_ERROB_BE_FLAG_MSK 0xff
#define B_BE_ZLD_FLAG_SH 8
#define B_BE_ZLD_FLAG_MSK 0xff
#define B_BE_LENGTH_ERR_FLAG_SH 0
#define B_BE_LENGTH_ERR_FLAG_MSK 0xff

#define R_BE_C0_WMTX_TCR_BE_3 0x002C
#define R_BE_C0_WMTX_TCR_BE_3_C1 0x202C
#define B_BE_EHT_HE_PPDU_4XLTF_ZLD_USTIMER_SH 24
#define B_BE_EHT_HE_PPDU_4XLTF_ZLD_USTIMER_MSK 0x1f
#define B_BE_EHT_HE_PPDU_2XLTF_ZLD_USTIMER_SH 16
#define B_BE_EHT_HE_PPDU_2XLTF_ZLD_USTIMER_MSK 0x1f
#define B_BE_NON_LEGACY_PPDU_ZLD_USTIMER_SH 8
#define B_BE_NON_LEGACY_PPDU_ZLD_USTIMER_MSK 0x1f
#define B_BE_LEGACY_PPDU_ZLD_USTIMER_SH 0
#define B_BE_LEGACY_PPDU_ZLD_USTIMER_MSK 0x1f

#define R_BE_C0_WMTX_TCR_BE_PLCP 0x0034
#define R_BE_C0_WMTX_TCR_BE_PLCP_C1 0x2034
#define B_BE_TCR_PRI20_BITMAP_SH 16
#define B_BE_TCR_PRI20_BITMAP_MSK 0xffff
#define B_BE_TCR_PLCP_SR_FIELD_SH 0
#define B_BE_TCR_PLCP_SR_FIELD_MSK 0xffff

#define R_BE_C0_WMTX_TX_BQR 0x0048
#define R_BE_C0_WMTX_TX_BQR_C1 0x2048
#define B_BE_DBG_CCA_PER20_BITMAP_BB_SH 24
#define B_BE_DBG_CCA_PER20_BITMAP_BB_MSK 0xff
#define B_BE_BQR_CHANNEL_MASK_VAL_SH 16
#define B_BE_BQR_CHANNEL_MASK_VAL_MSK 0xff
#define B_BE_BQR_MASK_CTRL_SH 8
#define B_BE_BQR_MASK_CTRL_MSK 0xff
#define B_BE_BQR_BMP_BIT_SHIFT_SH 5
#define B_BE_BQR_BMP_BIT_SHIFT_MSK 0x7
#define B_BE_BQR_CCA_BITMAP_SEL BIT(4)
#define B_BE_BQR_TID_VAL_SH 0
#define B_BE_BQR_TID_VAL_MSK 0xf

#define R_BE_C0_WMTX_PKTCNT 0x00E0
#define R_BE_C0_WMTX_PKTCNT_C1 0x20E0
#define B_BE_RO_PKTCNT_NUM_SH 16
#define B_BE_RO_PKTCNT_NUM_MSK 0xffff
#define B_BE_PKTCNT_RST_VLD BIT(12)
#define B_BE_PKTCNT_RST_IDX_SH 8
#define B_BE_PKTCNT_RST_IDX_MSK 0xf
#define B_BE_PKTCNT_READ_IDX_SH 0
#define B_BE_PKTCNT_READ_IDX_MSK 0xf

#define R_BE_C0_WMTX_TXINFO_SEL_DBG 0x00E4
#define R_BE_C0_WMTX_TXINFO_SEL_DBG_C1 0x20E4
#define B_BE_TXTIME_ERR_FLG_RST BIT(7)
#define B_BE_RO_PSDU_ERR_FLG BIT(6)
#define B_BE_RO_NSYM_ERR_FLG BIT(5)
#define B_BE_TXINFO_DEBUG_SEL_SH 0
#define B_BE_TXINFO_DEBUG_SEL_MSK 0x1f

#define R_BE_C0_WMTX_TXINFO_L4B_DBG 0x00E8
#define R_BE_C0_WMTX_TXINFO_L4B_DBG_C1 0x20E8
#define B_BE_RO_TX_INFO_L4B_SH 0
#define B_BE_RO_TX_INFO_L4B_MSK 0xffffffffL

#define R_BE_C0_WMTX_TXINFO_H4B_DBG 0x00EC
#define R_BE_C0_WMTX_TXINFO_H4B_DBG_C1 0x20EC
#define B_BE_RO_TX_INFO_H4B_SH 0
#define B_BE_RO_TX_INFO_H4B_MSK 0xffffffffL

#define R_BE_C0_WMTX_TX_BB_UID_DBG 0x00F0
#define R_BE_C0_WMTX_TX_BB_UID_DBG_C1 0x20F0
#define B_BE_RO_ERROB_BE_DET_UID_SH 4
#define B_BE_RO_ERROB_BE_DET_UID_MSK 0xff
#define B_BE_RO_ERROB_BE_DET_STATE_SH 0
#define B_BE_RO_ERROB_BE_DET_STATE_MSK 0xf

//
// TRXPTCL
//

#define R_BE_RSP_CHK_SIG 0x0000
#define R_BE_RSP_CHK_SIG_C1 0x2000
#define B_BE_RSP_STATIC_RTS_CHK_SERV_BW_EN BIT(30)
#define B_BE_RSP_TBPPDU_CHK_PWR BIT(29)
#define B_BE_RESP_TX_ABORT_TEST_EN BIT(24)
#define B_BE_RESP_TSSI_FAST_MODE_EN BIT(23)
#define B_BE_RESP_CHK_TB_EDCCA_PER20_BMP BIT(22)
#define B_BE_RSP_CHK_BASIC_NAV BIT(21)
#define B_BE_RSP_CHK_INTRA_NAV BIT(20)
#define B_BE_RSP_CHK_TXNAV BIT(19)
#define B_BE_TXDATA_END_PS_OPT BIT(18)
#define B_BE_CHECK_SOUNDING_SEQ BIT(17)
#define B_BE_RXBA_IGNOREA2 BIT(16)
#define B_BE_ACKTO_CCK_SH 8
#define B_BE_ACKTO_CCK_MSK 0xff
#define B_BE_ACKTO_SH 0
#define B_BE_ACKTO_MSK 0xff

#define R_BE_TRXPTCL_RESP_0 0x0004
#define R_BE_TRXPTCL_RESP_0_C1 0x2004
#define B_BE_WMAC_RESP_STBC_EN BIT(31)
#define B_BE_WMAC_RXFTM_TXACK_SC BIT(30)
#define B_BE_WMAC_RXFTM_TXACKBWEQ BIT(29)
#define B_BE_RSP_CHK_SEC_CCA_80 BIT(28)
#define B_BE_RSP_CHK_SEC_CCA_40 BIT(27)
#define B_BE_RSP_CHK_SEC_CCA_20 BIT(26)
#define B_BE_RSP_CHK_BTCCA BIT(25)
#define B_BE_RSP_CHK_EDCCA BIT(24)
#define B_BE_RSP_CHK_CCA BIT(23)
#define B_BE_WMAC_LDPC_EN BIT(22)
#define B_BE_WMAC_SGIEN BIT(21)
#define B_BE_WMAC_SPLCPEN BIT(20)
#define B_BE_WMAC_BESP_EARLY_TXBA BIT(17)
#define B_BE_WMAC_MBA_DUR_FORCE BIT(16)
#define B_BE_WMAC_SPEC_SIFS_OFDM_SH 8
#define B_BE_WMAC_SPEC_SIFS_OFDM_MSK 0xff
#define B_BE_WMAC_SPEC_SIFS_CCK_SH 0
#define B_BE_WMAC_SPEC_SIFS_CCK_MSK 0xff

#define R_BE_TRXPTCL_RESP_1 0x0008
#define R_BE_TRXPTCL_RESP_1_C1 0x2008
#define B_BE_WMAC_RESP_SR_MODE_EN BIT(31)
#define B_BE_FTM_RRSR_RATE_EN_SH 24
#define B_BE_FTM_RRSR_RATE_EN_MSK 0x1f
#define B_BE_NESS_SH 22
#define B_BE_NESS_MSK 0x3
#define B_BE_WMAC_RESP_DOPPLEB_BE_EN BIT(21)
#define B_BE_WMAC_RESP_DCM_EN BIT(20)
#define B_BE_WMAC_RESP_REF_RATE_SEL BIT(12)
#define B_BE_WMAC_RESP_REF_RATE_SH 0
#define B_BE_WMAC_RESP_REF_RATE_MSK 0xfff

#define R_BE_RESP_TX_NAV_ABORT_COUNTER 0x0014
#define R_BE_RESP_TX_NAV_ABORT_COUNTER_C1 0x2014
#define B_BE_TB_EDCCA_BMP_ABORT_RESP_TX_CNT_SH 24
#define B_BE_TB_EDCCA_BMP_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_BASIC_NAV_ABORT_RESP_TX_CNT_SH 16
#define B_BE_BASIC_NAV_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_INTRA_NAV_ABORT_RESP_TX_CNT_SH 8
#define B_BE_INTRA_NAV_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_TXNAV_ABORT_RESP_TX_CNT_SH 0
#define B_BE_TXNAV_ABORT_RESP_TX_CNT_MSK 0xff

#define R_BE_RESP_TX_CCA_ABORT_COUNTER 0x0018
#define R_BE_RESP_TX_CCA_ABORT_COUNTER_C1 0x2018
#define B_BE_DBG_FORCE_ABORT_RESP_TX_CNT_SH 24
#define B_BE_DBG_FORCE_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_SCH_ABORT_RESP_TX_CNT_SH 16
#define B_BE_SCH_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_BTCCA_ABORT_RESP_TX_CNT_SH 8
#define B_BE_BTCCA_ABORT_RESP_TX_CNT_MSK 0xff
#define B_BE_EDCCA_ABORT_RESP_TX_CNT_SH 0
#define B_BE_EDCCA_ABORT_RESP_TX_CNT_MSK 0xff

#define R_BE_TRXPTCL_RESP_TX_ABORT_COUNTER 0x001C
#define R_BE_TRXPTCL_RESP_TX_ABORT_COUNTER_C1 0x201C
#define B_BE_WMAC_SEC_CCA80_ABORT_RESP_TX_SH 24
#define B_BE_WMAC_SEC_CCA80_ABORT_RESP_TX_MSK 0xff
#define B_BE_WMAC_SEC_CCA40_ABORT_RESP_TX_SH 16
#define B_BE_WMAC_SEC_CCA40_ABORT_RESP_TX_MSK 0xff
#define B_BE_WMAC_SEC_CCA20_ABORT_RESP_TX_SH 8
#define B_BE_WMAC_SEC_CCA20_ABORT_RESP_TX_MSK 0xff
#define B_BE_WMAC_CCA_ABORT_RESP_TX_SH 0
#define B_BE_WMAC_CCA_ABORT_RESP_TX_MSK 0xff

#define R_BE_MAC_LOOPBACK 0x0020
#define R_BE_MAC_LOOPBACK_C1 0x2020
#define B_BE_MACLBK_RDY_PERIOD_SH 17
#define B_BE_MACLBK_RDY_PERIOD_MSK 0xfff
#define B_BE_MACLBK_PLCP_DLY_SH 8
#define B_BE_MACLBK_PLCP_DLY_MSK 0x1ff
#define B_BE_MACLBK_RDY_NUM_SH 3
#define B_BE_MACLBK_RDY_NUM_MSK 0x1f
#define B_BE_MACLBK_EN BIT(0)

#define R_BE_TRXPTCL_CTS_RRSR 0x0024
#define R_BE_TRXPTCL_CTS_RRSR_C1 0x2024
#define B_BE_WMAC_CTS_RRSR_RSC_SH 14
#define B_BE_WMAC_CTS_RRSR_RSC_MSK 0x3
#define B_BE_WMAC_CTS_RESP_OPT BIT(12)
#define B_BE_WMAC_CTS_RRSR_CCK_SH 8
#define B_BE_WMAC_CTS_RRSR_CCK_MSK 0xf
#define B_BE_WMAC_CTS_RRSR_OFDM_SH 0
#define B_BE_WMAC_CTS_RRSR_OFDM_MSK 0xff

#define R_BE_MAC_LOOPBACK_COUNT 0x0028
#define R_BE_MAC_LOOPBACK_COUNT_C1 0x2028
#define B_BE_RO_MACLBK_COUNT_SH 16
#define B_BE_RO_MACLBK_COUNT_MSK 0xffff
#define B_BE_MACLBK_COUNT_CLR BIT(0)

#define R_BE_CLIENT_OM_CTRL 0x0040
#define R_BE_CLIENT_OM_CTRL_C1 0x2040
#define B_BE_WMAC_DIS_ALL_RESP BIT(23)
#define B_BE_WMAC_TRIGDAT_RESP_NRLACK BIT(17)
#define B_BE_WMAC_DIS_SIGTA BIT(16)
#define B_BE_UL_DATA_DIS_SH 0
#define B_BE_UL_DATA_DIS_MSK 0x1f

#define R_BE_WMAC_FTM_CTL 0x0050
#define R_BE_WMAC_FTM_CTL_C1 0x2050
#define B_BE_FTM_RPT_ERROR BIT(15)
#define B_BE_FTM_TIMEOUT_BYPASS BIT(14)
#define B_BE_RXFTM_EN BIT(2)
#define B_BE_RXFTMREQ_EN BIT(1)
#define B_BE_FTM_EN BIT(0)

#define R_BE_GET_RTT 0x0054
#define R_BE_GET_RTT_C1 0x2054
#define B_BE_ACTION_FIELD_SH 16
#define B_BE_ACTION_FIELD_MSK 0xff
#define B_BE_CATEGORY_FIELD_SH 8
#define B_BE_CATEGORY_FIELD_MSK 0xff
#define B_BE_RTT_TYPE_SUBTYPE_SH 1
#define B_BE_RTT_TYPE_SUBTYPE_MSK 0x3f
#define B_BE_RTT_FILTER_EN BIT(0)

#define R_BE_FTM_PTT 0x0058
#define R_BE_FTM_PTT_C1 0x2058
#define B_BE_FTM_PTT_TSF_R2T_SEL_SH 3
#define B_BE_FTM_PTT_TSF_R2T_SEL_MSK 0x7
#define B_BE_FTM_PTT_TSF_T2R_SEL_SH 0
#define B_BE_FTM_PTT_TSF_T2R_SEL_MSK 0x7

#define R_BE_FTM_TSF 0x005C
#define R_BE_FTM_TSF_C1 0x205C
#define B_BE_FTM_T2_TSF_SH 16
#define B_BE_FTM_T2_TSF_MSK 0xffff
#define B_BE_FTM_T1_TSF_SH 0
#define B_BE_FTM_T1_TSF_MSK 0xffff

#define R_BE_WMAC_RX_WMMPS_UAPSD 0x0070
#define R_BE_WMAC_RX_WMMPS_UAPSD_C1 0x2070
#define B_BE_BC_MD_EN BIT(17)
#define B_BE_UC_MD_EN BIT(16)
#define B_BE_WMMPS_UAPSD_TID7 BIT(7)
#define B_BE_WMMPS_UAPSD_TID6 BIT(6)
#define B_BE_WMMPS_UAPSD_TID5 BIT(5)
#define B_BE_WMMPS_UAPSD_TID4 BIT(4)
#define B_BE_WMMPS_UAPSD_TID3 BIT(3)
#define B_BE_WMMPS_UAPSD_TID2 BIT(2)
#define B_BE_WMMPS_UAPSD_TID1 BIT(1)
#define B_BE_WMMPS_UAPSD_TID0 BIT(0)

#define R_BE_WMAC_NAV_CTL 0x0080
#define R_BE_WMAC_NAV_CTL_C1 0x2080
#define B_BE_WMAC_NAV_UPPER_EN BIT(26)
#define B_BE_WMAC_0P125US_TIMER_SH 18
#define B_BE_WMAC_0P125US_TIMER_MSK 0xff
#define B_BE_WMAC_PLCP_UP_NAV_EN BIT(17)
#define B_BE_WMAC_TF_UP_NAV_EN BIT(16)
#define B_BE_WMAC_NAV_UPPER_SH 8
#define B_BE_WMAC_NAV_UPPER_MSK 0xff
#define B_BE_WMAC_RTS_RST_DUR_SH 0
#define B_BE_WMAC_RTS_RST_DUR_MSK 0xff

#define R_BE_WMAC_NAV_UP_INFO 0x0084
#define R_BE_WMAC_NAV_UP_INFO_C1 0x2084
#define B_BE_WMAC_INTRA_NAV_UPD BIT(31)
#define B_BE_WMAC_BASIC_NAV_UPD BIT(30)
#define B_BE_WMAC_INTRANAV_INTXOP BIT(29)
#define B_BE_WMAC_BASICNAV_INTXOP BIT(28)
#define B_BE_WMAC_INTRA_NAV_DUR_SH 14
#define B_BE_WMAC_INTRA_NAV_DUR_MSK 0x3fff
#define B_BE_WMAC_BASIC_NAV_DUR_SH 0
#define B_BE_WMAC_BASIC_NAV_DUR_MSK 0x3fff

#define R_BE_WMAC_NAV_OPTION 0x0088
#define R_BE_WMAC_NAV_OPTION_C1 0x2088
#define B_BE_WMAC_VIR_TUAL_CCA BIT(0)

#define R_BE_RXTRIG_TEST_COMM_0 0x00A0
#define R_BE_RXTRIG_TEST_COMM_0_C1 0x20A0
#define B_BE_RXTRIG_COMMON_0_SH 0
#define B_BE_RXTRIG_COMMON_0_MSK 0xffffffffL

#define R_BE_RXTRIG_TEST_COMM_1 0x00A4
#define R_BE_RXTRIG_TEST_COMM_1_C1 0x20A4
#define B_BE_RXTRIG_COMMON_1_SH 0
#define B_BE_RXTRIG_COMMON_1_MSK 0xffffffffL

#define R_BE_RXTRIG_TEST_USER_0 0x00A8
#define R_BE_RXTRIG_TEST_USER_0_C1 0x20A8
#define B_BE_RXTRIG_USERINFO_0_SH 0
#define B_BE_RXTRIG_USERINFO_0_MSK 0xffffffffL

#define R_BE_RXTRIG_TEST_USER_1 0x00AC
#define R_BE_RXTRIG_TEST_USER_1_C1 0x20AC
#define B_BE_RXTRIG_USERINFO_1_SH 0
#define B_BE_RXTRIG_USERINFO_1_MSK 0xffffffffL

#define R_BE_RXTRIG_TEST_USER_2 0x00B0
#define R_BE_RXTRIG_TEST_USER_2_C1 0x20B0
#define B_BE_RXTRIG_MACID_SH 24
#define B_BE_RXTRIG_MACID_MSK 0xff
#define B_BE_RXTRIG_RU26_DIS BIT(21)
#define B_BE_RXTRIG_FCSCHK_EN BIT(20)
#define B_BE_RXTRIG_PORT_SEL_SH 17
#define B_BE_RXTRIG_PORT_SEL_MSK 0x7
#define B_BE_RXTRIG_EN BIT(16)
#define B_BE_RXTRIG_USERINFO_2_SH 0
#define B_BE_RXTRIG_USERINFO_2_MSK 0xffff

#define R_BE_RXTRIG_TEST_CTRL1 0x00B4
#define R_BE_RXTRIG_TEST_CTRL1_C1 0x20B4
#define B_BE_RXTRIG_STATUS_SH 24
#define B_BE_RXTRIG_STATUS_MSK 0xff
#define B_BE_RXTRIG_BSS_COLOR_SH 16
#define B_BE_RXTRIG_BSS_COLOR_MSK 0x3f
#define B_BE_RXTRIG_DURATION_SH 0
#define B_BE_RXTRIG_DURATION_MSK 0xffff

#define R_BE_SR_CONTROL_DBG 0x00B8
#define R_BE_SR_CONTROL_DBG_C1 0x20B8
#define B_BE_SR_RESTRICTED BIT(31)
#define B_BE_SR_PD_WMAC_C_SH 25
#define B_BE_SR_PD_WMAC_C_MSK 0x3f
#define B_BE_SRPERIOD_WMAC_C_SH 16
#define B_BE_SRPERIOD_WMAC_C_MSK 0x1ff
#define B_BE_SR_PD_PTCL_C_SH 10
#define B_BE_SR_PD_PTCL_C_MSK 0x3f
#define B_BE_SR_PERIOD_PTCL_C_SH 0
#define B_BE_SR_PERIOD_PTCL_C_MSK 0x3ff

#define R_BE_TRXPTCL_ERROR_INDICA_MASK 0x00BC
#define R_BE_TRXPTCL_ERROR_INDICA_MASK_C1 0x20BC
#define B_BE_WMAC_MODE BIT(22)
#define B_BE_WMAC_TIMETOUT_THR_SH 16
#define B_BE_WMAC_TIMETOUT_THR_MSK 0x3f
#define B_BE_RMAC_FTM BIT(8)
#define B_BE_RMAC_CSI BIT(7)
#define B_BE_TMAC_MIMO_CTRL BIT(6)
#define B_BE_TMAC_RXTB BIT(5)
#define B_BE_TMAC_HWSIGB_GEN BIT(4)
#define B_BE_TMAC_TXPLCP BIT(3)
#define B_BE_TMAC_RESP BIT(2)
#define B_BE_TMAC_TXCTL BIT(1)
#define B_BE_TMAC_MACTX BIT(0)

#define R_BE_TRXPTCL_ERROR_INDICA 0x00C0
#define R_BE_TRXPTCL_ERROR_INDICA_C1 0x20C0
#define B_BE_FTM_ERROR_FLAG_CLR BIT(8)
#define B_BE_CSI_ERROR_FLAG_CLR BIT(7)
#define B_BE_MIMOCTRL_ERROR_FLAG_CLR BIT(6)
#define B_BE_RXTB_ERROR_FLAG_CLR BIT(5)
#define B_BE_HWSIGB_GEN_ERROR_FLAG_CLR BIT(4)
#define B_BE_TXPLCP_ERROR_FLAG_CLR BIT(3)
#define B_BE_RESP_ERROR_FLAG_CLR BIT(2)
#define B_BE_TXCTL_ERROR_FLAG_CLR BIT(1)
#define B_BE_MACTX_ERROR_FLAG_CLR BIT(0)

#define R_BE_WMAC_WMAC_RX_TB_CTRL_INFO_CFG 0x00D0
#define R_BE_WMAC_WMAC_RX_TB_CTRL_INFO_CFG_C1 0x20D0
#define B_BE_WMAC_RX_TB_CTRL_DBG_SEL_SH 0
#define B_BE_WMAC_RX_TB_CTRL_DBG_SEL_MSK 0xf

#define R_BE_RX_TB_CTRL_INFO_0 0x00D4
#define R_BE_RX_TB_CTRL_INFO_0_C1 0x20D4
#define B_BE_RX_TB_CTRL_L4B_SH 0
#define B_BE_RX_TB_CTRL_L4B_MSK 0xffffffffL

#define R_BE_RX_TB_CTRL_INFO_1 0x00D8
#define R_BE_RX_TB_CTRL_INFO_1_C1 0x20D8
#define B_BE_RX_TB_CTRL_H4B_SH 0
#define B_BE_RX_TB_CTRL_H4B_MSK 0xffffffffL

#define R_BE_CTRL_FRAME_CNT_CTRL 0x00E0
#define R_BE_CTRL_FRAME_CNT_CTRL_C1 0x20E0
#define B_BE_WMAC_ALLCNT_RST BIT(16)
#define B_BE_CTRL_SUBTYPE_SH 12
#define B_BE_CTRL_SUBTYPE_MSK 0xf
#define B_BE_WMAC_WDATA_EN BIT(9)
#define B_BE_WMAC_ALLCNT_EN BIT(8)
#define B_BE_WMAC_CTRL_CNT_IDX_SH 0
#define B_BE_WMAC_CTRL_CNT_IDX_MSK 0xf

#define R_BE_CTRL_FRAME_CNT_SUBCTRL 0x00E4
#define R_BE_CTRL_FRAME_CNT_SUBCTRL_C1 0x20E4
#define B_BE_CNT_INDEX_SH 8
#define B_BE_CNT_INDEX_MSK 0xf
#define B_BE_CNTRST BIT(1)
#define B_BE_CNTEN BIT(0)

#define R_BE_CTRL_FRAME_CNT_RPT 0x00E8
#define R_BE_CTRL_FRAME_CNT_RPT_C1 0x20E8
#define B_BE_RX_CTRL_FRAME_CNT_SH 16
#define B_BE_RX_CTRL_FRAME_CNT_MSK 0xffff
#define B_BE_TX_CTRL_FRAME_CNT_SH 0
#define B_BE_TX_CTRL_FRAME_CNT_MSK 0xffff

#define R_BE_WMAC_RX_STATUS_MONITOR 0x00EC
#define R_BE_WMAC_RX_STATUS_MONITOR_C1 0x20EC
#define B_BE_RX_IDLE_TIMEOUT_CLR BIT(24)
#define B_BE_RX_IDLE_TIMEOUT_MASK BIT(16)
#define B_BE_RXSTS_FCS_TO_DIS BIT(11)
#define B_BE_RXSTS_PLCP_TO_DIS BIT(10)
#define B_BE_RXSTS_DATA_ON_TO_DIS BIT(9)
#define B_BE_RXSTS_CCA_TO_DIS BIT(8)
#define B_BE_RXSTS_TIMEOUT_THB_BE_UNIT_SH 6
#define B_BE_RXSTS_TIMEOUT_THB_BE_UNIT_MSK 0x3
#define B_BE_RXSTS_TIMEOUT_THR_SH 0
#define B_BE_RXSTS_TIMEOUT_THR_MSK 0x3f

#define R_BE_WMAC_DEBUG_PORT 0x00F0
#define R_BE_WMAC_DEBUG_PORT_C1 0x20F0
#define B_BE_WMAC_DEBUG_SH 0
#define B_BE_WMAC_DEBUG_MSK 0xffffffffL

#define R_BE_DBGSEL_TRXPTCL 0x00F4
#define R_BE_DBGSEL_TRXPTCL_C1 0x20F4
#define B_BE_WMAC_CHNSTS_STATE_SH 16
#define B_BE_WMAC_CHNSTS_STATE_MSK 0xf
#define B_BE_DBGSEL_TRIGCMD_SEL_SH 8
#define B_BE_DBGSEL_TRIGCMD_SEL_MSK 0xf
#define B_BE_DBGSEL_TRXPTCL_SH 0
#define B_BE_DBGSEL_TRXPTCL_MSK 0xff

#define R_BE_PHYINFO_ERR_IMR_V1 0x00F8
#define R_BE_PHYINFO_ERR_IMR_V1_C1 0x20F8
#define B_BE_PHYINTF_TIMEOUT_THR_V1_SH 16
#define B_BE_PHYINTF_TIMEOUT_THR_V1_MSK 0x3f
#define B_BE_CSI_ON_TIMEOUT_EN BIT(5)
#define B_BE_STS_ON_TIMEOUT_EN BIT(4)
#define B_BE_DATA_ON_TIMEOUT_EN BIT(3)
#define B_BE_OFDM_CCA_TIMEOUT_EN BIT(2)
#define B_BE_CCK_CCA_TIMEOUT_EN BIT(1)
#define B_BE_PHY_TXON_TIMEOUT_EN BIT(0)

#define R_BE_PHYINFO_ERR_ISR 0x00FC
#define R_BE_PHYINFO_ERR_ISR_C1 0x20FC
#define B_BE_CSI_ON_TIMEOUT_ERR BIT(5)
#define B_BE_STS_ON_TIMEOUT_ERR BIT(4)
#define B_BE_DATA_ON_TIMEOUT_ERR BIT(3)
#define B_BE_OFDM_CCA_TIMEOUT_ERR BIT(2)
#define B_BE_CCK_CCA_TIMEOUT_ERR BIT(1)
#define B_BE_PHY_TXON_TIMEOUT_ERR BIT(0)

#define R_BE_BFMER_ASSOCIATED_SU0 0x0100
#define R_BE_BFMER_ASSOCIATED_SU0_C1 0x2100
#define B_BE_MER_IGNORE_SU_BFMEE1_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE1_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE1_EN BIT(24)
#define B_BE_MER_SU_BFMEE1_MACID_SH 16
#define B_BE_MER_SU_BFMEE1_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE0_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE0_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE0_EN BIT(8)
#define B_BE_MER_SU_BFMEE0_MACID_SH 0
#define B_BE_MER_SU_BFMEE0_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU2 0x0104
#define R_BE_BFMER_ASSOCIATED_SU2_C1 0x2104
#define B_BE_MER_IGNORE_SU_BFMEE3_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE3_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE3_EN BIT(24)
#define B_BE_MER_SU_BFMEE3_MACID_SH 16
#define B_BE_MER_SU_BFMEE3_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE2_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE2_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE2_EN BIT(8)
#define B_BE_MER_SU_BFMEE2_MACID_SH 0
#define B_BE_MER_SU_BFMEE2_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU4 0x0108
#define R_BE_BFMER_ASSOCIATED_SU4_C1 0x2108
#define B_BE_MER_IGNORE_SU_BFMEE5_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE5_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE5_EN BIT(24)
#define B_BE_MER_SU_BFMEE5_MACID_SH 16
#define B_BE_MER_SU_BFMEE5_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE4_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE4_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE4_EN BIT(8)
#define B_BE_MER_SU_BFMEE4_MACID_SH 0
#define B_BE_MER_SU_BFMEE4_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU6 0x010C
#define R_BE_BFMER_ASSOCIATED_SU6_C1 0x210C
#define B_BE_MER_IGNORE_SU_BFMEE7_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE7_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE7_EN BIT(24)
#define B_BE_MER_SU_BFMEE7_MACID_SH 16
#define B_BE_MER_SU_BFMEE7_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE6_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE6_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE6_EN BIT(8)
#define B_BE_MER_SU_BFMEE6_MACID_SH 0
#define B_BE_MER_SU_BFMEE6_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU8 0x0110
#define R_BE_BFMER_ASSOCIATED_SU8_C1 0x2110
#define B_BE_MER_IGNORE_SU_BFMEE9_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE9_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE9_EN BIT(24)
#define B_BE_MER_SU_BFMEE9_MACID_SH 16
#define B_BE_MER_SU_BFMEE9_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE8_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE8_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE8_EN BIT(8)
#define B_BE_MER_SU_BFMEE8_MACID_SH 0
#define B_BE_MER_SU_BFMEE8_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU10 0x0114
#define R_BE_BFMER_ASSOCIATED_SU10_C1 0x2114
#define B_BE_MER_IGNORE_SU_BFMEE11_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE11_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE11_EN BIT(24)
#define B_BE_MER_SU_BFMEE11_MACID_SH 16
#define B_BE_MER_SU_BFMEE11_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE10_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE10_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE10_EN BIT(8)
#define B_BE_MER_SU_BFMEE10_MACID_SH 0
#define B_BE_MER_SU_BFMEE10_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU12 0x0118
#define R_BE_BFMER_ASSOCIATED_SU12_C1 0x2118
#define B_BE_MER_IGNORE_SU_BFMEE13_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE13_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE13_EN BIT(24)
#define B_BE_MER_SU_BFMEE13_MACID_SH 16
#define B_BE_MER_SU_BFMEE13_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE12_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE12_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE12_EN BIT(8)
#define B_BE_MER_SU_BFMEE12_MACID_SH 0
#define B_BE_MER_SU_BFMEE12_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_SU14 0x011C
#define R_BE_BFMER_ASSOCIATED_SU14_C1 0x211C
#define B_BE_MER_IGNORE_SU_BFMEE15_SND_STS BIT(26)
#define B_BE_MER_SU_BFMEE15_SND_STS BIT(25)
#define B_BE_MER_SU_BFMEE15_EN BIT(24)
#define B_BE_MER_SU_BFMEE15_MACID_SH 16
#define B_BE_MER_SU_BFMEE15_MACID_MSK 0xff
#define B_BE_MER_IGNORE_SU_BFMEE14_SND_STS BIT(10)
#define B_BE_MER_SU_BFMEE14_SND_STS BIT(9)
#define B_BE_MER_SU_BFMEE14_EN BIT(8)
#define B_BE_MER_SU_BFMEE14_MACID_SH 0
#define B_BE_MER_SU_BFMEE14_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_MU0 0x0120
#define R_BE_BFMER_ASSOCIATED_MU0_C1 0x2120
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE1 BIT(27)
#define B_BE_MER_IGNORE_MU_BFMEE1_SND_STS BIT(26)
#define B_BE_MER_MU_BFMEE1_SND_STS BIT(25)
#define B_BE_MER_MU_BFMEE1_EN BIT(24)
#define B_BE_MER_MU_BFMEE1_MACID_SH 16
#define B_BE_MER_MU_BFMEE1_MACID_MSK 0xff
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE0 BIT(11)
#define B_BE_MER_IGNORE_MU_BFMEE0_SND_STS BIT(10)
#define B_BE_MER_MU_BFMEE0_SND_STS BIT(9)
#define B_BE_MER_MU_BFMEE0_EN BIT(8)
#define B_BE_MER_MU_BFMEE0_MACID_SH 0
#define B_BE_MER_MU_BFMEE0_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_MU2 0x0124
#define R_BE_BFMER_ASSOCIATED_MU2_C1 0x2124
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE3 BIT(27)
#define B_BE_MER_IGNORE_MU_BFMEE3_SND_STS BIT(26)
#define B_BE_MER_MU_BFMEE3_SND_STS BIT(25)
#define B_BE_MER_MU_BFMEE3_EN BIT(24)
#define B_BE_MER_MU_BFMEE3_MACID_SH 16
#define B_BE_MER_MU_BFMEE3_MACID_MSK 0xff
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE2 BIT(11)
#define B_BE_MER_IGNORE_MU_BFMEE2_SND_STS BIT(10)
#define B_BE_MER_MU_BFMEE2_SND_STS BIT(9)
#define B_BE_MER_MU_BFMEE2_EN BIT(8)
#define B_BE_MER_MU_BFMEE2_MACID_SH 0
#define B_BE_MER_MU_BFMEE2_MACID_MSK 0xff

#define R_BE_BFMER_ASSOCIATED_MU4 0x0128
#define R_BE_BFMER_ASSOCIATED_MU4_C1 0x2128
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE5 BIT(27)
#define B_BE_MER_IGNORE_MU_BFMEE5_SND_STS BIT(26)
#define B_BE_MER_MU_BFMEE5_SND_STS BIT(25)
#define B_BE_MER_MU_BFMEE5_EN BIT(24)
#define B_BE_MER_MU_BFMEE5_MACID_SH 16
#define B_BE_MER_MU_BFMEE5_MACID_MSK 0xff
#define B_BE_MER_DIS_SU_TXBF_MU_BFMEE4 BIT(11)
#define B_BE_MER_IGNORE_MU_BFMEE4_SND_STS BIT(10)
#define B_BE_MER_MU_BFMEE4_SND_STS BIT(9)
#define B_BE_MER_MU_BFMEE4_EN BIT(8)
#define B_BE_MER_MU_BFMEE4_MACID_SH 0
#define B_BE_MER_MU_BFMEE4_MACID_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX0 0x012C
#define R_BE_BFMER_CSI_BUFF_IDX0_C1 0x212C
#define B_BE_MER_TXBF_CSI_BUFF_IDX0_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX0_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX0_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX0_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX0_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX0_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX1 0x0130
#define R_BE_BFMER_CSI_BUFF_IDX1_C1 0x2130
#define B_BE_MER_TXBF_CSI_BUFF_IDX1_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX1_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX1_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX1_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX1_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX1_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX2 0x0134
#define R_BE_BFMER_CSI_BUFF_IDX2_C1 0x2134
#define B_BE_MER_TXBF_CSI_BUFF_IDX2_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX2_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX2_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX2_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX2_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX2_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX3 0x0138
#define R_BE_BFMER_CSI_BUFF_IDX3_C1 0x2138
#define B_BE_MER_TXBF_CSI_BUFF_IDX3_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX3_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX3_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX3_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX3_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX3_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX4 0x013C
#define R_BE_BFMER_CSI_BUFF_IDX4_C1 0x213C
#define B_BE_MER_TXBF_CSI_BUFF_IDX4_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX4_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX4_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX4_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX4_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX4_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX5 0x0140
#define R_BE_BFMER_CSI_BUFF_IDX5_C1 0x2140
#define B_BE_MER_TXBF_CSI_BUFF_IDX5_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX5_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX5_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX5_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX5_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX5_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX6 0x0144
#define R_BE_BFMER_CSI_BUFF_IDX6_C1 0x2144
#define B_BE_MER_TXBF_CSI_BUFF_IDX6_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX6_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX6_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX6_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX6_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX6_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX7 0x0148
#define R_BE_BFMER_CSI_BUFF_IDX7_C1 0x2148
#define B_BE_MER_TXBF_CSI_BUFF_IDX7_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX7_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX7_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX7_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX7_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX7_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX8 0x014C
#define R_BE_BFMER_CSI_BUFF_IDX8_C1 0x214C
#define B_BE_MER_TXBF_CSI_BUFF_IDX8_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX8_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX8_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX8_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX8_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX8_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX9 0x0150
#define R_BE_BFMER_CSI_BUFF_IDX9_C1 0x2150
#define B_BE_MER_TXBF_CSI_BUFF_IDX9_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX9_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX9_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX9_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX9_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX9_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX10 0x0154
#define R_BE_BFMER_CSI_BUFF_IDX10_C1 0x2154
#define B_BE_MER_TXBF_CSI_BUFF_IDX10_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX10_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX10_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX10_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX10_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX10_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX11 0x0158
#define R_BE_BFMER_CSI_BUFF_IDX11_C1 0x2158
#define B_BE_MER_TXBF_CSI_BUFF_IDX11_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX11_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX11_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX11_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX11_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX11_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX12 0x015C
#define R_BE_BFMER_CSI_BUFF_IDX12_C1 0x215C
#define B_BE_MER_TXBF_CSI_BUFF_IDX12_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX12_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX12_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX12_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX12_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX12_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX13 0x0160
#define R_BE_BFMER_CSI_BUFF_IDX13_C1 0x2160
#define B_BE_MER_TXBF_CSI_BUFF_IDX13_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX13_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX13_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX13_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX13_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX13_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX14 0x0164
#define R_BE_BFMER_CSI_BUFF_IDX14_C1 0x2164
#define B_BE_MER_TXBF_CSI_BUFF_IDX14_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX14_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX14_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX14_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX14_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX14_MSK 0xff

#define R_BE_BFMER_CSI_BUFF_IDX15 0x0168
#define R_BE_BFMER_CSI_BUFF_IDX15_C1 0x2168
#define B_BE_MER_TXBF_CSI_BUFF_IDX15_SH 20
#define B_BE_MER_TXBF_CSI_BUFF_IDX15_MSK 0xfff
#define B_BE_MER_SND_CSI_BUFF_IDX15_SH 8
#define B_BE_MER_SND_CSI_BUFF_IDX15_MSK 0xfff
#define B_BE_MER_CSI_BUFF_MACID_IDX15_SH 0
#define B_BE_MER_CSI_BUFF_MACID_IDX15_MSK 0xff

#define R_BE_BFMER_SND_DEBUG_CNT 0x016C
#define R_BE_BFMER_SND_DEBUG_CNT_C1 0x216C
#define B_BE_DBG_BFMER_MIMO_CTRL_USER_SH 28
#define B_BE_DBG_BFMER_MIMO_CTRL_USER_MSK 0xf
#define B_BE_DBG_BFMER_MIMO_CTRL_HIGH_LOW_4BYTE BIT(27)
#define B_BE_DBG_BFMER_MIMO_CTRL_MODE_SH 25
#define B_BE_DBG_BFMER_MIMO_CTRL_MODE_MSK 0x3
#define B_BE_TB_CSI_ERR_FLAG_CLR BIT(24)
#define B_BE_BFMER_BBINFO_DBG_SEL_SH 21
#define B_BE_BFMER_BBINFO_DBG_SEL_MSK 0x7
#define B_BE_SND_DNGCNT_RST BIT(20)
#define B_BE_MER_SND_DBGCNT_SEL_SH 16
#define B_BE_MER_SND_DBGCNT_SEL_MSK 0xf
#define B_BE_TB_CSI_UL_LENGTH_ERR_FLAG BIT(8)
#define B_BE_MER_SND_DNGCNT_SH 0
#define B_BE_MER_SND_DNGCNT_MSK 0xff

#define R_BE_BFMER_UPD_MEE_PARA 0x0170
#define R_BE_BFMER_UPD_MEE_PARA_C1 0x2170
#define B_BE_MER_UPDMEE_USERID_C_SH 16
#define B_BE_MER_UPDMEE_USERID_C_MSK 0x1f
#define B_BE_MER_UPDMEE_CSI BIT(15)
#define B_BE_MER_UPDMEE_FT_SH 12
#define B_BE_MER_UPDMEE_FT_MSK 0x3
#define B_BE_MER_UPDMEE_BW_SH 10
#define B_BE_MER_UPDMEE_BW_MSK 0x3
#define B_BE_MER_UPDMEE_CB_SH 8
#define B_BE_MER_UPDMEE_CB_MSK 0x3
#define B_BE_MER_UPDMEE_NG_SH 6
#define B_BE_MER_UPDMEE_NG_MSK 0x3
#define B_BE_MER_UPDMEE_NR_SH 3
#define B_BE_MER_UPDMEE_NR_MSK 0x7
#define B_BE_MER_UPDMEE_NC_SH 0
#define B_BE_MER_UPDMEE_NC_MSK 0x7

#define R_BE_BFMER_RO_MEE_PARA 0x0174
#define R_BE_BFMER_RO_MEE_PARA_C1 0x2174
#define B_BE_BFMER_CTRLINFO_MACID_SH 24
#define B_BE_BFMER_CTRLINFO_MACID_MSK 0xff
#define B_BE_RO_USER_ID_SEL_SH 16
#define B_BE_RO_USER_ID_SEL_MSK 0x1f
#define B_BE_BFMER_RO_MEE_PARA_FT_SH 12
#define B_BE_BFMER_RO_MEE_PARA_FT_MSK 0x3
#define B_BE_BFMER_RO_MEE_PARA_BW_SH 10
#define B_BE_BFMER_RO_MEE_PARA_BW_MSK 0x3
#define B_BE_BFMER_RO_MEE_PARA_CB_SH 8
#define B_BE_BFMER_RO_MEE_PARA_CB_MSK 0x3
#define B_BE_BFMER_RO_MEE_PARA_NG_SH 6
#define B_BE_BFMER_RO_MEE_PARA_NG_MSK 0x3
#define B_BE_BFMER_RO_MEE_PARA_NR_SH 3
#define B_BE_BFMER_RO_MEE_PARA_NR_MSK 0x7
#define B_BE_BFMER_RO_MEE_PARA_NC_SH 0
#define B_BE_BFMER_RO_MEE_PARA_NC_MSK 0x7

#define R_BE_BFMER_CTRL_0 0x0178
#define R_BE_BFMER_CTRL_0_C1 0x2178
#define B_BE_BFMER_HE_CSI_OFFSET_SH 24
#define B_BE_BFMER_HE_CSI_OFFSET_MSK 0xff
#define B_BE_BFMER_VHT_CSI_OFFSET_SH 16
#define B_BE_BFMER_VHT_CSI_OFFSET_MSK 0xff
#define B_BE_BFMER_HT_CSI_OFFSET_SH 8
#define B_BE_BFMER_HT_CSI_OFFSET_MSK 0xff
#define B_BE_BFMER_NDP_BFEN BIT(2)
#define B_BE_BFMER_VHT_BFPRT_CHK BIT(0)

#define R_BE_BFMER_DEBUG_MIMO_CTRL_FIELD 0x017C
#define R_BE_BFMER_DEBUG_MIMO_CTRL_FIELD_C1 0x217C
#define B_BE_DBG_BFMER_MIMO_CTRL_SH 0
#define B_BE_DBG_BFMER_MIMO_CTRL_MSK 0xffffffffL

#define R_BE_BFMEE_RESP_OPTION 0x0180
#define R_BE_BFMEE_RESP_OPTION_C1 0x2180
#define B_BE_BFMEE_NDP_RX_TIMEOUT_SH 24
#define B_BE_BFMEE_NDP_RX_TIMEOUT_MSK 0xff
#define B_BE_BFMEE_CSI_RELEASE_TIMER_SH 20
#define B_BE_BFMEE_CSI_RELEASE_TIMER_MSK 0xf
#define B_BE_MU_BFRPTSEG_SEL_SH 17
#define B_BE_MU_BFRPTSEG_SEL_MSK 0x3
#define B_BE_BFMEE_NDP_RXSTDBY_SEL BIT(16)
#define B_BE_BFMEE_MU_BFEE_DIS BIT(7)
#define B_BE_BFMEE_CHECK_RPTPOLL_MACID_DIS BIT(6)
#define B_BE_BFMEE_NOCHK_BFPOLL_BMP BIT(5)
#define B_BE_BFMEE_VHTBFRPT_CHK BIT(4)
#define B_BE_BFMEE_HE_NDPA_EN BIT(2)
#define B_BE_BFMEE_VHT_NDPA_EN BIT(1)
#define B_BE_BFMEE_HT_NDPA_EN BIT(0)

#define R_BE_BFMEE_OPTION 0x0184
#define R_BE_BFMEE_OPTION_C1 0x2184
#define B_BE_CSI_IS_EHT BIT(29)
#define B_BE_CSI_RPT_LEN_SH 16
#define B_BE_CSI_RPT_LEN_MSK 0x1fff
#define B_BE_CSI_IS_HE BIT(15)
#define B_BE_CSI_IS_VNT BIT(14)
#define B_BE_CSI_IS_HT BIT(13)
#define B_BE_CSI_RPT_CNT_SH 0
#define B_BE_CSI_RPT_CNT_MSK 0x1fff

#define R_BE_TRXPTCL_RESP_CSI_CTRL_0 0x0188
#define R_BE_TRXPTCL_RESP_CSI_CTRL_0_C1 0x2188
#define B_BE_BFMEE_CSISEQ_SEL BIT(29)
#define B_BE_BFMEE_BFPARAM_SEL BIT(28)
#define B_BE_BFMEE_OFDM_LEN_TH_SH 24
#define B_BE_BFMEE_OFDM_LEN_TH_MSK 0xf
#define B_BE_BFMEE_BF_PORT_SEL BIT(23)
#define B_BE_BFMEE_USE_NSTS BIT(22)
#define B_BE_BFMEE_CSI_RATE_FB_EN BIT(21)
#define B_BE_BFMEE_CSI_GID_SEL BIT(20)
#define B_BE_BFMEE_CSI_RSC_SH 18
#define B_BE_BFMEE_CSI_RSC_MSK 0x3
#define B_BE_BFMEE_CSI_FORCE_RETE_EN BIT(17)
#define B_BE_BFMEE_CSI_USE_NDPARATE BIT(16)
#define B_BE_BFMEE_CSI_WITHHTC_EN BIT(15)
#define B_BE_BFMEE_CSIINFO0_BF_EN BIT(14)
#define B_BE_BFMEE_CSIINFO0_STBC_EN BIT(13)
#define B_BE_BFMEE_CSIINFO0_LDPC_EN BIT(12)
#define B_BE_BFMEE_CSIINFO0_CS_SH 10
#define B_BE_BFMEE_CSIINFO0_CS_MSK 0x3
#define B_BE_BFMEE_CSIINFO0_CB_SH 8
#define B_BE_BFMEE_CSIINFO0_CB_MSK 0x3
#define B_BE_BFMEE_CSIINFO0_NG_SH 6
#define B_BE_BFMEE_CSIINFO0_NG_MSK 0x3
#define B_BE_BFMEE_CSIINFO0_NR_SH 3
#define B_BE_BFMEE_CSIINFO0_NR_MSK 0x7
#define B_BE_BFMEE_CSIINFO0_NC_SH 0
#define B_BE_BFMEE_CSIINFO0_NC_MSK 0x7

#define R_BE_TRXPTCL_RESP_CSI_RRSC 0x018C
#define R_BE_TRXPTCL_RESP_CSI_RRSC_C1 0x218C
#define B_BE_BFMEE_CSI_RRSC_BMAP_SH 0
#define B_BE_BFMEE_CSI_RRSC_BMAP_MSK 0xffffffffL

#define R_BE_TRXPTCL_RESP_CSI_RATE 0x0190
#define R_BE_TRXPTCL_RESP_CSI_RATE_C1 0x2190
#define B_BE_BFMEE_EHT_CSI_RATE_SH 24
#define B_BE_BFMEE_EHT_CSI_RATE_MSK 0xff
#define B_BE_BFMEE_HE_CSI_RATE_SH 16
#define B_BE_BFMEE_HE_CSI_RATE_MSK 0xff
#define B_BE_BFMEE_VHT_CSI_RATE_SH 8
#define B_BE_BFMEE_VHT_CSI_RATE_MSK 0xff
#define B_BE_BFMEE_HT_CSI_RATE_SH 0
#define B_BE_BFMEE_HT_CSI_RATE_MSK 0xff

#define R_BE_TRXPTCL_RESP_CSI_CTRL_1 0x0194
#define R_BE_TRXPTCL_RESP_CSI_CTRL_1_C1 0x2194
#define B_BE_BFMEE_CSI_TXTIME_LEN_LIMIT_SH 16
#define B_BE_BFMEE_CSI_TXTIME_LEN_LIMIT_MSK 0xff
#define B_BE_BFMEE_CSIINFO1_BF_EN BIT(14)
#define B_BE_BFMEE_CSIINFO1_STBC_EN BIT(13)
#define B_BE_BFMEE_CSIINFO1_LDPC_EN BIT(12)
#define B_BE_BFMEE_CSIINFO1_CS_SH 10
#define B_BE_BFMEE_CSIINFO1_CS_MSK 0x3
#define B_BE_BFMEE_CSIINFO1_CB_SH 8
#define B_BE_BFMEE_CSIINFO1_CB_MSK 0x3
#define B_BE_BFMEE_CSIINFO1_NG_SH 6
#define B_BE_BFMEE_CSIINFO1_NG_MSK 0x3
#define B_BE_BFMEE_CSIINFO1_NR_SH 3
#define B_BE_BFMEE_CSIINFO1_NR_MSK 0x7
#define B_BE_BFMEE_CSIINFO1_NC_SH 0
#define B_BE_BFMEE_CSIINFO1_NC_MSK 0x7

//
// RMAC
//

#define R_BE_RCR 0xCE00
#define R_BE_RCR_C1 0xEE00
#define B_BE_BUSY_CHKSN BIT(15)
#define B_BE_DYN_CHEN BIT(14)
#define B_BE_AUTO_RST BIT(13)
#define B_BE_TIMER_SEL BIT(12)
#define B_BE_STOP_RX_IN BIT(11)
#define B_BE_DRV_INFO_SZ_SH 8
#define B_BE_DRV_INFO_SZ_MSK 0x3
#define B_BE_HDR_CNV_SZ_SH 6
#define B_BE_HDR_CNV_SZ_MSK 0x3
#define B_BE_PHY_RPT_SZ_SH 4
#define B_BE_PHY_RPT_SZ_MSK 0x3
#define B_BE_CH_EN BIT(0)

#define R_BE_DLK_PROTECT_CTL 0xCE02
#define R_BE_DLK_PROTECT_CTL_C1 0xEE02
#define B_BE_RX_DLK_CCA_TIME_SH 8
#define B_BE_RX_DLK_CCA_TIME_MSK 0xff
#define B_BE_RX_DLK_DATA_TIME_SH 4
#define B_BE_RX_DLK_DATA_TIME_MSK 0xf
#define B_BE_RX_DLK_RST_FSM BIT(3)
#define B_BE_RX_DLK_RST_SKIPDMA BIT(2)
#define B_BE_RX_DLK_RST_EN BIT(1)
#define B_BE_RX_DLK_INT_EN BIT(0)

#define R_BE_PLCP_HDR_FLTR 0xCE04
#define R_BE_PLCP_HDR_FLTR_C1 0xEE04
#define B_BE_PLCP_RXFA_RESET_TYPE_SH 12
#define B_BE_PLCP_RXFA_RESET_TYPE_MSK 0xf
#define B_BE_PLCP_RXFA_RESET_EN BIT(11)
#define B_BE_DIS_CHK_MIN_LEN BIT(8)
#define B_BE_HE_SIGB_CRC_CHK BIT(6)
#define B_BE_VHT_MU_SIGB_CRC_CHK BIT(5)
#define B_BE_VHT_SU_SIGB_CRC_CHK BIT(4)
#define B_BE_SIGA_CRC_CHK BIT(3)
#define B_BE_LSIG_PARITY_CHK_EN BIT(2)
#define B_BE_CCK_SIG_CHK BIT(1)
#define B_BE_CCK_CRC_CHK BIT(0)

#define R_BE_RXGCK_CTRL 0xCE06
#define R_BE_RXGCK_CTRL_C1 0xEE06
#define B_BE_RXGCK_GCK_RATE_LIMIT_SH 8
#define B_BE_RXGCK_GCK_RATE_LIMIT_MSK 0x3
#define B_BE_RXGCK_ENTRY_DELAY_SH 4
#define B_BE_RXGCK_ENTRY_DELAY_MSK 0x7
#define B_BE_RXGCK_GCK_CYCLE_SH 2
#define B_BE_RXGCK_GCK_CYCLE_MSK 0x3
#define B_BE_RXGCK_CCA_EN BIT(1)
#define B_BE_DISGCLK BIT(0)

#define R_BE_RXPSF_CTRL 0xCE08
#define R_BE_RXPSF_CTRL_C1 0xEE08
#define B_BE_RXPSF_PKT_TIME_THR_SH 16
#define B_BE_RXPSF_PKT_TIME_THR_MSK 0xf
#define B_BE_RXPSF_ERRTHR_SH 12
#define B_BE_RXPSF_ERRTHR_MSK 0x7
#define B_BE_INVALID_WIDTH_SH 8
#define B_BE_INVALID_WIDTH_MSK 0x3
#define B_BE_RXPSF_PLCP_CHKEN BIT(4)
#define B_BE_RXPSF_BSS_CHKEN BIT(3)
#define B_BE_RXPSF_MHCHKEN BIT(2)
#define B_BE_RXPSF_CONT_ERRCHKEN BIT(1)

#define R_BE_RXPSF_MGT_TYPE 0xCE0E
#define R_BE_RXPSF_MGT_TYPE_C1 0xEE0E
#define B_BE_RXPSF_MGT15_PRSV BIT(15)
#define B_BE_RXPSF_MGT14_PRSV BIT(14)
#define B_BE_RXPSF_MGT13_PRSV BIT(13)
#define B_BE_RXPSF_MGT12_PRSV BIT(12)
#define B_BE_RXPSF_MGT11_PRSV BIT(11)
#define B_BE_RXPSF_MGT10_PRSV BIT(10)
#define B_BE_RXPSF_MGT9_PRSV BIT(9)
#define B_BE_RXPSF_MGT8_PRSV BIT(8)
#define B_BE_RXPSF_MGT7_PRSV BIT(7)
#define B_BE_RXPSF_MGT6_PRSV BIT(6)
#define B_BE_RXPSF_MGT5_PRSV BIT(5)
#define B_BE_RXPSF_MGT4_PRSV BIT(4)
#define B_BE_RXPSF_MGT3_PRSV BIT(3)
#define B_BE_RXPSF_MGT2_PRSV BIT(2)
#define B_BE_RXPSF_MGT1_PRSV BIT(1)
#define B_BE_RXPSF_MGT0_PRSV BIT(0)

#define R_BE_RXPSF_DATA_TYPE 0xCE0C
#define R_BE_RXPSF_DATA_TYPE_C1 0xEE0C
#define B_BE_RXPSF_DATA15_PRSV BIT(15)
#define B_BE_RXPSF_DATA14_PRSV BIT(14)
#define B_BE_RXPSF_DATA13_PRSV BIT(13)
#define B_BE_RXPSF_DATA12_PRSV BIT(12)
#define B_BE_RXPSF_DATA11_PRSV BIT(11)
#define B_BE_RXPSF_DATA10_PRSV BIT(10)
#define B_BE_RXPSF_DATA9_PRSV BIT(9)
#define B_BE_RXPSF_DATA8_PRSV BIT(8)
#define B_BE_RXPSF_DATA7_PRSV BIT(7)
#define B_BE_RXPSF_DATA6_PRSV BIT(6)
#define B_BE_RXPSF_DATA5_PRSV BIT(5)
#define B_BE_RXPSF_DATA4_PRSV BIT(4)
#define B_BE_RXPSF_DATA3_PRSV BIT(3)
#define B_BE_RXPSF_DATA2_PRSV BIT(2)
#define B_BE_RXPSF_DATA1_PRSV BIT(1)
#define B_BE_RXPSF_DATA_PRSV BIT(0)

#define R_BE_RXPSF_CTRL_TYPE 0xCE10
#define R_BE_RXPSF_CTRL_TYPE_C1 0xEE10
#define B_BE_RXPSF_CTRL_PRSV BIT(0)

#define R_BE_RXPSF_RATE 0xCE12
#define R_BE_RXPSF_RATE_C1 0xEE12
#define B_BE_RXPSF_HETB_PRSV BIT(8)
#define B_BE_RXPSF_HEMU_PRSV BIT(7)
#define B_BE_RXPSF_HEERSU_PRSV BIT(6)
#define B_BE_RXPSF_HESU_PRSV BIT(5)
#define B_BE_RXPSF_VHTMU_PRSV BIT(4)
#define B_BE_RXPSF_VHTSU_PRSV BIT(3)
#define B_BE_RXPSF_HT_PRSV BIT(2)
#define B_BE_RXPSF_OFDM_PRSV BIT(1)
#define B_BE_RXPSF_CCK_PRSV BIT(0)

#define R_BE_RXAI_CTRL 0xCE14
#define R_BE_RXAI_CTRL_C1 0xEE14
#define B_BE_RXAI_INFO_RST BIT(7)
#define B_BE_RXAI_PRTCT_REL BIT(6)
#define B_BE_RXAI_PRTCT_VIO BIT(5)
#define B_BE_RXAI_RECCA_DIS BIT(2)
#define B_BE_RXAI_PRTCT_SEL BIT(1)
#define B_BE_RXAI_PRTCT_EN BIT(0)

#define R_BE_RX_FIFO_STATUS 0xCE18
#define R_BE_RX_FIFO_STATUS_C1 0xEE18
#define B_BE_RXDFIFO_ADDR_CLR BIT(31)
#define B_BE_RXDFIFO_ADDR_MODE_SH 28
#define B_BE_RXDFIFO_ADDR_MODE_MSK 0x3
#define B_BE_RXDFIFO_RADDR_SH 8
#define B_BE_RXDFIFO_RADDR_MSK 0xff
#define B_BE_RXDFIFO_WADDR_SH 0
#define B_BE_RXDFIFO_WADDR_MSK 0xff

#define R_BE_RX_FIFO_CTRL 0xCE1C
#define R_BE_RX_FIFO_CTRL_C1 0xEE1C
#define B_BE_RXS_FIFO_IORST BIT(24)
#define B_BE_RXD_FIFO_MAX_LEV_CLR BIT(23)
#define B_BE_RXD_FIFO_MAX_LEV_SH 8
#define B_BE_RXD_FIFO_MAX_LEV_MSK 0xff
#define B_BE_RXD_FIFO_FULL_TH_SH 0
#define B_BE_RXD_FIFO_FULL_TH_MSK 0xff

#define R_BE_RX_FLTR_OPT 0xCE20
#define R_BE_RX_FLTR_OPT_C1 0xEE20
#define B_BE_UID_FILTER_SH 24
#define B_BE_UID_FILTER_MSK 0xff
#define B_BE_UNSPT_FILTER_SH 22
#define B_BE_UNSPT_FILTER_MSK 0x3
#define B_BE_RX_MPDU_MAX_LEN_SH 16
#define B_BE_RX_MPDU_MAX_LEN_MSK 0x3f
#define B_BE_A_FTM_REQ BIT(14)
#define B_BE_A_ERR_PKT BIT(13)
#define B_BE_A_UNSUP_PKT BIT(12)
#define B_BE_A_CRC32_ERR BIT(11)
#define B_BE_A_BCN_CHK_RULE_SH 8
#define B_BE_A_BCN_CHK_RULE_MSK 0x3
#define B_BE_A_BCN_CHK_EN BIT(7)
#define B_BE_A_MC_LIST_CAM_MATCH BIT(6)
#define B_BE_A_BC_CAM_MATCH BIT(5)
#define B_BE_A_UC_CAM_MATCH BIT(4)
#define B_BE_A_MC BIT(3)
#define B_BE_A_BC BIT(2)
#define B_BE_A_A1_MATCH BIT(1)
#define B_BE_SNIFFER_MODE BIT(0)

#define R_BE_CTRL_FLTR 0xCE24
#define R_BE_CTRL_FLTR_C1 0xEE24
#define B_BE_CTRL_STYPE_SH 0
#define B_BE_CTRL_STYPE_MSK 0xffff

#define R_BE_MGNT_FLTR 0xCE28
#define R_BE_MGNT_FLTR_C1 0xEE28
#define B_BE_MGNT_STYPE_SH 0
#define B_BE_MGNT_STYPE_MSK 0xffff

#define R_BE_DATA_FLTR 0xCE2C
#define R_BE_DATA_FLTR_C1 0xEE2C
#define B_BE_DATA_STYPE_SH 0
#define B_BE_DATA_STYPE_MSK 0xffff

#define R_BE_ZLENDEL_COUNT 0xCE30
#define R_BE_ZLENDEL_COUNT_C1 0xEE30
#define B_BE_RXD_DELI_NUM_SH 8
#define B_BE_RXD_DELI_NUM_MSK 0xff
#define B_BE_RXD_DELI_NUM_SEL_SH 4
#define B_BE_RXD_DELI_NUM_SEL_MSK 0xf
#define B_BE_RXD_DELI_UNIT_SH 1
#define B_BE_RXD_DELI_UNIT_MSK 0x3
#define B_BE_RXD_DELI_EN BIT(0)

#define R_BE_ADDR_CAM_CTRL 0xCE34
#define R_BE_ADDR_CAM_CTRL_C1 0xEE34
#define B_BE_ADDR_CAM_RANGE_SH 16
#define B_BE_ADDR_CAM_RANGE_MSK 0xff
#define B_BE_ADDR_CAM_CMPLIMT_SH 12
#define B_BE_ADDR_CAM_CMPLIMT_MSK 0xf
#define B_BE_ADDR_CAM_IORST BIT(10)
#define B_BE_DIS_ADDR_CLK_GATED BIT(9)
#define B_BE_ADDR_CAM_CLR BIT(8)
#define B_BE_ADDR_CAM_A2_B0_CHK BIT(2)
#define B_BE_ADDR_CAM_SRCH_PERPKT BIT(1)
#define B_BE_ADDR_CAM_EN BIT(0)

#define R_BE_ADDR_CAM_DIS_INFO 0xCE38
#define R_BE_ADDR_CAM_DIS_INFO_C1 0xEE38
#define B_BE_ADDR_CAM_DIS_MACID_SH 24
#define B_BE_ADDR_CAM_DIS_MACID_MSK 0xff
#define B_BE_ADDR_CAM_DIS_SEC_IDX_SH 16
#define B_BE_ADDR_CAM_DIS_SEC_IDX_MSK 0xff
#define B_BE_ADDR_CAM_DIS_PORT_SH 12
#define B_BE_ADDR_CAM_DIS_PORT_MSK 0x7
#define B_BE_ADDR_CAM_DIS_A3_HIT BIT(11)
#define B_BE_ADDR_CAM_DIS_A2_HIT BIT(10)
#define B_BE_ADDR_CAM_DIS_A1_HIT BIT(9)
#define B_BE_ADDR_CAM_DIS_CAM_HIT BIT(8)
#define B_BE_ADDR_CAM_DIS_IDX_SH 0
#define B_BE_ADDR_CAM_DIS_IDX_MSK 0xff

#define R_BE_RESPBA_CAM_CTRL 0xCE3C
#define R_BE_RESPBA_CAM_CTRL_C1 0xEE3C
#define B_BE_BACAM_SKIP_ALL_QOSNULL BIT(24)
#define B_BE_BACAM_SIZE_SH 16
#define B_BE_BACAM_SIZE_MSK 0x3
#define B_BE_BACAM_RST_IDX_SH 8
#define B_BE_BACAM_RST_IDX_MSK 0xff
#define B_BE_BACAM_SHIFT_POLL BIT(7)
#define B_BE_BACAM_IORST BIT(6)
#define B_BE_BACAM_GCK_DIS BIT(5)
#define B_BE_COMPL_VAL BIT(3)
#define B_BE_SSN_SEL BIT(2)
#define B_BE_BACAM_RST_SH 0
#define B_BE_BACAM_RST_MSK 0x3

#define R_BE_PPDU_STAT 0xCE40
#define R_BE_PPDU_STAT_C1 0xEE40
#define B_BE_PPDU_STAT_WR_BW_SH 10
#define B_BE_PPDU_STAT_WR_BW_MSK 0x3
#define B_BE_PPDU_STAT_RPT_TRIG BIT(8)
#define B_BE_PPDU_STAT_RPT_DMA BIT(6)
#define B_BE_PPDU_STAT_RPT_CRC32 BIT(5)
#define B_BE_PPDU_STAT_RPT_ADDR BIT(4)
#define B_BE_APP_PLCP_HDR_RPT BIT(3)
#define B_BE_APP_RX_CNT_RPT BIT(2)
#define B_BE_APP_MAC_INFO_RPT BIT(1)
#define B_BE_PPDU_STAT_RPT_EN BIT(0)

#define R_BE_PPDU_STAT_ERR 0xCE42
#define R_BE_PPDU_STAT_ERR_C1 0xEE42
#define B_BE_PPDU_STAT_CNTR_SH 8
#define B_BE_PPDU_STAT_CNTR_MSK 0xff
#define B_BE_PPDU_STAT_ERR_FLAG_SH 0
#define B_BE_PPDU_STAT_ERR_FLAG_MSK 0xff

#define R_BE_CH_INFO_QRY 0xCE44
#define R_BE_CH_INFO_QRY_C1 0xEE44
#define B_BE_CH_INFO_TIME_SH 24
#define B_BE_CH_INFO_TIME_MSK 0xff
#define B_BE_CH_INFO_CNT_SH 21
#define B_BE_CH_INFO_CNT_MSK 0x7
#define B_BE_CH_INFO_REQUSTING BIT(20)
#define B_BE_CH_INFO_MGNT_FRM BIT(19)
#define B_BE_CH_INFO_CTRL_FRM BIT(18)
#define B_BE_CH_INFO_DATA_FRM BIT(17)
#define B_BE_CH_INFO_CRC_FAIL BIT(16)
#define B_BE_CH_INFO_MACID_SH 8
#define B_BE_CH_INFO_MACID_MSK 0xff
#define B_BE_CH_INFO_MODE_SH 1
#define B_BE_CH_INFO_MODE_MSK 0x7
#define B_BE_GET_CH_INFO_EN BIT(0)

#define R_BE_MACID_MATCH 0xCE48
#define R_BE_MACID_MATCH_C1 0xEE48
#define B_BE_MACID_MATCH_SH 8
#define B_BE_MACID_MATCH_MSK 0xff
#define B_BE_MACID_MATCH_MODE BIT(1)
#define B_BE_MACID_MATCH_EN BIT(0)

#define R_BE_RX_SR_CTRL 0xCE4A
#define R_BE_RX_SR_CTRL_C1 0xEE4A
#define B_BE_SR_OP_MODE_SH 4
#define B_BE_SR_OP_MODE_MSK 0x3
#define B_BE_SRG_CHK_EN BIT(2)
#define B_BE_SR_CTRL_PLCP_EN BIT(1)
#define B_BE_SR_EN BIT(0)

#define R_BE_BSSID_SRC_CTRL 0xCE4B
#define R_BE_BSSID_SRC_CTRL_C1 0xEE4B
#define B_BE_BSSID_MATCH BIT(3)
#define B_BE_PARTIAL_AID_MATCH BIT(2)
#define B_BE_BSSCOLOR_MATCH BIT(1)
#define B_BE_PLCP_SRC_EN BIT(0)

#define R_BE_SR_OBSS_PD 0xCE4C
#define R_BE_SR_OBSS_PD_C1 0xEE4C
#define B_BE_SRG_OBSS_PD_MAX_SH 24
#define B_BE_SRG_OBSS_PD_MAX_MSK 0xff
#define B_BE_SRG_OBSS_PD_MIN_SH 16
#define B_BE_SRG_OBSS_PD_MIN_MSK 0xff
#define B_BE_NONSRG_OBSS_PD_MAX_SH 8
#define B_BE_NONSRG_OBSS_PD_MAX_MSK 0xff
#define B_BE_NONSRG_OBSS_PD_MIN_SH 0
#define B_BE_NONSRG_OBSS_PD_MIN_MSK 0xff

#define R_BE_SR_BSSCOLOR_BITMAP 0xCE50
#define R_BE_SR_BSSCOLOR_BITMAP_C1 0xEE50
#define B_BE_BSSCOLOR_BITMAP_SH 0
#define B_BE_BSSCOLOR_BITMAP_MSK 0xffffffffL

#define R_BE_SR_BSSCOLOR_BITMAP_H 0xCE54
#define R_BE_SR_BSSCOLOR_BITMAP_H_C1 0xEE54
#define B_BE_BSSCOLOR_BITMAP_H_SH 0
#define B_BE_BSSCOLOR_BITMAP_H_MSK 0xffffffffL

#define R_BE_SR_PARTIAL_BSSCOLOR_BITMAP 0xCE58
#define R_BE_SR_PARTIAL_BSSCOLOR_BITMAP_C1 0xEE58
#define B_BE_PARTIAL_BSSID_BITMAP_SH 0
#define B_BE_PARTIAL_BSSID_BITMAP_MSK 0xffffffffL

#define R_BE_SR_PARTIAL_BSSCOLOR_BITMAP_H 0xCE5C
#define R_BE_SR_PARTIAL_BSSCOLOR_BITMAP_H_C1 0xEE5C
#define B_BE_PARTIAL_BSSID_BITMAP_H_SH 0
#define B_BE_PARTIAL_BSSID_BITMAP_H_MSK 0xffffffffL

#define R_BE_SCOPE_CTRL 0xCE60
#define R_BE_SCOPE_CTRL_C1 0xEE60
#define B_BE_SCOPE_LEN_SH 8
#define B_BE_SCOPE_LEN_MSK 0xf
#define B_BE_SCOPE_FILTER_SH 4
#define B_BE_SCOPE_FILTER_MSK 0x3
#define B_BE_SCOPE_APPZERO BIT(3)
#define B_BE_SCOPE_MODE_SH 0
#define B_BE_SCOPE_MODE_MSK 0x7

#define R_BE_CSIRPT_OPTION 0xCE64
#define R_BE_CSIRPT_OPTION_C1 0xEE64
#define B_BE_CSIRPT_CHKSUM_ERROR BIT(31)
#define B_BE_CSIRPT_BBLEN_LT_MAC BIT(30)
#define B_BE_CSIRPT_BBLEN_GT_MAC BIT(29)
#define B_BE_CSIPRT_HESU_AID_EN BIT(25)
#define B_BE_CSIPRT_VHTSU_AID_EN BIT(24)
#define B_BE_CSIRPT_FIFO_RESUME_THR_SH 16
#define B_BE_CSIRPT_FIFO_RESUME_THR_MSK 0xff
#define B_BE_CSIRPT_FIFO_PAUSE_THR_SH 8
#define B_BE_CSIRPT_FIFO_PAUSE_THR_MSK 0xff
#define B_BE_CSIRPT_LEN_MISMATCH BIT(6)
#define B_BE_CSIRPT_DMAFULL_IGNORE BIT(5)
#define B_BE_CSIRPT_FILTER_SH 3
#define B_BE_CSIRPT_FILTER_MSK 0x3
#define B_BE_CSIRPT_CHECKSUM_DIS BIT(2)
#define B_BE_CSIRPT_EMPTY_APPZERO BIT(1)
#define B_BE_CSIRPT_NDPPLCP_CHK_EN BIT(0)

#define R_BE_BSR_UPD_CTRL 0xCE68
#define R_BE_BSR_UPD_CTRL_C1 0xEE68
#define B_BE_QSIZE_UPD BIT(0)

#define R_BE_DRV_INFO_OPTION 0xCE70
#define R_BE_DRV_INFO_OPTION_C1 0xEE70
#define B_BE_DRV_INFO_PHYRPT_EN BIT(0)

#define R_BE_BCN_PSR_CTRL 0xCE80
#define R_BE_BCN_PSR_CTRL_C1 0xEE80
#define B_BE_BCN_HIT_INT_PORT_SH 4
#define B_BE_BCN_HIT_INT_PORT_MSK 0xf
#define B_BE_BCAID_HIT_INT_EN BIT(3)
#define B_BE_UNIAID_HIT_INT_EN BIT(2)
#define B_BE_IE_HIT_INT_EN BIT(1)
#define B_BE_TIM_PARSER_EN BIT(0)

#define R_BE_BCN_IECAM_CTRL 0xCE82
#define R_BE_BCN_IECAM_CTRL_C1 0xEE82
#define B_BE_BCN_PSR_BUSY BIT(15)
#define B_BE_BCN_IECAM_IORST BIT(14)
#define B_BE_BCN_IE_NOHIT_FRWD_SH 10
#define B_BE_BCN_IE_NOHIT_FRWD_MSK 0x3
#define B_BE_BCN_IE_HIT_FRWD_SH 8
#define B_BE_BCN_IE_HIT_FRWD_MSK 0x3
#define B_BE_BCN_IECAM_PORT_SH 4
#define B_BE_BCN_IECAM_PORT_MSK 0xf
#define B_BE_BCN_IECAM_CLR BIT(3)
#define B_BE_BCN_IE_NOHIT_FRWD_EN BIT(2)
#define B_BE_BCN_IE_HIT_FRWD_EN BIT(1)
#define B_BE_BCN_IECAM_EN BIT(0)

#define R_BE_BCN_PSR_RPT_P0 0xCE84
#define R_BE_BCN_PSR_RPT_P0_C1 0xEE84
#define B_BE_DTIM_CNT_P0_SH 24
#define B_BE_DTIM_CNT_P0_MSK 0xff
#define B_BE_DTIM_PERIOD_P0_SH 16
#define B_BE_DTIM_PERIOD_P0_MSK 0xff
#define B_BE_BCAID_HIT_P0 BIT(15)
#define B_BE_UNIAID_HIT_P0 BIT(14)
#define B_BE_IE_HIT_P0 BIT(13)
#define B_BE_TIM_ILEGAL_P0 BIT(12)
#define B_BE_RPT_VALID_P0 BIT(11)
#define B_BE_BCAID_P0_SH 0
#define B_BE_BCAID_P0_MSK 0x7ff

#define R_BE_BCN_PSR_RPT_P1 0xCE88
#define R_BE_BCN_PSR_RPT_P1_C1 0xEE88
#define B_BE_DTIM_CNT_P1_SH 24
#define B_BE_DTIM_CNT_P1_MSK 0xff
#define B_BE_DTIM_PERIOD_P1_SH 16
#define B_BE_DTIM_PERIOD_P1_MSK 0xff
#define B_BE_BCAID_HIT_P1 BIT(15)
#define B_BE_UNIAID_HIT_P1 BIT(14)
#define B_BE_IE_HIT_P1 BIT(13)
#define B_BE_TIM_ILEGAL_P1 BIT(12)
#define B_BE_RPT_VALID_P1 BIT(11)
#define B_BE_BCAID_P1_SH 0
#define B_BE_BCAID_P1_MSK 0x7ff

#define R_BE_BCN_PSR_RPT_P2 0xCE8C
#define R_BE_BCN_PSR_RPT_P2_C1 0xEE8C
#define B_BE_DTIM_CNT_P2_SH 24
#define B_BE_DTIM_CNT_P2_MSK 0xff
#define B_BE_DTIM_PERIOD_P2_SH 16
#define B_BE_DTIM_PERIOD_P2_MSK 0xff
#define B_BE_BCAID_HIT_P2 BIT(15)
#define B_BE_UNIAID_HIT_P2 BIT(14)
#define B_BE_IE_HIT_P2 BIT(13)
#define B_BE_TIM_ILEGAL_P2 BIT(12)
#define B_BE_RPT_VALID_P2 BIT(11)
#define B_BE_BCAID_P2_SH 0
#define B_BE_BCAID_P2_MSK 0x7ff

#define R_BE_BCN_PSR_RPT_P3 0xCE90
#define R_BE_BCN_PSR_RPT_P3_C1 0xEE90
#define B_BE_DTIM_CNT_P3_SH 24
#define B_BE_DTIM_CNT_P3_MSK 0xff
#define B_BE_DTIM_PERIOD_P3_SH 16
#define B_BE_DTIM_PERIOD_P3_MSK 0xff
#define B_BE_BCAID_HIT_P3 BIT(15)
#define B_BE_UNIAID_HIT_P3 BIT(14)
#define B_BE_IE_HIT_P3 BIT(13)
#define B_BE_TIM_ILEGAL_P3 BIT(12)
#define B_BE_RPT_VALID_P3 BIT(11)
#define B_BE_BCAID_P3_SH 0
#define B_BE_BCAID_P3_MSK 0x7ff

#define R_BE_BCN_PSR_RPT_P4 0xCE94
#define R_BE_BCN_PSR_RPT_P4_C1 0xEE94
#define B_BE_DTIM_CNT_P4_SH 24
#define B_BE_DTIM_CNT_P4_MSK 0xff
#define B_BE_DTIM_PERIOD_P4_SH 16
#define B_BE_DTIM_PERIOD_P4_MSK 0xff
#define B_BE_BCAID_HIT_P4 BIT(15)
#define B_BE_UNIAID_HIT_P4 BIT(14)
#define B_BE_IE_HIT_P4 BIT(13)
#define B_BE_TIM_ILEGAL_P4 BIT(12)
#define B_BE_RPT_VALID_P4 BIT(11)
#define B_BE_BCAID_P4_SH 0
#define B_BE_BCAID_P4_MSK 0x7ff

#define R_BE_PS_RXINFO 0xCEA0
#define R_BE_PS_RXINFO_C1 0xEEA0
#define B_BE_P4_RXCTRL BIT(14)
#define B_BE_P4_RXMGT BIT(13)
#define B_BE_P4_RXDATA BIT(12)
#define B_BE_P3_RXCTRL BIT(11)
#define B_BE_P3_RXMGT BIT(10)
#define B_BE_P3_RXDATA BIT(9)
#define B_BE_P2_RXCTRL BIT(8)
#define B_BE_P2_RXMGT BIT(7)
#define B_BE_P2_RXDATA BIT(6)
#define B_BE_P1_RXCTRL BIT(5)
#define B_BE_P1_RXMGT BIT(4)
#define B_BE_P1_RXDATA BIT(3)
#define B_BE_P0_RXCTRL BIT(2)
#define B_BE_P0_RXMGT BIT(1)
#define B_BE_P0_RXDATA BIT(0)

#define R_BE_PWRINT_CTRL 0xCEAC
#define R_BE_PWRINT_CTRL_C1 0xEEAC
#define B_BE_SEQNUM_MACID_SH 16
#define B_BE_SEQNUM_MACID_MSK 0xffff
#define B_BE_REF_MACID_SH 8
#define B_BE_REF_MACID_MSK 0x7f
#define B_BE_PWRINT_EN BIT(0)

#define R_BE_SPWR0 0xCEB0
#define R_BE_SPWR0_C1 0xEEB0
#define B_BE_MID_31TO0_SH 0
#define B_BE_MID_31TO0_MSK 0xffffffffL

#define R_BE_SPWR1 0xCEB4
#define R_BE_SPWR1_C1 0xEEB4
#define B_BE_MID_63TO32_SH 0
#define B_BE_MID_63TO32_MSK 0xffffffffL

#define R_BE_SPWR2 0xCEB8
#define R_BE_SPWR2_C1 0xEEB8
#define B_BE_MID_95O64_SH 0
#define B_BE_MID_95O64_MSK 0xffffffffL

#define R_BE_SPWR3 0xCEBC
#define R_BE_SPWR3_C1 0xEEBC
#define B_BE_MID_127TO96_SH 0
#define B_BE_MID_127TO96_MSK 0xffffffffL

#define R_BE_SNIFFER_MODE_CTRL 0xCEC0
#define R_BE_SNIFFER_MODE_CTRL_C1 0xEEC0
#define B_BE_AID3_ENABLE BIT(3)
#define B_BE_AID2_ENABLE BIT(2)
#define B_BE_AID1_ENABLE BIT(1)
#define B_BE_AID0_ENABLE BIT(0)

#define R_BE_SNIFFER_MODE_CFG0 0xCEC4
#define R_BE_SNIFFER_MODE_CFG0_C1 0xEEC4
#define B_BE_SNIFFER_MODE_AID1_SH 16
#define B_BE_SNIFFER_MODE_AID1_MSK 0xfff
#define B_BE_SNIFFER_MODE_AID0_SH 0
#define B_BE_SNIFFER_MODE_AID0_MSK 0xfff

#define R_BE_SNIFFER_MODE_CFG1 0xCEC8
#define R_BE_SNIFFER_MODE_CFG1_C1 0xEEC8
#define B_BE_SNIFFER_MODE_AID3_SH 16
#define B_BE_SNIFFER_MODE_AID3_MSK 0xfff
#define B_BE_SNIFFER_MODE_AID2_SH 0
#define B_BE_SNIFFER_MODE_AID2_MSK 0xfff

#define R_BE_RPL_CFG 0xCECC
#define R_BE_RPL_CFG_C1 0xEECC
#define B_BE_RPLCFG_UPPEB_BE_EN BIT(31)
#define B_BE_RPLCFG_UPPEB_BE_DBM_SH 16
#define B_BE_RPLCFG_UPPEB_BE_DBM_MSK 0x1ff
#define B_BE_RPLCFG_EN BIT(15)
#define B_BE_RPLCFG_DBM_SH 0
#define B_BE_RPLCFG_DBM_MSK 0x1ff

#define R_BE_RX_TO_BRK_OPT 0xCED0
#define R_BE_RX_TO_BRK_OPT_C1 0xEED0
#define B_BE_RXPSR_PAUSE_FRMTYPE_SH 24
#define B_BE_RXPSR_PAUSE_FRMTYPE_MSK 0x3f
#define B_BE_RXPSR_PAUSE_BEACON BIT(21)
#define B_BE_RXPSR_PAUSE_TRIGGER BIT(20)
#define B_BE_RXPSR_PAUSE_BAR BIT(19)
#define B_BE_RXPSR_PAUSE_BA BIT(18)
#define B_BE_RXPSR_PAUSE_MODE_SH 16
#define B_BE_RXPSR_PAUSE_MODE_MSK 0x3
#define B_BE_RXBRK_TB_TIME_SH 8
#define B_BE_RXBRK_TB_TIME_MSK 0x1f
#define B_BE_RXBRK_TIME_SH 0
#define B_BE_RXBRK_TIME_MSK 0xf

#define R_BE_RX_DBG_CNT_SEL 0xCEE0
#define R_BE_RX_DBG_CNT_SEL_C1 0xEEE0
#define B_BE_RX_DBG_CNT_SH 16
#define B_BE_RX_DBG_CNT_MSK 0xffff
#define B_BE_RXERR_RPT_RST BIT(8)
#define B_BE_RX_CNT_IDX_SH 0
#define B_BE_RX_CNT_IDX_MSK 0x3f

#define R_BE_RX_CNT_RPT_CFG 0xCEE4
#define R_BE_RX_CNT_RPT_CFG_C1 0xEEE4
#define B_BE_PKTCNT_SET BIT(31)
#define B_BE_UPD_PKTCNT_CFG_SH 0
#define B_BE_UPD_PKTCNT_CFG_MSK 0x7fffffffL

#define R_BE_RX_PLCP_MON 0xCEE8
#define R_BE_RX_PLCP_MON_C1 0xEEE8
#define B_BE_RX_PLCP_MON_SEL_SH 28
#define B_BE_RX_PLCP_MON_SEL_MSK 0xf
#define B_BE_RX_PLCP_CONT_SH 0
#define B_BE_RX_PLCP_CONT_MSK 0xfffffff

#define R_BE_RX_TIME_MON 0xCEEC
#define R_BE_RX_TIME_MON_C1 0xEEEC
#define B_BE_DMA_WR_TIME_SH 28
#define B_BE_DMA_WR_TIME_MSK 0xf
#define B_BE_DMA_WR_TIMEOUT_SH 24
#define B_BE_DMA_WR_TIMEOUT_MSK 0xf
#define B_BE_INTF_TIMEOUT_THR_SH 16
#define B_BE_INTF_TIMEOUT_THR_MSK 0x3f
#define B_BE_LATENCY_TIME_SH 8
#define B_BE_LATENCY_TIME_MSK 0xf
#define B_BE_CCA2DAT_TIME_SH 0
#define B_BE_CCA2DAT_TIME_MSK 0xff

#define R_BE_RX_STATE_MONITOR 0xCEF0
#define R_BE_RX_STATE_MONITOR_C1 0xEEF0
#define B_BE_STATE_CUR_SH 16
#define B_BE_STATE_CUR_MSK 0xffff
#define B_BE_STATE_EXSEL_SH 14
#define B_BE_STATE_EXSEL_MSK 0x3
#define B_BE_STATE_NXT_SH 8
#define B_BE_STATE_NXT_MSK 0x3f
#define B_BE_STATE_UPD BIT(7)
#define B_BE_STATE_MODE_SH 5
#define B_BE_STATE_MODE_MSK 0x3
#define B_BE_STATE_SEL_SH 0
#define B_BE_STATE_SEL_MSK 0x1f

#define R_BE_RX_ERR_ISR 0xCEF4
#define R_BE_RX_ERR_ISR_C1 0xEEF4
#define B_BE_RX_ERR_TRIG_ACT_TO BIT(9)
#define B_BE_RX_ERR_STS_ACT_TO BIT(8)
#define B_BE_RX_ERR_CSI_ACT_TO BIT(7)
#define B_BE_RX_ERR_ACT_TO BIT(6)
#define B_BE_CSI_DATAON_ASSERT_TO BIT(5)
#define B_BE_DATAON_ASSERT_TO BIT(4)
#define B_BE_CCA_ASSERT_TO BIT(3)
#define B_BE_RX_ERR_DMA_TO BIT(2)
#define B_BE_RX_ERR_DATA_TO BIT(1)
#define B_BE_RX_ERR_CCA_TO BIT(0)

#define R_BE_RX_ERR_IMR 0xCEF8
#define R_BE_RX_ERR_IMR_C1 0xEEF8
#define B_BE_RX_ERR_TRIG_ACT_TO_MSK BIT(9)
#define B_BE_RX_ERR_STS_ACT_TO_MSK BIT(8)
#define B_BE_RX_ERR_CSI_ACT_TO_MSK BIT(7)
#define B_BE_RX_ERR_ACT_TO_MSK BIT(6)
#define B_BE_CSI_DATAON_ASSERT_TO_MSK BIT(5)
#define B_BE_DATAON_ASSERT_TO_MSK BIT(4)
#define B_BE_CCA_ASSERT_TO_MSK BIT(3)
#define B_BE_RX_ERR_DMA_TO_MSK BIT(2)
#define B_BE_RX_ERR_DATA_TO_MSK BIT(1)
#define B_BE_RX_ERR_CCA_TO_MSK BIT(0)

#define R_BE_RX_DEBUG_SELECT 0xCEFC
#define R_BE_RX_DEBUG_SELECT_C1 0xEEFC
#define B_BE_DEBUG_SEL_SH 0
#define B_BE_DEBUG_SEL_MSK 0xff

#define R_BE_WMRX_RCR_EXT_OPTION 0xCF00
#define R_BE_WMRX_RCR_EXT_OPTION_C1 0xEF00
#define B_BE_EXT_CH_SH 0
#define B_BE_EXT_CH_MSK 0xffff

#define R_BE_RX_PLCP_EXT_OPTION_0 0xCF10
#define R_BE_RX_PLCP_EXT_OPTION_0_C1 0xEF10
#define B_BE_PLCP_CONT_CHK_BYPASS_SH 0
#define B_BE_PLCP_CONT_CHK_BYPASS_MSK 0xffff
#define B_BE_PLCP_UID_CHK_EN_SH 16
#define B_BE_PLCP_UID_CHK_EN_MSK 0xffff

#define R_BE_RX_PLCP_EXT_OPTION_1 0xCF14
#define R_BE_RX_PLCP_EXT_OPTION_1_C1 0xEF14
#define B_BE_PLCP_CLOSE_RX_UNSPUUORT BIT(19)
#define B_BE_PLCP_CLOSE_RX_BB_BRK BIT(18)
#define B_BE_PLCP_CLOSE_RX_PSDU_PRES BIT(17)
#define B_BE_PLCP_CLOSE_RX_NDP BIT(16)
#define B_BE_PLCP_DOPPLEB_BE_SRC BIT(10)
#define B_BE_PLCP_STBC_SRC BIT(9)
#define B_BE_PLCP_SU_PSDU_LEN_SRC BIT(8)
#define B_BE_PLCP_RXSB_SRC BIT(7)
#define B_BE_PLCP_BW_SRC_SH 5
#define B_BE_PLCP_BW_SRC_MSK 0x3
#define B_BE_PLCP_GILTF_SRC BIT(4)
#define B_BE_PLCP_NSTS_SRC BIT(3)
#define B_BE_PLCP_MCS_SRC BIT(2)
#define B_BE_PLCP_CH20_WIDATA_SRC BIT(1)
#define B_BEPLCP_PPDU_TYPE_SRC BIT(0)

#define R_BE_RX_PLCP_EXT_OPTION_2 0xCF18
#define R_BE_RX_PLCP_EXT_OPTION_2_C1 0xEF18
#define B_BE_EHTTB_EHTSIG_CRC_CHK_EN BIT(3)
#define B_BE_EHTTB_USIG_CRC_CHK_EN BIT(2)
#define B_BE_EHTMU_EHTSIG_CRC_CHK_EN BIT(1)
#define B_BE_EHTMU_USIG_CRC_CHK_EN BIT(0)

#define R_BE_RXFILTER_EXT_OPTION_0 0xCF20
#define R_BE_RXFILTER_EXT_OPTION_0_C1 0xEF20
#define B_BE_A_BCN_IE_NOHIT BIT(2)
#define B_BE_A_BCN_IE_HIT BIT(1)
#define B_BE_BCN_IE_FILTER_EN BIT(0)

//
// PWR
//

//
// BTCOEX
//

#define R_BE_BTC_CFG 0xDA00
#define R_BE_BTC_CFG_C1 0xFA00
#define B_BE_BTC_EN BIT(31)
#define B_BE_EN_EXT_BT_PINMUX BIT(29)
#define B_BE_BTC_RST BIT(28)
#define B_BE_BTC_DBG_SRC_SEL BIT(27)
#define B_BE_BTC_MODE_SH 24
#define B_BE_BTC_MODE_MSK 0x3
#define B_BE_INV_WL_ACT2 BIT(17)
#define B_BE_BTG_LNA1_GAIN_SEL BIT(16)
#define B_BE_COEX_DLY_CLK_SH 8
#define B_BE_COEX_DLY_CLK_MSK 0xff
#define B_BE_IGN_GNT_BT2_RX BIT(7)
#define B_BE_IGN_GNT_BT2_TX BIT(6)
#define B_BE_IGN_GNT_BT2 BIT(5)
#define B_BE_BTC_DBG_SEL_SH 3
#define B_BE_BTC_DBG_SEL_MSK 0x3
#define B_BE_DIS_BTC_CLK_G BIT(2)
#define B_BE_GNT_WL_RX_CTRL BIT(1)
#define B_BE_WL_SRC BIT(0)

#define R_BE_RTK_MODE_CFG_V1 0xDA04
#define R_BE_RTK_MODE_CFG_V1_C1 0xFA04
#define B_BE_BT_BLE_EN_V1 BIT(24)
#define B_BE_BT_ULTRA_EN BIT(16)
#define B_BE_BT_L_RX_ULTRA_SH 14
#define B_BE_BT_L_RX_ULTRA_MSK 0x3
#define B_BE_BT_L_TX_ULTRA_SH 12
#define B_BE_BT_L_TX_ULTRA_MSK 0x3
#define B_BE_BT_H_RX_ULTRA_SH 10
#define B_BE_BT_H_RX_ULTRA_MSK 0x3
#define B_BE_BT_H_TX_ULTRA_SH 8
#define B_BE_BT_H_TX_ULTRA_MSK 0x3
#define B_BE_SAMPLE_CLK_SH 0
#define B_BE_SAMPLE_CLK_MSK 0xff

#define R_BE_CSR_MODE_CFG 0xDA08
#define R_BE_CSR_MODE_CFG_C1 0xFA08
#define B_BE_BT_TIME_CNT_V1_SH 16
#define B_BE_BT_TIME_CNT_V1_MSK 0xff
#define B_BE_CSR_DELAY_SH 8
#define B_BE_CSR_DELAY_MSK 0xf
#define B_BE_CSR_TRX_SH 4
#define B_BE_CSR_TRX_MSK 0xf
#define B_BE_CSR_PRI_SH 0
#define B_BE_CSR_PRI_MSK 0xf

#define R_BE_BT_CNT_CFG 0xDA10
#define R_BE_BT_CNT_CFG_C1 0xFA10
#define B_BE_BT_CNT_RST_V1 BIT(1)
#define B_BE_BT_CNT_EN BIT(0)

#define R_BE_BT_CNT_HI 0xDA14
#define R_BE_BT_CNT_HI_C1 0xFA14
#define B_BE_BT_HI_RX_SH 16
#define B_BE_BT_HI_RX_MSK 0xffff
#define B_BE_BT_HI_TX_SH 0
#define B_BE_BT_HI_TX_MSK 0xffff

#define R_BE_BT_CNT_LOW 0xDA18
#define R_BE_BT_CNT_LOW_C1 0xFA18
#define B_BE_BT_LOW_RX_SH 16
#define B_BE_BT_LOW_RX_MSK 0xffff
#define B_BE_BT_LOW_TX_SH 0
#define B_BE_BT_LOW_TX_MSK 0xffff

#define R_BE_RTK_CMD_ERR_RPT 0xDA20
#define R_BE_RTK_CMD_ERR_RPT_C1 0xFA20
#define B_BE_RTK_CMD_CRC BIT(1)
#define B_BE_RTK_CMD_INC BIT(0)

#define R_BE_COEX_WL_REQ 0xDA24
#define R_BE_COEX_WL_REQ_C1 0xFA24
#define B_BE_TX_NULL_HI BIT(23)
#define B_BE_TX_BCN_HI BIT(22)
#define B_BE_TX_NDP_HI BIT(21)
#define B_BE_TX_PROT_HI BIT(20)
#define B_BE_TX_CF_END_HI BIT(19)
#define B_BE_TX_BAR_HI BIT(18)
#define B_BE_TX_TRI_HI BIT(17)
#define B_BE_TX_VOQ_HI BIT(16)
#define B_BE_TX_VIQ_HI BIT(15)
#define B_BE_TX_BEQ_HI BIT(14)
#define B_BE_TX_BKQ_HI BIT(13)
#define B_BE_TX_MGQ_HI BIT(12)
#define B_BE_TX_HIQ_HI BIT(11)
#define B_BE_RSP_ACK_HI BIT(10)
#define B_BE_RSP_CSI_HI BIT(9)
#define B_BE_RSP_BSR_BQR_HI BIT(8)
#define B_BE_PRI_MASK_TX_TIME_SH 3
#define B_BE_PRI_MASK_TX_TIME_MSK 0x3
#define B_BE_PRI_MASK_RX_TIME_V1_SH 1
#define B_BE_PRI_MASK_RX_TIME_V1_MSK 0x3
#define B_BE_WL_RX BIT(0)

#define R_BE_BTC_COEX_SEL 0xDA30
#define R_BE_BTC_COEX_SEL_C1 0xFA30
#define B_BE_COEX_TBL_SEL_SH 0
#define B_BE_COEX_TBL_SEL_MSK 0x3

#define R_BE_BT_COEX_TABLE_0 0xDA34
#define R_BE_BT_COEX_TABLE_0_C1 0xFA34
#define B_BE_BT_COEX_TBL_0_SH 0
#define B_BE_BT_COEX_TBL_0_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_1 0xDA38
#define R_BE_BT_COEX_TABLE_1_C1 0xFA38
#define B_BE_BT_COEX_TBL_1_SH 0
#define B_BE_BT_COEX_TBL_1_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_2 0xDA3C
#define R_BE_BT_COEX_TABLE_2_C1 0xFA3C
#define B_BE_BT_COEX_TBL_2_SH 0
#define B_BE_BT_COEX_TBL_2_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_3 0xDA40
#define R_BE_BT_COEX_TABLE_3_C1 0xFA40
#define B_BE_BT_COEX_TBL_3_SH 0
#define B_BE_BT_COEX_TBL_3_MSK 0xffffffffL

#define R_BE_BT_BREAK_TABLE 0xDA44
#define R_BE_BT_BREAK_TABLE_C1 0xFA44
#define B_BE_BREAK_WL_SH 16
#define B_BE_BREAK_WL_MSK 0xffff
#define B_BE_BREAK_BT_SH 0
#define B_BE_BREAK_BT_MSK 0xffff

#define R_BE_GNT_SW_CTRL 0xDA48
#define R_BE_GNT_SW_CTRL_C1 0xFA48
#define B_BE_WL_ACT2_VAL BIT(21)
#define B_BE_WL_ACT2_SWCTRL BIT(20)
#define B_BE_WL_ACT_VAL BIT(19)
#define B_BE_WL_ACT_SWCTRL BIT(18)
#define B_BE_GNT_BT_RX_VAL BIT(17)
#define B_BE_GNT_BT_RX_SWCTRL BIT(16)
#define B_BE_GNT_BT_TX_VAL BIT(15)
#define B_BE_GNT_BT_TX_SWCTRL BIT(14)
#define B_BE_GNT_WL_RX_VAL BIT(13)
#define B_BE_GNT_WL_RX_SWCTRL BIT(12)
#define B_BE_GNT_WL_TX_VAL BIT(11)
#define B_BE_GNT_WL_TX_SWCTRL BIT(10)
#define B_BE_GNT_BT_RFC_S1_VAL BIT(9)
#define B_BE_GNT_BT_RFC_S1_SWCTRL BIT(8)
#define B_BE_GNT_WL_RFC_S1_VAL BIT(7)
#define B_BE_GNT_WL_RFC_S1_SWCTRL BIT(6)
#define B_BE_GNT_BT_RFC_S0_VAL BIT(5)
#define B_BE_GNT_BT_RFC_S0_SWCTRL BIT(4)
#define B_BE_GNT_WL_RFC_S0_VAL BIT(3)
#define B_BE_GNT_WL_RFC_S0_SWCTRL BIT(2)
#define B_BE_GNT_WL_BB_VAL BIT(1)
#define B_BE_GNT_WL_BB_SWCTRL BIT(0)

#define R_BE_GNT_VAL 0xDA4C
#define R_BE_GNT_VAL_C1 0xFA4C
#define B_BE_WL_ACT2 BIT(10)
#define B_BE_WL_ACT BIT(9)
#define B_BE_GNT_BT_RX BIT(8)
#define B_BE_GNT_BT_TX BIT(7)
#define B_BE_GNT_WL_RX BIT(6)
#define B_BE_GNT_WL_TX BIT(5)
#define B_BE_GNT_BT_RFC_S1 BIT(4)
#define B_BE_GNT_BT_RFC_S0 BIT(3)
#define B_BE_GNT_WL_RFC_S1 BIT(2)
#define B_BE_GNT_WL_RFC_S0 BIT(1)
#define B_BE_GNT_WL_BB BIT(0)

#define R_BE_BTC_CFG_V2 0xDB00
#define R_BE_BTC_CFG_V2_C1 0xFB00

#define R_BE_RTK_MODE_CFG2 0xDB04
#define R_BE_RTK_MODE_CFG2_C1 0xFB04
#define B_BE_BT2_BLE_EN_V1 BIT(24)
#define B_BE_BT2_ULTRA_EN BIT(16)
#define B_BE_BT2_L_RX_ULTRA_SH 14
#define B_BE_BT2_L_RX_ULTRA_MSK 0x3
#define B_BE_BT2_L_TX_ULTRA_SH 12
#define B_BE_BT2_L_TX_ULTRA_MSK 0x3
#define B_BE_BT2_H_RX_ULTRA_SH 10
#define B_BE_BT2_H_RX_ULTRA_MSK 0x3
#define B_BE_BT2_H_TX_ULTRA_SH 8
#define B_BE_BT2_H_TX_ULTRA_MSK 0x3
#define B_BE_SAMPLE_CLK_2_SH 0
#define B_BE_SAMPLE_CLK_2_MSK 0xff

#define R_BE_CSR_MODE_CFG2 0xDB08
#define R_BE_CSR_MODE_CFG2_C1 0xFB08
#define B_BE_BT2_TIME_CNT_SH 16
#define B_BE_BT2_TIME_CNT_MSK 0xff
#define B_BE_CSR_DELAY_2_SH 8
#define B_BE_CSR_DELAY_2_MSK 0xf
#define B_BE_CSR_TRX_2_SH 4
#define B_BE_CSR_TRX_2_MSK 0xf
#define B_BE_CSR_PRI_2_SH 0
#define B_BE_CSR_PRI_2_MSK 0xf

#define R_BE_BT_CNT_CFG2 0xDB10
#define R_BE_BT_CNT_CFG2_C1 0xFB10
#define B_BE_BT2_CNT_RST_V1 BIT(1)
#define B_BE_BT2_CNT_EN BIT(0)

#define R_BE_BT_CNT_HI2 0xDB14
#define R_BE_BT_CNT_HI2_C1 0xFB14
#define B_BE_BT2_HI_RX_SH 16
#define B_BE_BT2_HI_RX_MSK 0xffff
#define B_BE_BT2_HI_TX_SH 0
#define B_BE_BT2_HI_TX_MSK 0xffff

#define R_BE_BT_CNT_LOW2 0xDB18
#define R_BE_BT_CNT_LOW2_C1 0xFB18
#define B_BE_BT2_LOW_RX_SH 16
#define B_BE_BT2_LOW_RX_MSK 0xffff
#define B_BE_BT2_LOW_TX_SH 0
#define B_BE_BT2_LOW_TX_MSK 0xffff

#define R_BE_RTK_CMD_ERR_RPT2 0xDB20
#define R_BE_RTK_CMD_ERR_RPT2_C1 0xFB20
#define B_BE_RTK_CMD_CRC_2 BIT(1)
#define B_BE_RTK_CMD_INC_2 BIT(0)

#define R_BE_BTC_COEX_SEL2 0xDB30
#define R_BE_BTC_COEX_SEL2_C1 0xFB30
#define B_BE_COEX_TBL_SEL_2_SH 0
#define B_BE_COEX_TBL_SEL_2_MSK 0x3

#define R_BE_BT_COEX_TABLE_0_2 0xDB34
#define R_BE_BT_COEX_TABLE_0_2_C1 0xFB34
#define B_BE_BT_COEX_TBL_0_2_SH 0
#define B_BE_BT_COEX_TBL_0_2_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_1_2 0xDB38
#define R_BE_BT_COEX_TABLE_1_2_C1 0xFB38
#define B_BE_BT_COEX_TBL_1_2_SH 0
#define B_BE_BT_COEX_TBL_1_2_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_2_2 0xDB3C
#define R_BE_BT_COEX_TABLE_2_2_C1 0xFB3C
#define B_BE_BT_COEX_TBL_2_2_SH 0
#define B_BE_BT_COEX_TBL_2_2_MSK 0xffffffffL

#define R_BE_BT_COEX_TABLE_3_2 0xDB40
#define R_BE_BT_COEX_TABLE_3_2_C1 0xFB40
#define B_BE_BT_COEX_TBL_3_2_SH 0
#define B_BE_BT_COEX_TBL_3_2_MSK 0xffffffffL

#define R_BE_BT_BREAK_TABLE_2 0xDB44
#define R_BE_BT_BREAK_TABLE_2_C1 0xFB44
#define B_BE_BREAK_WL_2_SH 16
#define B_BE_BREAK_WL_2_MSK 0xffff
#define B_BE_BREAK_BT_2_SH 0
#define B_BE_BREAK_BT_2_MSK 0xffff

//
// WL_BE_Reg_HAXIDMA.xls
//

//
// PCIE
//

#define R_BE_HAXI_INIT_CFG1 0x1000
#define B_BE_CFG_WD_PERIOD_IDLE_SH 28
#define B_BE_CFG_WD_PERIOD_IDLE_MSK 0xf
#define B_BE_CFG_WD_PERIOD_ACTIVE_SH 24
#define B_BE_CFG_WD_PERIOD_ACTIVE_MSK 0xf
#define B_BE_EN_RO_IDX_UPD_BY_IO BIT(19)
#define B_BE_RST_KEEP_REG BIT(18)
#define B_BE_FLUSH_HAXI_MST BIT(17)
#define B_BE_SET_BDRAM_BOUND BIT(16)
#define B_BE_ADDRINFO_ALIGN4B_EN BIT(15)
#define B_BE_RXBD_DONE_MODE_SH 13
#define B_BE_RXBD_DONE_MODE_MSK 0x3
#define B_BE_RXQ_RXBD_MODE_SH 11
#define B_BE_RXQ_RXBD_MODE_MSK 0x3
#define B_BE_DMA_MODE_SH 8
#define B_BE_DMA_MODE_MSK 0x7
#define B_BE_STOP_AXI_MST BIT(7)
#define B_BE_RXDMA_ALIGN64B_EN BIT(6)
#define B_BE_RXDMA_EN BIT(5)
#define B_BE_TXDMA_EN BIT(4)
#define B_BE_MAX_RXDMA_SH 2
#define B_BE_MAX_RXDMA_MSK 0x3
#define B_BE_MAX_TXDMA_SH 0
#define B_BE_MAX_TXDMA_MSK 0x3

#define R_BE_HAXI_DMA_RXQ_APPLEN 0x1004
#define B_BE_RXDMA_EXT_LEN_SH 0
#define B_BE_RXDMA_EXT_LEN_MSK 0x3fff

#define R_BE_HAXI_TRIG_PCIE_L0 0x1008
#define B_BE_AXIDMA_TRIG_PCIEL0_LTR_EN BIT(3)
#define B_BE_AXIDMA_TRIG_PCIEL0_WP_EN BIT(2)
#define B_BE_AXIDMA_TRIG_PCIEL0_RX_EN BIT(1)
#define B_BE_AXIDMA_TRIG_PCIEL0_TX_EN BIT(0)

#define R_BE_HAXI_DMA_STOP1 0x1010
#define B_BE_STOP_WPDMA BIT(31)
#define B_BE_STOP_CH14 BIT(14)
#define B_BE_STOP_CH13 BIT(13)
#define B_BE_STOP_CH12 BIT(12)
#define B_BE_STOP_CH11 BIT(11)
#define B_BE_STOP_CH10 BIT(10)
#define B_BE_STOP_CH9 BIT(9)
#define B_BE_STOP_CH8 BIT(8)
#define B_BE_STOP_CH7 BIT(7)
#define B_BE_STOP_CH6 BIT(6)
#define B_BE_STOP_CH5 BIT(5)
#define B_BE_STOP_CH4 BIT(4)
#define B_BE_STOP_CH3 BIT(3)
#define B_BE_STOP_CH2 BIT(2)
#define B_BE_STOP_CH1 BIT(1)
#define B_BE_STOP_CH0 BIT(0)

#define R_BE_TXBD_RWPTR_CLR1 0x1014
#define B_BE_CLR_CH14_IDX BIT(14)
#define B_BE_CLR_CH13_IDX BIT(13)
#define B_BE_CLR_CH12_IDX BIT(12)
#define B_BE_CLR_CH11_IDX BIT(11)
#define B_BE_CLR_CH10_IDX BIT(10)
#define B_BE_CLR_CH9_IDX BIT(9)
#define B_BE_CLR_CH8_IDX BIT(8)
#define B_BE_CLR_CH7_IDX BIT(7)
#define B_BE_CLR_CH6_IDX BIT(6)
#define B_BE_CLR_CH5_IDX BIT(5)
#define B_BE_CLR_CH4_IDX BIT(4)
#define B_BE_CLR_CH3_IDX BIT(3)
#define B_BE_CLR_CH2_IDX BIT(2)
#define B_BE_CLR_CH1_IDX BIT(1)
#define B_BE_CLR_CH0_IDX BIT(0)

#define R_BE_HAXI_DMA_BUSY1 0x101C
#define B_BE_AXI_MST_BUSY BIT(31)
#define B_BE_NOW_WP BIT(30)
#define B_BE_CH14_BUSY BIT(14)
#define B_BE_CH13_BUSY BIT(13)
#define B_BE_CH12_BUSY BIT(12)
#define B_BE_CH11_BUSY BIT(11)
#define B_BE_CH10_BUSY BIT(10)
#define B_BE_CH9_BUSY BIT(9)
#define B_BE_CH8_BUSY BIT(8)
#define B_BE_CH7_BUSY BIT(7)
#define B_BE_CH6_BUSY BIT(6)
#define B_BE_CH5_BUSY BIT(5)
#define B_BE_CH4_BUSY BIT(4)
#define B_BE_CH3_BUSY BIT(3)
#define B_BE_CH2_BUSY BIT(2)
#define B_BE_CH1_BUSY BIT(1)
#define B_BE_CH0_BUSY BIT(0)

#define R_BE_CH0_TXBD_NUM 0x1024
#define B_BE_TX_FLAG_CH0 BIT(14)
#define B_BE_TX_CH0_NUM_SH 0
#define B_BE_TX_CH0_NUM_MSK 0x3ff

#define R_BE_CH1_TXBD_NUM 0x1026
#define B_BE_TX_FLAG_CH1 BIT(14)
#define B_BE_TX_CH1_NUM_SH 0
#define B_BE_TX_CH1_NUM_MSK 0x3ff

#define R_BE_CH2_TXBD_NUM 0x1028
#define B_BE_TX_FLAG_CH3 BIT(14)
#define B_BE_TX_CH2_NUM_SH 0
#define B_BE_TX_CH2_NUM_MSK 0x3ff

#define R_BE_CH3_TXBD_NUM 0x102A
#define B_BE_TX_CH3_NUM_SH 0
#define B_BE_TX_CH3_NUM_MSK 0x3ff

#define R_BE_CH4_TXBD_NUM 0x102C
#define B_BE_TX_FLAG_CH4 BIT(14)
#define B_BE_TX_CH4_NUM_SH 0
#define B_BE_TX_CH4_NUM_MSK 0x3ff

#define R_BE_CH5_TXBD_NUM 0x102E
#define B_BE_TX_FLAG_CH5 BIT(14)
#define B_BE_TX_CH5_NUM_SH 0
#define B_BE_TX_CH5_NUM_MSK 0x3ff

#define R_BE_CH6_TXBD_NUM 0x1030
#define B_BE_TX_FLAG_CH6 BIT(14)
#define B_BE_TX_CH6_NUM_SH 0
#define B_BE_TX_CH6_NUM_MSK 0x3ff

#define R_BE_CH7_TXBD_NUM 0x1032
#define B_BE_TX_FLAG_CH7 BIT(14)
#define B_BE_TX_CH7_NUM_SH 0
#define B_BE_TX_CH7_NUM_MSK 0x3ff

#define R_BE_CH8_TXBD_NUM 0x1034
#define B_BE_TX_FLAG_CH8 BIT(14)
#define B_BE_TX_CH8_NUM_SH 0
#define B_BE_TX_CH8_NUM_MSK 0x3ff

#define R_BE_CH9_TXBD_NUM 0x1036
#define B_BE_TX_FLAG_CH9 BIT(14)
#define B_BE_TX_CH9_NUM_SH 0
#define B_BE_TX_CH9_NUM_MSK 0x3ff

#define R_BE_CH10_TXBD_NUM 0x1038
#define B_BE_TX_FLAG_CH10 BIT(14)
#define B_BE_TX_CH10_NUM_SH 0
#define B_BE_TX_CH10_NUM_MSK 0x3ff

#define R_BE_CH11_TXBD_NUM 0x103A
#define B_BE_TX_FLAG_CH11 BIT(14)
#define B_BE_TX_CH11_NUM_SH 0
#define B_BE_TX_CH11_NUM_MSK 0x3ff

#define R_BE_CH12_TXBD_NUM 0x103C
#define B_BE_TX_FLAG_CH12 BIT(14)
#define B_BE_TX_CH12_NUM_SH 0
#define B_BE_TX_CH12_NUM_MSK 0x3ff

#define R_BE_CH13_TXBD_NUM 0x1040
#define B_BE_TX_FLAG_CH13 BIT(14)
#define B_BE_TX_CH13_NUM_SH 0
#define B_BE_TX_CH13_NUM_MSK 0x3ff

#define R_BE_CH14_TXBD_NUM 0x1042
#define B_BE_TX_FLAG_CH14 BIT(14)
#define B_BE_TX_CH14_NUM_SH 0
#define B_BE_TX_CH14_NUM_MSK 0x3ff

#define R_BE_CH0_TXBD_IDX 0x1058
#define B_BE_TX_CH0_DMA_IDX_SH 16
#define B_BE_TX_CH0_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH0_CPU_IDX_SH 0
#define B_BE_TX_CH0_CPU_IDX_MSK 0x3ff

#define R_BE_CH1_TXBD_IDX 0x105C
#define B_BE_TX_CH1_DMA_IDX_SH 16
#define B_BE_TX_CH1_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH1_CPU_IDX_SH 0
#define B_BE_TX_CH1_CPU_IDX_MSK 0x3ff

#define R_BE_CH2_TXBD_IDX 0x1060
#define B_BE_TX_CH2_DMA_IDX_SH 16
#define B_BE_TX_CH2_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH2_CPU_IDX_SH 0
#define B_BE_TX_CH2_CPU_IDX_MSK 0x3ff

#define R_BE_CH3_TXBD_IDX 0x1064
#define B_BE_TX_CH3_DMA_IDX_SH 16
#define B_BE_TX_CH3_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH3_CPU_IDX_SH 0
#define B_BE_TX_CH3_CPU_IDX_MSK 0x3ff

#define R_BE_CH4_TXBD_IDX 0x1068
#define B_BE_TX_CH4_DMA_IDX_SH 16
#define B_BE_TX_CH4_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH4_CPU_IDX_SH 0
#define B_BE_TX_CH4_CPU_IDX_MSK 0x3ff

#define R_BE_CH5_TXBD_IDX 0x106C
#define B_BE_TX_CH5_DMA_IDX_SH 16
#define B_BE_TX_CH5_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH5_CPU_IDX_SH 0
#define B_BE_TX_CH5_CPU_IDX_MSK 0x3ff

#define R_BE_CH6_TXBD_IDX 0x1070
#define B_BE_TX_CH6_DMA_IDX_SH 16
#define B_BE_TX_CH6_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH6_CPU_IDX_SH 0
#define B_BE_TX_CH6_CPU_IDX_MSK 0x3ff

#define R_BE_CH7_TXBD_IDX 0x1074
#define B_BE_TX_CH7_DMA_IDX_SH 16
#define B_BE_TX_CH7_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH7_CPU_IDX_SH 0
#define B_BE_TX_CH7_CPU_IDX_MSK 0x3ff

#define R_BE_CH8_TXBD_IDX 0x1078
#define B_BE_TX_CH8_DMA_IDX_SH 16
#define B_BE_TX_CH8_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH8_CPU_IDX_SH 0
#define B_BE_TX_CH8_CPU_IDX_MSK 0x3ff

#define R_BE_CH9_TXBD_IDX 0x107C
#define B_BE_TX_CH9_DMA_IDX_SH 16
#define B_BE_TX_CH9_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH9_CPU_IDX_SH 0
#define B_BE_TX_CH9_CPU_IDX_MSK 0x3ff

#define R_BE_CH10_TXBD_IDX 0x1080
#define B_BE_TX_CH10_DMA_IDX_SH 16
#define B_BE_TX_CH10_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH10_CPU_IDX_SH 0
#define B_BE_TX_CH10_CPU_IDX_MSK 0x3ff

#define R_BE_CH11_TXBD_IDX 0x1084
#define B_BE_TX_CH11_DMA_IDX_SH 16
#define B_BE_TX_CH11_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH11_CPU_IDX_SH 0
#define B_BE_TX_CH11_CPU_IDX_MSK 0x3ff

#define R_BE_CH12_TXBD_IDX 0x1088
#define B_BE_TX_CH12_DMA_IDX_SH 16
#define B_BE_TX_CH12_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH12_CPU_IDX_SH 0
#define B_BE_TX_CH12_CPU_IDX_MSK 0x3ff

#define R_BE_CH13_TXBD_IDX 0x108C
#define B_BE_TX_CH13_DMA_IDX_SH 16
#define B_BE_TX_CH13_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH13_CPU_IDX_SH 0
#define B_BE_TX_CH13_CPU_IDX_MSK 0x3ff

#define R_BE_CH14_TXBD_IDX 0x1090
#define B_BE_TX_CH14_DMA_IDX_SH 16
#define B_BE_TX_CH14_DMA_IDX_MSK 0x3ff
#define B_BE_TX_CH14_CPU_IDX_SH 0
#define B_BE_TX_CH14_CPU_IDX_MSK 0x3ff

#define R_BE_HAXI_HIMR00 0x10B0
#define B_BE_RPQBD_FULL_INT_EN BIT(24)
#define B_BE_RDU_INT_EN BIT(23)
#define B_BE_RXDMA_STUCK_INT_EN BIT(22)
#define B_BE_TXDMA_STUCK_INT_EN BIT(21)
#define B_BE_TXDMA_CH14_INT_EN BIT(20)
#define B_BE_TXDMA_CH13_INT_EN BIT(19)
#define B_BE_TXDMA_CH12_INT_EN BIT(18)
#define B_BE_TXDMA_CH11_INT_EN BIT(17)
#define B_BE_TXDMA_CH10_INT_EN BIT(16)
#define B_BE_TXDMA_CH9_INT_EN BIT(15)
#define B_BE_TXDMA_CH8_INT_EN BIT(14)
#define B_BE_TXDMA_CH7_INT_EN BIT(13)
#define B_BE_TXDMA_CH6_INT_EN BIT(12)
#define B_BE_TXDMA_CH5_INT_EN BIT(11)
#define B_BE_TXDMA_CH4_INT_EN BIT(10)
#define B_BE_TXDMA_CH3_INT_EN BIT(9)
#define B_BE_TXDMA_CH2_INT_EN BIT(8)
#define B_BE_TXDMA_CH1_INT_EN BIT(7)
#define B_BE_TXDMA_CH0_INT_EN BIT(6)
#define B_BE_RPQ1DMA_INT_EN BIT(5)
#define B_BE_RX1P1DMA_INT_EN BIT(4)
#define B_BE_RX1DMA_INT_EN BIT(3)
#define B_BE_RPQ0DMA_INT_EN BIT(2)
#define B_BE_RX0P1DMA_INT_EN BIT(1)
#define B_BE_RX0DMA_INT_EN BIT(0)

#define R_BE_HAXI_HISR00 0x10B4
#define B_BE_RPQBD_FULL_INT BIT(24)
#define B_BE_RDU_INT BIT(23)
#define B_BE_RXDMA_STUCK_INT BIT(22)
#define B_BE_TXDMA_STUCK_INT BIT(21)
#define B_BE_TXDMA_CH14_INT BIT(20)
#define B_BE_TXDMA_CH13_INT BIT(19)
#define B_BE_TXDMA_CH12_INT BIT(18)
#define B_BE_TXDMA_CH11_INT BIT(17)
#define B_BE_TXDMA_CH10_INT BIT(16)
#define B_BE_TXDMA_CH9_INT BIT(15)
#define B_BE_TXDMA_CH8_INT BIT(14)
#define B_BE_TXDMA_CH7_INT BIT(13)
#define B_BE_TXDMA_CH6_INT BIT(12)
#define B_BE_TXDMA_CH5_INT BIT(11)
#define B_BE_TXDMA_CH4_INT BIT(10)
#define B_BE_TXDMA_CH3_INT BIT(9)
#define B_BE_TXDMA_CH2_INT BIT(8)
#define B_BE_TXDMA_CH1_INT BIT(7)
#define B_BE_TXDMA_CH0_INT BIT(6)
#define B_BE_RPQ1DMA_INT BIT(5)
#define B_BE_RX1P1DMA_INT BIT(4)
#define B_BE_RX1DMA_INT BIT(3)
#define B_BE_RPQ0DMA_INT BIT(2)
#define B_BE_RX0P1DMA_INT BIT(1)
#define B_BE_RX0DMA_INT BIT(0)

#define R_BE_HAXI_IDCT_MSK 0x10B8
#define B_BE__TXBD_LEN0_ERR_IDCT_MSK BIT(3)
#define B_BE__TXBD_4KBOUND_ERR_IDCT_MSK BIT(2)
#define B_BE_RXMDA_STUCK_IDCT_MSK BIT(1)
#define B_BE_TXMDA_STUCK_IDCT_MSK BIT(0)

#define R_BE_HAXI_IDCT 0x10BC
#define B_BE__TXBD_LEN0_ERR_IDCT BIT(3)
#define B_BE__TXBD_4KBOUND_ERR_IDCT BIT(2)
#define B_BE_RXMDA_STUCK_IDCT BIT(1)
#define B_BE_TXMDA_STUCK_IDCT BIT(0)

#define R_BE_HAXI_DBG_CTRL 0x1100
#define B_BE_EN_CHKDSC_NO_RX_STUCK BIT(2)
#define B_BE_EN_FIFO_FULL_NO_TX_STUCK BIT(1)
#define B_BE_EN_DBG_STUCK BIT(0)

#define R_BE_DBG_ERR_FLAG 0x1104
#define B_BE_HAXI_MSTR_WDT_TO BIT(11)
#define B_BE_HAXI_ROQ1_FULL BIT(10)
#define B_BE_HAXI_RPQ1_FULL BIT(9)
#define B_BE_HAXI_RXQ1_FULL BIT(8)
#define B_BE_HAXI_ROQ0_FULL BIT(7)
#define B_BE_HAXI_RPQ0_FULL BIT(6)
#define B_BE_HAXI_RXQ0_FULL BIT(5)
#define B_BE_RX_STUCK_V1 BIT(4)
#define B_BE_TX_STUCK_V1 BIT(3)
#define B_BE_HAXI_RXP1_ERR0 BIT(2)
#define B_BE_HAXI_TXBD_LEN0 BIT(1)
#define B_BE_HAXI_TXBD_4KBOUD_LENERR BIT(0)

#define R_BE_HAXI_INFO 0x1108
#define B_BE_RXDMA_IDLE BIT(1)
#define B_BE_TXDMA_IDLE BIT(0)

#define R_BE_HAXI_MST_WDT_TIMEOUT_SEL 0x110C
#define B_BE_AXI_MST_WDT_TIMEOUT_SEL_SH 0
#define B_BE_AXI_MST_WDT_TIMEOUT_SEL_MSK 0x1f

#define R_BE_INT_MIT_TX 0x1180
#define B_BE_TXMIT_CH12_SEL BIT(31)
#define B_BE_TXMIT_CH11_SEL BIT(30)
#define B_BE_TXMIT_CH10_SEL BIT(29)
#define B_BE_TXMIT_CH9_SEL BIT(28)
#define B_BE_TXMIT_CH8_SEL BIT(27)
#define B_BE_TXMIT_ACH7_SEL BIT(26)
#define B_BE_TXMIT_ACH6_SEL BIT(25)
#define B_BE_TXMIT_ACH5_SEL BIT(24)
#define B_BE_TXMIT_ACH4_SEL BIT(23)
#define B_BE_TXMIT_ACH3_SEL BIT(22)
#define B_BE_TXMIT_ACH2_SEL BIT(21)
#define B_BE_TXMIT_ACH1_SEL BIT(20)
#define B_BE_TXMIT_ACH0_SEL BIT(19)
#define B_BE_MIT_TXTIMER_UNIT_SH 16
#define B_BE_MIT_TXTIMER_UNIT_MSK 0x3
#define B_BE_MIT_TXCOUNTER_MATCH_SH 8
#define B_BE_MIT_TXCOUNTER_MATCH_MSK 0xff
#define B_BE_MIT_TXTIMER_MATCH_SH 0
#define B_BE_MIT_TXTIMER_MATCH_MSK 0xff

#define R_BE_INT_MIT_RX 0x1184
#define B_BE_RXMIT_RXQ1P2_SEL BIT(21)
#define B_BE_RXMIT_RXQ1P1_SEL BIT(20)
#define B_BE_RXMIT_RXQ0P2_SEL BIT(19)
#define B_BE_RXMIT_RXQ0P1_SEL BIT(18)
#define B_BE_MIT_RXTIMER_UNIT_SH 16
#define B_BE_MIT_RXTIMER_UNIT_MSK 0x3
#define B_BE_MIT_RXCOUNTER_MATCH_SH 8
#define B_BE_MIT_RXCOUNTER_MATCH_MSK 0xff
#define B_BE_MIT_RXTIMER_MATCH_SH 0
#define B_BE_MIT_RXTIMER_MATCH_MSK 0xff

#define R_BE_RXBD_RWPTR_CLR1 0x1200
#define B_BE_CLR_ROQ1_IDX BIT(6)
#define B_BE_CLR_RPQ1_IDX BIT(5)
#define B_BE_CLR_RXQ1_IDX BIT(4)
#define B_BE_CLR_ROQ0_IDX BIT(2)
#define B_BE_CLR_RPQ0_IDX BIT(1)
#define B_BE_CLR_RXQ0_IDX BIT(0)

#define R_BE_HAXI_EXP_CTRL 0x1204
#define B_BE_R_NO_SEC_ACCESS BIT(31)
#define B_BE_MAX_OUSTD_NUM_SH 0
#define B_BE_MAX_OUSTD_NUM_MSK 0x7

#define R_BE_HAXI_DMA_BUSY2 0x1208
#define B_BE_ROQ1_BUSY BIT(6)
#define B_BE_RPQ1_BUSY BIT(5)
#define B_BE_RXQ1_BUSY BIT(4)
#define B_BE_ROQ0_BUSY BIT(2)
#define B_BE_RPQ0_BUSY BIT(1)
#define B_BE_RXQ0_BUSY BIT(0)

#define R_BE_RXQ0_RXBD_NUM 0x1210
#define B_BE_RXQ0_DESC_NUM_SH 0
#define B_BE_RXQ0_DESC_NUM_MSK 0x3ff

#define R_BE_RPQ0_RXBD_NUM 0x1212
#define B_BE_RPQ0_DESC_NUM_SH 0
#define B_BE_RPQ0_DESC_NUM_MSK 0x3ff

#define R_BE_ROQ0_RXBD_NUM 0x1214
#define B_BE_ROQ0_DESC_NUM_SH 0
#define B_BE_ROQ0_DESC_NUM_MSK 0x3ff

#define R_BE_RXQ1_RXBD_NUM 0x1218
#define B_BE_RXQ1_DESC_NUM_SH 0
#define B_BE_RXQ1_DESC_NUM_MSK 0x3ff

#define R_BE_RPQ1_RXBD_NUM 0x121A
#define B_BE_RPQ1_DESC_NUM_SH 0
#define B_BE_RPQ1_DESC_NUM_MSK 0x3ff

#define R_BE_ROQ1_RXBD_NUM 0x121C
#define B_BE_ROQ1_DESC_NUM_SH 0
#define B_BE_ROQ1_DESC_NUM_MSK 0x3ff

#define R_BE_RXQ0_RXBD_IDX 0x1220
#define B_BE_RX_CH0_DMA_IDX_SH 16
#define B_BE_RX_CH0_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH0_CPU_IDX_SH 0
#define B_BE_RX_CH0_CPU_IDX_MSK 0x3ff

#define R_BE_RPQ0_RXBD_IDX 0x1224
#define B_BE_RX_CH1_DMA_IDX_SH 16
#define B_BE_RX_CH1_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH1_CPU_IDX_SH 0
#define B_BE_RX_CH1_CPU_IDX_MSK 0x3ff

#define R_BE_ROQ0_RXBD_IDX 0x1228
#define B_BE_RX_CH2_DMA_IDX_SH 16
#define B_BE_RX_CH2_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH2_CPU_IDX_SH 0
#define B_BE_RX_CH2_CPU_IDX_MSK 0x3ff

#define R_BE_RXQ1_RXBD_IDX 0x122C
#define B_BE_RX_CH4_DMA_IDX_SH 16
#define B_BE_RX_CH4_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH4_CPU_IDX_SH 0
#define B_BE_RX_CH4_CPU_IDX_MSK 0x3ff

#define R_BE_RPQ1_RXBD_IDX 0x1230
#define B_BE_RX_CH5_DMA_IDX_SH 16
#define B_BE_RX_CH5_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH5_CPU_IDX_SH 0
#define B_BE_RX_CH5_CPU_IDX_MSK 0x3ff

#define R_BE_ROQ1_RXBD_IDX 0x1234
#define B_BE_RX_CH6_DMA_IDX_SH 16
#define B_BE_RX_CH6_DMA_IDX_MSK 0x3ff
#define B_BE_RX_CH6_CPU_IDX_SH 0
#define B_BE_RX_CH6_CPU_IDX_MSK 0x3ff

#define R_BE_RXQ0_RXBD_DESA_L 0x1238
#define B_BE_RX_CH0_DESA_L_SH 0
#define B_BE_RX_CH0_DESA_L_MSK 0xffffffffL

#define R_BE_RXQ0_RXBD_DESA_H 0x123C
#define B_BE_RX_CH0_DESA_H_SH 0
#define B_BE_RX_CH0_DESA_H_MSK 0xff

#define R_BE_RPQ0_RXBD_DESA_L 0x1240
#define B_BE_RX_CH1_DESA_L_SH 0
#define B_BE_RX_CH1_DESA_L_MSK 0xffffffffL

#define R_BE_RPQ0_RXBD_DESA_H 0x1244
#define B_BE_RX_CH1_DESA_H_SH 0
#define B_BE_RX_CH1_DESA_H_MSK 0xff

#define R_BE_ROQ0_RXBD_DESA_L 0x1248
#define B_BE_RX_CH2_DESA_L_SH 0
#define B_BE_RX_CH2_DESA_L_MSK 0xffffffffL

#define R_BE_ROQ0_RXBD_DESA_H 0x124C
#define B_BE_RX_CH2_DESA_H_SH 0
#define B_BE_RX_CH2_DESA_H_MSK 0xff

#define R_BE_RXQ1_RXBD_DESA_L 0x1250
#define B_BE_RX_CH4_DESA_L_SH 0
#define B_BE_RX_CH4_DESA_L_MSK 0xffffffffL

#define R_BE_RXQ1_RXBD_DESA_H 0x1254
#define B_BE_RX_CH4_DESA_H_SH 0
#define B_BE_RX_CH4_DESA_H_MSK 0xff

#define R_BE_RPQ1_RXBD_DESA_L 0x1258
#define B_BE_RX_CH5_DESA_L_SH 0
#define B_BE_RX_CH5_DESA_L_MSK 0xffffffffL

#define R_BE_RPQ1_RXBD_DESA_H 0x125C
#define B_BE_RX_CH5_DESA_H_SH 0
#define B_BE_RX_CH5_DESA_H_MSK 0xff

#define R_BE_ROQ1_RXBD_DESA_L 0x1260
#define B_BE_RX_CH6_DESA_L_SH 0
#define B_BE_RX_CH6_DESA_L_MSK 0xffffffffL

#define R_BE_ROQ1_RXBD_DESA_H 0x1264
#define B_BE_RX_CH6_DESA_H_SH 0
#define B_BE_RX_CH6_DESA_H_MSK 0xff

#define R_BE_CH0_TXBD_DESA_L 0x1268
#define B_BE_TX_CH0_DESA_L_SH 0
#define B_BE_TX_CH0_DESA_L_MSK 0xffffffffL

#define R_BE_CH0_TXBD_DESA_H 0x126C
#define B_BE_TX_CH0_DESA_H_SH 0
#define B_BE_TX_CH0_DESA_H_MSK 0xff

#define R_BE_CH1_TXBD_DESA_L 0x1270
#define B_BE_TX_CH1_DESA_L_SH 0
#define B_BE_TX_CH1_DESA_L_MSK 0xffffffffL

#define R_BE_CH1_TXBD_DESA_H 0x1274
#define B_BE_TX_CH1_DESA_H_SH 0
#define B_BE_TX_CH1_DESA_H_MSK 0xff

#define R_BE_CH2_TXBD_DESA_L 0x1278
#define B_BE_TX_CH2_DESA_L_SH 0
#define B_BE_TX_CH2_DESA_L_MSK 0xffffffffL

#define R_BE_CH2_TXBD_DESA_H 0x127C
#define B_BE_TX_CH2_DESA_H_SH 0
#define B_BE_TX_CH2_DESA_H_MSK 0xff

#define R_BE_CH3_TXBD_DESA_L 0x1280
#define B_BE_TX_CH3_DESA_L_SH 0
#define B_BE_TX_CH3_DESA_L_MSK 0xffffffffL

#define R_BE_CH3_TXBD_DESA_H 0x1284
#define B_BE_TX_CH3_DESA_H_SH 0
#define B_BE_TX_CH3_DESA_H_MSK 0xff

#define R_BE_CH4_TXBD_DESA_L 0x1288
#define B_BE_TX_CH4_DESA_L_SH 0
#define B_BE_TX_CH4_DESA_L_MSK 0xffffffffL

#define R_BE_CH4_TXBD_DESA_H 0x128C
#define B_BE_TX_CH4_DESA_H_SH 0
#define B_BE_TX_CH4_DESA_H_MSK 0xff

#define R_BE_CH5_TXBD_DESA_L 0x1290
#define B_BE_TX_CH5_DESA_L_SH 0
#define B_BE_TX_CH5_DESA_L_MSK 0xffffffffL

#define R_BE_CH5_TXBD_DESA_H 0x1294
#define B_BE_TX_CH5_DESA_H_SH 0
#define B_BE_TX_CH5_DESA_H_MSK 0xff

#define R_BE_CH6_TXBD_DESA_L 0x1298
#define B_BE_TX_CH6_DESA_L_SH 0
#define B_BE_TX_CH6_DESA_L_MSK 0xffffffffL

#define R_BE_CH6_TXBD_DESA_H 0x129C
#define B_BE_TX_CH6_DESA_H_SH 0
#define B_BE_TX_CH6_DESA_H_MSK 0xff

#define R_BE_CH7_TXBD_DESA_L 0x12A0
#define B_BE_TX_CH7_DESA_L_SH 0
#define B_BE_TX_CH7_DESA_L_MSK 0xffffffffL

#define R_BE_CH7_TXBD_DESA_H 0x12A4
#define B_BE_TX_CH7_DESA_H_SH 0
#define B_BE_TX_CH7_DESA_H_MSK 0xff

#define R_BE_CH8_TXBD_DESA_L 0x12A8
#define B_BE_TX_CH8_DESA_L_SH 0
#define B_BE_TX_CH8_DESA_L_MSK 0xffffffffL

#define R_BE_CH8_TXBD_DESA_H 0x12AC
#define B_BE_TX_CH8_DESA_H_SH 0
#define B_BE_TX_CH8_DESA_H_MSK 0xff

#define R_BE_CH9_TXBD_DESA_L 0x12B0
#define B_BE_TX_CH9_DESA_L_SH 0
#define B_BE_TX_CH9_DESA_L_MSK 0xffffffffL

#define R_BE_CH9_TXBD_DESA_H 0x12B4
#define B_BE_TX_CH9_DESA_H_SH 0
#define B_BE_TX_CH9_DESA_H_MSK 0xff

#define R_BE_CH10_TXBD_DESA_L 0x12B8
#define B_BE_TX_CH10_DESA_L_SH 0
#define B_BE_TX_CH10_DESA_L_MSK 0xffffffffL

#define R_BE_CH10_TXBD_DESA_H 0x12BC
#define B_BE_TX_CH10_DESA_H_SH 0
#define B_BE_TX_CH10_DESA_H_MSK 0xff

#define R_BE_CH11_TXBD_DESA_L 0x12C0
#define B_BE_TX_CH11_DESA_L_SH 0
#define B_BE_TX_CH11_DESA_L_MSK 0xffffffffL

#define R_BE_CH11_TXBD_DESA_H 0x12C4
#define B_BE_TX_CH11_DESA_H_SH 0
#define B_BE_TX_CH11_DESA_H_MSK 0xff

#define R_BE_CH12_TXBD_DESA_L 0x12C8
#define B_BE_TX_CH12_DESA_L_SH 0
#define B_BE_TX_CH12_DESA_L_MSK 0xffffffffL

#define R_BE_CH12_TXBD_DESA_H 0x12CC
#define B_BE_TX_CH12_DESA_H_SH 0
#define B_BE_TX_CH12_DESA_H_MSK 0xff

#define R_BE_CH13_TXBD_DESA_L 0x12D0
#define B_BE_TX_CH13_DESA_L_SH 0
#define B_BE_TX_CH13_DESA_L_MSK 0xffffffffL

#define R_BE_CH13_TXBD_DESA_H 0x12D4
#define B_BE_TX_CH13_DESA_H_SH 0
#define B_BE_TX_CH13_DESA_H_MSK 0xff

#define R_BE_CH14_TXBD_DESA_L 0x12D8
#define B_BE_TX_CH14_DESA_L_SH 0
#define B_BE_TX_CH14_DESA_L_MSK 0xffffffffL

#define R_BE_CH14_TXBD_DESA_H 0x12DC
#define B_BE_TX_CH14_DESA_H_SH 0
#define B_BE_TX_CH14_DESA_H_MSK 0xff

#define R_BE_RX_CH0_CH1_CLOSE_TAG 0x12E0
#define B_BE_CH1_RXBUF_CLOSE_TAG_SH 16
#define B_BE_CH1_RXBUF_CLOSE_TAG_MSK 0x1fff
#define B_BE_CH0_RXBUF_CLOSE_TAG_SH 0
#define B_BE_CH0_RXBUF_CLOSE_TAG_MSK 0x1fff

#define R_BE_RX_CH2_CH3_CLOSE_TAG 0x12E4
#define B_BE_CH3_RXBUF_CLOSE_TAG_SH 16
#define B_BE_CH3_RXBUF_CLOSE_TAG_MSK 0x1fff
#define B_BE_CH2_RXBUF_CLOSE_TAG_SH 0
#define B_BE_CH2_RXBUF_CLOSE_TAG_MSK 0x1fff

#define R_BE_BD_ADDR_H 0x12F0
#define B_BE_BD_ADDR_H_SH 8
#define B_BE_BD_ADDR_H_MSK 0xffffff

#define R_BE_WD_ADDR_H 0x12F4
#define B_BE_WD_ADDR_H_SH 8
#define B_BE_WD_ADDR_H_MSK 0xffffff

#define R_BE_WP_ADDR_H 0x12F8
#define B_BE_WP_ADDR_H_SH 8
#define B_BE_WP_ADDR_H_MSK 0xffffff

#define R_BE_RXP1_ADDR_H 0x12FC
#define B_BE_RXP1_ADDR_H_SH 8
#define B_BE_RXP1_ADDR_H_MSK 0xffffff

#define R_BE_RX_ADDR_H 0x1300
#define B_BE_RX_ADDR_H_SH 8
#define B_BE_RX_ADDR_H_MSK 0xffffff

#define R_BE_CH0_BDRAM_CTRL 0x1400
#define B_BE_CH0_BDRAM_MIN_SH 16
#define B_BE_CH0_BDRAM_MIN_MSK 0x3f
#define B_BE_CH0_BDRAM_NUM_SH 8
#define B_BE_CH0_BDRAM_NUM_MSK 0x3f
#define B_BE_CH0_BDRAM_SIDX_SH 0
#define B_BE_CH0_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH1_BDRAM_CTRL 0x1404
#define B_BE_CH1_BDRAM_MIN_SH 16
#define B_BE_CH1_BDRAM_MIN_MSK 0x3f
#define B_BE_CH1_BDRAM_NUM_SH 8
#define B_BE_CH1_BDRAM_NUM_MSK 0x3f
#define B_BE_CH1_BDRAM_SIDX_SH 0
#define B_BE_CH1_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH2_BDRAM_CTRL 0x1408
#define B_BE_CH2_BDRAM_MIN_SH 16
#define B_BE_CH2_BDRAM_MIN_MSK 0x3f
#define B_BE_CH2_BDRAM_NUM_SH 8
#define B_BE_CH2_BDRAM_NUM_MSK 0x3f
#define B_BE_CH2_BDRAM_SIDX_SH 0
#define B_BE_CH2_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH3_BDRAM_CTRL 0x140C
#define B_BE_CH3_BDRAM_MIN_SH 16
#define B_BE_CH3_BDRAM_MIN_MSK 0x3f
#define B_BE_CH3_BDRAM_NUM_SH 8
#define B_BE_CH3_BDRAM_NUM_MSK 0x3f
#define B_BE_CH3_BDRAM_SIDX_SH 0
#define B_BE_CH3_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH4_BDRAM_CTRL 0x1410
#define B_BE_CH4_BDRAM_MIN_SH 16
#define B_BE_CH4_BDRAM_MIN_MSK 0x3f
#define B_BE_CH4_BDRAM_NUM_SH 8
#define B_BE_CH4_BDRAM_NUM_MSK 0x3f
#define B_BE_CH4_BDRAM_SIDX_SH 0
#define B_BE_CH4_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH5_BDRAM_CTRL 0x1414
#define B_BE_CH5_BDRAM_MIN_SH 16
#define B_BE_CH5_BDRAM_MIN_MSK 0x3f
#define B_BE_CH5_BDRAM_NUM_SH 8
#define B_BE_CH5_BDRAM_NUM_MSK 0x3f
#define B_BE_CH5_BDRAM_SIDX_SH 0
#define B_BE_CH5_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH6_BDRAM_CTRL 0x1418
#define B_BE_CH6_BDRAM_MIN_SH 16
#define B_BE_CH6_BDRAM_MIN_MSK 0x3f
#define B_BE_CH6_BDRAM_NUM_SH 8
#define B_BE_CH6_BDRAM_NUM_MSK 0x3f
#define B_BE_CH6_BDRAM_SIDX_SH 0
#define B_BE_CH6_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH7_BDRAM_CTRL 0x141C
#define B_BE_CH7_BDRAM_MIN_SH 16
#define B_BE_CH7_BDRAM_MIN_MSK 0x3f
#define B_BE_CH7_BDRAM_NUM_SH 8
#define B_BE_CH7_BDRAM_NUM_MSK 0x3f
#define B_BE_CH7_BDRAM_SIDX_SH 0
#define B_BE_CH7_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH8_BDRAM_CTRL 0x1420
#define B_BE_CH8_BDRAM_MIN_SH 16
#define B_BE_CH8_BDRAM_MIN_MSK 0x3f
#define B_BE_CH8_BDRAM_NUM_SH 8
#define B_BE_CH8_BDRAM_NUM_MSK 0x3f
#define B_BE_CH8_BDRAM_SIDX_SH 0
#define B_BE_CH8_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH9_BDRAM_CTRL 0x1424
#define B_BE_CH9_BDRAM_MIN_SH 16
#define B_BE_CH9_BDRAM_MIN_MSK 0x3f
#define B_BE_CH9_BDRAM_NUM_SH 8
#define B_BE_CH9_BDRAM_NUM_MSK 0x3f
#define B_BE_CH9_BDRAM_SIDX_SH 0
#define B_BE_CH9_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH10_BDRAM_CTRL 0x1428
#define B_BE_CH10_BDRAM_MIN_SH 16
#define B_BE_CH10_BDRAM_MIN_MSK 0x3f
#define B_BE_CH10_BDRAM_NUM_SH 8
#define B_BE_CH10_BDRAM_NUM_MSK 0x3f
#define B_BE_CH10_BDRAM_SIDX_SH 0
#define B_BE_CH10_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH11_BDRAM_CTRL 0x142C
#define B_BE_CH11_BDRAM_MIN_SH 16
#define B_BE_CH11_BDRAM_MIN_MSK 0x3f
#define B_BE_CH11_BDRAM_NUM_SH 8
#define B_BE_CH11_BDRAM_NUM_MSK 0x3f
#define B_BE_CH11_BDRAM_SIDX_SH 0
#define B_BE_CH11_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH12_BDRAM_CTRL 0x1430
#define B_BE_CH12_BDRAM_MIN_SH 16
#define B_BE_CH12_BDRAM_MIN_MSK 0x3f
#define B_BE_CH12_BDRAM_NUM_SH 8
#define B_BE_CH12_BDRAM_NUM_MSK 0x3f
#define B_BE_CH12_BDRAM_SIDX_SH 0
#define B_BE_CH12_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH13_BDRAM_CTRL 0x1434
#define B_BE_CH13_BDRAM_MIN_SH 16
#define B_BE_CH13_BDRAM_MIN_MSK 0x3f
#define B_BE_CH13_BDRAM_NUM_SH 8
#define B_BE_CH13_BDRAM_NUM_MSK 0x3f
#define B_BE_CH13_BDRAM_SIDX_SH 0
#define B_BE_CH13_BDRAM_SIDX_MSK 0x3f

#define R_BE_CH14_BDRAM_CTRL 0x1438
#define B_BE_CH14_BDRAM_MIN_SH 16
#define B_BE_CH14_BDRAM_MIN_MSK 0x3f
#define B_BE_CH14_BDRAM_NUM_SH 8
#define B_BE_CH14_BDRAM_NUM_MSK 0x3f
#define B_BE_CH14_BDRAM_SIDX_SH 0
#define B_BE_CH14_BDRAM_SIDX_MSK 0x3f

#define R_BE_SEL_BDRAM_RWPTR 0x143C
#define B_BE_SEL_BDRAM_PTR_CH_SH 16
#define B_BE_SEL_BDRAM_PTR_CH_MSK 0xf
#define B_BE_SEL_BDRAM_WPTR_SH 8
#define B_BE_SEL_BDRAM_WPTR_MSK 0x3f
#define B_BE_SEL_BDRAM_RPTR_SH 0
#define B_BE_SEL_BDRAM_RPTR_MSK 0x3f

#define R_BE_WP_ADDR_H_SEL0_3 0x1440
#define B_BE_WP_ADDR_H_SEL3_SH 24
#define B_BE_WP_ADDR_H_SEL3_MSK 0xff
#define B_BE_WP_ADDR_H_SEL2_SH 16
#define B_BE_WP_ADDR_H_SEL2_MSK 0xff
#define B_BE_WP_ADDR_H_SEL1_SH 8
#define B_BE_WP_ADDR_H_SEL1_MSK 0xff
#define B_BE_WP_ADDR_H_SEL0_SH 0
#define B_BE_WP_ADDR_H_SEL0_MSK 0xff

#define R_BE_WP_ADDR_H_SEL4_7 0x1444
#define B_BE_WP_ADDR_H_SEL7_SH 24
#define B_BE_WP_ADDR_H_SEL7_MSK 0xff
#define B_BE_WP_ADDR_H_SEL6_SH 16
#define B_BE_WP_ADDR_H_SEL6_MSK 0xff
#define B_BE_WP_ADDR_H_SEL5_SH 8
#define B_BE_WP_ADDR_H_SEL5_MSK 0xff
#define B_BE_WP_ADDR_H_SEL4_SH 0
#define B_BE_WP_ADDR_H_SEL4_MSK 0xff

#define R_BE_WP_ADDR_H_SEL8_11 0x1448
#define B_BE_WP_ADDR_H_SEL11_SH 24
#define B_BE_WP_ADDR_H_SEL11_MSK 0xff
#define B_BE_WP_ADDR_H_SEL10_SH 16
#define B_BE_WP_ADDR_H_SEL10_MSK 0xff
#define B_BE_WP_ADDR_H_SEL9_SH 8
#define B_BE_WP_ADDR_H_SEL9_MSK 0xff
#define B_BE_WP_ADDR_H_SEL8_SH 0
#define B_BE_WP_ADDR_H_SEL8_MSK 0xff

#define R_BE_WP_ADDR_H_SEL12_15 0x144C
#define B_BE_WP_ADDR_H_SEL15_SH 24
#define B_BE_WP_ADDR_H_SEL15_MSK 0xff
#define B_BE_WP_ADDR_H_SEL14_SH 16
#define B_BE_WP_ADDR_H_SEL14_MSK 0xff
#define B_BE_WP_ADDR_H_SEL13_SH 8
#define B_BE_WP_ADDR_H_SEL13_MSK 0xff
#define B_BE_WP_ADDR_H_SEL12_SH 0
#define B_BE_WP_ADDR_H_SEL12_MSK 0xff

#define R_BE_WR_TXBD_DATA 0x1500
#define B_BE_WRITE_TXBD_DATA_SH 0
#define B_BE_WRITE_TXBD_DATA_MSK 0xffffffffL

#define R_BE_WR_PRECOST_REQ 0x1504
#define B_BE_REQ_CH_PG_SH 0
#define B_BE_REQ_CH_PG_MSK 0x1fff

#define R_BE_LTR_DECISION_CTRL 0x1600
#define B_BE_LAT_LTR_IDX_DRV_VLD BIT(16)
#define B_BE_LAT_LTR_IDX_DRV_SH 14
#define B_BE_LAT_LTR_IDX_DRV_MSK 0x3
#define B_BE_LAT_LTR_IDX_FW_VLD BIT(13)
#define B_BE_LAT_LTR_IDX_FW_SH 11
#define B_BE_LAT_LTR_IDX_FW_MSK 0x3
#define B_BE_LAT_LTR_IDX_HW_VLD BIT(10)
#define B_BE_LAT_LTR_IDX_HW_SH 8
#define B_BE_LAT_LTR_IDX_HW_MSK 0x3
#define B_BE_LTR_REQ_DRV BIT(7)
#define B_BE_LTR_IDX_DRV_SH 5
#define B_BE_LTR_IDX_DRV_MSK 0x3
#define B_BE_LTR_EN_PORT_SH 2
#define B_BE_LTR_EN_PORT_MSK 0x7
#define B_BE_LTR_SPACE_IDX_SH 0
#define B_BE_LTR_SPACE_IDX_MSK 0x3

#define R_BE_LTR_LATENCY_IDX0 0x1604
#define B_BE_LTR_LATENCY_IDX0_SH 0
#define B_BE_LTR_LATENCY_IDX0_MSK 0xffffffffL

#define R_BE_LTR_LATENCY_IDX1 0x1608
#define B_BE_LTR_LATENCY_IDX1_SH 0
#define B_BE_LTR_LATENCY_IDX1_MSK 0xffffffffL

#define R_BE_LTR_LATENCY_IDX2 0x160C
#define B_BE_LTR_LATENCY_IDX2_SH 0
#define B_BE_LTR_LATENCY_IDX2_MSK 0xffffffffL

#define R_BE_LTR_LATENCY_IDX3 0x1610
#define B_BE_LTR_LATENCY_IDX3_SH 0
#define B_BE_LTR_LATENCY_IDX3_MSK 0xffffffffL

#define R_BE_CURRENT_LTR_LATENCY 0x1614
#define B_BE_CUR_LTR_LATENCY_SH 0
#define B_BE_CUR_LTR_LATENCY_MSK 0xffffffffL

#define R_BE_HCI_FC_CTRL 0x1700
#define B_BE_HCI_FC_CH12_FULL_COND_SH 10
#define B_BE_HCI_FC_CH12_FULL_COND_MSK 0x3
#define B_BE_HCI_FC_WP_CH811_FULL_COND_SH 8
#define B_BE_HCI_FC_WP_CH811_FULL_COND_MSK 0x3
#define B_BE_HCI_FC_WP_CH07_FULL_COND_SH 6
#define B_BE_HCI_FC_WP_CH07_FULL_COND_MSK 0x3
#define B_BE_HCI_FC_WD_FULL_COND_SH 4
#define B_BE_HCI_FC_WD_FULL_COND_MSK 0x3
#define B_BE_HCI_FC_CH12_EN BIT(3)
#define B_BE_HCI_FC_MODE_SH 1
#define B_BE_HCI_FC_MODE_MSK 0x3
#define B_BE_HCI_FC_EN BIT(0)

#define R_BE_CH_PAGE_CTRL 0x1704
#define B_BE_PREC_PAGE_CH12_SH 16
#define B_BE_PREC_PAGE_CH12_MSK 0x1ff
#define B_BE_PREC_PAGE_CH011_SH 0
#define B_BE_PREC_PAGE_CH011_MSK 0x1ff

#define R_BE_CH_PAGE_CTRL2 0x1708
#define B_BE_PREC_WD_PAGE_CH13_SH 0
#define B_BE_PREC_WD_PAGE_CH13_MSK 0x1ff

#define R_BE_CH_PAGE_CTRL3 0x170C
#define B_BE_PREC_WP_PAGE_CH14_SH 16
#define B_BE_PREC_WP_PAGE_CH14_MSK 0x1ff
#define B_BE_PREC_WP_PAGE_CH07_13_SH 0
#define B_BE_PREC_WP_PAGE_CH07_13_MSK 0x1ff

#define R_BE_ACH011_INTRPT_STAT 0x1710
#define B_BE_CH11_INTRPT_STAT BIT(11)
#define B_BE_CH10_INTRPT_STAT BIT(10)
#define B_BE_CH9_INTRPT_STAT BIT(9)
#define B_BE_CH8_INTRPT_STAT BIT(8)
#define B_BE_CH7_INTRPT_STAT BIT(7)
#define B_BE_CH6_INTRPT_STAT BIT(6)
#define B_BE_CH5_INTRPT_STAT BIT(5)
#define B_BE_CH4_INTRPT_STAT BIT(4)
#define B_BE_CH3_INTRPT_STAT BIT(3)
#define B_BE_CH2_INTRPT_STAT BIT(2)
#define B_BE_CH1_INTRPT_STAT BIT(1)
#define B_BE_CH0_INTRPT_STAT BIT(0)

#define R_BE_HCI_FC_ERR_FLAG 0x1714
#define B_BE_PUB_AVAL_PG_UFW BIT(3)
#define B_BE_PUB_USE_PG_UFW BIT(2)
#define B_BE_CH011_USE_PG_UFW BIT(1)
#define B_BE_CH011_AVAL_PG_UFW BIT(0)

#define R_BE_CH0_PAGE_CTRL 0x1718
#define B_BE_CH0_GRP BIT(31)
#define B_BE_CH0_MAX_PG_SH 16
#define B_BE_CH0_MAX_PG_MSK 0x1fff
#define B_BE_CH0_MIN_PG_SH 0
#define B_BE_CH0_MIN_PG_MSK 0x1fff

#define R_BE_CH1_PAGE_CTRL 0x171C
#define B_BE_CH1_GRP BIT(31)
#define B_BE_CH1_MAX_PG_SH 16
#define B_BE_CH1_MAX_PG_MSK 0x1fff
#define B_BE_CH1_MIN_PG_SH 0
#define B_BE_CH1_MIN_PG_MSK 0x1fff

#define R_BE_CH2_PAGE_CTRL 0x1720
#define B_BE_CH2_GRP BIT(31)
#define B_BE_CH2_MAX_PG_SH 16
#define B_BE_CH2_MAX_PG_MSK 0x1fff
#define B_BE_CH2_MIN_PG_SH 0
#define B_BE_CH2_MIN_PG_MSK 0x1fff

#define R_BE_CH3_PAGE_CTRL 0x1724
#define B_BE_CH3_GRP BIT(31)
#define B_BE_CH3_MAX_PG_SH 16
#define B_BE_CH3_MAX_PG_MSK 0x1fff
#define B_BE_CH3_MIN_PG_SH 0
#define B_BE_CH3_MIN_PG_MSK 0x1fff

#define R_BE_CH4_PAGE_CTRL 0x1728
#define B_BE_CH4_GRP BIT(31)
#define B_BE_CH4_MAX_PG_SH 16
#define B_BE_CH4_MAX_PG_MSK 0x1fff
#define B_BE_CH4_MIN_PG_SH 0
#define B_BE_CH4_MIN_PG_MSK 0x1fff

#define R_BE_CH5_PAGE_CTRL 0x172C
#define B_BE_CH5_GRP BIT(31)
#define B_BE_CH5_MAX_PG_SH 16
#define B_BE_CH5_MAX_PG_MSK 0x1fff
#define B_BE_CH5_MIN_PG_SH 0
#define B_BE_CH5_MIN_PG_MSK 0x1fff

#define R_BE_CH6_PAGE_CTRL 0x1730
#define B_BE_CH6_GRP BIT(31)
#define B_BE_CH6_MAX_PG_SH 16
#define B_BE_CH6_MAX_PG_MSK 0x1fff
#define B_BE_CH6_MIN_PG_SH 0
#define B_BE_CH6_MIN_PG_MSK 0x1fff

#define R_BE_CH7_PAGE_CTRL 0x1734
#define B_BE_CH7_GRP BIT(31)
#define B_BE_CH7_MAX_PG_SH 16
#define B_BE_CH7_MAX_PG_MSK 0x1fff
#define B_BE_CH7_MIN_PG_SH 0
#define B_BE_CH7_MIN_PG_MSK 0x1fff

#define R_BE_CH8_PAGE_CTRL 0x1738
#define B_BE_CH8_GRP BIT(31)
#define B_BE_CH8_MAX_PG_SH 16
#define B_BE_CH8_MAX_PG_MSK 0x1fff
#define B_BE_CH8_MIN_PG_SH 0
#define B_BE_CH8_MIN_PG_MSK 0x1fff

#define R_BE_CH9_PAGE_CTRL 0x173C
#define B_BE_CH9_GRP BIT(31)
#define B_BE_CH9_MAX_PG_SH 16
#define B_BE_CH9_MAX_PG_MSK 0x1fff
#define B_BE_CH9_MIN_PG_SH 0
#define B_BE_CH9_MIN_PG_MSK 0x1fff

#define R_BE_CH10_PAGE_CTRL 0x1740
#define B_BE_CH10_GRP BIT(31)
#define B_BE_CH10_MAX_PG_SH 16
#define B_BE_CH10_MAX_PG_MSK 0x1fff
#define B_BE_CH10_MIN_PG_SH 0
#define B_BE_CH10_MIN_PG_MSK 0x1fff

#define R_BE_CH11_PAGE_CTRL 0x1744
#define B_BE_CH11_GRP BIT(31)
#define B_BE_CH11_MAX_PG_SH 16
#define B_BE_CH11_MAX_PG_MSK 0x1fff
#define B_BE_CH11_MIN_PG_SH 0
#define B_BE_CH11_MIN_PG_MSK 0x1fff

#define R_BE_CH13_PAGE_CTRL 0x1748
#define B_BE_CH13_GRP BIT(31)
#define B_BE_CH13_MAX_PG_SH 16
#define B_BE_CH13_MAX_PG_MSK 0x1fff
#define B_BE_CH13_MIN_PG_SH 0
#define B_BE_CH13_MIN_PG_MSK 0x1fff

#define R_BE_CH0_PAGE_INFO 0x1750
#define B_BE_CH0_AVAL_PG_SH 16
#define B_BE_CH0_AVAL_PG_MSK 0x1fff
#define B_BE_CH0_USE_PG_SH 0
#define B_BE_CH0_USE_PG_MSK 0x1fff

#define R_BE_CH1_PAGE_INFO 0x1754
#define B_BE_CH1_AVAL_PG_SH 16
#define B_BE_CH1_AVAL_PG_MSK 0x1fff
#define B_BE_CH1_USE_PG_SH 0
#define B_BE_CH1_USE_PG_MSK 0x1fff

#define R_BE_CH2_PAGE_INFO 0x1758
#define B_BE_CH2_AVAL_PG_SH 16
#define B_BE_CH2_AVAL_PG_MSK 0x1fff
#define B_BE_CH2_USE_PG_SH 0
#define B_BE_CH2_USE_PG_MSK 0x1fff

#define R_BE_CH3_PAGE_INFO 0x175C
#define B_BE_CH3_AVAL_PG_SH 16
#define B_BE_CH3_AVAL_PG_MSK 0x1fff
#define B_BE_CH3_USE_PG_SH 0
#define B_BE_CH3_USE_PG_MSK 0x1fff

#define R_BE_CH4_PAGE_INFO 0x1760
#define B_BE_CH4_AVAL_PG_SH 16
#define B_BE_CH4_AVAL_PG_MSK 0x1fff
#define B_BE_CH4_USE_PG_SH 0
#define B_BE_CH4_USE_PG_MSK 0x1fff

#define R_BE_CH5_PAGE_INFO 0x1764
#define B_BE_CH5_AVAL_PG_SH 16
#define B_BE_CH5_AVAL_PG_MSK 0x1fff
#define B_BE_CH5_USE_PG_SH 0
#define B_BE_CH5_USE_PG_MSK 0x1fff

#define R_BE_CH6_PAGE_INFO 0x1768
#define B_BE_CH6_AVAL_PG_SH 16
#define B_BE_CH6_AVAL_PG_MSK 0x1fff
#define B_BE_CH6_USE_PG_SH 0
#define B_BE_CH6_USE_PG_MSK 0x1fff

#define R_BE_CH7_PAGE_INFO 0x176C
#define B_BE_CH7_AVAL_PG_SH 16
#define B_BE_CH7_AVAL_PG_MSK 0x1fff
#define B_BE_CH7_USE_PG_SH 0
#define B_BE_CH7_USE_PG_MSK 0x1fff

#define R_BE_CH8_PAGE_INFO 0x1770
#define B_BE_CH8_AVAL_PG_SH 16
#define B_BE_CH8_AVAL_PG_MSK 0x1fff
#define B_BE_CH8_USE_PG_SH 0
#define B_BE_CH8_USE_PG_MSK 0x1fff

#define R_BE_CH9_PAGE_INFO 0x1774
#define B_BE_CH9_AVAL_PG_SH 16
#define B_BE_CH9_AVAL_PG_MSK 0x1fff
#define B_BE_CH9_USE_PG_SH 0
#define B_BE_CH9_USE_PG_MSK 0x1fff

#define R_BE_CH10_PAGE_INFO 0x1778
#define B_BE_CH10_AVAL_PG_SH 16
#define B_BE_CH10_AVAL_PG_MSK 0x1fff
#define B_BE_CH10_USE_PG_SH 0
#define B_BE_CH10_USE_PG_MSK 0x1fff

#define R_BE_CH11_PAGE_INFO 0x177C
#define B_BE_CH11_AVAL_PG_SH 16
#define B_BE_CH11_AVAL_PG_MSK 0x1fff
#define B_BE_CH11_USE_PG_SH 0
#define B_BE_CH11_USE_PG_MSK 0x1fff

#define R_BE_CH12_PAGE_INFO 0x1780
#define B_BE_CH12_AVAL_PG_SH 16
#define B_BE_CH12_AVAL_PG_MSK 0x1fff

#define R_BE_CH13_PAGE_INFO 0x1784
#define B_BE_CH13_AVAL_PG_SH 16
#define B_BE_CH13_AVAL_PG_MSK 0x1fff
#define B_BE_CH13_USE_PG_SH 0
#define B_BE_CH13_USE_PG_MSK 0x1fff

#define R_BE_H2D_TMP_PAGE_INFO 0x1788
#define B_BE_H2DCMD_AVAL_PG_SH 16
#define B_BE_H2DCMD_AVAL_PG_MSK 0x1fff
#define B_BE_H2DTWD_AVAL_PG_SH 0
#define B_BE_H2DTWD_AVAL_PG_MSK 0x1fff

#define R_BE_PUB_PAGE_INFO3 0x178C
#define B_BE_G1_AVAL_PG_SH 16
#define B_BE_G1_AVAL_PG_MSK 0x1fff
#define B_BE_G0_AVAL_PG_SH 0
#define B_BE_G0_AVAL_PG_MSK 0x1fff

#define R_BE_PUB_PAGE_CTRL1 0x1790
#define B_BE_PUBPG_G1_SH 16
#define B_BE_PUBPG_G1_MSK 0x1fff
#define B_BE_PUBPG_G0_SH 0
#define B_BE_PUBPG_G0_MSK 0x1fff

#define R_BE_PUB_PAGE_CTRL2 0x1794
#define B_BE_PUBPG_ALL_SH 0
#define B_BE_PUBPG_ALL_MSK 0x1fff

#define R_BE_PUB_PAGE_CTRL3 0x1798
#define B_BE_H2DCMD_PLE_PG_SH 16
#define B_BE_H2DCMD_PLE_PG_MSK 0x1fff
#define B_BE_H2DTWD_PLE_PG_SH 0
#define B_BE_H2DTWD_PLE_PG_MSK 0x1fff

#define R_BE_PUB_PAGE_INFO1 0x179C
#define B_BE_G1_USE_PG_SH 16
#define B_BE_G1_USE_PG_MSK 0x1fff
#define B_BE_G0_USE_PG_SH 0
#define B_BE_G0_USE_PG_MSK 0x1fff

#define R_BE_PUB_PAGE_INFO2 0x17A0
#define B_BE_PUB_AVAL_PG_SH 0
#define B_BE_PUB_AVAL_PG_MSK 0x1fff

#define R_BE_WP_PAGE_CTRL1 0x17A4
#define B_BE_PREC_PAGE_WP_CH811_SH 16
#define B_BE_PREC_PAGE_WP_CH811_MSK 0x1ff
#define B_BE_PREC_PAGE_WP_CH07_SH 0
#define B_BE_PREC_PAGE_WP_CH07_MSK 0x1ff

#define R_BE_WP_PAGE_CTRL2 0x17A8
#define B_BE_WP_THRD_SH 0
#define B_BE_WP_THRD_MSK 0x1fff

#define R_BE_WP_PAGE_INFO1 0x17AC
#define B_BE_WP_AVAL_PG_SH 16
#define B_BE_WP_AVAL_PG_MSK 0x1fff

#define R_BE_CH0_THR 0x17B0
#define B_BE_CH0_INTRPT_EN BIT(31)
#define B_BE_CH0_THR_WP_SH 16
#define B_BE_CH0_THR_WP_MSK 0x1fff
#define B_BE_CH0_THR_WD_SH 0
#define B_BE_CH0_THR_WD_MSK 0x1fff

#define R_BE_CH1_THR 0x17B4
#define B_BE_CH1_INTRPT_EN BIT(31)
#define B_BE_CH1_THR_WP_SH 16
#define B_BE_CH1_THR_WP_MSK 0x1fff
#define B_BE_CH1_THR_WD_SH 0
#define B_BE_CH1_THR_WD_MSK 0x1fff

#define R_BE_CH2_THR 0x17B8
#define B_BE_CH2_INTRPT_EN BIT(31)
#define B_BE_CH2_THR_WP_SH 16
#define B_BE_CH2_THR_WP_MSK 0x1fff
#define B_BE_CH2_THR_WD_SH 0
#define B_BE_CH2_THR_WD_MSK 0x1fff

#define R_BE_CH3_THR 0x17BC
#define B_BE_CH3_INTRPT_EN BIT(31)
#define B_BE_CH3_THR_WP_SH 16
#define B_BE_CH3_THR_WP_MSK 0x1fff
#define B_BE_CH3_THR_WD_SH 0
#define B_BE_CH3_THR_WD_MSK 0x1fff

#define R_BE_CH4_THR 0x17C0
#define B_BE_CH4_INTRPT_EN BIT(31)
#define B_BE_CH4_THR_WP_SH 16
#define B_BE_CH4_THR_WP_MSK 0x1fff
#define B_BE_CH4_THR_WD_SH 0
#define B_BE_CH4_THR_WD_MSK 0x1fff

#define R_BE_CH5_THR 0x17C4
#define B_BE_CH5_INTRPT_EN BIT(31)
#define B_BE_CH5_THR_WP_SH 16
#define B_BE_CH5_THR_WP_MSK 0x1fff
#define B_BE_CH5_THR_WD_SH 0
#define B_BE_CH5_THR_WD_MSK 0x1fff

#define R_BE_CH6_THR 0x17C8
#define B_BE_CH6_INTRPT_EN BIT(31)
#define B_BE_CH6_THR_WP_SH 16
#define B_BE_CH6_THR_WP_MSK 0x1fff
#define B_BE_CH6_THR_WD_SH 0
#define B_BE_CH6_THR_WD_MSK 0x1fff

#define R_BE_CH7_THR 0x17CC
#define B_BE_CH7_INTRPT_EN BIT(31)
#define B_BE_CH7_THR_WP_SH 16
#define B_BE_CH7_THR_WP_MSK 0x1fff
#define B_BE_CH7_THR_WD_SH 0
#define B_BE_CH7_THR_WD_MSK 0x1fff

#define R_BE_CH8_THR 0x17D0
#define B_BE_CH8_INTRPT_EN BIT(31)
#define B_BE_CH8_THR_WP_SH 16
#define B_BE_CH8_THR_WP_MSK 0x1fff
#define B_BE_CH8_THR_WD_SH 0
#define B_BE_CH8_THR_WD_MSK 0x1fff

#define R_BE_CH9_THR 0x17D4
#define B_BE_CH9_INTRPT_EN BIT(31)
#define B_BE_CH9_THR_WP_SH 16
#define B_BE_CH9_THR_WP_MSK 0x1fff
#define B_BE_CH9_THR_WD_SH 0
#define B_BE_CH9_THR_WD_MSK 0x1fff

#define R_BE_CH10_THR 0x17D8
#define B_BE_CH10_INTRPT_EN BIT(31)
#define B_BE_CH10_THR_WP_SH 16
#define B_BE_CH10_THR_WP_MSK 0x1fff
#define B_BE_CH10_THR_WD_SH 0
#define B_BE_CH10_THR_WD_MSK 0x1fff

#define R_BE_CH11_THR 0x17DC
#define B_BE_CH11_INTRPT_EN BIT(31)
#define B_BE_CH11_THR_WP_SH 16
#define B_BE_CH11_THR_WP_MSK 0x1fff
#define B_BE_CH11_THR_WD_SH 0
#define B_BE_CH11_THR_WD_MSK 0x1fff

#endif
