/******************************************************************************
 *
 * Copyright(c) 2007 - 2022 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/

#define RTW_MODULE_RTL8821AE_HMC_M2		BIT0	/* RTL8821AE(HMC + M.2) */
#define RTW_MODULE_RTL8821AU			BIT1	/* RTL8821AU */
#define RTW_MODULE_RTL8812AENF_NGFF		BIT2	/* RTL8812AENF(8812AE+8761)_NGFF */
#define RTW_MODULE_RTL8812AEBT_HMC		BIT3	/* RTL8812AEBT(8812AE+8761)_HMC */
#define RTW_MODULE_RTL8188EE_HMC_M2		BIT4	/* RTL8188EE(HMC + M.2) */
#define RTW_MODULE_RTL8723BE_HMC_M2		BIT5	/* RTL8723BE(HMC + M.2) */
#define RTW_MODULE_RTL8723BS_NGFF1216	BIT6	/* RTL8723BS(NGFF1216) */
#define RTW_MODULE_RTL8192EEBT_HMC_M2	BIT7	/* RTL8192EEBT(8192EE+8761AU)_(HMC + M.2) */
#define RTW_MODULE_RTL8723DE_NGFF1630	BIT8	/* RTL8723DE(NGFF1630) */
#define RTW_MODULE_RTL8822BE			BIT9	/* RTL8822BE */
#define RTW_MODULE_RTL8821CE			BIT10	/* RTL8821CE */
#define RTW_MODULE_RTL8822CE			BIT11	/* RTL8822CE */

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8821AE_HMC_M2) /* 2013 certify */
static const struct country_chplan RTL8821AE_HMC_M2_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x3D, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x36, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8821AU) /* 2014 certify */
static const struct country_chplan RTL8821AU_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x3D, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x36, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8812AENF_NGFF) /* 2014 certify */
static const struct country_chplan RTL8812AENF_NGFF_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8812AEBT_HMC) /* 2013 certify */
static const struct country_chplan RTL8812AEBT_HMC_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x36, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8188EE_HMC_M2) /* 2012 certify */
static const struct country_chplan RTL8188EE_HMC_M2_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AW", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BB", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x20, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ET", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GD", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x5D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8723BE_HMC_M2) /* 2013 certify */
static const struct country_chplan RTL8723BE_HMC_M2_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AW", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BS", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x20, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ET", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GD", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x5D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8723BS_NGFF1216) /* 2014 certify */
static const struct country_chplan RTL8723BS_NGFF1216_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BB", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x20, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x5D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("YE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8192EEBT_HMC_M2) /* 2013 certify */
static const struct country_chplan RTL8192EEBT_HMC_M2_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AW", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x20, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EH", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ET", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GD", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x5D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SC", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ST", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x39, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("YT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8723DE_NGFF1630) /* 2016 certify */
static const struct country_chplan RTL8723DE_NGFF1630_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x2A, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x5D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x34, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8822BE) /* 2016 certify */
static const struct country_chplan RTL8822BE_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BB", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BM", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BS", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x2B, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EH", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FJ", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GP", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GU", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x3D, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MO", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x4D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ST", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, UKRAINE, 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("YT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8821CE) /* 2016 certify */
static const struct country_chplan RTL8821CE_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BB", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BM", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BS", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x2B, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EH", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ET", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FJ", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GP", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GU", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ID", 0x3D, 0x00, DEF    , 0, 0, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x28, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MO", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x4D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ST", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, UKRAINE, 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("YT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

#if (RTW_DEF_MODULE_REGULATORY_CERT & RTW_MODULE_RTL8822CE) /* 2018 certify */
static const struct country_chplan RTL8822CE_country_chplan_map[] = {
	COUNTRY_CHPLAN_ENT("AE", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AN", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AO", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AR", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AU", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AW", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("AZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BB", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BH", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BM", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BO", 0x73, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BR", 0x62, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BS", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BW", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("BY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CA", 0x2B, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CI", 0x42, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CL", 0x2D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CN", 0x48, 0x00, CN     , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CY", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("CZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DO", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("DZ", 0x00, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EG", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("EH", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ES", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ET", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FJ", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("FR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GP", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GT", 0x61, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GU", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("GW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HK", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HN", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HT", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("HU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IL", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IN", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("IT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JM", 0x32, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JO", 0x49, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("JP", 0x27, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KE", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KH", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KR", 0x4B, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("KZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LB", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("LV", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MA", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MC", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ME", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ML", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MO", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MQ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MU", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MW", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MX", 0x4D, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MY", 0x63, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("MZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NA", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NG", 0x75, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NI", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NP", 0x48, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("NZ", 0x45, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("OM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PA", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PE", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PK", 0x51, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PR", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("PY", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("QA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RO", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RS", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("RU", 0x59, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SC", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SE", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SG", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SI", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SK", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SL", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SN", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ST", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SV", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("SZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TD", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TF", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TH", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TJ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TN", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TR", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TW", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("TZ", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UA", 0x35, 0x00, UKRAINE, 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UG", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("US", 0x76, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UY", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("UZ", 0x47, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VE", 0x30, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("VN", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("YT", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZA", 0x35, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZM", 0x26, 0x00, DEF    , 0, 1, 1),
	COUNTRY_CHPLAN_ENT("ZW", 0x26, 0x00, DEF    , 0, 1, 1),
};
#endif

/**
 * rtw_def_module_country_chplan_map -
 * @hal_map: returned map
 * @return: size of map
 */
static u16 rtw_def_module_country_chplan_map(const struct country_chplan **hal_map)
{
	u16 hal_map_sz = 0;

	/* TODO: runtime selection for multi driver */
#if (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8821AE_HMC_M2)
	*hal_map = RTL8821AE_HMC_M2_country_chplan_map;
	hal_map_sz = sizeof(RTL8821AE_HMC_M2_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8821AU)
	*hal_map = RTL8821AU_country_chplan_map;
	hal_map_sz = sizeof(RTL8821AU_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8812AENF_NGFF)
	*hal_map = RTL8812AENF_NGFF_country_chplan_map;
	hal_map_sz = sizeof(RTL8812AENF_NGFF_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8812AEBT_HMC)
	*hal_map = RTL8812AEBT_HMC_country_chplan_map;
	hal_map_sz = sizeof(RTL8812AEBT_HMC_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8188EE_HMC_M2)
	*hal_map = RTL8188EE_HMC_M2_country_chplan_map;
	hal_map_sz = sizeof(RTL8188EE_HMC_M2_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8723BE_HMC_M2)
	*hal_map = RTL8723BE_HMC_M2_country_chplan_map;
	hal_map_sz = sizeof(RTL8723BE_HMC_M2_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8723BS_NGFF1216)
	*hal_map = RTL8723BS_NGFF1216_country_chplan_map;
	hal_map_sz = sizeof(RTL8723BS_NGFF1216_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8192EEBT_HMC_M2)
	*hal_map = RTL8192EEBT_HMC_M2_country_chplan_map;
	hal_map_sz = sizeof(RTL8192EEBT_HMC_M2_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8723DE_NGFF1630)
	*hal_map = RTL8723DE_NGFF1630_country_chplan_map;
	hal_map_sz = sizeof(RTL8723DE_NGFF1630_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8822BE)
	*hal_map = RTL8822BE_country_chplan_map;
	hal_map_sz = sizeof(RTL8822BE_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8821CE)
	*hal_map = RTL8821CE_country_chplan_map;
	hal_map_sz = sizeof(RTL8821CE_country_chplan_map) / sizeof(struct country_chplan);
#elif (RTW_DEF_MODULE_REGULATORY_CERT == RTW_MODULE_RTL8822CE)
	*hal_map = RTL8822CE_country_chplan_map;
	hal_map_sz = sizeof(RTL8822CE_country_chplan_map) / sizeof(struct country_chplan);
#endif

	return hal_map_sz;
}
