/**
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef _COMMON_H_
#define _COMMON_H_

/* --------------------------------------------------------------------------- */
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/stat.h>

/* --------------------------------------------------------------------------- */
#ifndef UNUSED
#define UNUSED(x) (void)(x)
#endif

#ifdef OS_FRTOS
#define FD_FWDUMP_FILE   0x01
#endif
/* --------------------------------------------------------------------------- */
/* This device node only for read firmware log */
#define CUST_WIFI_FWLOG_PORT  "/proc/net/wlan/core_dump"
/* FW dump default PATH is /data/vendor/misc/wifi */
#define DEFAULT_PATH "/data/vendor/misc/wifi"
#define FW_DUMP_PICUS_NAME_PREFIX "wifi_dump_"

#define RETRY_COUNT         20
#define FW_LOG_SWITCH_SIZE  20 * 1024 * 1024
#define MT_TIMEOUT_VALUE    1000
#define IOC_MAGIC           0xb0

/* --------------------------------------------------------------------------- */
typedef enum _MT_DEBUG_LEVEL
{
    SHOW,       // debug off, priority highest
    ERROR,      // only show eror
    WARN,
    TRACE,
} MT_DEBUG_LEVEL;

/* --------------------------------------------------------------------------- */
void DBGPRINT(int level, const char *format, ...);

#define PICUS_RAW_INFO(p, l, fmt, ...)                  \
    do {                                                \
        int raw_count = 0;                              \
        const unsigned char *ptr = p;                   \
        printf("[wifi_dump] "fmt, ##__VA_ARGS__);           \
        for (raw_count = 0; raw_count < l; ++raw_count) \
            printf(" %02X", ptr[raw_count]);            \
        printf("\n");                                   \
    } while (0)

#endif /* _COMMON_H_ */
