/******************************************************************************
 *
 * This file is provided under a dual license.  When you use or
 * distribute this software, you may choose to be licensed under
 * version 2 of the GNU General Public License ("GPLv2 License")
 * or BSD License.
 *
 * GPLv2 License
 *
 * Copyright(C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 *
 * BSD LICENSE
 *
 * Copyright(C) 2016 MediaTek Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  * Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/
/******************************************************************************
 *[File]             dbg_mt7922.c
 *[Version]          v1.0
 *[Revision Date]    2021-03-10
 *[Author]
 *[Description]
 *    The program provides WIFI FALCON MAC Debug APIs
 *[Copyright]
 *    Copyright (C) 2015 MediaTek Incorporation. All Rights Reserved.
 ******************************************************************************/

#if defined(MT7922)
/*******************************************************************************
 *                         C O M P I L E R   F L A G S
 *******************************************************************************
 */

/*******************************************************************************
 *                    E X T E R N A L   R E F E R E N C E S
 *******************************************************************************
 */
#include "precomp.h"

/*******************************************************************************
 *                              C O N S T A N T S
 *******************************************************************************
 */

/*******************************************************************************
 *                             D A T A   T Y P E S
 *******************************************************************************
 */
#if (CFG_SUPPORT_DEBUG_SOP == 1)
struct MT7922_DEBUG_SOP_INFO {
	u_int32_t	*wfsys_sleep_status;
	uint8_t		wfsys_sleep_cr_num;
	u_int32_t	*wfsys_status;
	uint8_t		wfsys_cr_num;
	u_int32_t	*bgfsys_bus_status;
	uint8_t		bgfsys_bus_cr_num;
	u_int32_t	*bgfsys_status;
	uint8_t		bgfsys_cr_num;
	u_int32_t	*conninfra_status;
	uint8_t		conninfra_cr_num;
	u_int32_t	*conninfra_bus_cr;
	uint8_t		conninfra_bus_cr_num;
	u_int32_t	*conninfra_signal_status;
	uint8_t		conninfra_signal_num;
};
#endif

/*******************************************************************************
 *                            P U B L I C   D A T A
 *******************************************************************************
 */

/*******************************************************************************
 *                           P R I V A T E   D A T A
 *******************************************************************************
 */
#if (CFG_SUPPORT_DEBUG_SOP == 1)
static u_int32_t mt7922_wfsys_sleep_status_sel[] = {
	0x00100000, 0x00100001, 0x00100010, 0x00100017, 0x0010001D};

static u_int32_t mt7922_wfsys_status_sel[] = {
	0xD0010001, 0xD0020001, 0xD0030001, 0xD0040001, 0xD0050001,
	0xD0060001, 0xD0070001, 0xD0080001, 0xD0090001, 0xD00A0001,
	0xD00B0001, 0xD00C0001, 0xD00D0001, 0xD00E0001, 0xD00F0001,
	0xD0100001, 0xD0010002, 0xD0010003
};

static u_int32_t mt7922_bgfsys_bus_status_sel[] = {
	0x00767501, 0x00787701, 0x007A7901, 0x007C7B01, 0x007E7D01,
	0x00807F01, 0x00828101, 0x00848301, 0x00868501, 0x00888701,
	0x008A8901, 0x008C8B01, 0x008E8D01, 0x00908F01, 0x00929101,
	0x00949301, 0x00969501, 0x00989701, 0x009A9901, 0x009C9B01,
	0x009E9D01, 0x00A09F01, 0x00A2A101, 0x00A4A301, 0x00A6A501,
	0x00A8A701, 0x00AAA901, 0x00ACAB01, 0x00AEAD01, 0x00B0AF01
};

static u_int32_t mt7922_bgfsys_status_sel[] = {
	0x00000080, 0x00000081, 0x00000082, 0x00000083, 0x00000084,
	0x00000085, 0x00000086, 0x00000087, 0x00000088, 0x00000089,
	0x0000008a, 0x0000008b, 0x0000008c, 0x0000008d, 0x0000008e,
	0x0000008f, 0x00000090, 0x00000091, 0x00000092, 0x00000093,
	0x000000c0, 0x000000c1, 0x000000c2, 0x000000c3, 0x000000c4,
	0x000000c5, 0x000000c6, 0x000000c7, 0x000000c8, 0x000000d0,
	0x000000d1, 0x000000d2, 0x000000d3, 0x000000d4, 0x000000d5,
	0x000000d6, 0x000000d7, 0x000000d8, 0x000000d9, 0x000000da,
	0x000000db, 0x000000dc, 0x000000dd, 0x000000de, 0x000000e0,
	0x000000e1, 0x000000e2, 0x000000e3
};

static u_int32_t mt7922_conninfra_status_sel[] = {
	0x00000000, 0x00000001, 0x00000002, 0x00000003, 0x00000004,
	0x00000005};

static u_int32_t mt7922_conninfra_bus_cr[] = {
	0xE042C, 0xE0430, 0xE0414, 0xE0418, 0xE041C, 0xE0420};

static u_int32_t mt7922_conn_infra_signal_status_sel[] = {
	 0xC0000000, 0xC0010000, 0xC0000001, 0xC0010001, 0xC0020001,
	 0xC0000002, 0xC0010002, 0xC0020002, 0xC0000003, 0xC0010003,
	 0xC0000004
};

static struct MT7922_DEBUG_SOP_INFO mt7922_debug_sop_info[] = {
	{mt7922_wfsys_sleep_status_sel,
	sizeof(mt7922_wfsys_sleep_status_sel)/sizeof(u_int32_t),
	mt7922_wfsys_status_sel,
	sizeof(mt7922_wfsys_status_sel)/sizeof(u_int32_t),
	mt7922_bgfsys_bus_status_sel,
	sizeof(mt7922_bgfsys_bus_status_sel)/sizeof(u_int32_t),
	mt7922_bgfsys_status_sel,
	sizeof(mt7922_bgfsys_status_sel)/sizeof(u_int32_t),
	mt7922_conninfra_status_sel,
	sizeof(mt7922_conninfra_status_sel)/sizeof(u_int32_t),
	mt7922_conninfra_bus_cr,
	sizeof(mt7922_conninfra_bus_cr)/sizeof(u_int32_t),
	mt7922_conn_infra_signal_status_sel,
	sizeof(mt7922_conn_infra_signal_status_sel)/sizeof(u_int32_t),
	}
};
#endif /* (CFG_SUPPORT_DEBUG_SOP == 1) */

/*******************************************************************************
 *                                 M A C R O S
 *******************************************************************************
 */

/*******************************************************************************
 *                   F U N C T I O N   D E C L A R A T I O N S
 *******************************************************************************
 */

/*******************************************************************************
 *                              F U N C T I O N S
 *******************************************************************************
 */
#if (CFG_SUPPORT_DEBUG_SOP == 1)
void pcie_mt7922_dump_wfsys_debug_cr(struct ADAPTER *prAdapter,
	uint8_t ucCase)
{
	uint8_t i = 0;
	uint32_t u4Val = 0;

	if (ucCase == SLAVENORESP) {
		for (i = 0; i < mt7922_debug_sop_info->wfsys_cr_num; i++) {
			HAL_MCR_WR(prAdapter,
			  CONNAC25_PCIE_WF_DEBUG_SEL,
			  mt7922_debug_sop_info->wfsys_status[i]);

			HAL_MCR_RD(prAdapter,
			  CONNAC25_PCIE_WF_DEBUG_STATUS, &u4Val);

			DBGLOG(HAL, INFO,
			  "WFSYS sel: 0x%08x, Val: 0x%08x\n",
			  mt7922_debug_sop_info->wfsys_status[i], u4Val);
		}
	}

	for (i = 0; i < mt7922_debug_sop_info->wfsys_sleep_cr_num; i++) {
		HAL_MCR_WR(prAdapter,
		  CONNAC2X_PCIE_DEBUG_SEL,
		  mt7922_debug_sop_info->wfsys_sleep_status[i]);

		HAL_MCR_RD(prAdapter,
		  CONNAC2X_PCIE_DEBUG_STATUS, &u4Val);

		DBGLOG(HAL, INFO,
		  "WFSYS sleep sel: 0x%08x, Val: 0x%08x\n",
		  mt7922_debug_sop_info->wfsys_sleep_status[i], u4Val);
	}
}

void pcie_mt7922_dump_bgfsys_debug_cr(struct ADAPTER *prAdapter,
	uint8_t ucCase)
{
	uint8_t i = 0;
	uint32_t u4Val = 0;

	if (ucCase == SLEEP) {
		HAL_MCR_WR(prAdapter, CONNAC25_PCIE_BGF_DBG_SEL, 0x0081);
		HAL_MCR_RD(prAdapter, CONNAC25_PCIE_BGF_DBG_STATUS, &u4Val);

		DBGLOG(HAL, INFO, "BGFSYS sel: 0x0081, Val: 0x%08x\n", u4Val);
	}
	if (ucCase == SLAVENORESP) {
		/* For pin mux setting. */
		HAL_MCR_WR(prAdapter, 0xE00A0, 0xA8);
		for (i = 0; i < mt7922_debug_sop_info->bgfsys_bus_cr_num; i++) {
			HAL_MCR_WR(prAdapter,
			  CONNAC25_PCIE_BGF_BUS_SEL,
			  mt7922_debug_sop_info->bgfsys_bus_status[i]);

			HAL_MCR_RD(prAdapter,
			  CONNAC25_PCIE_BGF_BUS_STATUS, &u4Val);

			DBGLOG(HAL, INFO,
			  "BGFSYS bus sel: 0x%08x, Val: 0x%08x\n",
			  mt7922_debug_sop_info->bgfsys_bus_status[i], u4Val);
		}
		for (i = 0; i < mt7922_debug_sop_info->bgfsys_cr_num; i++) {
			HAL_MCR_WR(prAdapter,
			  CONNAC25_PCIE_BGF_DBG_SEL,
			  mt7922_debug_sop_info->bgfsys_status[i]);

			HAL_MCR_RD(prAdapter,
			  CONNAC25_PCIE_BGF_DBG_STATUS, &u4Val);

			DBGLOG(HAL, INFO,
			  "BGFSYS sel: 0x%08x, Val: 0x%08x\n",
			  mt7922_debug_sop_info->bgfsys_status[i], u4Val);
		}
	}
}

void pcie_mt7922_dump_conninfra_debug_cr(struct ADAPTER *prAdapter,
	uint8_t ucCase)
{
	uint8_t i = 0;
	uint32_t u4Val = 0;

	for (i = 0; i < mt7922_debug_sop_info->conninfra_cr_num; i++) {
		HAL_MCR_WR(prAdapter, CONNAC25_PCIE_CONNINFRA_CLK_SEL,
		  mt7922_debug_sop_info->conninfra_status[i]);

		HAL_MCR_RD(prAdapter, CONNAC25_PCIE_CONNINFRA_CLK_STATUS,
		  &u4Val);

		DBGLOG(HAL, INFO, "CONNINFRA sel: 0x%08x, Val: 0x%08x\n",
		  mt7922_debug_sop_info->conninfra_status[i], u4Val);
	}
	if (ucCase == SLAVENORESP) {
		HAL_MCR_RD(prAdapter, CONNAC25_PCIE_CONNINFRA_STRAP_STATUS,
		  &u4Val);
		DBGLOG(HAL, INFO, "CONNINFRA STRAP: 0x%08x, Val: 0x%08x\n",
		  CONNAC25_PCIE_CONNINFRA_STRAP_STATUS, u4Val);

		for (i = 0; i < mt7922_debug_sop_info->conninfra_bus_cr_num;
			i++) {
			HAL_MCR_RD(prAdapter,
			  mt7922_debug_sop_info->conninfra_bus_cr[i],
			  &u4Val);

			DBGLOG(HAL, INFO,
			  "CONNINFRA bus cr: 0x%08x, Val: 0x%08x\n",
			  mt7922_debug_sop_info->conninfra_bus_cr[i], u4Val);
		}
		/* off domain */
		HAL_MCR_WR(prAdapter, 0xE0000, 0x1);
		HAL_MCR_RD(prAdapter, 0xE0000, &u4Val);
		DBGLOG(HAL, INFO,
		  "CONNINFRA off domain cr: 0xE0000, Val: 0x%08x\n", u4Val);
		HAL_MCR_RD(prAdapter, 0xE02D4, &u4Val);
		if (!(u4Val & BIT(0)))
			DBGLOG(HAL, INFO, "CONNINFRA off domain bus hang!!!\n");

		for (i = 0; i < mt7922_debug_sop_info->conninfra_signal_num;
			i++) {
			HAL_MCR_WR(prAdapter,
			  CONNAC2X_PCIE_CONN_INFRA_BUS_SEL,
			  mt7922_debug_sop_info->conninfra_signal_status[i]);

			HAL_MCR_RD(prAdapter,
			  CONNAC2X_PCIE_CONN_INFRA_BUS_STATUS,
			  &u4Val);

			DBGLOG(HAL, INFO,
			  "CONNINFRA sel: 0x%08x, Val: 0x%08x\n",
			  mt7922_debug_sop_info->conninfra_signal_status[i],
			  u4Val);
		}
	}
}

u_int8_t mt7922_show_debug_sop_info(struct ADAPTER *prAdapter,
	uint8_t ucCase)
{
	uint32_t u4Val = 0;

	switch (ucCase) {
	case SLEEP:
		/* Check power status */
		DBGLOG(HAL, ERROR, "Sleep Fail!\n");
		HAL_MCR_RD(prAdapter, CONNAC25_PCIE_POWER_STATUS, &u4Val);
		DBGLOG(HAL, INFO, "Power status CR: 0x%08x, Val: 0x%08x\n",
			CONNAC25_PCIE_POWER_STATUS, u4Val);
		pcie_mt7922_dump_wfsys_debug_cr(prAdapter, ucCase);
		pcie_mt7922_dump_bgfsys_debug_cr(prAdapter, ucCase);
		pcie_mt7922_dump_conninfra_debug_cr(prAdapter, ucCase);
		break;
	case SLAVENORESP:
		DBGLOG(HAL, ERROR, "Slave no response!\n");
		pcie_mt7922_dump_wfsys_debug_cr(prAdapter, ucCase);
		pcie_mt7922_dump_bgfsys_debug_cr(prAdapter, ucCase);
		pcie_mt7922_dump_conninfra_debug_cr(prAdapter, ucCase);
		break;
	default:
		break;
	}

	return TRUE;
}
#endif /* (CFG_SUPPORT_DEBUG_SOP == 1) */

#endif /* defined(MT7922) */
